<?php
//about theme info
add_action( 'admin_menu', 'estate_vista_gettingstarted_page' );
function estate_vista_gettingstarted_page() {      
    add_theme_page( esc_html__('Estate Vista', 'estate-vista'), esc_html__('All About Estate Vista', 'estate-vista'), 'edit_theme_options', 'estate_vista_mainpage', 'estate_vista_main_content');   
}


function estate_vista_discount_notice() {
    global $pagenow;
    if ( is_admin() && ('themes.php' == $pagenow) && isset( $_GET['activated'] ) ) { ?>
        <div class="notice getting_started">
            <div class="notice-content">
                <p><?php esc_html_e( '🎉 Thank You For Choosing CA WP Themes!', 'estate-vista' ); ?></p>
                
                <h2><?php esc_html_e( '🚀 Get Started with Your Free Theme!', 'estate-vista' ); ?></h2>
                
                <p><?php esc_html_e( "Here are some useful links to help you set up your theme quickly:", 'estate-vista' ); ?></p>
                
                <div class="info-link">
                    <a href="<?php echo esc_url( 'https://cawpthemes.com/estate-vista-free-wordpress-theme/' ); ?>" target="_blank">
                        <?php esc_html_e( '🎨 View Free Theme Details', 'estate-vista' ); ?>
                    </a>
                </div>
                
                <div class="info-link">
                    <a href="<?php echo esc_url( 'https://cawpthemes.com/docs/estate-vista-free-theme-documentation/' ); ?>" target="_blank">
                        <?php esc_html_e( '📖 Read Theme Documentation', 'estate-vista' ); ?>
                    </a>
                </div>

                <h2><?php esc_html_e( '🔥 Upgrade to Pro for More Amazing Features!', 'estate-vista' ); ?></h2>
                
                <p><?php esc_html_e( "Unlock the full potential of your website with our premium version! 🚀", 'estate-vista' ); ?></p>
                
                <div class="info-link">
                   <a href="<?php echo esc_url( 'https://cawpthemes.com/docs/premium-theme-and-plugin-download/' ); ?>" target="_blank">
                        <?php esc_html_e( '📖 Pro Documentation', 'estate-vista' ); ?>
                    </a>
                </div>

                <div class="info-link">
                    <a href="<?php echo esc_url( ESTATE_VISTA_PRO_URL ); ?>" target="_blank">
                        <?php esc_html_e( '🚀 Upgrade to Pro', 'estate-vista' ); ?>
                    </a>
                </div>

                <div class="info-link">
                    <a href="<?php echo esc_url( ESTATE_VISTA_PRO_DEMO ); ?>" target="_blank">
                        <?php esc_html_e( '✨ Premium Demo', 'estate-vista' ); ?>
                    </a>
                </div>

                <h2><?php esc_html_e( '🔥 Limited Time Offer – Flat 15% OFF on Pro Themes!', 'estate-vista' ); ?></h2>
                
                <p><?php esc_html_e( "Upgrade today and get 15% off! Don't miss this exclusive deal! 💰", 'estate-vista' ); ?></p>
                
                <ul class="discount-benefits">
                    <li>✅ <?php esc_html_e('SEO Optimized & Speed Fast 🚀', 'estate-vista'); ?></li>
                    <li>✅ <?php esc_html_e('Fully Responsive & Mobile-Friendly 📱', 'estate-vista'); ?></li>
                    <li>✅ <?php esc_html_e('Customizer Support for Easy Customization 🎨', 'estate-vista'); ?></li>
                    <li>✅ <?php esc_html_e('Premium Features & Regular Updates 🔥', 'estate-vista'); ?></li>
                </ul>
                
                <p class="discount-code">
                    <?php esc_html_e('👉 Use Code:', 'estate-vista'); ?> 
                    <span>SAVE15</span> 
                    <?php esc_html_e(' at Checkout', 'estate-vista'); ?>
                </p>
                
                <div class="info-link">
                    <a href="<?php echo esc_url( ESTATE_VISTA_PRO_URL ); ?>" target="_blank">
                        <?php esc_html_e( '🛒 Shop Now', 'estate-vista' ); ?>
                    </a>
                </div>

                <p class="offer-expiry"><?php esc_html_e('📅 Hurry! Offer ends soon.', 'estate-vista' ); ?></p>
            </div>
        </div>
    <?php }
}

add_action( 'admin_notices', 'estate_vista_discount_notice' );

// Add a Custom CSS file to WP Admin Area
function estate_vista_admin_page_theme_style() {
   wp_enqueue_style('estate-vista-custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/getstarted/getstarted.css');
}
add_action('admin_enqueue_scripts', 'estate_vista_admin_page_theme_style');

//About Theme Info
function estate_vista_main_content() { 

    //custom function about theme customizer

    $return = add_query_arg( array()) ;
    $theme = wp_get_theme( 'estate-vista' );
?>

<div class="theme-discount-banner">
    <h2><?php esc_html_e('🚀 Limited Time Offer – Flat 15% OFF on All Premium WordPress Themes! 🎉', 'estate-vista'); ?></h2>
    <p><?php esc_html_e('Upgrade your website with our stunning, high-performance WordPress themes at an exclusive 15% discount! 💰✨', 'estate-vista'); ?></p>
    
    <ul class="discount-benefits">
        <li>✅ <?php esc_html_e('SEO Optimized & Speed Fast 🚀', 'estate-vista'); ?></li>
        <li>✅ <?php esc_html_e('Fully Responsive & Mobile-Friendly 📱', 'estate-vista'); ?></li>
        <li>✅ <?php esc_html_e('Customizer Support for Easy Customization 🎨', 'estate-vista'); ?></li>
        <li>✅ <?php esc_html_e('Premium Features & Regular Updates 🔥', 'estate-vista'); ?></li>
    </ul>
    
    <p class="discount-code"><?php esc_html_e('👉 Use Code: ', 'estate-vista'); ?> <span>SAVE15</span> <?php esc_html_e(' at Checkout', 'estate-vista'); ?></p>
    
    <a href="https://cawpthemes.com/estate-vista-premium-wordpress-theme/" class="cta-button"><?php esc_html_e('Shop Now 🚀', 'estate-vista'); ?></a>
    
    <p class="offer-expiry"><?php esc_html_e('📅 Hurry! Offer ends soon.', 'estate-vista'); ?></p>
</div>


<div class="admin-main-box">
    <div class="admin-left-box">
        <h2><?php esc_html_e( 'Welcome to Estate Vista Theme', 'estate-vista' ); ?> <span class="version"><?php $theme_info = wp_get_theme();
echo $theme_info->get( 'Version' );?></span></h2>
        <p><?php esc_html_e('CA WP Themes is a premium WordPress theme development company that provides high-quality themes for various types of websites. They specialize in creating themes for businesses, eCommerce, portfolios, blogs, and many more. Their themes are easy to use and customize, making them perfect for those who want to create a professional-looking website without any coding skills.','estate-vista'); ?></p>
        <p><?php esc_html_e('CA WP Themes offers a wide range of themes that are designed to be responsive and compatible with the latest versions of WordPress. Our themes are also SEO optimized, ensuring that your website will rank well on search engines. They come with a variety of features such as customizable widgets, social media integration, and custom page templates.','estate-vista'); ?></p>
        <p><?php esc_html_e('One of the unique things about CA WP Themes is their focus on providing excellent customer support. They have a dedicated team of support staff who are available 24/7 to help customers with any issues they may encounter. Their support team is knowledgeable and friendly, ensuring that customers receive the best possible experience.','estate-vista'); ?></p>
    </div>
    <div class="admin-right-box">
        <div class="admin_text-btn">
            <h4><?php esc_html_e('Buy Estate Vista Premium Theme','estate-vista'); ?></h4>
            <p><?php esc_html_e('Now the Premium Version is only at $39.99 with Lifetime Access!Grab the deal now!', 'estate-vista'); ?></p>
            <div class="info-link">
                <a href="<?php echo esc_url( ESTATE_VISTA_PRO_URL ); ?>" target="_blank"> <?php esc_html_e( 'Upgrade to Pro', 'estate-vista' ); ?></a>
            </div>
        </div>
        <hr>
        <div class="admin_text-btn">
            <h4><?php esc_html_e('Premium Theme Demo','estate-vista'); ?></h4>
            <div class="info-link">
                <a href="<?php echo esc_url( ESTATE_VISTA_PRO_DEMO ); ?>" target="_blank"> <?php esc_html_e( 'Demo', 'estate-vista' ); ?></a>
            </div>
        </div>
        <hr>
        <div class="admin_text-btn">
            <h4><?php esc_html_e('Need Support? / Contact Us','estate-vista'); ?></h4>
            <div class="info-link">
                <a href="<?php echo esc_url( ESTATE_VISTA_PRO_SUPPORT ); ?>" target="_blank"> <?php esc_html_e( 'Contact Us', 'estate-vista' ); ?></a>
            </div>
        </div>
        <hr>
        <div class="admin_text-btn">
            <h4><?php esc_html_e('Documentation','estate-vista'); ?></h4>
            <div class="info-link">
                <a href="<?php echo esc_url( ESTATE_VISTA_PRO_DOCUMENTATION ); ?>" target="_blank"> <?php esc_html_e( 'Docs', 'estate-vista' ); ?></a>
            </div>
        </div>
        <hr>
        <div class="admin_text-btn">
            <h4><?php esc_html_e('Free Theme','estate-vista'); ?></h4>
            <div class="info-link">
                <a href="<?php echo esc_url( ESTATE_VISTA_FREE_URL ); ?>" target="_blank"> <?php esc_html_e( 'Demo', 'estate-vista' ); ?></a>
            </div>
        </div>

    </div>
</div>


<?php } ?>