<?php
/**
 * Add custom settings and controls to the WordPress Customizer
 */


//---------------------Code to add the Upgrade to Pro button in the Customizer----------

function estate_vista_customize_register_btn( $wp_customize ) {
    $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
    $wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
    $wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

    get_template_part('inc/customizer-button/upsell-section');

    if ( isset( $wp_customize->selective_refresh ) ) {
        $wp_customize->selective_refresh->add_partial( 'blogname', array(
            'selector'        => '.site-title a',
            'render_callback' => 'estate_vista_customize_partial_blogname',
        ) );
        $wp_customize->selective_refresh->add_partial( 'blogdescription', array(
            'selector'        => '.site-description',
            'render_callback' => 'estate_vista_customize_partial_blogdescription',
        ) );
    }

    $wp_customize->register_section_type( 'Estate_Vista_Customize_Upsell_Section' );

    // Register section.
    $wp_customize->add_section(
        new Estate_Vista_Customize_Upsell_Section(
            $wp_customize,
            'theme_upsell',
            array(
                'title'    => esc_html__( 'Estate Vista Pro', 'estate-vista' ),
                'pro_text' => esc_html__( 'Upgrade To Pro', 'estate-vista' ),
                'pro_url'  => 'https://cawpthemes.com/estate-vista-premium-wordpress-theme/',
                'priority' => 1,
            )
        )
    );
}
add_action( 'customize_register', 'estate_vista_customize_register_btn' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function estate_vista_customize_partial_blogname() {
    bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function estate_vista_customize_partial_blogdescription() {
    bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function estate_vista_customize_preview_js() {
    wp_enqueue_script( 'estate-vista-customizer', get_template_directory_uri() . '/inc/customizer-button/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'estate_vista_customize_preview_js' );

/**
 * Customizer control scripts and styles.
 *
 * @since 1.0.0
 */
function estate_vista_customizer_control_scripts() {

    wp_enqueue_style( 'estate-vista-customize-controls', get_template_directory_uri() . '/inc/customizer-button/customize-controls.css', '', '1.0.0' );

    wp_enqueue_script( 'estate-vista-customize-controls', get_template_directory_uri() . '/inc/customizer-button/customize-controls.js', array( 'customize-controls' ), '1.0.0', true );
}
add_action( 'customize_controls_enqueue_scripts', 'estate_vista_customizer_control_scripts', 0 );


//---------------------Code to add the Upgrade to Pro button in the Customizer End----------


//------------------Theme Information--------------------


function estate_vista_customize_register( $wp_customize ) {


      // Add a custom setting for the Site Identity color
  $wp_customize->add_setting( 'estate_vista_site_identity_color', array(
    'default' => '#D2C196',
    'sanitize_callback' => 'sanitize_hex_color',
  ) );

  // Add a custom control for the primary color
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'estate_vista_site_identity_color', array(
    'label' => __( 'Site Identity Color', 'estate-vista' ),
    'section' => 'title_tagline',
    'settings' => 'estate_vista_site_identity_color',
  ) ) );


  // Add a custom setting for the Site Identity color
  $wp_customize->add_setting( 'estate_vista_site_identity_tagline_color', array(
    'default' => '#000',
    'sanitize_callback' => 'sanitize_hex_color',
  ) );

  // Add a custom control for the primary color
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'estate_vista_site_identity_tagline_color', array(
    'label' => __( 'Tagline Color', 'estate-vista' ),
    'section' => 'title_tagline',
    'settings' => 'estate_vista_site_identity_tagline_color',
  ) ) );

//------------------Site Identity Ends---------------------

  
  // Add a custom setting for the primary color
  $wp_customize->add_setting( 'estate_vista_primary_color', array(
    'default' => '#0073aa',
    'sanitize_callback' => 'sanitize_hex_color',
  ) );

  // Add a custom control for the primary color
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'estate_vista_primary_color', array(
    'label' => __( 'Primary Color', 'estate-vista' ),
    'section' => 'colors',
    'settings' => 'estate_vista_primary_color',
  ) ) );

  //-----------------------------------Home Front Page-------------------------------

  $wp_customize->add_panel( 'estate_vista_panel', array(
    'title'    => __( 'Front Page Settings', 'estate-vista' ),
    'priority' => 100,
  ) );


  //-------------------------------------Banner Image Section--------------

      $wp_customize->add_section( 'estate_vista_section_banner', array(
        'title'    => __( 'Home First Section', 'estate-vista' ),
        'priority' => 8,
        'panel'    => 'estate_vista_panel',
    ) );


  //-----------------Enable Option banner-------------

  $wp_customize->add_setting('estate_vista_section_banner',array(
      'default' => 'Enable',
      'sanitize_callback' => 'estate_vista_sanitize_choices'
  ));
  $wp_customize->add_control('estate_vista_section_banner',array(
        'type' => 'radio',
        'label' => __('Do you want this section', 'estate-vista'),
        'section' => 'estate_vista_section_banner',
        'choices' => array(
            'Enable' => __('Enable', 'estate-vista'),
            'Disable' => __('Disable', 'estate-vista')
  )));

  $wp_customize->add_setting('estate_vista_section_bannerimage_section',array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
  ));
  $wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'estate_vista_section_bannerimage_section',array(
    'label' => __('Section Background Image','estate-vista'),
    'description' => __('Dimention 1600 * 800','estate-vista'),
    'section' => 'estate_vista_section_banner',
    'settings' => 'estate_vista_section_bannerimage_section'
  )));

    $wp_customize->add_setting('estate_vista_section_bannerimage_section_title',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('estate_vista_section_bannerimage_section_title',array(
      'label' => __('Banner Title','estate-vista'),
      'section' => 'estate_vista_section_banner',
      'setting' => 'estate_vista_section_bannerimage_section_title',
      'type'    => 'text'
    )
  ); 

      $wp_customize->add_setting('estate_vista_section_bannerimage_section_text',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('estate_vista_section_bannerimage_section_text',array(
      'label' => __('Banner Text','estate-vista'),
      'section' => 'estate_vista_section_banner',
      'setting' => 'estate_vista_section_bannerimage_section_text',
      'type'    => 'textarea'
    )
  );

    $wp_customize->add_setting('estate_vista_banner_btn_text',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('estate_vista_banner_btn_text',array(
      'label' => __('Button Text','estate-vista'),
      'section' => 'estate_vista_section_banner',
      'setting' => 'estate_vista_banner_btn_text',
      'type'    => 'text'
    )
  );


    $wp_customize->add_setting('estate_vista_banner_btn_text_url',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('estate_vista_banner_btn_text_url',array(
      'label' => __('Button URL','estate-vista'),
      'section' => 'estate_vista_section_banner',
      'setting' => 'estate_vista_banner_btn_text_url',
      'type'    => 'text'
    )
  );


  //----------------------------------About Section----------------------------

    $wp_customize->add_section( 'estate_vista_about', array(
        'title'    => __( 'About Section', 'estate-vista' ),
        'priority' => 10,
        'panel'    => 'estate_vista_panel',
    ) );

  //-----------------Enable Option Section about-------------

  $wp_customize->add_setting('estate_vista_about_enable',array(
      'default' => 'Enable',
      'sanitize_callback' => 'estate_vista_sanitize_choices'
  ));
  $wp_customize->add_control('estate_vista_about_enable',array(
        'type' => 'radio',
        'label' => __('Do you want this section', 'estate-vista'),
        'section' => 'estate_vista_about',
        'choices' => array(
            'Enable' => __('Enable', 'estate-vista'),
            'Disable' => __('Disable', 'estate-vista')
  )));

    //--------------About Title-----------------------

    $wp_customize->add_setting('estate_vista_about_title',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('estate_vista_about_title',array(
      'label' => __('Section Title','estate-vista'),
      'section' => 'estate_vista_about',
      'setting' => 'estate_vista_about_title',
      'type'    => 'text'
    )
  ); 


  //-----------------------------About Image-----------

  $wp_customize->add_setting('estate_vista_aboutimage1_section',array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
  ));
  $wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'estate_vista_aboutimage1_section',array(
    'label' => __('About Side Image','estate-vista'),
    'description' => __('Dimention 500 * 750','estate-vista'),
    'section' => 'estate_vista_about',
    'settings' => 'estate_vista_aboutimage1_section'
  )));


    $wp_customize->add_setting('estate_vista_about_name',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('estate_vista_about_name',array(
      'label' => __('Main Heading','estate-vista'),
      'section' => 'estate_vista_about',
      'setting' => 'estate_vista_about_name',
      'type'    => 'text'
    )
  );


    $wp_customize->add_setting('estate_vista_about_title_second',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('estate_vista_about_title_second',array(
      'label' => __('Paragraph 1','estate-vista'),
      'section' => 'estate_vista_about',
      'setting' => 'estate_vista_about_title_second',
      'type'    => 'textarea'
    )
  );


    $wp_customize->add_setting('estate_vista_about_para',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('estate_vista_about_para',array(
      'label' => __('Paragraph 2','estate-vista'),
      'section' => 'estate_vista_about',
      'setting' => 'estate_vista_about_para',
      'type'    => 'textarea'
    )
  );

    $wp_customize->add_setting('estate_vista_about_btn_text',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('estate_vista_about_btn_text',array(
      'label' => __('Button Text','estate-vista'),
      'section' => 'estate_vista_about',
      'setting' => 'estate_vista_about_btn_text',
      'type'    => 'text'
    )
  );


    $wp_customize->add_setting('estate_vista_about_btn_text_url',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('estate_vista_about_btn_text_url',array(
      'label' => __('Button URL','estate-vista'),
      'section' => 'estate_vista_about',
      'setting' => 'estate_vista_about_btn_text_url',
      'type'    => 'text'
    )
  );

  //------------Features---------------------

  $wp_customize->add_section( 'estate_vista_features_amenities', array(
        'title'    => __( 'Features/Amenities', 'estate-vista' ),
        'priority' => 10,
        'panel'    => 'estate_vista_panel',
    ) );


  //-----------------Enable Option Section One-------------

  $wp_customize->add_setting('estate_vista_features_enable',array(
      'default' => 'Enable',
      'sanitize_callback' => 'estate_vista_sanitize_choices'
  ));
  $wp_customize->add_control('estate_vista_features_enable',array(
        'type' => 'radio',
        'label' => __('Do you want this section', 'estate-vista'),
        'section' => 'estate_vista_features_amenities',
        'choices' => array(
            'Enable' => __('Enable', 'estate-vista'),
            'Disable' => __('Disable', 'estate-vista')
  )));

    //--------------Section One Title-----------------------

    $wp_customize->add_setting('estate_vista_features_title',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('estate_vista_features_title',array(
      'label' => __('Section Title','estate-vista'),
      'section' => 'estate_vista_features_amenities',
      'setting' => 'estate_vista_features_title',
      'type'    => 'text'
    )
  ); 

  //-----------------------------Feature Image 1-----------

  $wp_customize->add_setting('estate_vista_featureimage1_section',array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
  ));
  $wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'estate_vista_featureimage1_section',array(
    'label' => __('Feature 1 Image','estate-vista'),
    'description' => __('Dimention 100 * 100','estate-vista'),
    'section' => 'estate_vista_features_amenities',
    'settings' => 'estate_vista_featureimage1_section'
  )));


    $wp_customize->add_setting('estate_vista_feature1_title',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('estate_vista_feature1_title',array(
      'label' => __('Feature 1 Title','estate-vista'),
      'section' => 'estate_vista_features_amenities',
      'setting' => 'estate_vista_feature1_title',
      'type'    => 'text'
    )
  ); 


    $wp_customize->add_setting('estate_vista_feature1_text',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('estate_vista_feature1_text',array(
      'label' => __('Feature 1 Text','estate-vista'),
      'section' => 'estate_vista_features_amenities',
      'setting' => 'estate_vista_feature1_text',
      'type'    => 'text'
    )
  ); 



  //-----------------------------Feature Image 2-----------

  $wp_customize->add_setting('estate_vista_featureimage2_section',array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
  ));
  $wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'estate_vista_featureimage2_section',array(
    'label' => __('Feature 2 Image','estate-vista'),
    'description' => __('Dimention 100 * 100','estate-vista'),
    'section' => 'estate_vista_features_amenities',
    'settings' => 'estate_vista_featureimage2_section'
  )));


    $wp_customize->add_setting('estate_vista_feature2_title',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('estate_vista_feature2_title',array(
      'label' => __('Feature 2 Title','estate-vista'),
      'section' => 'estate_vista_features_amenities',
      'setting' => 'estate_vista_feature2_title',
      'type'    => 'text'
    )
  ); 


    $wp_customize->add_setting('estate_vista_feature2_text',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('estate_vista_feature2_text',array(
      'label' => __('Feature 2 Text','estate-vista'),
      'section' => 'estate_vista_features_amenities',
      'setting' => 'estate_vista_feature2_text',
      'type'    => 'text'
    )
  ); 


  //-----------------------------Feature Image 3-----------

  $wp_customize->add_setting('estate_vista_featureimage3_section',array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
  ));
  $wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'estate_vista_featureimage3_section',array(
    'label' => __('Feature 3 Image','estate-vista'),
    'description' => __('Dimention 100 * 100','estate-vista'),
    'section' => 'estate_vista_features_amenities',
    'settings' => 'estate_vista_featureimage3_section'
  )));


    $wp_customize->add_setting('estate_vista_feature3_title',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('estate_vista_feature3_title',array(
      'label' => __('Feature 3 Title','estate-vista'),
      'section' => 'estate_vista_features_amenities',
      'setting' => 'estate_vista_feature3_title',
      'type'    => 'text'
    )
  ); 


    $wp_customize->add_setting('estate_vista_feature3_text',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('estate_vista_feature3_text',array(
      'label' => __('Feature 3 Text','estate-vista'),
      'section' => 'estate_vista_features_amenities',
      'setting' => 'estate_vista_feature3_text',
      'type'    => 'text'
    )
  ); 







  //------------Section One (Featured Post)---------------------

  $wp_customize->add_section( 'estate_vista_section1', array(
        'title'    => __( 'Latest Post', 'estate-vista' ),
        'priority' => 10,
        'panel'    => 'estate_vista_panel',
    ) );


  //-----------------Enable Option Section One-------------

  $wp_customize->add_setting('estate_vista_section1_enable',array(
      'default' => 'Enable',
      'sanitize_callback' => 'estate_vista_sanitize_choices'
  ));
  $wp_customize->add_control('estate_vista_section1_enable',array(
        'type' => 'radio',
        'label' => __('Do you want this section', 'estate-vista'),
        'section' => 'estate_vista_section1',
        'choices' => array(
            'Enable' => __('Enable', 'estate-vista'),
            'Disable' => __('Disable', 'estate-vista')
  )));

    //--------------Section One Title-----------------------

    $wp_customize->add_setting('estate_vista_section1_title',array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    )
  );
  $wp_customize->add_control('estate_vista_section1_title',array(
      'label' => __('Section Title','estate-vista'),
      'section' => 'estate_vista_section1',
      'setting' => 'estate_vista_section1_title',
      'type'    => 'text'
    )
  ); 

  //-----------Category------------

  $categories = get_categories();
  $cats = array();
  $i = 0;
  foreach($categories as $category){
    if($i==0){
      $default = $category->name;
      $i++;
    }
    $cats[$category->name] = $category->name;
  }

  $wp_customize->add_setting('estate_vista_section1_category',array(
  'sanitize_callback' => 'sanitize_text_field',
  ));
  $wp_customize->add_control('estate_vista_section1_category',array(
    'type'    => 'select',
    'choices' => $cats,
    'label' => __('Select Category to Display Post','estate-vista'),
    'section' => 'estate_vista_section1',
    'sanitize_callback' => 'sanitize_text_field',
  ));



    $wp_customize->add_setting('estate_vista_section1_category_number_of_posts_setting',array(
    'default' => '8',
    'sanitize_callback' => 'sanitize_text_field'
  ));
  $wp_customize->add_control('estate_vista_section1_category_number_of_posts_setting',array(
    'label' => __('Number of Posts','estate-vista'),
    'section' => 'estate_vista_section1',
    'setting' => 'estate_vista_section1_category_number_of_posts_setting',
    'type'    => 'number'
  )); 



  //-------------------------Footer Settings------------------------------


    $wp_customize->add_section( 'estate_vista_footer', array(
        'title'    => __( 'Footer Settings', 'estate-vista' ),
        'priority' => 10,
        'panel'    => 'estate_vista_panel',
    ) );


  // Add a custom setting for the footer text
  $wp_customize->add_setting( 'estate_vista_footer_text', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field',
  ) );

  // Add a custom control for the footer text
  $wp_customize->add_control( 'estate_vista_footer_text', array(
    'label' => __( 'Footer Text', 'estate-vista' ),
    'section' => 'estate_vista_footer',
    'type' => 'text',
  ) );


//--------------------------------------General Settings------------------------------------------

  $wp_customize->add_section( 'estate_vista_general', array(
        'title'    => __( 'General Settings', 'estate-vista' ),
        'panel'    => 'estate_vista_panel',
    ) );

    $wp_customize->add_setting( 'estate_vista_post_meta_toggle_switch_control', array(
        'default'   => true,
        'sanitize_callback' => 'sanitize_text_field', // Use a suitable sanitization function based on your needs
        'transport' => 'refresh', // or 'postMessage' for instant preview without page refresh
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'estate_vista_post_meta_toggle_switch_control', array(
        'label'    => __( 'Display Time/Author', 'estate-vista' ),
        'section'  => 'estate_vista_general',
        'settings' => 'estate_vista_post_meta_toggle_switch_control',
        'type'     => 'checkbox',
    ) ) );

    $wp_customize->add_setting( 'estate_vista_post_readdmore_toggle_switch_control', array(
        'default'   => true,
        'sanitize_callback' => 'sanitize_text_field', // Use a suitable sanitization function based on your needs
        'transport' => 'refresh', // or 'postMessage' for instant preview without page refresh
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'estate_vista_post_readdmore_toggle_switch_control', array(
        'label'    => __( 'Display Read More Link', 'estate-vista' ),
        'section'  => 'estate_vista_general',
        'settings' => 'estate_vista_post_readdmore_toggle_switch_control',
        'type'     => 'checkbox',
    ) ) );


}
add_action( 'customize_register', 'estate_vista_customize_register' );



