<?php

/**
 * Title: Menu Section
 * Slug: enyoi/menu-section
 * Categories: enyoi_patterns
 */
?>
<!-- wp:group {"tagName":"section","metadata":{"name":"Menu Section"},"className":"section section-bg-white","layout":{"type":"constrained"}} -->
<section id="menu" class="wp-block-group section section-bg-white"><!-- wp:group {"className":"container","layout":{"type":"flex","orientation":"vertical","justifyContent":"center"}} -->
    <div class="wp-block-group container"><!-- wp:heading {"textAlign":"center","className":"section-title fade-in"} -->
        <h2 class="wp-block-heading has-text-align-center section-title fade-in">
            <span data-subtitle="MENU"><?php esc_html_e('Menu', 'enyoi'); ?></span>
        </h2>
        <!-- /wp:heading -->

        <!-- wp:group {"className":"menu-category fade-in"} -->
        <div class="wp-block-group menu-category fade-in"><!-- wp:heading {"level":3,"className":"category-title"} -->
            <h3 class="wp-block-heading category-title"><?php esc_html_e('Cut and Styling', 'enyoi'); ?></h3>
            <!-- /wp:heading -->

            <!-- wp:group {"className":"menu-grid","layout":{"type":"grid","columnCount":3}} -->
            <div class="wp-block-group menu-grid"><!-- wp:group {"className":"menu-item"} -->
                <div class="wp-block-group menu-item"><!-- wp:heading {"level":4,"className":"menu-name"} -->
                    <h4 class="wp-block-heading menu-name"><?php esc_html_e('Ladies Cut', 'enyoi'); ?></h4>
                    <!-- /wp:heading -->

                    <!-- wp:paragraph {"className":"menu-description"} -->
                    <p class="menu-description"><?php esc_html_e('From trendy styles to haircuts that suit you', 'enyoi'); ?></p>
                    <!-- /wp:paragraph -->

                    <!-- wp:paragraph {"className":"menu-price"} -->
                    <p class="menu-price"><?php esc_html_e('￥4,500〜', 'enyoi'); ?></p>
                    <!-- /wp:paragraph -->
                </div>
                <!-- /wp:group -->

                <!-- wp:group {"className":"menu-item"} -->
                <div class="wp-block-group menu-item"><!-- wp:heading {"level":4,"className":"menu-name"} -->
                    <h4 class="wp-block-heading menu-name"><?php esc_html_e('Mens Cut', 'enyoi'); ?></h4>
                    <!-- /wp:heading -->

                    <!-- wp:paragraph {"className":"menu-description"} -->
                    <p class="menu-description"><?php esc_html_e('A sophisticated style that is also suitable for business occasions', 'enyoi'); ?></p>
                    <!-- /wp:paragraph -->

                    <!-- wp:paragraph {"className":"menu-price"} -->
                    <p class="menu-price"><?php esc_html_e('￥3,500〜', 'enyoi'); ?></p>
                    <!-- /wp:paragraph -->
                </div>
                <!-- /wp:group -->

                <!-- wp:group {"className":"menu-item"} -->
                <div class="wp-block-group menu-item"><!-- wp:heading {"level":4,"className":"menu-name"} -->
                    <h4 class="wp-block-heading menu-name"><?php esc_html_e('Shampoo and blow dry', 'enyoi'); ?></h4>
                    <!-- /wp:heading -->

                    <!-- wp:paragraph {"className":"menu-description"} -->
                    <p class="menu-description"><?php esc_html_e('Refresh your scalp with scalp care and styling', 'enyoi'); ?></p>
                    <!-- /wp:paragraph -->

                    <!-- wp:paragraph {"className":"menu-price"} -->
                    <p class="menu-price"><?php esc_html_e('￥2,500', 'enyoi'); ?></p>
                    <!-- /wp:paragraph -->
                </div>
                <!-- /wp:group -->
            </div>
            <!-- /wp:group -->
        </div>
        <!-- /wp:group -->

        <!-- wp:group {"className":"menu-category fade-in"} -->
        <div class="wp-block-group menu-category fade-in"><!-- wp:heading {"level":3,"className":"category-title"} -->
            <h3 class="wp-block-heading category-title"><?php esc_html_e('Coloring', 'enyoi'); ?></h3>
            <!-- /wp:heading -->

            <!-- wp:group {"className":"menu-grid","layout":{"type":"grid","columnCount":3}} -->
            <div class="wp-block-group menu-grid"><!-- wp:group {"className":"menu-item"} -->
                <div class="wp-block-group menu-item"><!-- wp:heading {"level":4,"className":"menu-name"} -->
                    <h4 class="wp-block-heading menu-name"><?php esc_html_e('Full Color', 'enyoi'); ?></h4>
                    <!-- /wp:heading -->

                    <!-- wp:paragraph {"className":"menu-description"} -->
                    <p class="menu-description"><?php esc_html_e('A complete color change gives a fresh impression', 'enyoi'); ?></p>
                    <!-- /wp:paragraph -->

                    <!-- wp:paragraph {"className":"menu-price"} -->
                    <p class="menu-price"><?php esc_html_e('￥6,500〜', 'enyoi'); ?></p>
                    <!-- /wp:paragraph -->
                </div>
                <!-- /wp:group -->

                <!-- wp:group {"className":"menu-item"} -->
                <div class="wp-block-group menu-item"><!-- wp:heading {"level":4,"className":"menu-name"} -->
                    <h4 class="wp-block-heading menu-name"><?php esc_html_e('Highlights and Lowlights', 'enyoi'); ?></h4>
                    <!-- /wp:heading -->

                    <!-- wp:paragraph {"className":"menu-description"} -->
                    <p class="menu-description"><?php esc_html_e('A three-dimensional finish with depth', 'enyoi'); ?></p>
                    <!-- /wp:paragraph -->

                    <!-- wp:paragraph {"className":"menu-price"} -->
                    <p class="menu-price"><?php esc_html_e('￥8,500〜', 'enyoi'); ?></p>
                    <!-- /wp:paragraph -->
                </div>
                <!-- /wp:group -->

                <!-- wp:group {"className":"menu-item"} -->
                <div class="wp-block-group menu-item"><!-- wp:heading {"level":4,"className":"menu-name"} -->
                    <h4 class="wp-block-heading menu-name"><?php esc_html_e('Retouch Color', 'enyoi'); ?></h4>
                    <!-- /wp:heading -->

                    <!-- wp:paragraph {"className":"menu-description"} -->
                    <p class="menu-description"><?php esc_html_e('Thoroughly covers problem areas around the roots', 'enyoi'); ?></p>
                    <!-- /wp:paragraph -->

                    <!-- wp:paragraph {"className":"menu-price"} -->
                    <p class="menu-price"><?php esc_html_e('￥4,500〜', 'enyoi'); ?></p>
                    <!-- /wp:paragraph -->
                </div>
                <!-- /wp:group -->
            </div>
            <!-- /wp:group -->
        </div>
        <!-- /wp:group -->

        <!-- wp:group {"className":"menu-category fade-in"} -->
        <div class="wp-block-group menu-category fade-in"><!-- wp:heading {"level":3,"className":"category-title"} -->
            <h3 class="wp-block-heading category-title"><?php esc_html_e('Perm and Straight', 'enyoi'); ?></h3>
            <!-- /wp:heading -->

            <!-- wp:group {"className":"menu-grid","layout":{"type":"grid","columnCount":3}} -->
            <div class="wp-block-group menu-grid"><!-- wp:group {"className":"menu-item"} -->
                <div class="wp-block-group menu-item"><!-- wp:heading {"level":4,"className":"menu-name"} -->
                    <h4 class="wp-block-heading menu-name"><?php esc_html_e('Digital perm', 'enyoi'); ?></h4>
                    <!-- /wp:heading -->

                    <!-- wp:paragraph {"className":"menu-description"} -->
                    <p class="menu-description"><?php esc_html_e('Long-lasting, beautiful curl style', 'enyoi'); ?></p>
                    <!-- /wp:paragraph -->

                    <!-- wp:paragraph {"className":"menu-price"} -->
                    <p class="menu-price"><?php esc_html_e('￥9,500〜', 'enyoi'); ?></p>
                    <!-- /wp:paragraph -->
                </div>
                <!-- /wp:group -->

                <!-- wp:group {"className":"menu-item"} -->
                <div class="wp-block-group menu-item"><!-- wp:heading {"level":4,"className":"menu-name"} -->
                    <h4 class="wp-block-heading menu-name"><?php esc_html_e('Hair straightening', 'enyoi'); ?></h4>
                    <!-- /wp:heading -->

                    <!-- wp:paragraph {"className":"menu-description"} -->
                    <p class="menu-description"><?php esc_html_e('Turn curly hair into naturally straight hair', 'enyoi'); ?></p>
                    <!-- /wp:paragraph -->

                    <!-- wp:paragraph {"className":"menu-price"} -->
                    <p class="menu-price"><?php esc_html_e('￥12,000〜', 'enyoi'); ?></p>
                    <!-- /wp:paragraph -->
                </div>
                <!-- /wp:group -->

                <!-- wp:group {"className":"menu-item"} -->
                <div class="wp-block-group menu-item"><!-- wp:heading {"level":4,"className":"menu-name"} -->
                    <h4 class="wp-block-heading menu-name"><?php esc_html_e('Air Wave', 'enyoi'); ?></h4>
                    <!-- /wp:heading -->

                    <!-- wp:paragraph {"className":"menu-description"} -->
                    <p class="menu-description"><?php esc_html_e('Soft and natural wave style', 'enyoi'); ?></p>
                    <!-- /wp:paragraph -->

                    <!-- wp:paragraph {"className":"menu-price"} -->
                    <p class="menu-price"><?php esc_html_e('￥8,500〜', 'enyoi'); ?></p>
                    <!-- /wp:paragraph -->
                </div>
                <!-- /wp:group -->
            </div>
            <!-- /wp:group -->
        </div>
        <!-- /wp:group -->

        <!-- wp:group {"className":"menu-category fade-in"} -->
        <div class="wp-block-group menu-category fade-in"><!-- wp:heading {"level":3,"className":"category-title"} -->
            <h3 class="wp-block-heading category-title"><?php esc_html_e('Head spa treatment', 'enyoi'); ?></h3>
            <!-- /wp:heading -->

            <!-- wp:group {"className":"menu-grid","layout":{"type":"grid","columnCount":3}} -->
            <div class="wp-block-group menu-grid"><!-- wp:group {"className":"menu-item"} -->
                <div class="wp-block-group menu-item"><!-- wp:heading {"level":4,"className":"menu-name"} -->
                    <h4 class="wp-block-heading menu-name"><?php esc_html_e('Relaxation Spa', 'enyoi'); ?></h4>
                    <!-- /wp:heading -->

                    <!-- wp:paragraph {"className":"menu-description"} -->
                    <p class="menu-description"><?php esc_html_e('Relaxing scalp massage', 'enyoi'); ?></p>
                    <!-- /wp:paragraph -->

                    <!-- wp:paragraph {"className":"menu-price"} -->
                    <p class="menu-price"><?php esc_html_e('￥3,500', 'enyoi'); ?></p>
                    <!-- /wp:paragraph -->
                </div>
                <!-- /wp:group -->

                <!-- wp:group {"className":"menu-item"} -->
                <div class="wp-block-group menu-item"><!-- wp:heading {"level":4,"className":"menu-name"} -->
                    <h4 class="wp-block-heading menu-name"><?php esc_html_e('Intensive Repair Treatment', 'enyoi'); ?></h4>
                    <!-- /wp:heading -->

                    <!-- wp:paragraph {"className":"menu-description"} -->
                    <p class="menu-description"><?php esc_html_e('Intensive care for damaged hair', 'enyoi'); ?></p>
                    <!-- /wp:paragraph -->

                    <!-- wp:paragraph {"className":"menu-price"} -->
                    <p class="menu-price"><?php esc_html_e('￥4,500', 'enyoi'); ?></p>
                    <!-- /wp:paragraph -->
                </div>
                <!-- /wp:group -->

                <!-- wp:group {"className":"menu-item"} -->
                <div class="wp-block-group menu-item"><!-- wp:heading {"level":4,"className":"menu-name"} -->
                    <h4 class="wp-block-heading menu-name"><?php esc_html_e('Carbonated Spa', 'enyoi'); ?></h4>
                    <!-- /wp:heading -->

                    <!-- wp:paragraph {"className":"menu-description"} -->
                    <p class="menu-description"><?php esc_html_e('Carbonation effect improves scalp environment', 'enyoi'); ?></p>
                    <!-- /wp:paragraph -->

                    <!-- wp:paragraph {"className":"menu-price"} -->
                    <p class="menu-price"><?php esc_html_e('￥2,500', 'enyoi'); ?></p>
                    <!-- /wp:paragraph -->
                </div>
                <!-- /wp:group -->
            </div>
            <!-- /wp:group -->
        </div>
        <!-- /wp:group -->
    </div>
    <!-- /wp:group -->
</section>
<!-- /wp:group -->