<?php
/**
 * The Header Layout-6
 *
 * @package Envy Blog
 */
$search_activate = get_theme_mod( 'envy-blog_header_search_icon_activate', true );
$cart_activate   = get_theme_mod( 'envy-blog_header_wc_cart_icon_activate', true );
?>

<div class="site-branding">
    <?php if ( is_front_page() ) : ?>
        <h1 class="site-title">
            <?php the_custom_logo(); ?>

            <?php if( true == get_theme_mod( 'envy-blog_header_site_title_activate', true ) ) { ?>
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                    <?php bloginfo( 'name' ); ?>
                </a>
            <?php } ?>
        </h1>
    <?php else : ?>
        <p class="site-title">
            <?php the_custom_logo(); ?>

            <?php if( true == get_theme_mod( 'envy-blog_header_site_title_activate', true ) ) { ?>
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                    <?php bloginfo( 'name' ); ?>
                </a>
            <?php } ?>
        </p>
    <?php endif; ?>

    <?php
    if ( true == get_theme_mod( 'envy-blog_header_site_tagline_activate', true ) ) :
        $description = get_bloginfo( 'description', 'display' );
        if ( $description || is_customize_preview() ) : ?>
            <p class="site-description"><?php echo esc_html($description); /* WPCS: xss ok. */ ?></p>
        <?php
        endif;
    endif;
    ?>
</div><!-- .site-branding -->

<div id="site-navigation" class="main-navigation" role="navigation">
    <div class="main-navigation-wrap main-navigation-sm desktop-only">
        <?php wp_nav_menu( array( 'theme_location' => 'primary' ) ); ?>
    </div>

    <div class="nav-bar-extended">
        <?php if ( true == $search_activate || true == $cart_activate ) : ?>
            <ul>
                <?php if ( true == $search_activate ) { ?><li class="nav-bar-search-icon"><a href="#"><i class="pt-icon-search"></i></a></li><?php } ?>

                <?php if ( true == $cart_activate && class_exists( 'WooCommerce' ) ) { ?>
                    <li class="nav-bar-cart-icon">
                        <a href="<?php echo esc_url( WC()->cart->get_cart_url() ); ?>">
                            <i class="pt-icon-cart"></i>
                            <span class="nav-bar-cart">
                                <span class="nav-bar-cart-value">
                                    <?php echo wp_kses_data ( WC()->cart->get_cart_contents_count() ); ?>
                                </span>
                            </span>
                        </a>

                        <div class="nav-bar-shopping-cart-widget transition-35">
                            <?php the_widget('WC_Widget_Cart');  ?>
                        </div>
                    </li>
                <?php } ?>
            </ul>
        <?php endif; ?>

        <div class="hamburger-menu hamburger-menu-primary open">
            <a href="#">
                <span></span>
                <span></span>
                <span></span>
                <span></span>
            </a>
        </div><!-- .hamburger-menu -->
    </div><!-- .nav-bar-extended -->

    <div class="main-navigation-wrap main-navigation-sm mobile-only">
        <?php wp_nav_menu( array( 'theme_location' => 'primary' ) ); ?>
        <div class="hamburger-menu hamburger-menu-primary open">
            <a href="#">
                <span></span>
                <span></span>
                <span></span>
                <span></span>
            </a>
        </div><!-- .hamburger-menu -->

    </div>

</div><!-- #site-navigation -->


<?php if ( true == $search_activate ) { ?>
     <div class="nav-bar-search-wrap transition-5">
        
        <div class="nav-bar-search-holder">
            <button class="circular-focus screen-reader-text" data-goto=".nav-bar-search-close"><?php esc_html_e( 'Circular focus', 'envy-blog' ); ?></button>
            <?php get_search_form( true ); ?>
            <a class="nav-bar-search-close" href="#"><i class="pt-icon-close transition-5"></i></a>
            <button class="circular-focus screen-reader-text" data-goto=".search-field"><?php esc_html_e( 'Circular focus', 'envy-blog' ); ?></button>
        </div><!-- .nav-bar-search-holder -->
    </div><!-- .nav-bar-search-wrap -->
<?php } ?>
