<?php
/**
 * Template part for displaying front page introduction.
 *
 * @package Entire News
 */

// Banner Section.
$banner_section = get_theme_mod( 'entire_news_banner_section_enable', false );

if ( false === $banner_section ) {
	return;
}

$featured_news_content_ids  = $trending_news_content_ids = $banner_slider_content_ids = $banner_grid_content_ids = array();
$featured_news_content_type = get_theme_mod( 'entire_news_featured_news_content_type', 'post' );
$trending_news_content_type = get_theme_mod( 'entire_news_trending_news_content_type', 'post' );
$slider_news_content_type   = get_theme_mod( 'entire_news_banner_slider_content_type', 'post' );
$banner_grid_content_type   = get_theme_mod( 'entire_news_banner_grid_content_type', 'post' );

if ( $featured_news_content_type === 'post' ) {

	for ( $i = 1; $i <= 2; $i++ ) {
		$featured_news_content_ids[] = get_theme_mod( 'entire_news_featured_news_post_' . $i );
	}

	$featured_news_args = array(
		'post_type'           => 'post',
		'posts_per_page'      => absint( 2 ),
		'ignore_sticky_posts' => true,
	);

	if ( ! empty( array_filter( $featured_news_content_ids ) ) ) {
		$featured_news_args['post__in'] = array_filter( $featured_news_content_ids );
		$featured_news_args['orderby']  = 'post__in';
	} else {
		$featured_news_args['orderby'] = 'date';
	}

} else {
	$cat_content_id     = get_theme_mod( 'entire_news_featured_news_category' );
	$featured_news_args = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( 2 ),
	);
}

if ( $trending_news_content_type === 'post' ) {

	for ( $i = 1; $i <= 6; $i++ ) {
		$trending_news_content_ids[] = get_theme_mod( 'entire_news_trending_news_post_' . $i );
	}

	$trending_news_args = array(
		'post_type'           => 'post',
		'posts_per_page'      => absint( 6 ),
		'ignore_sticky_posts' => true,
	);

	if ( ! empty( array_filter( $trending_news_content_ids ) ) ) {
		$trending_news_args['post__in'] = array_filter( $trending_news_content_ids );
		$trending_news_args['orderby']  = 'post__in';
	} else {
		$trending_news_args['orderby'] = 'date';
	}

} else {
	$cat_content_id     = get_theme_mod( 'entire_news_trending_news_category' );
	$trending_news_args = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( 6 ),
	);
}

if ( $slider_news_content_type === 'post' ) {

	for ( $i = 1; $i <= 3; $i++ ) {
		$banner_slider_content_ids[] = get_theme_mod( 'entire_news_banner_slider_post_' . $i );
	}

	$banner_slider_args = array(
		'post_type'           => 'post',
		'posts_per_page'      => absint( 3 ),
		'ignore_sticky_posts' => true,
	);

	if ( ! empty( array_filter( $banner_slider_content_ids ) ) ) {
		$banner_slider_args['post__in'] = array_filter( $banner_slider_content_ids );
		$banner_slider_args['orderby']  = 'post__in';
	} else {
		$banner_slider_args['orderby'] = 'date';
	}

} else {
	$cat_content_id     = get_theme_mod( 'entire_news_banner_slider_category' );
	$banner_slider_args = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( 3 ),
	);
}

if ( $banner_grid_content_type === 'post' ) {

	for ( $i = 1; $i <= 5; $i++ ) {
		$banner_grid_content_ids[] = get_theme_mod( 'entire_news_banner_grid_post_' . $i );
	}

	$banner_grid_args = array(
		'post_type'           => 'post',
		'posts_per_page'      => absint( 5 ),
		'ignore_sticky_posts' => true,
	);

	if ( ! empty( array_filter( $banner_grid_content_ids ) ) ) {
		$banner_grid_args['post__in'] = array_filter( $banner_grid_content_ids );
		$banner_grid_args['orderby']  = 'post__in';
	} else {
		$banner_grid_args['orderby'] = 'date';
	}

} else {
	$cat_content_id   = get_theme_mod( 'entire_news_banner_grid_category' );
	$banner_grid_args = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( 5 ),
	);
}

?>

<div id="entire_news_banner_section" class="main-banner-section style-2 adore-navigation">
	<div class="theme-wrapper">
		<div class="main-banner-section-wrapper">
			<?php
			require get_template_directory() . '/inc/frontpage-sections/banner-sections/featured-news.php';
			require get_template_directory() . '/inc/frontpage-sections/banner-sections/banner-slider.php';
			require get_template_directory() . '/inc/frontpage-sections/banner-sections/trending-news.php';
			?>

		</div>

		<?php
		require get_template_directory() . '/inc/frontpage-sections/banner-sections/banner-grid.php';
		?>

	</div>
</div>
