<?php $trending_title = get_theme_mod( 'entire_news_trending_news_title', __( 'Trending News', 'entire-news' ) ); ?>
<div class="banner-trending-news">
	<div class="trending-news-wrapper">
		<?php if ( ! empty( $trending_title ) ) : ?>
			<div class="widget-header">
				<h3 class="widget-title"><?php echo esc_html( $trending_title ); ?></h3>			
			</div>
			<?php
		endif;
		$trending_query = new WP_Query( $trending_news_args );
		if ( $trending_query->have_posts() ) {
			$i = 1;
			while ( $trending_query->have_posts() ) :
				$trending_query->the_post();
				?>
				<div class="post-item post-list small-list">
					<div class="post-item-number">
						<?php echo absint( $i ); ?>
					</div>
					<div class="post-item-content">
						<h3 class="entry-title">
							<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
						</h3> 
						<ul class="entry-meta">
							<li class="post-author"> <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><span class="far fa-user"></span><?php echo esc_html( get_the_author() ); ?></a></li>
							<li class="post-date"> <span class="far fa-calendar-alt"></span><?php echo esc_html( get_the_date() ); ?></li>
							<li class="post-comment"><span class="far fa-comment"></span><?php echo absint( get_comments_number( get_the_ID() ) ); ?></li>
						</ul> 
					</div>
				</div>
				<?php
				$i++;
			endwhile;
			wp_reset_postdata();
		}
		?>
	</div>
</div>
