<div class="banner-featured-news">
	<div class="featured-news-wrapper">
		<?php
		$featured_query = new WP_Query( $featured_news_args );
		if ( $featured_query->have_posts() ) {
			while ( $featured_query->have_posts() ) :
				$featured_query->the_post();
				?>
				<div class="post-item post-grid">
					<?php if ( has_post_thumbnail() ) { ?>
						<div class="post-item-image">
							<a href="<?php the_permalink(); ?>">
								<?php the_post_thumbnail( 'post-thumbnail' ); ?>
							</a>
						</div>
					<?php } ?>
					<div class="post-item-content">
						<div class="entry-cat no-bg">
							<?php the_category( '', '', get_the_ID() ); ?>							
						</div>
						<h3 class="entry-title">
							<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
						</h3>  
						<ul class="entry-meta">
							<li class="post-author"> <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><span class="far fa-user"></span><?php echo esc_html( get_the_author() ); ?></a></li>
							<li class="post-date"> <span class="far fa-calendar-alt"></span><?php echo esc_html( get_the_date() ); ?></li>
							<li class="post-comment"><span class="far fa-comment"></span><?php echo absint( get_comments_number( get_the_ID() ) ); ?></li>
						</ul> 
					</div>
				</div>
				<?php
			endwhile;
			wp_reset_postdata();
		}
		?>
	</div>
</div>
