<div class="banner-main-news">
	<div class="banner-main-news-wrapper banner-slider">
		<?php
		$banner_slider_query = new WP_Query( $banner_slider_args );
		if ( $banner_slider_query->have_posts() ) {
			while ( $banner_slider_query->have_posts() ) :
				$banner_slider_query->the_post();
				$read_more_btn = get_theme_mod( 'entire_news_posts_banner_slider_button_label', __( 'Read More', 'entire-news' ) );
				?>

				<div class="post-item post-grid">
					<div class="post-item-image">
						<a href="<?php the_permalink(); ?>">
							<?php the_post_thumbnail( 'post-thumbnail' ); ?>
						</a>
					</div>
					<div class="post-item-content">
						<div class="entry-cat no-bg">
							<?php the_category( '', '', get_the_ID() ); ?>						
						</div>
						<h3 class="entry-title">
							<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
						</h3>  
						<ul class="entry-meta">
							<li class="post-author"> <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><span class="far fa-user"></span><?php echo esc_html( get_the_author() ); ?></a></li>
							<li class="post-date"> <span class="far fa-calendar-alt"></span><?php echo esc_html( get_the_date() ); ?></li>
							<li class="post-comment"><span class="far fa-comment"></span><?php echo absint( get_comments_number( get_the_ID() ) ); ?></li>
						</ul>
						<div class="post-exerpt">
							<p><?php echo wp_kses_post( wp_trim_words( get_the_excerpt(), 20 ) ); ?></p>
						</div>
						<?php if ( ! empty( $read_more_btn ) ) { ?>
							<div class="post-btn">
								<a href="<?php the_permalink(); ?>" class="btn-read-more"><?php echo esc_html( $read_more_btn ); ?><i></i></a>
							</div>
						<?php } ?>
					</div>
				</div>
				<?php
			endwhile;
			wp_reset_postdata();
		}
		?>
	</div>
</div>
