<div class="banner-grid-posts">
	<div class="banner-grid-posts-wrapper">
		<?php
		$banner_grid_query = new WP_Query( $banner_grid_args );
		if ( $banner_grid_query->have_posts() ) {
			$i = 1;
			while ( $banner_grid_query->have_posts() ) :
				$banner_grid_query->the_post();
				$small_list_class = ( $i === 1 ? ' ' : 'small-list' );
				?>

				<div class="post-item post-list <?php echo esc_attr( $small_list_class ); ?>">
					<?php if ( has_post_thumbnail() ) { ?>
						<div class="post-item-image">
							<a href="<?php the_permalink(); ?>">
								<?php the_post_thumbnail( 'post-thumbnail' ); ?>
							</a>
						</div>
					<?php } ?>
					<div class="post-item-content">
						<?php if ( $i === 1 ) : ?>
							<div class="entry-cat no-bg">
								<?php the_category( '', '', get_the_ID() ); ?>
							</div>
						<?php endif; ?>
						<h3 class="entry-title">
							<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
						</h3>  
						<ul class="entry-meta">
							<li class="post-author"> <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><span class="far fa-user"></span><?php echo esc_html( get_the_author() ); ?></a></li>
							<li class="post-date"> <span class="far fa-calendar-alt"></span><?php echo esc_html( get_the_date() ); ?></li>
								<li class="post-comment"><span class="far fa-comment"></span><?php echo absint( get_comments_number( get_the_ID() ) ); ?></li>
						</ul>
					</div>
				</div>

				<?php
				$i++;
			endwhile;
			wp_reset_postdata();
		}
		?>
	</div>
</div>
