<?php
/**
 * Single Post Options
 */

$wp_customize->add_section(
	'entire_news_single_page_options',
	array(
		'title' => esc_html__( 'Single Post Options', 'entire-news' ),
		'panel' => 'entire_news_theme_options_panel',
	)
);

// Enable single post category setting.
$wp_customize->add_setting(
	'entire_news_enable_single_category',
	array(
		'default'           => true,
		'sanitize_callback' => 'entire_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Entire_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'entire_news_enable_single_category',
		array(
			'label'    => esc_html__( 'Enable Category', 'entire-news' ),
			'settings' => 'entire_news_enable_single_category',
			'section'  => 'entire_news_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable single post author setting.
$wp_customize->add_setting(
	'entire_news_enable_single_author',
	array(
		'default'           => true,
		'sanitize_callback' => 'entire_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Entire_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'entire_news_enable_single_author',
		array(
			'label'    => esc_html__( 'Enable Author', 'entire-news' ),
			'settings' => 'entire_news_enable_single_author',
			'section'  => 'entire_news_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable single post date setting.
$wp_customize->add_setting(
	'entire_news_enable_single_date',
	array(
		'default'           => true,
		'sanitize_callback' => 'entire_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Entire_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'entire_news_enable_single_date',
		array(
			'label'    => esc_html__( 'Enable Date', 'entire-news' ),
			'settings' => 'entire_news_enable_single_date',
			'section'  => 'entire_news_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable single post tag setting.
$wp_customize->add_setting(
	'entire_news_enable_single_tag',
	array(
		'default'           => true,
		'sanitize_callback' => 'entire_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Entire_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'entire_news_enable_single_tag',
		array(
			'label'    => esc_html__( 'Enable Post Tag', 'entire-news' ),
			'settings' => 'entire_news_enable_single_tag',
			'section'  => 'entire_news_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Single post related Posts title label.
$wp_customize->add_setting(
	'entire_news_related_posts_title',
	array(
		'default'           => __( 'Related Posts', 'entire-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'entire_news_related_posts_title',
	array(
		'label'    => esc_html__( 'Related Posts Title', 'entire-news' ),
		'section'  => 'entire_news_single_page_options',
		'settings' => 'entire_news_related_posts_title',
	)
);
