<?php
/**
 * Sidebar settings.
 */

$wp_customize->add_section(
	'entire_news_sidebar_option',
	array(
		'title' => esc_html__( 'Sidebar Options', 'entire-news' ),
		'panel' => 'entire_news_theme_options_panel',
	)
);

// Sidebar Option - Global Sidebar Position.
$wp_customize->add_setting(
	'entire_news_sidebar_position',
	array(
		'sanitize_callback' => 'entire_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'entire_news_sidebar_position',
	array(
		'label'   => esc_html__( 'Global Sidebar Position', 'entire-news' ),
		'section' => 'entire_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'entire-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'entire-news' ),
		),
	)
);

// Sidebar Option - Post Sidebar Position.
$wp_customize->add_setting(
	'entire_news_post_sidebar_position',
	array(
		'sanitize_callback' => 'entire_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'entire_news_post_sidebar_position',
	array(
		'label'   => esc_html__( 'Post Sidebar Position', 'entire-news' ),
		'section' => 'entire_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'entire-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'entire-news' ),
		),
	)
);

// Sidebar Option - Page Sidebar Position.
$wp_customize->add_setting(
	'entire_news_page_sidebar_position',
	array(
		'sanitize_callback' => 'entire_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'entire_news_page_sidebar_position',
	array(
		'label'   => esc_html__( 'Page Sidebar Position', 'entire-news' ),
		'section' => 'entire_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'entire-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'entire-news' ),
		),
	)
);
