<?php
/**
 * Pagination setting
 */

// Pagination setting.
$wp_customize->add_section(
	'entire_news_pagination',
	array(
		'title' => esc_html__( 'Pagination', 'entire-news' ),
		'panel' => 'entire_news_theme_options_panel',
	)
);

// Pagination enable setting.
$wp_customize->add_setting(
	'entire_news_pagination_enable',
	array(
		'default'           => true,
		'sanitize_callback' => 'entire_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Entire_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'entire_news_pagination_enable',
		array(
			'label'    => esc_html__( 'Enable Pagination.', 'entire-news' ),
			'settings' => 'entire_news_pagination_enable',
			'section'  => 'entire_news_pagination',
			'type'     => 'checkbox',
		)
	)
);

// Pagination - Pagination Style.
$wp_customize->add_setting(
	'entire_news_pagination_type',
	array(
		'default'           => 'numeric',
		'sanitize_callback' => 'entire_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'entire_news_pagination_type',
	array(
		'label'           => esc_html__( 'Pagination Style', 'entire-news' ),
		'section'         => 'entire_news_pagination',
		'type'            => 'select',
		'choices'         => array(
			'default'  => __( 'Default (Older/Newer)', 'entire-news' ),
			'numeric'  => __( 'Numeric', 'entire-news' ),
		),
		'active_callback' => function( $control ) {
			return ( $control->manager->get_setting( 'entire_news_pagination_enable' )->value() );
		},
	)
);
