<?php
/**
 * Header Options settings
 */

$wp_customize->add_section(
	'entire_news_header_options_section',
	array(
		'title' => esc_html__( 'Header Options', 'entire-news' ),
		'panel' => 'entire_news_theme_options_panel',
	)
);

// Enable topbar Options.
$wp_customize->add_setting(
	'entire_news_enable_topbar',
	array(
		'default'           => true,
		'sanitize_callback' => 'entire_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Entire_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'entire_news_enable_topbar',
		array(
			'label'    => esc_html__( 'Enable Topbar.', 'entire-news' ),
			'section'  => 'entire_news_header_options_section',
			'settings' => 'entire_news_enable_topbar',
			'type'     => 'checkbox',
		)
	)
);
