<?php
/**
 * Adore Themes Customizer
 *
 * @package Entire News
 *
 * Breaking News Section
 */

$wp_customize->add_section(
	'entire_news_breaking_news_section',
	array(
		'title' => esc_html__( 'Breaking News Section', 'entire-news' ),
		'panel' => 'entire_news_frontpage_panel',
	)
);

// Breaking News section enable settings.
$wp_customize->add_setting(
	'entire_news_breaking_news_section_enable',
	array(
		'default'           => false,
		'sanitize_callback' => 'entire_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Entire_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'entire_news_breaking_news_section_enable',
		array(
			'label'    => esc_html__( 'Enable Breaking News Section', 'entire-news' ),
			'type'     => 'checkbox',
			'settings' => 'entire_news_breaking_news_section_enable',
			'section'  => 'entire_news_breaking_news_section',
		)
	)
);

// breaking_news content type settings.
$wp_customize->add_setting(
	'entire_news_breaking_news_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'entire_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'entire_news_breaking_news_content_type',
	array(
		'label'           => esc_html__( 'Content type:', 'entire-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'entire-news' ),
		'section'         => 'entire_news_breaking_news_section',
		'type'            => 'select',
		'active_callback' => 'entire_news_if_breaking_news_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'entire-news' ),
			'category' => esc_html__( 'Category', 'entire-news' ),
		),
	)
);

for ( $i = 1; $i <= 5; $i++ ) {
	// breaking_news post setting.
	$wp_customize->add_setting(
		'entire_news_breaking_news_post_' . $i,
		array(
			'sanitize_callback' => 'entire_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'entire_news_breaking_news_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'entire-news' ), $i ),
			'section'         => 'entire_news_breaking_news_section',
			'type'            => 'select',
			'choices'         => entire_news_get_post_choices(),
			'active_callback' => 'entire_news_breaking_news_section_content_type_post_enabled',
		)
	);

}

// breaking_news category setting.
$wp_customize->add_setting(
	'entire_news_breaking_news_category',
	array(
		'sanitize_callback' => 'entire_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'entire_news_breaking_news_category',
	array(
		'label'           => esc_html__( 'Category', 'entire-news' ),
		'section'         => 'entire_news_breaking_news_section',
		'type'            => 'select',
		'choices'         => entire_news_get_post_cat_choices(),
		'active_callback' => 'entire_news_breaking_news_section_content_type_category_enabled',
	)
);

/*========================Active Callback==============================*/
function entire_news_if_breaking_news_enabled( $control ) {
	return $control->manager->get_setting( 'entire_news_breaking_news_section_enable' )->value();
}
function entire_news_breaking_news_section_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'entire_news_breaking_news_content_type' )->value();
	return entire_news_if_breaking_news_enabled( $control ) && ( 'post' === $content_type );
}
function entire_news_breaking_news_section_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'entire_news_breaking_news_content_type' )->value();
	return entire_news_if_breaking_news_enabled( $control ) && ( 'category' === $content_type );
}
