<?php
/**
 * Adore Themes Customizer
 *
 * @package Entire News
 *
 * Banner Section
 */

$wp_customize->add_section(
	'entire_news_banner_section',
	array(
		'title' => esc_html__( 'Banner Section', 'entire-news' ),
		'panel' => 'entire_news_frontpage_panel',
	)
);

// Banner enable setting.
$wp_customize->add_setting(
	'entire_news_banner_section_enable',
	array(
		'default'           => false,
		'sanitize_callback' => 'entire_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Entire_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'entire_news_banner_section_enable',
		array(
			'label'    => esc_html__( 'Enable Banner Section', 'entire-news' ),
			'type'     => 'checkbox',
			'settings' => 'entire_news_banner_section_enable',
			'section'  => 'entire_news_banner_section',
		)
	)
);

// Featured News Sub Heading.
$wp_customize->add_setting(
	'entire_news_featured_news_sub_heading',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Entire_News_Sub_Section_Heading_Custom_Control(
		$wp_customize,
		'entire_news_featured_news_sub_heading',
		array(
			'label'           => esc_html__( 'Featured News Section', 'entire-news' ),
			'settings'        => 'entire_news_featured_news_sub_heading',
			'section'         => 'entire_news_banner_section',
			'active_callback' => 'entire_news_if_banner_enabled',
		)
	)
);

// banner featured news content type settings.
$wp_customize->add_setting(
	'entire_news_featured_news_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'entire_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'entire_news_featured_news_content_type',
	array(
		'label'           => esc_html__( 'Featured News Content type:', 'entire-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'entire-news' ),
		'section'         => 'entire_news_banner_section',
		'settings'        => 'entire_news_featured_news_content_type',
		'type'            => 'select',
		'active_callback' => 'entire_news_if_banner_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'entire-news' ),
			'category' => esc_html__( 'Category', 'entire-news' ),
		),
	)
);

for ( $i = 1; $i <= 2; $i++ ) {
	// Featured News post setting.
	$wp_customize->add_setting(
		'entire_news_featured_news_post_' . $i,
		array(
			'sanitize_callback' => 'entire_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'entire_news_featured_news_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'entire-news' ), $i ),
			'section'         => 'entire_news_banner_section',
			'type'            => 'select',
			'choices'         => entire_news_get_post_choices(),
			'active_callback' => 'entire_news_featured_news_section_content_type_post_enabled',
		)
	);
}

// Featured News category setting.
$wp_customize->add_setting(
	'entire_news_featured_news_category',
	array(
		'sanitize_callback' => 'entire_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'entire_news_featured_news_category',
	array(
		'label'           => esc_html__( 'Category', 'entire-news' ),
		'section'         => 'entire_news_banner_section',
		'type'            => 'select',
		'choices'         => entire_news_get_post_cat_choices(),
		'active_callback' => 'entire_news_featured_news_section_content_type_category_enabled',
	)
);

// Banner Slider Sub Heading.
$wp_customize->add_setting(
	'entire_news_banner_slider_sub_heading',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Entire_News_Sub_Section_Heading_Custom_Control(
		$wp_customize,
		'entire_news_banner_slider_sub_heading',
		array(
			'label'           => esc_html__( 'Banner Slider Section', 'entire-news' ),
			'settings'        => 'entire_news_banner_slider_sub_heading',
			'section'         => 'entire_news_banner_section',
			'active_callback' => 'entire_news_if_banner_enabled',
		)
	)
);

// banner featured news content type settings.
$wp_customize->add_setting(
	'entire_news_banner_slider_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'entire_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'entire_news_banner_slider_content_type',
	array(
		'label'           => esc_html__( 'Banner Slider Content type:', 'entire-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'entire-news' ),
		'section'         => 'entire_news_banner_section',
		'settings'        => 'entire_news_banner_slider_content_type',
		'type'            => 'select',
		'active_callback' => 'entire_news_if_banner_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'entire-news' ),
			'category' => esc_html__( 'Category', 'entire-news' ),
		),
	)
);

for ( $i = 1; $i <= 3; $i++ ) {
	// Banner Slider post setting.
	$wp_customize->add_setting(
		'entire_news_banner_slider_post_' . $i,
		array(
			'sanitize_callback' => 'entire_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'entire_news_banner_slider_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'entire-news' ), $i ),
			'section'         => 'entire_news_banner_section',
			'type'            => 'select',
			'choices'         => entire_news_get_post_choices(),
			'active_callback' => 'entire_news_banner_slider_section_content_type_post_enabled',
		)
	);

}

// Banner Slider category setting.
$wp_customize->add_setting(
	'entire_news_banner_slider_category',
	array(
		'sanitize_callback' => 'entire_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'entire_news_banner_slider_category',
	array(
		'label'           => esc_html__( 'Category', 'entire-news' ),
		'section'         => 'entire_news_banner_section',
		'type'            => 'select',
		'choices'         => entire_news_get_post_cat_choices(),
		'active_callback' => 'entire_news_banner_slider_section_content_type_category_enabled',
	)
);

// Read More button label setting.
$wp_customize->add_setting(
	'entire_news_posts_banner_slider_button_label',
	array(
		'default'           => __( 'Read More', 'entire-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'entire_news_posts_banner_slider_button_label',
	array(
		'label'           => esc_html__( 'Read More Button Label', 'entire-news' ),
		'section'         => 'entire_news_banner_section',
		'type'            => 'text',
		'active_callback' => 'entire_news_if_banner_enabled',
	)
);

// Trending News Sub Heading.
$wp_customize->add_setting(
	'entire_news_trending_news_sub_heading',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Entire_News_Sub_Section_Heading_Custom_Control(
		$wp_customize,
		'entire_news_trending_news_sub_heading',
		array(
			'label'           => esc_html__( 'Trending News Section', 'entire-news' ),
			'settings'        => 'entire_news_trending_news_sub_heading',
			'section'         => 'entire_news_banner_section',
			'active_callback' => 'entire_news_if_banner_enabled',
		)
	)
);

// Trending News title settings.
$wp_customize->add_setting(
	'entire_news_trending_news_title',
	array(
		'default'           => __( 'Trending News', 'entire-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'entire_news_trending_news_title',
	array(
		'label'           => esc_html__( 'Title', 'entire-news' ),
		'section'         => 'entire_news_banner_section',
		'active_callback' => 'entire_news_if_banner_enabled',
	)
);

// banner featured news content type settings.
$wp_customize->add_setting(
	'entire_news_trending_news_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'entire_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'entire_news_trending_news_content_type',
	array(
		'label'           => esc_html__( 'Trending News Content type:', 'entire-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'entire-news' ),
		'section'         => 'entire_news_banner_section',
		'settings'        => 'entire_news_trending_news_content_type',
		'type'            => 'select',
		'active_callback' => 'entire_news_if_banner_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'entire-news' ),
			'category' => esc_html__( 'Category', 'entire-news' ),
		),
	)
);

for ( $i = 1; $i <= 6; $i++ ) {
	// Trending News post setting.
	$wp_customize->add_setting(
		'entire_news_trending_news_post_' . $i,
		array(
			'sanitize_callback' => 'entire_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'entire_news_trending_news_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'entire-news' ), $i ),
			'section'         => 'entire_news_banner_section',
			'type'            => 'select',
			'choices'         => entire_news_get_post_choices(),
			'active_callback' => 'entire_news_trending_news_section_content_type_post_enabled',
		)
	);

}

// Trending News category setting.
$wp_customize->add_setting(
	'entire_news_trending_news_category',
	array(
		'sanitize_callback' => 'entire_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'entire_news_trending_news_category',
	array(
		'label'           => esc_html__( 'Category', 'entire-news' ),
		'section'         => 'entire_news_banner_section',
		'type'            => 'select',
		'choices'         => entire_news_get_post_cat_choices(),
		'active_callback' => 'entire_news_trending_news_section_content_type_category_enabled',
	)
);

// Banner Grid Sub Heading.
$wp_customize->add_setting(
	'entire_news_banner_grid_sub_heading',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Entire_News_Sub_Section_Heading_Custom_Control(
		$wp_customize,
		'entire_news_banner_grid_sub_heading',
		array(
			'label'           => esc_html__( 'Banner Grid Section', 'entire-news' ),
			'settings'        => 'entire_news_banner_grid_sub_heading',
			'section'         => 'entire_news_banner_section',
			'active_callback' => 'entire_news_if_banner_enabled',
		)
	)
);

// banner featured news content type settings.
$wp_customize->add_setting(
	'entire_news_banner_grid_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'entire_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'entire_news_banner_grid_content_type',
	array(
		'label'           => esc_html__( 'Banner Grid Content type:', 'entire-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'entire-news' ),
		'section'         => 'entire_news_banner_section',
		'settings'        => 'entire_news_banner_grid_content_type',
		'type'            => 'select',
		'active_callback' => 'entire_news_if_banner_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'entire-news' ),
			'category' => esc_html__( 'Category', 'entire-news' ),
		),
	)
);

for ( $i = 1; $i <= 5; $i++ ) {
	// Banner Grid post setting.
	$wp_customize->add_setting(
		'entire_news_banner_grid_post_' . $i,
		array(
			'sanitize_callback' => 'entire_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'entire_news_banner_grid_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'entire-news' ), $i ),
			'section'         => 'entire_news_banner_section',
			'type'            => 'select',
			'choices'         => entire_news_get_post_choices(),
			'active_callback' => 'entire_news_banner_grid_section_content_type_post_enabled',
		)
	);

}

// Banner Grid category setting.
$wp_customize->add_setting(
	'entire_news_banner_grid_category',
	array(
		'sanitize_callback' => 'entire_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'entire_news_banner_grid_category',
	array(
		'label'           => esc_html__( 'Category', 'entire-news' ),
		'section'         => 'entire_news_banner_section',
		'type'            => 'select',
		'choices'         => entire_news_get_post_cat_choices(),
		'active_callback' => 'entire_news_banner_grid_section_content_type_category_enabled',
	)
);

/*========================Active Callback==============================*/
function entire_news_if_banner_enabled( $control ) {
	return $control->manager->get_setting( 'entire_news_banner_section_enable' )->value();
}
// Banner Featured News.
function entire_news_featured_news_section_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'entire_news_featured_news_content_type' )->value();
	return entire_news_if_banner_enabled( $control ) && ( 'post' === $content_type );
}
function entire_news_featured_news_section_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'entire_news_featured_news_content_type' )->value();
	return entire_news_if_banner_enabled( $control ) && ( 'category' === $content_type );
}
// Banner Slider.
function entire_news_banner_slider_section_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'entire_news_banner_slider_content_type' )->value();
	return entire_news_if_banner_enabled( $control ) && ( 'post' === $content_type );
}
function entire_news_banner_slider_section_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'entire_news_banner_slider_content_type' )->value();
	return entire_news_if_banner_enabled( $control ) && ( 'category' === $content_type );
}
// Banner Trending News.
function entire_news_trending_news_section_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'entire_news_trending_news_content_type' )->value();
	return entire_news_if_banner_enabled( $control ) && ( 'post' === $content_type );
}
function entire_news_trending_news_section_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'entire_news_trending_news_content_type' )->value();
	return entire_news_if_banner_enabled( $control ) && ( 'category' === $content_type );
}
// Banner Grid.
function entire_news_banner_grid_section_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'entire_news_banner_grid_content_type' )->value();
	return entire_news_if_banner_enabled( $control ) && ( 'post' === $content_type );
}
function entire_news_banner_grid_section_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'entire_news_banner_grid_content_type' )->value();
	return entire_news_if_banner_enabled( $control ) && ( 'category' === $content_type );
}
