<?php defined( 'ABSPATH' ) || exit;
/**
 * Template Name: Full default page, no sidebar
 * Template Post Type: post, page, product, locations
 *
 * @package WordPress
 * @subpackage Entex Theme
 * @author Jonas Lundman
 * @documentation http://wordpress.entex.info
 * @since 2013-11-06
 * @updated 2018-03-01
 */
 
/**
 * TEMPLATE EXPLAINED
 *
 * This is a WordPress 'Page attributes' template
 * This is selected by the metabox nearby 'Save post' button
 * The first 'root' template in use for that post
 *
 * This template removes the aside section / sidebar
 * And make the first column full width
 * The document content area margins are intact
 *
 * Useful when the content has wide tables or representing data
 * In combination with sitewidth, the page mimics a printable document
 * 
 */

/**
 * TEMPLATE FUNCTIONS
 * This is what we need to render full width
 */
 
/* Override column settings */
add_filter('body_class', function($classes){
	$classes[] = 'ua-doc-set-full';
	return $classes;
}, 10, 1);

/* Remove 'sidebar' */
add_filter('entex_template_aside', function($render){
	return false;
}, 10, 1);

define('ENTEX_TEMPLATE_SHORTCUT_TABS_DISABLE', true);
 
get_template_part('index');

// -- END FILE -- //