<?php defined( 'ABSPATH' ) || exit;
/**
 * Template Name: Style full article setup
 * Template Post Type: template-style
 *
 * @package Entex
 * @subpackage Entex
 * @since Entex 1.0
 * @version 2.30325
 */

$add = '

/* remove the main extra margins on singular pages */
body.wp-is-singular .ua-grid-box > main.ua-main {
  padding-left: 0;
  padding-right: 0;
}

#main-header {
  display: grid;
  position: relative;
  grid-template-columns: auto 33.333%;
  grid-auto-rows: minmax(min-content, max-content);
  grid-auto-columns: auto;
  grid-column-gap: 0em;
  grid-row-gap: 0em;
}

#main-header .post-thumbnail img {
  display: block;
  object-fit: cover;
  height: 100%;
  width: 100%;
  min-height: 400px;
  max-height: 480px;
  filter: blur(7px);
  scale: 1.02;
}

/* this can be overridden in includer */
@media screen and (max-width: 639px) {
	#main-header .post-thumbnail img {
		min-height: calc(600px - 30vw);
	}
}

#main-header > * {
  min-width: 0px;
  margin-top: 0px;
  position: relative;
}

#main-header > * {
  grid-column: 1 / span 2;
  grid-row: 1;
}

#main-header-inner ~ * {
  grid-row: auto;
}

#main-header-inner {
  z-index: 2;
  /* background-color: #7e2447ba; */
  width: 100%;
  margin-bottom: 0px;
  padding: 2rem 1rem 1rem 1rem;
}

#main-header-inner {
  align-self: end;
  justify-self: center;  
  /* text-align: center; */
}

#dep-main-header-inner h1 {
  text-shadow: rgb(0,0,0) 0px 1px 1px;
}

@media screen and (min-width: 980px) {
  #main-header-inner {
	max-width: 800px;
    /* margin-bottom: 2rem; */
	/* text-align: center; */
  }
  
  .wp-not-post-thumbnail #main-header-inner {
	max-width: 100%;
	/* padding-top: 2rem; */
    /* margin-bottom: 0px; */
	/* background-color: #7e2447ba; */
  }
}

/* taxonomy image */
.wp-doc-article-header .ua-header-content figure {
  border: none;
  margin: 0 auto;
}


#main-header-inner .ua-crumbs, #main-header-inner h1 {
  border: none !important;
}

#main-header-inner > :not(.wp-edit-post-wr) {
  margin-left: auto;
  margin-right: auto;
  width: 95%;
}

#main-header-inner *:not(.wp-edit-post-wr *), 
#main-header-inner *:before,
#main-header-inner *:after {
  color: inherit;
}

#main-header img.ua-image-focus {
  object-position: top;
}

#main-header img.ua-image-focus-bottom {
  object-position: bottom;
}


/* section full */

.ua-section-full:not(#id) > .ua-set-sitewidth {
	padding: 0px;
}

.ua-section-full:not(body.ua-grid-padding-false .ua-section-full) { margin: 0px; }

@media screen and (max-width: 819px) {
	.ua-grid-padding-false .ua-root-content .ua-grid-box.ua-set-sitewidth {
		padding-top: 0px;
		padding-bottom: 0px;
		box-shadow: none;
	}
}



@media screen and (max-width: 409px) {
	
	.ua-grid-padding-false [class*=ua-root-section] {
		margin-bottom: 0.938rem;
	}

	.ua-grid-padding-false [class*=ua-root-section]:not([class*=section-above]:first-of-type) {
		margin-top: 0.938rem;
	}
}

@media screen and (min-width: 410px) and (max-width: 479px) {
	
	.ua-grid-padding-false [class*=ua-root-section] {
		margin-bottom: 1.563rem;
	}

	.ua-grid-padding-false [class*=ua-root-section]:not([class*=section-above]:first-of-type) {
		margin-top: 1.563rem;
	}
}

@media screen and (min-width: 480px) and (max-width: 819px) {

	.ua-grid-padding-false [class*=ua-root-section] {
		margin-bottom: calc(5vw + 0.625rem);
	}

	.ua-grid-padding-false [class*=ua-root-section]:not([class*=section-above]:first-of-type) {
		margin-top: calc(5vw + 0.625rem);
	}
}

@media screen and (min-width: 820px) {
	.ua-grid-padding-false .ua-root-content .ua-grid-box.ua-set-sitewidth {
		padding: 0px;
		box-shadow: none;
	}
}

@media screen and (min-width: 820px) and (max-width: 979px) {

	.ua-grid-padding-false [class*=ua-root-section] {
		margin-bottom: 0.625rem;
	}

	.ua-grid-padding-false [class*=ua-root-section]:not([class*=section-above]:first-of-type) {
		margin-top: 0.625rem);
	}
}

@media screen and (max-width: 979px) {
	.ua-grid-padding-false .ua-section-full > div {
		margin-left: 0px;
		margin-right: 0px;
	}
	.ua-grid-padding-false #section-id-above-1.ua-section-full ~ #ua-id-spacer {
		display: none;
	}
}

#main-header .ua-tabs-header > ul {
  max-width: 800px;
  margin-left: auto;
  margin-right: auto;
  margin-top: 0.75rem;
}

';

entex_STL($add, __FILE__); 

/* body ua-article-header */
/* this trigger the customizer targets */
add_filter('body_class', function($classes){
	$classes[] = 'wp-doc-article-header';
	return $classes;
}, 10, 1);

// -- END FILE -- //