<?php defined( 'ABSPATH' ) || exit;
/**
 * Template Name: Article full width, no sidebar
 * Template Post Type: template-layout
 *
 * @package Entex
 * @subpackage Entex
 * @since Entex 2.0
 * @version 2.30325
 */

get_template_part('tmpl-wp/tmpl-style-article-header', get_post_type());
get_template_part('tmpl-wp/tmpl-style-article-wide-full', get_post_type());
get_template_part('tmpl-wp/tmpl-style-article-wide-full-sections', get_post_type());

$add = '

.wp-doc-wide main {
	padding-bottom: 5vw;
}

@media screen and (min-width: 820px) {
	.wp-doc-wide main {
		padding-bottom: 4vw;
	}
}

.ua-root-tabs-bottom:not(#A) { 
	background: #f0f0f0; 
	margin-bottom: 0px;
}

@media screen and (min-width: 980px) {
	.ua-root-tabs-bottom nav > ul { 
		margin-left: auto;
		margin-right: auto;
		max-width: 800px;	
	}
}

@media screen and (max-width: 979px) {
	.ua-root-tabs-bottom ~ #section-id-below-1.ua-section-full {
		margin-top: 0px;
	}
}

@media screen and (max-width: 979px) {
	[id*=section-id-above]:not(.ua-section-full) + [id*=section-id-above]:not(.ua-section-full) > div,
	[id*=section-id-below]:not(.ua-section-full) + [id*=section-id-below]:not(.ua-section-full) > div	{ 
		padding-top: 0px; 
	}
}

/* spacer */

@media screen and (max-width: 979px) {
	#ua-id-spacer { 
		display: none; 
	}
}

@media screen and (min-width: 980px) {
	#ua-id-header + .ua-root-main ~ #ua-id-spacer:not(.ua-root-main ~ [id*=section-id-above] ~ *),
	#ua-id-header + .ua-root-main ~ #section-id-above-1.ua-section-full ~ #ua-id-spacer,
	#ua-id-header + .ua-root-main ~ #section-id-above-2.ua-section-full ~ #ua-id-spacer:not(#section-id-above-1 + #section-id-above-2 ~ *),
	#qua-id-header + [class*=ua-root-tabs] ~ #ua-id-spacer { 
		display: none; 
	}
}

/* fillout - only removed if section in use */
[id*=section-id-below] ~ #ua-id-fillout { display: none; }
@media screen and (min-width: 980px) {
	.ua-root-main ~ #ua-id-fillout:not(.ua-root-main ~ [id*=section-id-below] ~ *){ 
		display: none; 
	}
}

/* Messages */
main > :first-child:not(.ua-crumbs) + article, main > :first-child:not(.ua-crumbs) + article > :first-child {
    margin-top: 0px;
}

#qua-id-fillout, .qua-w-full + br[data-clear] { display: none; }

/* always visible - also on desktop view */
[class*=QQua-root-tabs] { display: flex !important; }

';

entex_STL($add, __FILE__); 

define('ENTEX_THEME_SINGULAR_CAPTION_DISABLE', true);
define('ENTEX_TEMPLATE_SHORTCUT_TABS_DISABLE', true);

remove_action('entex_template_shortcut_tabs_top', 'entex_template_output_shortcut_tabs', 10, 3);
add_action('entex_template_after_main_header_inner', function($indent){
	entex_template_output_shortcut_tabs($indent, 'header', false);
}, 10, 1);

add_filter('entex_shortcut_tab_2_bookmark', function($bookmark){
	return '#ua-id-socle';
});

/* Remove or Show 'sidebar' */
add_filter('entex_template_aside', function($render){
	return false;
}, 10, 1);

add_filter('body_class', function($classes){
	$classes[] = 'wp-doc-wide';
	if(is_singular()){
		$has = entex_theme_fn_show_post_thumbnail();
		if($has) $classes[] = 'wp-has-post-thumbnail';
			else $classes[] = 'wp-not-post-thumbnail';
	}
	return $classes;
}, 10, 1);

remove_action('entex_template_before_singular_content', 'entex_template_output_singular_post_thumbnail', 10, 2);
add_action('entex_template_before_main_header_inner', 'entex_template_output_singular_post_thumbnail', 10, 2);

remove_action('entex_template_before_main_content', 'entex_template_output_breadcrumbs', 20, 1);
add_action('entex_template_before_singular_title', 'entex_template_output_breadcrumbs', 5, 1);

// -- END FILE -- //