<?php defined( 'ABSPATH' ) || exit;
/**
 * Template Name: Article wide
 * Template Post Type: template-layout
 *
 * @package Entex
 * @subpackage Entex
 * @since Entex 2.0
 * @version 2.30325
 */

get_template_part('tmpl-wp/tmpl-style-article-header', get_post_type());
get_template_part('tmpl-wp/tmpl-style-article-wide', get_post_type());


$add = '

@media screen and (min-width: 980px) {
	
	.wp-doc-wide .ua-grid-root main {
		grid-column: 1 / 4;
	}
	
	.wp-doc-wide .ua-grid-root main:after {
		display: none;
	}
	
	.wp-doc-wide .ua-grid-root main + aside {
		grid-column: 1 / 4;
		padding-top: 3.126rem;
	}
}

@media screen and (min-width: 820px) {
	
	.wp-doc-wide main + aside {
		padding-bottom: 4vw;
	}
}

';

entex_STL($add, __FILE__); 

define('ENTEX_THEME_SINGULAR_CAPTION_DISABLE', true);
define('ENTEX_TEMPLATE_SHORTCUT_TABS_DISABLE', true);


/* Remove or Show 'sidebar' */
add_filter('entex_template_aside', function($render){
	return true;
}, 10, 1);

add_filter('entex_template_aside_classname', function($classname){
	if($classname) $classname .= ' '.'ua-main';
		else $classname = 'ua-main';
	return $classname;
}, 10, 1);

add_filter('body_class', function($classes){
	$classes[] = 'wp-doc-wide';
	if(is_singular()){
		$has = entex_theme_fn_show_post_thumbnail();
		if($has) $classes[] = 'wp-has-post-thumbnail';
			else $classes[] = 'wp-not-post-thumbnail';
	}
	return $classes;
}, 10, 1);

remove_action('entex_template_before_singular_content', 'entex_template_output_singular_post_thumbnail', 10, 2);
add_action('entex_template_before_main_header_inner', 'entex_template_output_singular_post_thumbnail', 10, 2);

// -- END FILE -- //