<?php defined( 'ABSPATH' ) || exit;
/**
 * Template Name: Article Header background - crumbs moved
 * Template Post Type: template-layout
 *
 * @package Entex
 * @subpackage Entex
 * @since Entex 2.0
 * @version 2.30325
 */

get_template_part('tmpl-wp/tmpl-style-article-header', get_post_type());

/* note: not i use - prepared for child templates */

$add = '

@media screen and (min-width: 980px) {
	
	#main-header-inner {
		margin-bottom: 0rem;
	}
  
	.wp-not-post-thumbnail #main-header-inner {
		padding-top: 2rem;
	}
}

@media screen and (max-width: 639px) {

	#main-header .post-thumbnail img {
		min-height: 320px;
		max-height: 320px;
	}
}

';

//entex_STL($add, __FILE__); 

define('ENTEX_THEME_SINGULAR_CAPTION_DISABLE', true);
define('ENTEX_TEMPLATE_SHORTCUT_TABS_DISABLE', true);

add_filter('body_class', function($classes){
	if(is_singular()){
		$has = entex_theme_fn_show_post_thumbnail();
		if($has) $classes[] = 'wp-has-post-thumbnail';
			else $classes[] = 'wp-not-post-thumbnail';
	}
	return $classes;
}, 10, 1);

remove_action('entex_template_before_singular_content', 'entex_template_output_singular_post_thumbnail', 10, 2);
add_action('entex_template_before_main_header_inner', 'entex_template_output_singular_post_thumbnail', 10, 2);

remove_action('entex_template_before_main_content', 'entex_template_output_breadcrumbs', 20, 1);
add_action('entex_template_before_singular_title', 'entex_template_output_breadcrumbs', 5, 1);

// -- END FILE -- //