<?php 
/**
 * Template Name: ACF Front end form include
 * Template Post Type: template-form
 *
 * @package WordPress
 * @subpackage Entex Theme
 * @author Jonas Lundman
 * @documentation http://wordpress.entex.info
 * @since 2021
 * @version 2.20926
 *
 * NOTE: UNIQUE FOR RETROLUX THEME
 * NOTE: ACF CSS is filtered out by default here
 */

defined( 'ABSPATH' ) || exit;

if(!defined('ENTEX_ACF_ACTIVE')){
	get_template_part('index');
	return;
}

if(!defined('ENTEX_ACF_FIELD_GROUP_FORM')) define('ENTEX_ACF_FIELD_GROUP_FORM', 'group_5abacbfc315a4');

function entex_template_acf_form_additional_submission_message($additional){
	$additional = esc_html_x('If our message has ended up as spam, please move it to your inbox folder, or mark it as Not spam. This will help your email-client next time to accept information from our services.', 'ACF Poster', 'entex');
	return $additional;
}
add_filter('entex_theme_acf_front_end_form_additional_submission_message', 'entex_template_acf_form_additional_submission_message', 10, 1);


if( function_exists('acf_add_local_field_group') ):

acf_add_local_field_group(array(
	'key' => 'group_5abacbfc315a4',
	'title' => esc_html_x('Contact us', 'ACF Poster', 'entex'),
	'fields' => array(
		array(
			'key' => 'field_5abacc0d27d7d',
			'label' => esc_html_x('First name', 'ACF Poster', 'entex'),
			'name' => 'entex_form_first_name',
			'type' => 'text',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_5abaccb627d7e',
			'label' => esc_html_x('Last name', 'ACF Poster', 'entex'),
			'name' => 'entex_form_last_name',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'hide_admin' => 0,
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_5abacd0627d7f',
			'label' => esc_html_x('Your email', 'ACF Poster', 'entex'),
			'name' => 'entex_form_email',
			'type' => 'email',
			'instructions' => esc_html_x('Please make shure your email address is correct', 'ACF Poster', 'entex'),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'hide_admin' => 0,
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_5abacd4627d80',
			'label' => esc_html_x('Message', 'ACF Poster', 'entex'),
			'name' => 'entex_form_message',
			'type' => 'textarea',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'maxlength' => 1200,
			'rows' => '',
			'new_lines' => '',
		),
		array(
			'key' => 'field_5abacd9227d81',
			'label' => esc_html_x('Approval', 'ACF Poster', 'entex'),
			'name' => 'entex_form_accept',
			'type' => 'true_false',
			'instructions' => esc_html_x('Prevents spam and abuse of this form', 'ACF Poster', 'entex'),
			'required' => 1,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5abacd0627d7f',
						'operator' => '!=empty',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => 'ua-set-responsive ua-f-accept-wr',
				'id' => '',
			),
			'message' => esc_html_x('I accept the terms of use', 'ACF Poster', 'entex'),
			'default_value' => 0,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'post',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

endif;			



if(!function_exists('entex_core_get_acf_post_value')):
function entex_core_get_acf_post_value($slug = false, $array = false){
	if(!$array && isset($_POST['acf'])) $array = wp_unslash($_POST['acf']); // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
	$key = acf_get_field($slug)['key'];
	$results = entex_core_search_acf_post_value($array, $key);
	if(count($results) == 1) return reset($results);
	return $results;
}
endif;



if(!function_exists('entex_core_search_acf_post_value')):
function entex_core_search_acf_post_value($array, $key){
	$results = array();
	if(is_array($array)){
		if(isset($array[$key])) $results[] = $array[$key];
		foreach ($array as $subarray){
			$results = array_merge($results, entex_core_search_acf_post_value($subarray, $key));
		}
	}
	return $results;
}
endif;





/* The built in Title field label */
function entex_template_acf_form_populate_post_title($field){
	$field['label'] = esc_html_x('Subject', 'ACF Poster', 'entex');
	return $field;
}
add_filter('acf/load_field/name=_post_title', 'entex_template_acf_form_populate_post_title');



function entex_template_acf_form_validate_submit($valid, $value, $field, $input_name){ 

	if(isset($_POST['_acf_post_id']) && $_POST['_acf_post_id'] == 'no_post') $submit = true;
	if(!isset($submit)) return $valid;
		
	if(!$valid) return $valid;
	
	if($field['name'] == 'entex_form_message'){
		$entex_form_first_name = entex_core_get_acf_post_value('entex_form_first_name');
		$entex_form_last_name = entex_core_get_acf_post_value('entex_form_last_name');
		$entex_form_email = entex_core_get_acf_post_value('entex_form_email');
		$entex_form_message = entex_core_get_acf_post_value('entex_form_message');
		
		$name = trim($entex_form_first_name.' '.$entex_form_last_name);
		$email = trim($entex_form_email);
		$message = trim($entex_form_message);
		
		if(!$name || !$email || !$message) return esc_html_x('Required empty sanitized fields found', 'ACF Poster', 'entex');
		/* die by plugin is set as true */
		$valid = apply_filters('entex_akismet_validate', $valid, $name, $email, $message, true, false);
	}
	
	return $valid;
}
add_filter('acf/validate_value', 'entex_template_acf_form_validate_submit', 10, 4);


function entex_template_acf_form_save_submit($post_id){

	if(is_admin()) return $post_id;
	if(!isset($_POST['acf'])) return $post_id;
    return $post_id;
	
}
add_action('acf/save_post', 'entex_template_acf_form_save_submit', 20, 1);


function entex_template_acf_form_pre_save_submit($post_id){

	if(isset($_POST['_acf_post_id']) && $_POST['_acf_post_id'] == 'no_post') $submit = true;
	if(!isset($submit)) return $post_id;
	
	$entex_form_first_name = sanitize_text_field(entex_core_get_acf_post_value('entex_form_first_name'));
	$entex_form_last_name = sanitize_text_field(entex_core_get_acf_post_value('entex_form_last_name'));
	$entex_form_email = sanitize_email(entex_core_get_acf_post_value('entex_form_email'));
	$entex_form_message = sanitize_text_field(entex_core_get_acf_post_value('entex_form_message'));

	$options = get_option('smtp_mailer_options');
	if(!empty($options)){
		if(!empty($options['from_name'])) $name = $options['from_name'];
		if(!empty($options['from_email'])) $email = $options['from_email'];
	}
	if(!isset($name)) $name = get_bloginfo('name');
	if(!isset($email)) $email = get_bloginfo('admin_email');
	
	$headers[] = 'Content-type: text/plain; charset=UTF-8';
	$headers[] = 'From: ' . $name . ' <' . $email . '>';
	$headers_user = $headers;
	$to = $email;
	
	$name = trim($entex_form_first_name.' '.$entex_form_last_name);
	$email = trim($entex_form_email);
	$headers[] = 'Reply-To: ' . $name . ' <' . $email . '>';
	
	$subject = esc_html_x('Message from submitted form', 'ACF Poster', 'entex');
	$message = trim($entex_form_message);
	
	$body = '';
	$body .= esc_html_x('Name', 'ACF Poster', 'entex').' : '. $name ."\r\n";
	$body .= esc_html_x('Email', 'ACF Poster', 'entex').' : '. $email ."\r\n";
	$body .= "\r\n";
	$body .= esc_html_x('Message', 'ACF Poster', 'entex').' : ' ."\r\n"."\r\n". $message;
	$message = $body;
	
	/*
	echo '<pre>'.htmlentities(print_r($headers, true)).'</pre>';
	die();
	*/
	
	$success = wp_mail($to, $subject, $message, $headers);
	if(!$success){
		set_transient('entex-acf-form-email-submit', 'error', 30);
	} else {
		delete_transient('entex-acf-form-email-submit');
	}
	
	$to = $email;
	$headers = $headers_user;
	$subject = esc_html_x('Receipt of submitted information', 'ACF Poster', 'entex');
	$message = '';
	/* translators: */
	$message .= sprintf( esc_html_x('Thank you for your form submission. This is a copy of your information you provided in the form at %s', 'ACF Poster', 'entex'), get_bloginfo('name')) .'.'."\r\n"."\r\n";
	$message .= $body;
	
	$success = wp_mail($to, $subject, $message, $headers);
	if(!$success){
		set_transient('entex-acf-form-email-submit', 'error', 30);
	} else {
		delete_transient('entex-acf-form-email-submit');
	}
	
	/* dont save the post */
	$_POST = array();
	
	return $post_id;
}
add_action('acf/pre_save_post', 'entex_template_acf_form_pre_save_submit', 5, 1);



/* -------------------- */
// BEGIN TEMPLATE
if(!post_password_required()) acf_form_head();


function entex_template_acf_form(){
	
	$field_group = ENTEX_ACF_FIELD_GROUP_FORM;
	$args = array(
		'id' => 'entex-contact-form',
		'form_attributes' => array('class' => 'ua-form'),
		'post_id' => 'no_post',
		'field_groups' => array($field_group),
		'new_post' => array(
			'post_type'	=> 'post',
			'post_status' => 'draft'
		),
		'updated_message' => '',
		'submit_value'	=> esc_html_x('Send', 'ACF Poster', 'entex')
	);

	acf_form($args);
}

/* Add body class */
add_filter('body_class', function($classes){
	$classes[] = 'ua-doc-function-post';
	return $classes;
}, 10, 1);

/* Remove form styles with theme */
add_filter('entex_add_remove_style_handles', function($handles){
	$handles[] = 'acf-global';
	$handles[] = 'acf-input';
	$handles[] = 'acf-pro-input';
	return $handles;
}, 10, 1);

/* Remove form styles with loader */
add_filter('entex_theme_wp_styles_filtered_handles', function($handles){
	$handles[] = 'acf-global';
	return $handles;
}, 10, 1);

function entex_template_acf_posted(){
	if(isset($_GET['updated']) && $_GET['updated'] == true){
		if(get_transient('entex-acf-form-email-submit')){
			echo '<p>'. esc_html_x('Form submission error', 'ACF Poster', 'entex') .'</p>';
			echo '<pre>'. htmlentities(print_r(get_transient('entex-acf-form-email-submit'), true)) .'</pre>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			delete_transient('entex-acf-form-email-submit');
		} else {
			$additional = apply_filters('entex_theme_acf_front_end_form_additional_submission_message', '');
			if($additional) $additional = ' '.$additional;
			echo '<p class="is-style-ua-box">'. esc_html_x('Thank you for your form submission.', 'ACF Poster', 'entex') .'</p>';
			echo '<p><em>'. esc_html_x('A copy of your information has been sent to the email address you provided in the form. We will get back to you as soon as possible.', 'ACF Poster', 'entex') . esc_html($additional) .'</em></p>';
		}
	}
}

/* -------------------- */
// REGISTER HOOK OUTPUT
/* insert function call after the content */
if(!post_password_required()){
	add_action('entex_template_before_singular_content', 'entex_template_acf_posted');
	add_action('entex_template_after_singular_content', 'entex_template_acf_form');
}


// -- END FILE -- //