<?php // phpcs:ignoreFile
/**
 * Template Name: ACF Front end Contact form Upload
 * Template Post Type: template-form
 *
 * @package WordPress
 * @subpackage Entex Theme
 * @author Jonas Lundman
 * @documentation http://wordpress.entex.info
 * @since 2021
 * @version 2.20925
 *
 * NOTE: UNIQUE FOR RETROLUX THEME
 * NOTE: ACF CSS is filtered out by default here
 */

defined( 'ABSPATH' ) || exit;

if(!defined('ENTEX_ACF_ACTIVE')){
	get_template_part('index');
	return;
}

if(!defined('ENTEX_ACF_FIELD_GROUP_FORM')) define('ENTEX_ACF_FIELD_GROUP_FORM', 'group_5faec41d6eeeb');
//define('ENTEX_ACF_POSTER_UPLOAD_MULTIPLE', true);

function entex_template_acf_form_additional_submission_message($additional){
	$additional = esc_html_x('If our message has ended up as spam, please move it to your inbox folder, or mark it as Not spam. This will help your email-client next time to accept information from our services.', 'ACF Poster', 'entex');
	return $additional;
}
add_filter('entex_theme_acf_front_end_form_additional_submission_message', 'entex_template_acf_form_additional_submission_message', 10, 1);


if( function_exists('acf_add_local_field_group') ):

acf_add_local_field_group(array(
	'key' => 'group_5faec41d6eeeb',
	'title' => esc_html_x('Product inquiry', 'ACF Poster', 'entex'),
	'fields' => array(
		array(
			'key' => 'field_5faec41d7c4c9',
			'label' => esc_html_x('First name', 'ACF Poster', 'entex'),
			'name' => 'entex_form_first_name',
			'type' => 'text',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'hide_admin' => 0,
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_5faec41d7c6b6',
			'label' => esc_html_x('Last name', 'ACF Poster', 'entex'),
			'name' => 'entex_form_last_name',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'hide_admin' => 0,
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_5faec41d7c8a5',
			'label' => esc_html_x('Your email', 'ACF Poster', 'entex'),
			'name' => 'entex_form_email',
			'type' => 'email',
			'instructions' => esc_html_x('Please make shure your email address is correct', 'ACF Poster', 'entex'),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'hide_admin' => 0,
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_5faec7c023288',
			'label' => esc_html_x('Subject', 'ACF Poster', 'entex'),
			'name' => 'entex_form_subject',
			'type' => 'text',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'hide_admin' => 0,
			'default_value' => '',
			'placeholder' => esc_html_x('Please enter a concise heading', 'ACF Poster', 'entex'),
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_5faec41d7ca7f',
			'label' => esc_html_x('Information', 'ACF Poster', 'entex'),
			'name' => 'entex_form_message',
			'type' => 'textarea',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'hide_admin' => 0,
			'default_value' => '',
			'placeholder' => esc_html_x('Describe your request here, feel free to mention what it may cost', 'ACF Poster', 'entex'),
			'maxlength' => 1200,
			'rows' => '',
			'new_lines' => '',
		),
		array(
			'key' => 'field_5faec4c3fcfc8',
			'label' => esc_html_x('Image', 'ACF Poster', 'entex'),
			'name' => 'entex_form_image',
			'type' => 'image',
			'instructions' => esc_html_x('You can upload an image from your phone or computer. But it can not be larger than 4 MB.', 'ACF Poster', 'entex'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'hide_admin' => 0,
			'return_format' => 'array',
			'preview_size' => 'thumbnail',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => 4,
			'mime_types' => 'jpg,jpeg,gif,png,webp',
		),
		array(
			'key' => 'field_61a9d33ce7678',
			'label' => esc_html_x('Images', 'ACF Poster', 'entex'),
			'name' => 'entex_form_images',
			'type' => 'image',
			'instructions' => esc_html_x('You can upload pictures from your phone or computer. But each image can not be larger than 4 MB.', 'ACF Poster', 'entex'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'hide_admin' => 0,
			'return_format' => 'array',
			'preview_size' => 'thumbnail',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => 4,
			'mime_types' => 'jpg,jpeg,gif,png,webp',
		),
		array(
			'key' => 'field_5faec41d7cc51',
			'label' => esc_html_x('Approval', 'ACF Poster', 'entex'),
			'name' => 'entex_form_accept',
			'type' => 'true_false',
			'instructions' => esc_html_x('We protect your personal data and only use this information to respond to your request for items.', 'ACF Poster', 'entex'),
			'required' => 1,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5faec41d7c8a5',
						'operator' => '!=empty',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => 'ua-set-responsive ua-f-accept-wr',
				'id' => '',
			),
			'hide_admin' => 0,
			'message' => esc_html_x('I accept the terms of use', 'ACF Poster', 'entex'),
			'default_value' => 0,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'af_form',
				'operator' => '==',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
));

endif;		


if(!function_exists('entex_core_get_acf_post_value')):
function entex_core_get_acf_post_value($slug = false, $array = false){
	if(!$array && isset($_POST['acf'])) $array = wp_unslash($_POST['acf']); // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
	$key = acf_get_field($slug)['key'];
	$results = entex_core_search_acf_post_value($array, $key);
	if(count($results) == 1) return reset($results);
	return $results;
}
endif;

if(!function_exists('entex_core_search_acf_post_value')):
function entex_core_search_acf_post_value($array, $key){
	$results = array();
	if(is_array($array)){
		if(isset($array[$key])) $results[] = $array[$key];
		foreach ($array as $subarray){
			$results = array_merge($results, entex_core_search_acf_post_value($subarray, $key));
		}
	}
	return $results;
}
endif;


/* The built in Title field label */
function entex_template_acf_form_populate_post_title($field){
	$field['label'] = esc_html_x('Subject', 'ACF Poster', 'entex');
	return $field;
}
add_filter('acf/load_field/name=_post_title', 'entex_template_acf_form_populate_post_title');



function entex_template_acf_form_validate_submit($valid, $value, $field, $input_name){ 

	if(isset($_POST['_acf_post_id']) && $_POST['_acf_post_id'] == 'no_post') $submit = true;
	if(!isset($submit)) return $valid;
		
	if(!$valid) return $valid;
	
	if($field['name'] == 'entex_form_message'){
		$entex_form_first_name = entex_core_get_acf_post_value('entex_form_first_name');
		$entex_form_last_name = entex_core_get_acf_post_value('entex_form_last_name');
		$entex_form_email = entex_core_get_acf_post_value('entex_form_email');
		$entex_form_message = entex_core_get_acf_post_value('entex_form_message');
		
		$name = trim($entex_form_first_name.' '.$entex_form_last_name);
		$email = trim($entex_form_email);
		$message = trim($entex_form_message);
		
		if(!$name || !$email || !$message) return esc_html_x('Required empty sanitized fields found', 'ACF Poster', 'entex');
		/* die by plugin is set as true */
		$valid = apply_filters('entex_akismet_validate', $valid, $name, $email, $message, true, false);
	}
	
	return $valid;
}
add_filter('acf/validate_value', 'entex_template_acf_form_validate_submit', 10, 4);


function entex_template_acf_form_save_submit($post_id){

	if(is_admin()) return $post_id;
	if(!isset($_POST['acf'])) return $post_id;
    return $post_id;
	
}
add_action('acf/save_post', 'entex_template_acf_form_save_submit', 20, 1);


function entex_template_acf_form_pre_save_submit($post_id){

	if(isset($_POST['_acf_post_id']) && $_POST['_acf_post_id'] == 'no_post') $submit = true;
	if(!isset($submit)) return $post_id;
	
	$entex_form_first_name = sanitize_text_field(entex_core_get_acf_post_value('entex_form_first_name'));
	$entex_form_last_name = sanitize_text_field(entex_core_get_acf_post_value('entex_form_last_name'));
	$entex_form_email = sanitize_email(entex_core_get_acf_post_value('entex_form_email'));
	$entex_form_subject = sanitize_text_field(entex_core_get_acf_post_value('entex_form_subject'));
	$entex_form_message = sanitize_text_field(entex_core_get_acf_post_value('entex_form_message'));
	$entex_form_image = entex_core_get_acf_post_value('entex_form_image');
	
	$err = '';
	$html = false;

	/* compat function for multiple uploads */
	/* multiple image uploads */
	/* if 'ua_acf_files' are in use instead of 'entex_form_image */
	if(isset($_FILES['ua_acf_files']['tmp_name'])){

		$dir = true;
		if(!is_dir(WP_CONTENT_DIR.'/uploads/emails/')) $dir = mkdir(WP_CONTENT_DIR.'/uploads/emails/');
		if(!$dir){
			if(count($_FILES['ua_acf_files']['tmp_name']) < 1) $err = esc_html_x('Files could not be attached, directory failed.', 'ACF Poster', 'entex');
				else $err = esc_html_x('File could not be attached, directory failed.', 'ACF Poster', 'entex');
		} else {
			$count = 0;
			$maxsize = 4194304;
			$mb = '4 mB';
			$allowed =  array('gif', 'png', 'jpeg', 'jpg', 'webp', 'doc', 'docx', 'odt', 'pdf', 'zip', 'rar', '7zip');
			$images =  array('gif', 'png', 'jpeg', 'jpg', 'webp');
			foreach($_FILES['ua_acf_files']['tmp_name'] as $index => $tmp_name){
				
				/* sanitize */
				$failed = '';
				$is_image = false;
				$name = ''; $size = ''; 
				if(isset($_FILES['ua_acf_files']['name'][$index])) $name = $_FILES['ua_acf_files']['name'][$index];
				if(isset($_FILES['ua_acf_files']['size'][$index])) $size = $_FILES['ua_acf_files']['size'][$index];
				if(!$name || !$size) continue;
				
				$ext = pathinfo($name, PATHINFO_EXTENSION);
				$ext = mb_strtolower($ext);
				if(in_array($ext, $images)) $is_image = true;
				
				if($size > $maxsize){
					if($is_image){
						if($count) $err = esc_html_x('Some images could not be attached, filesize to large.', 'ACF Poster', 'entex');
							else $err = esc_html_x('Image could not be attached, filesize to large.', 'ACF Poster', 'entex');
					} else {
						if($count) $err = esc_html_x('Some files could not be attached, filesize to large.', 'ACF Poster', 'entex');
							else $err = esc_html_x('File could not be attached, filesize to large.', 'ACF Poster', 'entex');
					}
					/* translators: */
					$err .= ' ('. sprintf(esc_html_x('Max filesize is %s', 'ACF Poster', 'entex'), $mb) .')';
					continue;
				}
				
				/* translators: */
				$failed = sprintf(esc_html_x('File could not be attached, filetype (%s) not allowed.', 'ACF Poster', 'entex'), $ext);
				/* translators: */
				if($count) $failed = sprintf(esc_html_x('Some files could not be attached, filetype (%s) not allowed.', 'ACF Poster', 'entex'), $ext);
				
				/* translators: */
				if($is_image) $failed = sprintf(esc_html_x('Image could not be attached, filetype (%s) not allowed.', 'ACF Poster', 'entex'), $ext);
				/* translators: */
				if($is_image && $count) $failed = sprintf(esc_html_x('Some images could not be attached, filetype (%s) not allowed.', 'ACF Poster', 'entex'), $ext);

				if(in_array($ext, $allowed)){
					/* WordPress handle the upload process */
					if(!move_uploaded_file($tmp_name, WP_CONTENT_DIR.'/uploads/emails/'.basename($name))) $err = esc_html_x('Some files could not be attached.', 'ACF Poster', 'entex');
						else $files[] = WP_CONTENT_DIR.'/uploads/emails/'.basename($name);
					if(file_exists($tmp_name)) unlink($tmp_name);
				} else $err = $failed;
				$count++;
			}
			
		}
		if(!empty($files)) $html = true;
			else if(!$err) $err = esc_html_x('Some files could not be attached.', 'ACF Poster', 'entex');

	}
	
	
	$file = '';
	if($entex_form_image){

		$dir = true;
		if(!is_dir(WP_CONTENT_DIR.'/uploads/emails/')) $dir = mkdir(WP_CONTENT_DIR.'/uploads/emails/');
		if(!$dir){
			$translate = esc_html_x('Image could not be attached, directory failed.', 'ACF Poster', 'entex');
			$err = esc_html_x('File could not be attached, directory failed.', 'ACF Poster', 'entex');
		} else {
			
			/* DONT FORGET: FIELD MUST SYNC */
			$field = 'field_5faec4c3fcfc8';
			
			/* sanitize */
			$failed = '';
			$name = ''; $tmp_name = '';
			if(isset($_FILES['acf']['name'][$field])) $name = $_FILES['acf']['name'][$field];
			if(isset($_FILES['acf']['tmp_name'][$field])) $tmp_name = $_FILES['acf']['tmp_name'][$field];
			
			/* acf should validate this before, but it doesnt harm to keep the consistance with above */
			$allowed =  array('gif', 'png', 'jpeg', 'jpg', 'webp', 'doc', 'docx', 'odt', 'pdf', 'zip', 'rar', '7zip');
			$images =  array('gif', 'png', 'jpeg', 'jpg', 'webp');
			if($name) $ext = pathinfo($name, PATHINFO_EXTENSION);
				else $ext ='forbidden';

			$ext = mb_strtolower($ext);
			/* translators: */
			if(!in_array($ext, $allowed)) $failed = sprintf(esc_html_x('File could not be attached, filetype (%s) not allowed.', 'ACF Poster', 'entex'), $ext);
			/* translators: */
			if($err && in_array($ext, $images)) $failed = sprintf(esc_html_x('Image could not be attached, filetype (%s) not allowed.', 'ACF Poster', 'entex'), $ext);

			if($name && $tmp_name && !$failed){
				
				/* WordPress handle the upload process */
				if(!move_uploaded_file($tmp_name, WP_CONTENT_DIR.'/uploads/emails/'.basename($name))) $err = esc_html_x('File could not be attached, server upload failed.', 'ACF Poster', 'entex');
					else $file = WP_CONTENT_DIR.'/uploads/emails/'.basename($name);
				if(file_exists($tmp_name)) unlink($tmp_name);
			} else $err = $failed;
			
		}
		if($file) $html = true;
	} 
	
	if(empty($files)) $files = array($file);
	
	$options = get_option('smtp_mailer_options');
	if(!empty($options)){
		if(!empty($options['from_name'])) $name = $options['from_name'];
		if(!empty($options['from_email'])) $email = $options['from_email'];
	}
	if(!isset($name)) $name = get_bloginfo('name');
	if(!isset($email)) $email = get_bloginfo('admin_email');
	
	if($html) $headers[] = 'Content-type: text/html; charset=UTF-8';
		else $headers[] = 'Content-type: text/plain; charset=UTF-8';
	
	$headers[] = 'From: ' . $name . ' <' . $email . '>';
	$headers_user = $headers;
	$to = $email;
	
	$name = trim($entex_form_first_name.' '.$entex_form_last_name);
	$email = trim($entex_form_email);
	$headers[] = 'Reply-To: ' . $name . ' <' . $email . '>';
	
	$subject = esc_html_x('Request', 'ACF Poster', 'entex').' : '. $entex_form_subject;
	$headline = $entex_form_subject;
	$message = trim($entex_form_message);
	
	$body = '';
	$body .= esc_html_x('Name', 'ACF Poster', 'entex').' : '. $name ."\r\n";
	$body .= esc_html_x('Email', 'ACF Poster', 'entex').' : '. $email ."\r\n";
	$body .= esc_html_x('Subject', 'ACF Poster', 'entex').' : '. $headline ."\r\n";
	if($err) $body .= esc_html_x('File', 'ACF Poster', 'entex').' : '. $err ."\r\n";
	$body .= "\r\n";
	$body .= esc_html_x('Message', 'ACF Poster', 'entex').' : ' ."\r\n"."\r\n". $message;
	$message = $body;
	
	if($html){
		$message = str_replace("\r\n", '<br/>', $message);
	}
	
	// -- MAIL -- //
	
	$success = wp_mail($to, $subject, $message, $headers, $files);
	if(!$success){
		set_transient('entex-acf-form-email-submit', 'error', 30);
	} else {
		delete_transient('entex-acf-form-email-submit');
	}
	
	// -- RECEIPT -- //
	
	$to = $email;
	$headers = $headers_user;
	$subject = esc_html_x('Receipt of submitted information', 'ACF Poster', 'entex');
	$message = '';
	/* translators: */
	$message .= sprintf( esc_html_x('Thank you for your form submission. This is a copy of your information you provided in the form at %s', 'ACF Poster', 'entex'), get_bloginfo('name')) .'.'."\r\n"."\r\n";
	$message .= $body;
	
	if($html){
		$message = str_replace("\r\n", '<br/>', $message);
	}
	
	$success = wp_mail($to, $subject, $message, $headers, $files);
	if(!$success){
		set_transient('entex-acf-form-email-submit', 'error', 30);
	} else {
		delete_transient('entex-acf-form-email-submit');
	}
	
	/* dont save the post */
	$_POST = array();
	if(!empty($files)){
		foreach($files as $file) unlink($file);
	}
	return $post_id;
}
add_action('acf/pre_save_post', 'entex_template_acf_form_pre_save_submit', 5, 1);


/* -------------------- */
// ASSETS

function entex_template_acf_poster_enquene_script(){
	
	if(defined('ENTEX_ACF_POSTER_UPLOAD_MULTIPLE')) $multiupload = '1';
		else $multiupload = '0';

	$add = "
(function($) {
	$(document).ready(function(){
		
		var multi = ". $multiupload ."; 
		
		if($('#entex-upload-form .acf-image-uploader [type=file]').get(0)){ 

			if(multi){
				
				$('#entex-upload-form').find('[data-name=entex_form_image]').remove();
				$('#entex-upload-form [data-name=entex_form_images]').find('.acf-image-uploader .image-wrap').removeAttr('style').find('img').removeAttr('style');
				$('#entex-upload-form [data-name=entex_form_images]').find('.acf-image-uploader .image-wrap').before($('<p />').addClass('ua-uploader-image'));
				$('#entex-upload-form [data-name=entex_form_images] .acf-image-uploader [type=file]').attr('name', 'ua_acf_files[]').attr('id', 'ua-id-form-files').prop('multiple', true).on('change', function(){
				
					var input = this;
					var placeholder = '.ua-uploader-image';
					$(input).closest('.acf-image-uploader').addClass('has-value');

					/* clear out earlier */
					$(placeholder).addClass('ua-wr-float').children().remove();

					if(input.files){
						var filesAmount = input.files.length;
						for(i = 0; i < filesAmount; i++){
							var reader = new FileReader();
							reader.files = input.files[i].name;
							reader.index = i;
							reader.onload = function(event){
								$($.parseHTML('<img>')).attr('src', event.target.result).attr('data-image', this.index).data('reference', this.files).addClass('ua-float-5').appendTo(placeholder);
							}
							reader.readAsDataURL(input.files[i]);
						}
					}
				});


			} else {
				
				$('#entex-upload-form').find('[data-name=entex_form_images]').remove();
				$('#entex-upload-form [data-name=entex_form_image]').find('.acf-image-uploader .image-wrap').removeAttr('style').find('img').removeAttr('style');
				$('#entex-upload-form [data-name=entex_form_image]').find('.acf-image-uploader .image-wrap').before($('<p />').addClass('ua-uploader-image'));
				
				var imagesPreview = function(input, placeToInsertImagePreview) {
					if(input.files){
						var filesAmount = input.files.length;
						for (i = 0; i < filesAmount; i++) {
							var reader = new FileReader();
							reader.onload = function(event){
								var pos = $(input).offset().top;
								$(input).closest('.acf-image-uploader').addClass('has-value').find(placeToInsertImagePreview).html($($.parseHTML('<img>')).attr('src', event.target.result)).next('.image-wrap').find('img').hide();
								$('html, body').stop().animate({ scrollTop: (pos) - 10 }, 500);
							}
							reader.readAsDataURL(input.files[i]);
						}
					}
				};

				$(document).on('change', '[data-name=entex_form_image] .acf-image-uploader [type=file]', function(){
					imagesPreview(this, '.ua-uploader-image');
				});
			}
			
			/* shared */
			$(document).on('click', '#entex-upload-form .acf-image-uploader a[data-name=remove]', function(){
				var input = $(this).closest('.acf-image-uploader').find('[type=file]').get(0);
				input.value = '';
			});
		}
		
	});
})(jQuery);
	";
	
	wp_register_script('entex-acf-poster', '', array('jquery'), '', true);
	wp_enqueue_script('entex-acf-poster');
	wp_add_inline_script('entex-acf-poster', $add);
}
entex_template_acf_poster_enquene_script();


/* -------------------- */
// BEGIN TEMPLATE
if(!post_password_required()) acf_form_head();


function entex_template_acf_form(){
	
	$field_group = ENTEX_ACF_FIELD_GROUP_FORM;
	$args = array(
		'id' => 'entex-upload-form',
		'form_attributes' => array('class' => 'ua-form ua-not-main'),
		'post_id' => 'no_post',
		'uploader' => 'basic',
		'field_groups' => array($field_group),
		'new_post' => array(
			'post_type'	=> 'post',
			'post_status' => 'draft'
		),
		'updated_message' => '',
		'submit_value'	=> esc_html_x('Send', 'ACF Poster', 'entex')
	);

	acf_form($args);
}

/* Add body class */
add_filter('body_class', function($classes){
	$classes[] = 'ua-doc-function-post';
	return $classes;
}, 10, 1);

/* Remove form styles with theme */
add_filter('entex_add_remove_style_handles', function($handles){
	$handles[] = 'acf-global';
	$handles[] = 'acf-input';
	$handles[] = 'acf-pro-input';
	return $handles;
}, 10, 1);

/* Remove form styles with loader */
add_filter('entex_theme_wp_styles_filtered_handles', function($handles){
	$handles[] = 'acf-global';
	return $handles;
}, 10, 1);

function entex_template_acf_posted(){
	if(isset($_GET['updated']) && $_GET['updated'] == true){
		if(get_transient('entex-acf-form-email-submit')){
			echo '<p>'. esc_html_x('Form submission error', 'ACF Poster', 'entex') .'</p>';
			echo '<pre>'. htmlentities(print_r(get_transient('entex-acf-form-email-submit'), true)) .'</pre>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			delete_transient('entex-acf-form-email-submit');
		} else {
			$additional = apply_filters('entex_theme_acf_front_end_form_additional_submission_message', '');
			if($additional) $additional = ' '.$additional;
			echo '<p class="is-style-ua-box">'. esc_html_x('Thank you for your request.', 'ACF Poster', 'entex') .'</p>';
			echo '<p>'. esc_html_x('A copy of your information has been sent to the email address you provided in the form.', 'ACF Poster', 'entex') . esc_html($additional) .'</p>';
		}
	}
}

/* -------------------- */
// REGISTER HOOK OUTPUT
/* insert function call after the content */
if(!post_password_required()){
	add_action('entex_template_before_singular_content', 'entex_template_acf_posted');
	add_action('entex_template_after_singular_content', 'entex_template_acf_form');
}

// -- END FILE -- //