<?php if(!defined('ABSPATH')) die(); ?>
<?php
/**
 * Template Name: Entries article | Floating Image / Media framed only | ( medium )
 * Template Post Type: template-entries
 *
 * @package Entex, WooCommerce
 * @subpackage Entex
 * @version 2.210525
 */
 
/**
 * TEMPLATE EXPLAINED
 *
 * Floating 5 framed attachments on each row, means each entry is ALWAYS 20% wide
 * No headings, only populated attributes
 * Showing representable content for all media types, depending on how the media is calculated
 * Note, no responsive linebreaks, using float instead of flex
 * This template play nice with minimum 10 entries 
 * Remember, this is still an Article entry, suitable outside the document content flow
 * Copy to child theme and replace the <article> element with a <div> if needed
 *
 */
?>
<?php

$hover = '';
global $product;
if(!empty($product)){
	$hover .= ' | '. strip_tags($product->get_price_html());
}
 
// This is the builder to calculate the media
// As background, icon, representing media and so on
// This normally done in post thumbnail action(s) output as well
// But we keep this manuallly alive in this template
// To follow issues and updates and easier track broken code ideas

$SET_CLASS = '';
$SET_STYLE = '';

/* get all data we need from the attachment */
$attr = entex_fn_extract_attachment(get_the_ID(), $max = 60);
$classes = entex_theme_fn_get_post_thumbnail_classes();
$classes[] = 'ua-framed';
	
if(get_post_type() == 'attachment' && has_post_thumbnail()){
	if($attr['data-file-media-type'] != 'image'){
		$SET_STYLE = ' style="background-image: url('. $attr['data-file-background'] .');"';
		$classes[] = ' ua-attachment-background ua-attachment-icon';
	}
} else if(get_post_type() == 'attachment' && !has_post_thumbnail() && $attr['data-file-background']){
	if($attr['data-file-media-type'] == 'image'){
		$SET_STYLE = ' style="background-image: url('. $attr['data-file-background'] .');"';
		if($attr['data-file-repeat'] == 'repeat') $classes[] = ' ua-attachment-background ua-attachment-repeat';
			else $classes[] = ' ua-attachment-background';

	} else {
		$SET_STYLE = ' style="background-image: url('. $attr['data-file-background'] .');"';
		$classes[] = ' ua-attachment-background ua-attachment-icon';
	}
}

/* Set layout size */ // - keep in balance with the true image size in use below
$classes[] = 'ua-fixed-medium';
$SET_CLASS = implode(' ', $classes);

?>
<?php do_action('entex_template_before_template', 0, '', __FILE__, entex_backtrace()); ?>
<?php if(!empty($args['start'])) echo wp_kses_post('<div class="ua-wr-float">'.entex_LBR()); ?>
<article id="post-<?php the_ID(); ?>" class="<?php entex_template_output_post_class(array('ua-float-5', 'ua-attachment-fixed')); ?>">
 <div class="<?php echo esc_attr($SET_CLASS); ?>">
  <?php echo wp_kses_post('<a title="'. esc_attr(get_the_title()) . esc_attr($hover) .'" href="'. esc_url(get_permalink()) .'"'. $SET_STYLE .'>'); ?>
   <?php entex_template_output_the_post_thumbnail(3, 'medium'); // NOTE THE FUNCTION NAME - uses image markup only ?>
  </a>
  <?php echo wp_kses_post(apply_filters('entex_template_get_entry_post_thumbnail_html_before_close', '', 2, 'thumbnail')); ?>
 </div>
</article>
<?php if(!empty($args['end'])) echo '</div>'."\r\n"; ?>