<?php if(!defined('ABSPATH')) die(); 
/**
 * Singular article footer template part 
 *
 * Specialised template part file
 * Parent: tmpl-singular-article.php
 * Specialised for post-type: post
 * Fallback: tmpl-singular-article.php
 * Fallback exists: No
 *
 * @package Entex
 * @subpackage Entex
 * @version 2019 12 05
 *
 */
?>
<?php
/**
 * The document footer is separated as a template part of its own
 * Sometimes we dont need a document footer at all, like 'Contact us' pages
 * And we dont want empty footer html
 * To 'show' a document footer or not, is decided by WordPress template hierarchy system
 * If a template is not found, an empty string is returned, and no footer will be present
 * Therefore, make shure not to create a fallback template file, that the system will find and use
 * In this case, tmpl-singular-article-footer-post.php will try to find a fallback-file named: tmpl-singular-article-footer.php
 * Do not create one if you not intend to make a footer for all post-types, except posts, who grabs this file.
 *
 * The content within the footer has small variations depending on post type
 * Also re-usable content variates for entries
 * To avoid a mess of diffrent output calls or options
 * We use the template-part approach instead
 *
 * NOTE: This is a singular template file with ID = main-footer
 *
 */

/**
 * HOOKS:
 *
 * do_action('entex_template_singular_footer_before_content')
 * @hooked: none
 *
 * do_action('entex_template_singular_footer_after_content')
 * @hooked: none
 *
 */
?>
<?php do_action('entex_template_before_template', 0, '', __FILE__, entex_backtrace()); ?>
<footer id="main-footer" class="singular-footer ua-content ua-not-main">
 <?php do_action('entex_template_singular_footer_before_content', 1); ?>
 <?php entex_template_output_post_taglist(1, 'attachment_tag'); ?>
 <?php entex_template_output_social_sharing(1); ?>
 <?php entex_template_output_the_author_box(1); ?>
 <?php do_action('entex_template_singular_footer_after_content', 1); ?>
</footer>
<?php do_action('entex_template_after_template', 0, '', __FILE__, entex_backtrace()); ?>