<?php if(!defined('ABSPATH')) die(); ?>
<?php
/**
 * The main Singular template part
 * Registered as default template
 *
 * @package Entex
 * @subpackage Entex
 * @version 2.20424
 *
 * Note:
 * This is a singular main template
 * Can only be included ONCE as it contains ID
 */
?>
<?php
/**
 * HOOKS
 *
 * do_action('entex_template_before_template', args)
 * @hooked: entex_template_comment_before_template', 10, 5
 *
 * do_action('entex_template_before_singular_title')
 * @hooked: 'entex_template_output_before_singular_title', 10, 1
 *
 * do_action('entex_template_inside_singular_title')
 * @hooked: entex_template_output_the_singular_header_image, 10, 1
 *
 * do_action('entex_template_inside_singular_title_before_close')
 * @hooked: none, but might be filtered in by other actions
 *
 * get_the_title()
 * @function: entex_template_get_the_title()
 *
 * do_action('entex_template_after_singular_title')
 * @hooked: entex_template_output_admin_edit_post_wrapper, 30, 1
 *
 * do_action('entex_template_before_singular_content')
 * @hooked: entex_template_output_singular_post_thumbnail, 10, 2
 *
 * the_content();
 * @filter: entex_theme_filter_the_content_article_end, -5, 1
 *
 * do_action('entex_template_after_singular_content')
 * @hooked: entex_template_output_wp_link_pages, 10, 1
 * @hooked: (edit_post_link())
 *
 * do_action('entex_template_singular_end')
 * @hooked: entex_template_output_the_post_navigation, 10, 1
 *
 * do_action('entex_template_after_template', args)
 * @hooked: entex_template_comment_after_template', 10, 5
 */
?>
<?php do_action('entex_template_before_template', 0, '', __FILE__, entex_backtrace()); ?>
<article data-permalink="<?php echo esc_url(get_permalink()); ?>" id="main-article" class="<?php entex_template_output_post_class(array('hentry')); ?>">
 <?php do_action('entex_template_before_singular_header', 1); ?>
 <header id="main-header" class="singular-header">
  <?php do_action('entex_template_before_main_header_inner', 2); ?>
  <div id="main-header-inner">
   <?php do_action('entex_template_before_singular_title', 3); ?>
   <h1 class="singular-title"><?php echo wp_kses_post(entex_template_get_the_title()); ?></h1>
   <?php entex_template_output_subtitle(3); ?>
   <?php entex_template_output_singular_meta(3, 'ua-meta ua-main-meta'); ?>
   <?php do_action('entex_template_after_singular_title', 3); ?>
  </div>
  <?php do_action('entex_template_after_main_header_inner', 2); ?>
 </header>
 <div id="main-content" class="<?php entex_template_output_singular_class(array('ua-singular-content', 'ua-content')); ?>">
  <?php do_action('entex_template_before_singular_content', 2); ?>
<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- Visual editor -->

<?php the_content(); ?>

<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: --><!-- END Visual editor -->
  <br data-clear="all">
  <?php do_action('entex_template_after_singular_content', 2); ?>
  </div>
 <?php 
	entex_OUT(entex_CMN(0, 'template start'));
	get_template_part('tmpl-defaults/tmpl-singular-footer', get_post_type(), $args); 
 ?>
</article>
<?php if((!is_front_page() && comments_open()) || (!is_front_page() && get_comments_number())) { comments_template(); } else { entex_eCMN(0, 'no comments'); } ?>
<?php do_action('entex_template_singular_end', 0); ?>
<?php do_action('entex_template_after_template', 0, '', entex_backtrace(), false); ?>