<?php if(!defined('ABSPATH')) die(); 
/**
 *
 * Template Name: Entries Plain product | Entry Heading | RSS
 * Template Post Type: template-entries
 *
 * The default Archive template part
 * Registered as default template
 *
 * @package Entex
 * @subpackage Entex
 * @author Jonas Lundman
 * @documentation entex.info
 * @development intervik.com
 * @version 2.11116
 * 
 *
 */
?>
<?php
/**
 * NOTE: products have different post types
 * Any template part must correspond to each one
 * ua-product-data is hidden if ua-hide-product-data is populated
 * and all next siblings except star-rating is hidden on closed
 * ua-hide-review hides star rating on closed as well
 */
?>
<?php

/* product setup */
do_action('woocommerce_shop_loop');
global $product;
if(empty($product) || !$product->is_visible()) return;

?>
<?php

	$flex = false; // Flex handled by loop start wrapper and/ or archive wrapper class
	$_MORE = false;
	$_LENGTH = true;
	$_TITLE_CLASS = 'entry-exp-heading ua-not-main';
	$_TEMPLATE_CLASS = 'ua-attachment-fixed ua-wr-grid ua-show-current-id ua-is-closed ua-expander ua-hide-product-data ua-hide-entry-footer ua-hide-extended-title ua-hide-entry-gallery ua-hide-entry-meta ua-hide-subtitle ua-hide-entry-summary ua-hide-custom';

?>
<?php do_action('entex_template_before_template', 0, '', __FILE__, entex_backtrace()); ?>
<?php if($flex && $args['start']) echo '<div class="ua-flex">'; ?>
<article id="post-<?php the_ID(); ?>" class="<?php entex_template_output_post_class(array('hentry', $_TEMPLATE_CLASS)); ?>">
 <?php entex_template_output_entry_pre_header(1); ?>
 <header class="ua-fr-row-2">
  <?php do_action('entex_template_before_entry_title', 2); ?>
  <h2 class="entry-title <?php echo esc_attr($_TITLE_CLASS); ?>"><a href="<?php echo esc_url(get_permalink()); ?>" rel="bookmark"><?php echo wp_kses_post(entex_template_get_the_title()); ?></a></h2>
  <?php entex_template_output_subtitle(2); ?>
  <?php do_action('entex_template_after_entry_title', 2); ?>
 </header>
 <?php entex_template_output_entry_meta(1, array('classname' => 'ua-fr-row-3 ua-fr-margin')); ?>
 <div class="ua-wr">
  <div class="ua-content ua-wr-left">
   <?php entex_template_output_entry_post_thumbnail(2, 'medium_large', $data = array('caption' => false, 'classname' => 'ua-fixed-medium ua-expander-open', 'role' => 'button')); ?>
   <?php entex_template_output_entry_gallery(2, array('native' => true, 'size' => 'medium', 'id' => null, 'classname' => '')); ?>
   <?php do_action('entex_template_product_column_left_end', 2); ?>
  </div>
  <div class="ua-content ua-wr-right ua-not-main">
   <?php woocommerce_template_loop_price(); ?>
   <?php do_action('entex_template_before_entry_excerpt', 1); ?>
   <?php entex_template_output_entry_excerpt(2, array('more' => $_MORE, 'loop' => true, 'length' => $_LENGTH, 'indicate' => false)); ?>
   <?php do_action('entex_template_after_entry_excerpt', 1); ?>
   <div class="entry-buttons ua-wrapper ua-product-data"><?php do_action('woocommerce_after_shop_loop_item'); ?></div>
   <?php woocommerce_template_loop_rating(); ?>
   <?php do_action('entex_template_product_column_right_end', 2); ?>
  </div>
 </div>
 <?php do_action('entex_template_before_entry_end', 1); ?>
 <?php 
	entex_OUT(entex_CMN(0, 'template part - if in the loop'));
	if(in_the_loop()) get_template_part('tmpl-defaults/tmpl-entries-footer', get_post_type(), $args); 
 ?>
</article>
<?php if($flex && $args['end']) echo '</div>'; ?>
<?php do_action('entex_template_after_template', 0, '', __FILE__, entex_backtrace()); ?>
