<?php if(!defined('ABSPATH')) die();
/**
 *
 * Template Name: Entries article attachment gallery ( Taxonomies ) | WordPress gallery | RSS 
 * Template Post Type: template-entries
 *
 * Specialised template part file
 * Specialised for: attachment taxonomies ( any )
 * Default parent: tmpl-entries-article.php
 * Sortable within: Entries (template-entries)
 *
 * IMPORTANT: This template includes the parent wrapper to set the grid correctly
 * IMPORTANT: You must pass $args['start'] and $args['end'] when manually chained
 *
 * @package Entex
 * @subpackage Entex
 * @author Jonas Lundman
 * @documentation entex.info
 * @development intervik.com
 * @version 2.10517
 *
 */
?>
<?php
/**
 * Original: tmpl-defaults/tmpl-entries-article.php
 * Read original file for documentation
 *
 * This template render attachments as WordPress gallery shortcode
 * Together with Entex gallery expander, this is suitable for attachment taxonomies and terms
 * Without the plugin, the output will be as default WordPress gallery
 * The purpose is to view and access your images on the front end
 * If Entex Media library extended is installed, or MLA (Media Library Assistance)
 * This template works well to present folders, categories and attachment tags
 */
?>
<?php

	
	$_TEMPLATE_CLASS = 'gallery-item ua-attachment-fixed ua-expander ua-hidden-meta ua-hide-date ua-hidden-time ua-hide-above-title ua-hide-title ua-hide-subtitle ua-hide-content ua-hide-entry-meta ua-hide-custom';

	/* Populate the image element with data from plugin, if installed */
	/* This makes media files like Videos and documents to expand as content */
	/* It also activates functionslities for Entex media modal plugin */
	if($args['start']) add_filter('entex_gallery_expander_add_attachment_image_attributes', 'entex_return_true', 10, 1);
	

	
?>
<?php do_action('entex_template_before_template', 0, '', __FILE__, entex_backtrace()); ?>
<?php if($args['start']) echo '<div class="gallery gallery-columns-4">'."\r\n"; ?>
<article id="post-<?php the_ID(); ?>" class="<?php entex_template_output_post_class(array('hentry', $_TEMPLATE_CLASS)); ?>">
 <?php entex_template_output_entry_pre_header(1); ?>
 <?php entex_template_output_entry_post_thumbnail(1, 'medium_large', array('classname' => 'gallery-icon ua-expander-open')); ?>
 <header>
  <?php do_action('entex_template_before_entry_title', 2); ?>
  <h2 class='entry-title'><a href='<?php echo esc_url(get_permalink()); ?>' rel='bookmark'><?php echo wp_kses_post(entex_template_get_the_title()); ?></a></h2>
  <?php entex_template_output_subtitle(2, '', entex_template_get_entry_excerpt(1, array('length' => true, 'indicate' => false))); ?>
 </header>
 <?php entex_template_output_entry_content(1); ?>
 <?php //entex_template_output_entry_meta(2); ?>
 <div class="ua-content ua-custom ua-not-main">
	<?php if(get_post_type() == 'attachment') get_template_part('tmpl-parts/tmpl-meta-entry-attachment', '', $args); ?>
 </div>
</article>
<?php if($args['end']) echo '</div>'."\r\n"; ?>
<?php if($args['end']) remove_filter('entex_gallery_expander_add_attachment_image_attributes', 'entex_return_true', 10, 1); ?>
<?php do_action('entex_template_after_template', 0, '', __FILE__, entex_backtrace()); ?>
