<?php if(!defined('ABSPATH')) die();
/**
 * Template Name: Article manual (example template)
 * Template Post Type: template-example
 *
 * @package Entex
 * @subpackage Entex theme
 * @updated 2010-06-18
 *
 * Athom (hentry) compatible
 * 
 * NOTE:
 * This is an example of an entry template without hooks, building manually. To use this template you must first asign a proper Type like: template-entries
 */
?>
<!-- ——————————————————————————————————————————————————————————————————————————————————————————————————————————————— -->
<?php if(current_user_can('manage_options')) echo '<!-- Template: entex-post-widget/templates/plugin-entry-article.php -->'."\r\n"; ?>
<article id="post-<?php the_ID(); ?>" <?php echo 'class="' . esc_attr(join( ' ', apply_filters('post_class', array('hentry'), array(), get_the_ID()) )) . '"'; ?>>
 <div class="ua-pre-header">
  <span class="post-date ua-meta-date"><?php printf('<time class="entry-date published updated" datetime="%1$s">%2$s</time>', esc_attr(get_the_date('c')), get_the_date()); ?></span>
  <span class="post-category ua-meta-parent"><?php
  
	/* create your own template to access other post types */
	if(get_post_type() == 'post'){
		$categories = get_the_category();
		if(!empty($categories)) echo '<a href="'. esc_url(get_category_link($categories[(count($categories)-1)]->term_id)) .'" rel="category tag">'. esc_html($categories[(count($categories)-1)]->name) .'</a>';  
	}
	if(get_post_type() == 'page'){
		$parents = get_post_ancestors(get_the_ID());
		if(!empty($parents)) echo '<a href="'. esc_url(get_permalink($parents[(count($parents) - 1)])) .'">'. esc_html(get_the_title($parents[(count($parents) - 1)])) .'</a>';
	}
  ?></span>
 </div>
 <header class='entry-header'>
  <h2 class='entry-title'><a href='<?php echo esc_url(get_permalink()); ?>' rel='bookmark'><?php echo wp_kses_post(get_the_title()); ?></a></h2>
 </header>
 <div class="entry-meta">
  <span class="ua-meta-author"><span class="ua-author author vcard"><?php 
	echo '<span class="ua-by">'. esc_html(_x('By', 'Meta vocabulary: By Author', 'entex')) .'</span> ';
	/* translators: */
	printf('<a class="url fn n" title="%1$s" href="%2$s">%3$s</a>',
	/* translators: */
	esc_html(sprintf(_x('View all entries posted by %s', 'Meta: Hover author link', 'entex'), get_the_author())),
	esc_url(get_author_posts_url(get_the_author_meta('ID'))), 
	get_the_author()
	);
   ?></span></span>
   <span class="ua-meta-comments"><?php comments_popup_link(__('No comments', 'entex'), __('1 Comment', 'entex'), __('% Comments', 'entex')); ?></span>
 </div>
 <?php do_action('entex_template_before_entry_content', 1); ?>
 <div class="post-thumbnail"><a href="<?php echo esc_url(get_permalink()); ?>"><?php the_post_thumbnail(); ?></a></div>
 <?php the_excerpt(); ?>
 <?php do_action('entex_template_after_entry_content', 1); ?>
</article>
