<?php if(!defined('ABSPATH')) die();
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 * @package Entex
 * @subpackage Entex
 * @updated 2020 07 26
 *
 * Please read the Entex documentation about action indent arguments
 */

/**
 * HOOKS
 *
 * Note: Root template files does not render template source comments
 * Note: Root template files keeps the site main HTML architecture indent intact
 * Note: header.php | footer.php are considered as root template files in this matter
 *
 *
 * do_action('entex_template_before_archive_title')
 * @hooked: entex_template_output_the_archive_header_image, 10, 1
 *
 * do_action('entex_template_after_archive_title')
 * @hooked: entex_template_output_archive_meta, 10, 1
 * 
 * do_action('entex_template_before_archive_loop')
 * @hooked: entex_template_output_archive_description, 10, 1
 * @hooked: Woocommerce categories and filters
 *
 * do_action('entex_template_after_archive_loop')
 * @hooked: none
 *
 * do_action('entex_template_archive_footer')
 * @hooked: entex_template_output_the_posts_pagination, 10, 1
 *
 * do_action('entex_template_before_singular_loop', 5);
 * @hooked: none
 *
 * do_action('entex_template_after_singular_loop', 5);
 * @hooked: none
 *
 * NOTE: entex_template_output_action_comment, 5, 1
 * is not documented as it hooks into every action
 * As of all source comments, define responding constant to disable
 *
 */
 
/**
 * TEMPLATE DATA
 *
 * do_action('the_post')
 * @hooked: entex_fn_setup_postdata
 *
 * The globals below are populated by 'the_post()'
 * They must be declared global inside every template-file 'the main loop' is initialized to render
 * To take advantage of Entex theme dynamic template selector system
 */
 
 global $_entex_current_template;
 global $_entex_current_specialised;
 
 /**
 * TEMPLATE ROOT
 *
 * This is a template root, not template part
 * The first file to render source code within the browser
 * To avoid whitespace or empty lines at the top
 * Please keep the first call within this enclosing PHP
 */
 
 get_header();
 
?>
<?php if(have_posts()): ?>
<?php if(is_archive() || is_search() || is_home()): ?>
     <?php do_action('entex_template_before_archive_header', 5); ?>
     <header id="main-header">
	  <?php do_action('entex_template_before_main_header_inner', 6); ?>
	  <div id="main-header-inner">
       <?php do_action('entex_template_before_archive_title', 7); ?>
       <h1 class="archive-title"><?php echo wp_kses_post(get_the_archive_title()); ?></h1>
       <?php do_action('entex_template_after_archive_title', 7); ?>
	  </div>
	  <?php do_action('entex_template_after_main_header_inner', 6); ?>
     </header>
     <div id="main-content" class="ua-content">
      <?php do_action('entex_template_before_archive_loop', 6); ?>
	  <div class="<?php entex_template_output_archive_class(array('ua-archive-content', 'ua-content')); ?>">
       <?php 
	     entex_OUT(entex_CMN(0, 'loop start'));
		 while ( have_posts() ) : the_post();
			get_template_part($_entex_current_template, $_entex_current_specialised, get_query_var('args'));
		 endwhile;
		 entex_OUT(entex_CMN(7, 'loop end'));
       ?>
	  </div>
	  <?php do_action('entex_template_after_archive_loop', 6); ?>
     </div>
     <footer id="main-footer" class="ua-not-main">
	  <?php do_action('entex_template_archive_footer', 6); ?>
     </footer>
<?php else : ?>
     <?php do_action('entex_template_before_singular_loop', 5); ?>
     <?php
		entex_OUT(entex_CMN(0, 'loop start'));
		while (have_posts()) : the_post();
			get_template_part($_entex_current_template, $_entex_current_specialised, get_query_var('args'));
		endwhile;
		entex_OUT(entex_CMN(5, 'loop end'));
     ?>
	 <?php do_action('entex_template_after_singular_loop', 5); ?>
<?php endif; ?>
<?php else : ?>
     <header id="main-header" class="archive-title">
      <h1><?php echo esc_html(__('No content found', 'entex')); ?></h1>
     </header>
     <div id="main-content" class="<?php entex_template_output_archive_class(array('ua-content')); ?>">
      <p><?php echo esc_html(__('This text is shown if no content for this url could be found.', 'entex')); ?></p>
     </div>
<?php endif; ?>
<?php get_footer(); ?>