<?php if(!defined('ABSPATH')) die();

// WIDGET SETUP and SOCLE sidebar function

// Updated 2021 11 25

if(!function_exists('entex_theme_setup_widgets')):
/**
 * Entex filter widgets engine setup
 * Activates filter functions on all built in and custom widgets
 * Create your own entex_theme_setup_widgets() function to override in a child theme or to deactivate this construction.
 * All functions in this file are depended on this setup.
 * Example of use is provided in the end of this file
 *
 * @since Entex 1.0
 * @version 2.11118
 */
 
function entex_theme_setup_widgets() {

	/* support shortcodes in widgets */
	add_filter('widget_text', 'do_shortcode');
	add_filter('widget_text', 'entex_theme_widget_text');
	
	/* add individual filter constructor */
	add_filter('dynamic_sidebar_params', 'entex_theme_dynamic_sidebar_params_next', 10, 1);
	add_filter('dynamic_sidebar_params', 'entex_theme_dynamic_sidebar_params', 20, 1);
	
	/* Populate default filters */
	add_action('wp_loaded', 'entex_theme_filter_widgets');
}
endif; // END Pluggable
add_action('after_setup_theme', 'entex_theme_setup_widgets', 10);



/* Wrap another div */
function entex_theme_widget_text($text){
	return '<div class="ua-content">'. $text .'</div>';
}


// Example of adding inverted class to a widget
/* 
add_filter('entex_theme_filter_add_widget_classname', function($add, $classnames){
	if(strpos($classnames, 'example_of_widget_classname') !== FALSE){
		$add = 'ua-set-inverted';
	}
	return $add;
}, 10, 2);
*/

/* filter all widgets, inject class if needed */
function entex_theme_filter_all_widgets($classname, $classnames){
	$add = '';
	$add = apply_filters('entex_theme_filter_add_widget_classname', $add, $classnames);
	if($add) $classname .= ' '.$add;
	return $classname;
}


function entex_theme_dynamic_sidebar_params($params){
	
	if(is_admin()) return $params;

	$extend = '';
	$before_widget = $params[0]['before_widget'];
	
	if(strpos($before_widget, 'widget_categories') !== FALSE){
		$options = get_option('widget_categories');
		if(isset($options[$params[1]['number']]) && !$options[$params[1]['number']]['dropdown']){
			if($options[$params[1]['number']]['hierarchical']) $extend = 'widget_categories_list_hierarchical';
				else $extend = 'widget_categories_list';
		} else if(isset($options[$params[1]['number']])){
			if($options[$params[1]['number']]['hierarchical']) $extend = 'widget_categories_dropdown_hierarchical';
				else $extend = 'widget_categories_dropdown';
		}
		if($extend) $extend = ' '.$extend;
	}

	$changes = array();
	$arr = array();
    preg_match('/class="(.*?)"/i', $before_widget, $arr);
	$classnames = $arr[1];
	$original = 'class="'.$classnames;
	$classes = explode(' ', $classnames.$extend);
	foreach($classes as $value){
		/* filter */
		$changes[] = apply_filters('entex_theme_filter_widget_classname_'.$value, $value, $classnames);
	}
	$str = implode(' ', $changes);
	$replacement = 'class="'.$str;
	$params[0]['before_widget'] = str_replace($original, $replacement, $params[0]['before_widget']);
	
	/* old link widget doesnt match id in customizer */
	/* the id is the category id as default in the widget, replaced by preg_replace */
	if(strpos($before_widget, 'widget_links') !== FALSE){
		$params[0]['before_widget'] = str_replace('id="', 'data-filter="¤'. $params[0]['widget_id'] .'¤" id="', $params[0]['before_widget']);
	}
	return $params;
}


/* old link widget doesnt match id in customizer */
add_filter('widget_links_args', function($args, $instance){
	$before_widget = $args['category_before'];
	if(strpos($before_widget, '¤') !== FALSE){
		list($d1, $id, $d2) = explode('¤', $before_widget);
		$before_widget = preg_replace('/ data-filter="[^"]*"/', '', $before_widget);
		$before_widget = str_replace('%id', $id, $before_widget);
		$args['category_before'] = $before_widget;
	}
	return $args;
}, 10, 2);


/* removes previous widgets filters */
/* Todo: apply sidebar id argument */
function entex_theme_dynamic_sidebar_params_next($params){
	if(is_admin()) return $params;
	do_action('entex_theme_before_next_widget');
	return $params;
}


/* helper (to be registered valid hook) */
function entex_cleanup_populate_ancestors_false(){
	return false;
}


/* Init */
/* called only once from inside: entex_theme_setup_widgets */
function entex_theme_filter_widgets(){
	
	if(is_admin() && (!defined('DOING_AJAX') || !DOING_AJAX)) return;

	/* populate removal action for default filters */
	add_action('entex_theme_before_next_widget', function(){
		remove_filter('entex_cleanup_populate_ancestors', 'entex_cleanup_populate_ancestors_false');
	});
	
	/* do not use on nestled list menues */
	$uaNavListWidgets = apply_filters('entex_theme_widgets_type_ua_nav_list', array(
		'widget_recent_entries',
		'widget_recent_comments',
		'widget_meta',
		'widget_links',
		'widget_archive',
		'widget_views'
	));
	
	$uaContentWidgets = apply_filters('entex_theme_widgets_type_ua_content', array(
		'widget_media_images',
		'widget_media_audio',
		'widget_media_video'
	));
	
	$uaListNodeRightWidgets = apply_filters('entex_theme_widgets_type_ua_list_node_right', array(
		'widget_recent_entries',
		'widget_archive',
		'widget_views'
	));

	/* dynamic filter '_widget' applies to all widgets */
	add_filter('entex_theme_filter_widget_classname_widget', 'entex_theme_filter_all_widgets', 10, 2);
	
	// NOTE the space before classname strings
	
	/* dynamic filter '_widget_categories_list' applies to all categories widgets like woocommerce product categories widget */
	add_filter('entex_theme_filter_widget_classname_widget_categories_list', function($classname, $classnames){
		/* this is removed by entex_theme_before_next_widget */
		add_filter('entex_cleanup_populate_ancestors', 'entex_cleanup_populate_ancestors_false');
		return $classname .' ua-set-nav-list';
	}, 10, 2);
	
	add_filter('entex_theme_filter_widget_classname_widget_categories_list_hierarchical', function($classname, $classnames){
		return $classname .' ua-nav ua-nav-y ua-set-after ua-fn-accordion ua-hide-count';
	}, 10, 2);
	
	/* use on nestled menues as straight vertical links */
	add_filter('entex_theme_filter_widget_classname_widget_pages', function($classname, $classnames){
		/* this is removed by entex_theme_before_next_widget */
		add_filter('entex_cleanup_populate_ancestors', 'entex_cleanup_populate_ancestors_false');
		return $classname .' ua-nav ua-nav-y ua-fn-accordion ua-set-after';
	}, 10, 2);
	
	/* add theme navigation class to navigation menu widget */
	add_filter('widget_nav_menu_args', function($nav_menu_args, $nav_menu, $args, $instance){
		/* The sidebar id */
		$conditional = $args['id'];
		$nav_menu_args['container_class'] = apply_filters('entex_theme_widget_nav_menu_container_class_'. $conditional, 'ua-nav ua-nav-y ua-set-after ua-fn-accordion ua-menu-box', $nav_menu_args, $nav_menu, $args, $instance);
		return $nav_menu_args;
	}, 12, 4);
	
	foreach($uaNavListWidgets as $widget){
		add_filter('entex_theme_filter_widget_classname_'. $widget, function($classname, $classnames){
			return $classname .' ua-set-nav-list';
		}, 11, 2);
	}
	
	foreach($uaContentWidgets as $widget){
		add_filter('entex_theme_filter_widget_classname_'. $widget, function($classname, $classnames){
			return $classname .' ua-content';
		}, 11, 2);
	}
	
	/* wrap counts in span element sitewide */
	add_filter('wp_list_categories', function ($links){
		
		/* if custom walkers not using class filter */
		if(strpos($links, 'cat-item') !== FALSE){
			$populate_ancestors = apply_filters('entex_cleanup_populate_ancestors', true);
			if($populate_ancestors) $populate_ancestors = ' '.apply_filters('nav_class_current', 'selected');
				else $populate_ancestors = '';
			
			$replace = apply_filters('nav_class_current_menu_parent', 'current-menu-parent');
			$links = str_replace('current-cat-parent', $replace.$populate_ancestors, $links);
		
			$replace = apply_filters('nav_class_current_menu_ancestor', 'current-menu-ancestor');
			$links = str_replace('current-cat-ancestor', $replace.$populate_ancestors, $links);
		
			$replace = apply_filters('nav_class_current_menu_item', 'current-menu-item');
			$current = ' '.apply_filters('nav_class_current', 'selected').' '.apply_filters('nav_class_current_onload', 'selected-onload');
			$links = str_replace('current-cat', $replace.$current, $links);
		}
		if(strpos($links, 'class="count"') === FALSE){
			$links = str_replace('</a> (', '</a> <span class="count">(', $links);
			$links = str_replace(')', ')</span>', $links);
		}
		return $links;
	}, 10, 1);
	
	add_filter('get_archives_link', function ($links){
		$links = str_replace('</a>&nbsp;(', '</a> <span class="count">(', $links);
		$links = str_replace(')', ')</span>', $links);
		return $links;
	}, 10, 1);
	
}

// SOCLE-1 SIDEBAR NAV DEFAULT FILTER
function entex_theme_filter_widget_nav_menu_container_socle($classnames, $nav_menu_args, $nav_menu, $args, $instance){
	$classnames = 'ua-nav ua-set-nav-list ua-nav-clean ua-set-after ua-nav-onload-false';
	return $classnames;
}
add_filter('entex_theme_widget_nav_menu_container_class_socle-1', 'entex_theme_filter_widget_nav_menu_container_socle', 10, 5);


// YOAST LOCAL SEO PLUGIN EXAMPLE (not in use here)
function entex_theme_filter_widget_plugin_yoast_location($classname, $classnames){
	$classname .= ' ua-all ua-horizontal';
	return $classname;
}
//add_filter('entex_theme_filter_widget_classname_WPSEO_Show_Address', 'entex_theme_filter_widget_plugin_yoast_location', 10, 2);
//add_filter('entex_theme_filter_widget_classname_WPSEO_Show_OpeningHours', 'entex_theme_filter_widget_plugin_yoast_location', 10, 2);



/* -------------------- */
// SOCLE SIDEBAR
/* Appears before footer within a section */
/* Each widget activates one column */
/* The column settings can be filtered in */

function entex_template_socle_params($params){
	$params[0]['after_widget'] .= '_¤_';
	return $params;
}

function entex_template_socle_image_attributes($attr){
	if(isset($attr['style'])) unset($attr['style']);
	if(isset($attr['class'])) unset($attr['class']); 
	return $attr; 
}

function entex_template_filter_section_socle_item_2($classnames, $n, $count, $html){
	if($count == 2) $classnames .= ' ua-grid-span';
	if($count == 2 && strpos($html, 'widget_media_image') !== FALSE) $classnames .= ' ua-set-bottom-column-right';
	return $classnames;
}
add_filter('entex_template_section_socle_item_2', 'entex_template_filter_section_socle_item_2', 10, 4);

function entex_template_filter_section_socle_html_2($html, $indent, $identifier, $n, $count){
	//if(strpos($html, 'widget_media_image') !== FALSE) $html = str_replace('figure class="', 'figure class="ua-layer-caption ', $html);
	return $html;
}
add_filter('entex_template_section_socle_html_2', 'entex_template_filter_section_socle_html_2', 10, 5);


function entex_template_output_socle($indent = 0, $sidebar = 'socle-1'){
	
	/* comment */
	do_action('entex_template_before_function', 0, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	$name = $sidebar;
	
	$sidebars_widgets = wp_get_sidebars_widgets();
	if(empty($sidebars_widgets[$sidebar])) return;
	$widgets = $sidebars_widgets[$sidebar];
	
	$count = count($widgets);
	if(!$count) return;
	
	/* remove hard-coded style by WordPress */
	add_filter('wp_get_attachment_image_attributes', 'entex_template_socle_image_attributes', 60, 1);
	
	/* socle uses fixed columns by default */
	$remove = array('ua-grid-span', 'ua-main');
	
	add_filter('dynamic_sidebar_params', 'entex_template_socle_params', -5, 1);
	ob_start();
	dynamic_sidebar($sidebar);
	remove_filter('dynamic_sidebar_params', 'entex_template_params_socle', -5, 1);
	
	$buffer = explode('_¤_', ob_get_clean());
	unset($buffer[(count($buffer) - 1)]);

	foreach($buffer as $contains){
		if($contains && trim($contains)){
			$_html[] = $contains;
		}
	}
	if(isset($_html)){
		
		/* manually added as this is not a filtered in sidebar */
		$context = 'ua-socle';
		
		/* inverted as default */
		if(get_theme_mod('entex_theme_layout_socle_set_invert', 1)){
			$context .= ' ua-set-invert';
		}
		
		$n = 0;
		foreach($_html as $html){
			$n++;
			if($n > 4) break;
			add_action('entex_template_section_column_'.$n, function($indent, $identifier) use ($html, $n, $count){
				$html = apply_filters('entex_template_section_socle_html_'.$n, $html, $indent, $identifier, $n, $count);
				echo wp_kses($html, entex_wp_kses());
			}, ($n * 10), 2);
			add_filter('entex_template_section_item_'.$n, function($classnames) use ($remove, $n, $count, $html){
				$classnames = str_replace($remove, '', $classnames);
				return apply_filters('entex_template_section_socle_item_'.$n, $classnames, $n, $count, $html);
			}, ($n * 10), 2);
		}
		if($n > 4) $n = 4;
		
		
		/* filter */ // default ''
		add_filter('entex_template_section_id', function($id) { return 'ua-id-socle'; }, 10, 1);
		
		/* filter */ // default '', this filter add context into template class attribute - we also remove the content classname from the section template
		add_filter('entex_template_section_context', function($classname, $filename) use ($context){ return $context; }, 10, 2);
		
		/* filter */ // NOTE: $classnames is complete string from template, return added value !
		add_filter('entex_template_section_item_parent', function($classnames, $filename) use ($n){ $classnames .= ' ua-grid-root-'. $n; return $classnames; }, 10, 2);
		
		/* action */ // manually filter in exceptions
		do_action('entex_template_output_socle_before', $context, $n);
		
		get_template_part('tmpl-sections/tmpl-section-'. $n .'-col');
		for($i = 0; $i < $n; $i++){
			//remove_all_filters('entex_template_section_socle_html_'.($i + 1));
			//remove_all_filters('entex_template_section_socle_item_'.($i + 1));
			remove_all_filters('entex_template_section_item_'.($i + 1));
			remove_all_actions('entex_template_section_column_'.($i + 1));
		}
		
		/* action */ // manually filter out exceptions
		do_action('entex_template_output_socle_after', $context, $n);
		
		remove_filter('entex_template_section_id', function($id) { return 'ua-id-socle'; }, 10, 1);
		remove_filter('entex_template_section_context', function($classname, $filename) use ($context){ return $context; }, 10, 2);
		remove_filter('entex_template_section_item_parent', function($classnames, $filename) use ($n){ $classnames .= ' ua-grid-root-'. $n; return $classnames; }, 10, 2);
	}

	remove_filter('wp_get_attachment_image_attributes', 'entex_template_socle_image_attributes', 60, 1);

}
add_action('entex_template_socle', 'entex_template_output_socle', 10, 2);


// -- END FILE -- //