<?php if(!defined('ABSPATH')) die();

// Updated 2021 11 06

// ENTEX VISUAL EDITOR
/* Entex theme support for: TinyMCE Visual editor */
/* Make editor compatible with Entex styles and classnames */


/* -------------------- */
// SETUP :

if(!function_exists('entex_theme_setup_visual_editor')) :
/* Create your own function to override in a child theme. */

function entex_theme_setup_visual_editor(){
	
	/* Editor content area background layout */
	/* As MCE load front-end stylesheet */
	/* We need to remove layout applied to the front end body */

	add_filter('tiny_mce_before_init', function($mceInit){
		
		$gutenberg = false;
		if(function_exists('entex_is_gutenberg')){
			if(entex_is_gutenberg()) $gutenberg = true;
		}
		
		if(!defined('ENTEX_THEME_TINY_MCE_GUTENBERG_ENABLE') && !defined('ENTEX_PLUGIN_TINY_MCE_GUTENBERG_ENABLE')){
			if($gutenberg) return $mceInit;
		}
		
		if(!isset($mceInit['body_class'])) $mceInit['body_class'] = '';
		if(!$mceInit['body_class']) $mceInit['body_class'] = 'ua-init ua-content ua-main';
			else $mceInit['body_class'] = $mceInit['body_class'].' ua-init ua-content ua-main';
		if(!get_theme_mod('entex_theme_remove_wp_is_initial', 0)) $mceInit['body_class'] = $mceInit['body_class'].' wp-is-initial';

		
		if(defined('ENTEX_THEME_EDIT_CONTENT_WIDTH')) $width = ENTEX_THEME_EDIT_CONTENT_WIDTH;
			else $width = 640;
		if(strpos($width, 'px') !== FALSE) $width = trim(str_replace('px', '', $width));
		$styles = '';

		if(!defined('ENTEX_THEME_TINY_MCE_BLOCK_FORMATS_DISABLE')){
			$mceInit['block_formats'] = 'Paragraph=p;Heading 2=h2;Heading 3=h3;Heading 4=h4;Subtitle=h5;Note=h6;Preformatted=pre;Code=code;Blockquote=blockquote;Div=div;';
		}
		$style_formats = array(
			array('title' => 'Preamble', 'selector' => 'p', 'classes' => 'is-style-ua-preamble'),
			array('title' => 'Indent', 'selector' => 'p', 'classes' => 'is-style-ua-indent'),
			array('title' => 'Hyphenate', 'selector' => 'p', 'classes' => 'is-style-ua-hyphenate'),
			array('title' => 'Content in box', 'selector' => 'p, ul, div', 'classes' => 'is-style-ua-box'),
			array('title' => 'Border', 'selector' => 'figure, img', 'classes' => 'ua-border'),
			array('title' => 'Large list', 'selector' => 'ul, ol', 'classes' => 'is-style-item-large'),
		);
		
		/* filter */
		$style_formats = apply_filters('entex_theme_tiny_mce_style_formats', $style_formats, $mceInit);
		
		if(!empty($mceInit['style_formats'])){
			$original = json_decode($mceInit['style_formats']);
			if(apply_filters('entex_theme_tiny_mce_original_merge', true, $mceInit)){
				$style_formats = array_merge($original, $style_formats);
			}
		}
		$mceInit['style_formats'] = json_encode($style_formats);
		$mceInit['style_formats_merge'] = apply_filters('entex_theme_tiny_mce_style_formats_merge', false, $mceInit);
		
		if($gutenberg){
			
			$styles .= '.mce-content-body { background-color: #fff; padding: 0px; background-image: none; } ';
			$styles .= '.mce-content-body:before { display: none; } ';
			$styles .= '.mce-content-body:after { display: none; } ';
			
		} else {
			
			$styles .= 'body.mce-content-body { background-color: #fff; padding: 20px 40px; width: '. ($width + 80) .'px; background-image: none; } ';
			$styles .= 'body.mce-content-body.ua-as-main { padding: 40px; width: '. ($width + 80) .'px; } ';
			$styles .= 'body.mce-content-body.ua-not-main { padding: 20px; width: 360px; margin: 0 auto; } ';
			$styles .= 'html.ua-tiny-mobile { background-color: #000; } ';
			$styles .= 'body.mce-content-body:before { display: none; } ';
			$styles .= 'body.mce-content-body:after { display: none; } ';
		}

		if(isset($mceInit['content_style'])) $mceInit['content_style'] .= ' '. $styles .' ';
			else $mceInit['content_style'] = $styles .' ';
		
		/* filter */
		$mceInit['content_style'] = apply_filters('entex_admin_mce_content_style', $mceInit['content_style']);
		
		if(defined('ENTEX_THEME_TINYMCE_NO_CACHE')) $mceInit['cache_suffix'] = '?v='.rand(1,1000);
		return $mceInit;
		
	}, 99, 1);
}
endif; // END Pluggable
add_action('after_setup_theme', 'entex_theme_setup_visual_editor');


/* -------------------- */
// ADMIN TINY MCE EDITOR STYLES

function entex_theme_visual_editor_styles(){

	if(function_exists('entex_is_gutenberg')){
		if(entex_is_gutenberg()){
			return;
		}
	}

	/* There are also inline styles in entex-setup-visual-editor.php */
	/* NOTE: If writing to file not permitted, customized styles is not loaded in TinyMCE for now */
	/* As we are running a Hybrid we load the block styles */
	//add_editor_style(array('assets/ua-css/ua-default-stylesheet.min.css')); return;
	add_editor_style(array('assets/ua-css/ua-default-stylesheet.min.css', 'customizer.css', '../../../wp-includes/css/dist/block-library/style.min.css'));
	
	/* google fonts */
	$fonts_url = entex_theme_fonts_url();
	if($fonts_url) add_editor_style($fonts_url);
	
	/* Customizer styles */
	$fonts_url = entex_theme_customize_fonts_url();
	if($fonts_url) add_editor_style($fonts_url);
}
add_action('admin_enqueue_scripts', 'entex_theme_visual_editor_styles');

/* ******************** */

// -- END FILE -- //