<?php if(!defined('ABSPATH')) die();

// SIDEBAR SETUP 

// Updated 2021 11 21


/* AUTO-GENERATE FALLBACK SIDEBARS */
/* remove this to gain some miliseconds of speed on large installs */
add_filter('entex_template_filter_output_merge_intercepted_sidebar', 'entex_return_true', 10, 1);



/* DEFAULT WIDGET SIDEBAR */

if(!function_exists('entex_theme_widgets_init')) :
/* Create your own function to override in a child theme. */

function entex_theme_widgets_init() {

	register_sidebar( array(
		'name'          => _x('Default sidebar', 'Admin: Sidebars', 'entex'),
		'id'            => 'sidebar-1',
		'description'   => _x('Appears on any page if no conditional sidebar is in use. Add widgets here to appear in this area.', 'Admin: Sidebars', 'entex'),
		'before_widget' => '<section id="%1$s" class="widget %2$s">', // phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
		'after_widget'  => '</section>',
		'before_title'  => '<h4>',
		'after_title'   => '</h4>',
	) );
	
	register_sidebar( array(
		'name'          => _x('Sticky sidebar ( Above )', 'Admin: Sidebars', 'entex'),
		'id'            => 'sticky-1',
		'description'   => _x('Appears if active, on every page above any other sidebar. Filters are available for finer control.', 'Admin: Sidebars', 'entex'),
		'before_widget' => '<section id="%1$s" class="widget %2$s">', // phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
		'after_widget'  => '</section>',
		'before_title'  => '<h4>',
		'after_title'   => '</h4>',
	) );
	
	register_sidebar( array(
		'name'          => _x('Template sidebar', 'Admin: Sidebars', 'entex'),
		'id'            => 'template-sidebar-1',
		'description'   => _x('Appears in custom templates by action.', 'Admin: Sidebars', 'entex'),
		'before_widget' => '<section id="%1$s" class="widget %2$s">', // phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
		'after_widget'  => '</section>',
		'before_title'  => '<h4>',
		'after_title'   => '</h4>',
	) );

	register_sidebar( array(
		'name'          => _x('Socle sidebar', 'Admin: Sidebars', 'entex'),
		'id'            => 'socle-1',
		'description'   => _x('Appears everywhere within section before footer. One column for each widget. Note, when using 2 widgets, the second column will be absolute to bottom right corner. Make shure the first column content is taller.', 'Admin: Sidebars', 'entex'),
		'before_widget' => '<section id="%1$s" class="widget %2$s">', // phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
		'after_widget'  => '</section>',
		'before_title'  => '<h4>',
		'after_title'   => '</h4>',
	) );
}
endif; // END Pluggable
add_action('widgets_init', 'entex_theme_widgets_init');



/* ADDED SIDEBARS */

if(!function_exists('entex_theme_sidebars')) :
/* Create your own function to override in a child theme. */

function entex_theme_sidebars(){
	
	$sidebars['is_front_page'] = _x('Front page', 'Sidebars: DO NOT TRANSLATE', 'entex');
	$sidebars['is_page'] = _x('Pages ( Single page )', 'Sidebars: DO NOT TRANSLATE', 'entex');
	$posttype['is_page'] = 'page';
	$sidebars['is_post'] = _x('Posts ( Single post )', 'Sidebars: DO NOT TRANSLATE', 'entex');
	$posttype['is_post'] = 'post';
	
	/* init unique */
	/* Conditional is_post() doesnt exists */
	/* Same for all post types except is_attachment() */
	$unique[] = 'is_post';
	
	$sidebars['is_singular'] = _x('Singular', 'Sidebars: DO NOT TRANSLATE', 'entex');
	$sidebars['is_home'] = _x('Blog ( index )', 'Sidebars: DO NOT TRANSLATE', 'entex');
	$sidebars['is_category'] = _x('Categories', 'Sidebars: DO NOT TRANSLATE', 'entex');
	$sidebars['is_post_tag'] = _x('Tags', 'Sidebars: DO NOT TRANSLATE', 'entex');
	$sidebars['is_post_format'] = _x('Post formats ( type ) archives', 'Sidebars: DO NOT TRANSLATE', 'entex');
	$sidebars['is_author'] = _x('Author archives', 'Sidebars: DO NOT TRANSLATE', 'entex');
	$sidebars['is_date'] = _x('Date archives', 'Sidebars: DO NOT TRANSLATE', 'entex');
	
	$fallback['is_front_page'] = _x('Default sidebar', 'Sidebars: DO NOT TRANSLATE', 'entex');
	$fallback['is_home'] = _x('Default sidebar', 'Sidebars: DO NOT TRANSLATE', 'entex');
	$fallback['is_page'] = 'is_singular';
	$fallback['is_post'] = 'is_singular';
	$fallback['is_singular'] = _x('Default sidebar', 'Sidebars: DO NOT TRANSLATE', 'entex');
	$fallback['is_category'] = 'is_archive';
	$fallback['is_post_tag'] = 'is_archive';
	$fallback['is_post_format'] = 'is_archive';
	$fallback['is_author'] = 'is_archive';
	$fallback['is_date'] = 'is_archive';
	
	// filter in further below if needed:
	/*
	$sidebars['is_year'] = _x('Year archives', 'Sidebars: DO NOT TRANSLATE', 'entex');
	$sidebars['is_month'] = _x('Month archives', 'Sidebars: DO NOT TRANSLATE', 'entex');
	$sidebars['is_day'] = _x('Day archives', 'Sidebars: DO NOT TRANSLATE', 'entex');
	$sidebars['is_time'] = _x('Time archives', 'Sidebars: DO NOT TRANSLATE', 'entex');
	$fallback['is_year'] = 'is_date'; 
	etc etc
	*/
	
	/* filter */ // EARLY - for grouping close to default WordPress conditionals, there is another filter at the end
	$sidebars = apply_filters('entex_theme_filter_register_sidebars_early', $sidebars);
	
	/* filter */ // EARLY - for grouping close to default WordPress conditionals, there is another filter at the end
	$fallback = apply_filters('entex_theme_filter_register_sidebars_fallback_early', $fallback);
	
	
	/* UNWANTED SIDEBARS */
	
	/* example default unwanted from entex media library extended and woocommerce */
	$unwanted = array('attachment_tag', 'product_shipping_class');
	
	/* filter */
	$unwanted = apply_filters('entex_theme_filter_unwanted_sidebar_post_types', $unwanted);
	
	
	/* Built in public post types */
	
	$objects = get_object_taxonomies('post', 'objects');
	if(!empty($objects)){
		foreach($objects as $id => $obj){
			if(in_array($obj->name, $unwanted)) continue;
			if($obj->name == 'post_format') $taxonomies[] = _x('Post formats', 'Sidebars: DO NOT TRANSLATE', 'entex');
				else $taxonomies[] = $obj->label;
			$intercepted['is_'.$obj->name] = 'all_post';
		}
		if(isset($taxonomies[0])){
			$intersepts['all_post'] = $taxonomies;
			array_unshift($intersepts['all_post'], _x('Blog', 'Sidebars: DO NOT TRANSLATE', 'entex'));
			$intersepts['all_post'][] = _x('Single post', 'Sidebars: DO NOT TRANSLATE', 'entex');
			unset($taxonomies);
			/* add */
			$intercepted['is_post'] = 'all_post';
			$intercepted['is_home'] = 'all_post';
		}
	}
	
	
	/* Attachment special case, has often custom taxonomies */
	
	$custom = array();
	$custom['is_attachment'] = _x('Media ( Single attachment )', 'Sidebars: DO NOT TRANSLATE', 'entex');
	$fallback['is_attachment'] = 'is_singular';
	$posttype['is_attachment'] = 'attachment';
	
	$objects = get_object_taxonomies('attachment', 'objects');
	if(!empty($objects)){
		foreach($objects as $id => $obj){
			if(!$obj->public || $obj->_builtin) continue;
			if(in_array($obj->name, $unwanted)) continue;
			if($obj->label){
				$taxonomies[] = $obj->label;
				if($obj->name == 'attachment_category') $custom['is_'.$obj->name] = $obj->label . _x(' ( Media categories ) ', 'Sidebars: DO NOT TRANSLATE', 'entex');
					else $custom['is_'.$obj->name] = $obj->label;
				$tax['is_'.$obj->name] = $obj->name;
				$fallback['is_'.$obj->name] = 'is_archive';
				$intercepted['is_'.$obj->name] = 'all_attachment';
			}
		}
		if(isset($taxonomies[0])){
			$intersepts['all_attachment'] = $taxonomies;
			$intersepts['all_attachment'][] = _x('Single attachment', 'Sidebars: DO NOT TRANSLATE', 'entex');
			unset($taxonomies);
			/* add */
			$intercepted['is_attachment'] = 'all_attachment';
		}
	}

	
	/* Collect custom post types, taxonomies and arcives */
	
	$args = array('public' => true, '_builtin' => false);
    $output = 'object';
    $operator = 'and';
	
	$post_types = get_post_types($args, $output, $operator);
	foreach($post_types as $key =>$object){
		$post_type = $object->name;
		if(in_array($post_type, $unwanted)) continue;
		$note = '';
		if($object->labels->singular_name != $object->label) $note = ' ( '. esc_html_x('Single', 'Sidebars: LIKE Single [ page ]', 'entex') .' '. $object->labels->singular_name .' )';
		if($object->label){
			$custom['is_'.$post_type] = $object->label. $note;
			$fallback['is_'.$post_type] = 'is_singular';
			$posttype['is_'.$post_type] = $post_type;
			$unique[] = 'is_'.$post_type;
			$objects = get_object_taxonomies($post_type, 'objects');
			if(!empty($objects)){
				foreach($objects as $id => $obj){
					if(!$obj->public || $obj->_builtin) continue;
					if(in_array($obj->name, $unwanted)) continue;
					if($obj->label){
						$taxonomies[] = $obj->label;
						$custom['is_'.$obj->name] = $obj->label;
						$tax['is_'.$obj->name] = $obj->name;
						$fallback['is_'.$obj->name] = 'is_archive';
						$intercepted['is_'.$obj->name] = 'all_'.$post_type;
					}
				}
				if(isset($taxonomies[0])){
					$intersepts['all_'.$post_type] = $taxonomies;
					$intersepts['all_'.$post_type][] = esc_html_x('Single', 'Sidebars: LIKE Single [ page ]', 'entex') .' '.$post_type;
					unset($taxonomies);
					/* add */
					$intercepted['is_'.$post_type] = 'all_'.$post_type;
				}
			}
		}
		if($object->has_archive){
			$note = '';
			if($object->has_archive != mb_strtolower($object->label)) $note = ' ( '. entex_mb_ucfirst($object->has_archive) .' )';
			$custom['is_post_type_archive_'.$object->name] = $object->label.' '. esc_html_x('archive', 'Sidebars: DO NOT TRANSLATE', 'entex') .$note;
			$parchive['is_post_type_archive_'.$object->name] = $post_type;
			$fallback['is_post_type_archive_'.$object->name] = _x('Default sidebar', 'Sidebars: DO NOT TRANSLATE', 'entex');
			if(isset($intersepts['all_'.$post_type])){
				if($note) array_unshift($intersepts['all_'.$post_type], entex_mb_ucfirst($object->has_archive));
					else array_unshift($intersepts['all_'.$post_type], $object->label.' '.esc_html_x('archive', 'Sidebars: DO NOT TRANSLATE', 'entex'));
				$intercepted['is_post_type_archive_'.$object->name] = 'all_'.$post_type;
			}
		}
	}
	
	/* check for taxonomies without post type */
	
	$taxonomies = get_taxonomies($args, $output, $operator);
	foreach($taxonomies as $key =>$object){
		if(in_array($object->name, $unwanted)) continue;
		if(isset($custom['is_'.$object->name])) continue;
		if($object->label){
			$custom['is_'.$object->name] = $object->label;
			$fallback['is_'.$object->name] = 'is_archive';
		}
	}
	
	$sidebars = array_merge($sidebars, $custom);
	
	$sidebars['is_archive'] = _x('Archives', 'Sidebars: DO NOT TRANSLATE', 'entex');
	$fallback['is_archive'] = _x('Default sidebar', 'Sidebars: DO NOT TRANSLATE', 'entex');
	$sidebars['is_search'] = _x('Search results', 'Sidebars: DO NOT TRANSLATE', 'entex');
	$fallback['is_search'] = _x('Default sidebar', 'Sidebars: DO NOT TRANSLATE', 'entex');
	$sidebars['is_404'] = _x('404 not found', 'Sidebars: DO NOT TRANSLATE', 'entex');
	$fallback['is_404'] = _x('Default sidebar', 'Sidebars: DO NOT TRANSLATE', 'entex');
	
	$sidebars = array_merge($sidebars, $intersepts);
	
	/* filter */
	$sidebars = apply_filters('entex_theme_filter_register_sidebars', $sidebars);
	
	/* filter */
	$fallback = apply_filters('entex_theme_filter_register_sidebars_fallback', $fallback);
	
	/* filter */
	$intercepted = apply_filters('entex_theme_filter_register_sidebars_intercepted', $intercepted);
	
	/* we dont want them here, but pass them to the filter */
	$def['sidebar-1'] = _x('Default sidebar', 'Sidebars: DO NOT TRANSLATE', 'entex');
	$def['sticky-1'] = _x('Sticky sidebar', 'Sidebars: DO NOT TRANSLATE', 'entex') .' ( '. _x('Above', 'Sidebars: LIKE Above Default sidebar', 'entex') .' )';
	$def['template-sidebar-1'] = _x('Template sidebar', 'Sidebars: DO NOT TRANSLATE', 'entex');
	$fallback['sidebar-1'] = _x('This sidebar has no fallback', 'Sidebars', 'entex');
	$fallback['sticky-1'] = _x('This sidebar has no fallback', 'Sidebars', 'entex');
	$fallback['template-sidebar-1'] = _x('This sidebar has no fallback', 'Sidebars', 'entex');
	
	
	/* pass variables into sidebar output function */
	$pass = array_merge($def, $sidebars);
	
	add_filter('entex_theme_filter_registered_sidebars', function() use ($pass){
		return $pass;
	}, 10, 1);
	
	add_filter('entex_theme_filter_registered_sidebars_fallback', function() use ($fallback){
		return $fallback;
	}, 10, 1);
	
	add_filter('entex_theme_filter_registered_sidebars_intercepted', function() use ($intercepted){
		return $intercepted;
	}, 10, 1);
	
	add_filter('entex_theme_filter_registered_sidebars_intersepts', function() use ($intersepts){
		return $intersepts;
	}, 10, 1);
	

	/* build the sidebars */
	
	foreach($sidebars as $id => $name){
		
		$argument = '';
		$current = $id;
		if($id == 'is_post_tag') $current = 'is_tag';
		
		/* default */
		/* translators: */
		$description = sprintf(_x('This area responds to the %1$s(%2$s) template conditional.', 'Admin: Sidebars', 'entex'), $current, $argument);
		
		/* intercepts carries no name */
		if(is_array($name)){
			
			if(empty($name)) continue;
			$name = str_replace('all_', _x('All', 'Sidebars: LIKE All [ is_page ] sidebars', 'entex') .' ', $id);
			if($id == 'all_attachment') $name = str_replace('attachment', 'media', $name);
			$conditionals = implode(', ', $intersepts[$id]);
			
			/* translators: */
			$description = sprintf(_x('This area responds to %1$s conditionals.', 'Admin: Sidebars', 'entex'), $conditionals);
			$description .= ' '. _x('If any individual sidebar is populated, this fallback will be replaced on that conditional.', 'Admin: Sidebars', 'entex');
			$description .= ' '. _x('The next fallback is handled by each sidebar in this collection.', 'Admin: Sidebars', 'entex');
		}
		
		if(in_array($id, $unique)){
			/* translators: */
			$description = sprintf(_x('This area only responds to single %1$s pages, like %2$s(%3$s).', 'Admin: Sidebars', 'entex'), $posttype[$id], $current, $argument);
		}
		if(isset($tax[$id])){
			/* translators: */
			$description = sprintf(_x('This area only responds to archive %1$s conditional, like %2$s(%3$s).', 'Admin: Sidebars', 'entex'), "is_tax(". $tax[$id] .")", $current, $argument);
		}
		if(isset($parchive[$id])){
			/* translators: */
			$description = sprintf(_x('This area only responds to %1$s conditional, like %2$s(%3$s).', 'Admin: Sidebars', 'entex'), "is_post_type_archive(". $parchive[$id] .")", $current, $argument);
		}
		
		$note = '';
		if(isset($fallback[$id])){
			if($fallback[$id] == 'Default sidebar'){
				$note = 'The only fallback is the Default sidebar.';
			} else {
				$argument = '';
				$next = $sidebars[$fallback[$id]];
				if($fallback[$id] == 'is_singular'){
					if(isset($posttype[$id])) $argument = $posttype[$id];
				}
				/* we dont need the argument for now */
				$argument = '';
				/* translators: */
				$note = sprintf(_x('The next fallback is the %1$s sidebar with conditional %2$s(%3$s).', 'Admin: Sidebars', 'entex'), $next, $fallback[$id], $argument);
			}
			if(isset($intercepted[$id]) && !empty($intersepts[$intercepted[$id]])){
				$by = str_replace('all_', _x('All', 'Sidebars: LIKE All [ is_page ] sidebars', 'entex') .' ', $intercepted[$id]);
				$by = str_replace('attachment', 'media', $by);
				/* translators: */
				$note .= ' '. sprintf(_x('Note, the fallback is intercepted by %1$s sidebar.', 'Admin: Sidebars', 'entex'), $by);
			}
		}

		if($note) $note = ' '.$note;
		$add = ' '._x('Add widgets here to activate this sidebar.', 'Admin: Sidebars', 'entex');
		$description = $description.$note.$add;

		register_sidebar( 
			array(
				'name' => esc_html($name),
				'id' => $id,
				'description' => esc_html($description),
				'before_widget' => '<section id="%1$s" class="widget %2$s">',
				'after_widget' => '</section>',
				'before_title' => '<h4>',
				'after_title' => '</h4>',
			) 
		);
	}
}
endif; // END Pluggable
add_action('init', 'entex_theme_sidebars', 99);


// -- END FILE -- //