<?php if(!defined('ABSPATH')) die();

// Updated 2021 12 02
// NOTE: We might remove custom image sizes
// in favor for object-fit CSS property
// WE can simulate any thumbnail size and presented dimensions with CSS values
// Therefore, we syncronize the post-thumbnail with the built in 'medium_large' size
// Then WordPress will only create ONE image instead of two



/* -------------------- */
// EMBED SETUP

/* Not needed in Gutenberg as 'add' theme supports responsive embeds */
/* The responsive CSS is then rendered on the fly by the core */
/* Remember, all oembeds are stored in cache when they are created in the editor */
/* All embeds created with TinyMCE will use the markup below */
/* No matter if you switched to Gutenberg */

function entex_theme_embed_wrapper($html, $data, $url){
	
	if(!defined('ENTEX_CLASSIC_EDITOR_INTERFACE')) return $html;
	if(!is_object($data) || empty($data->type)) return $html;
	if($data->type == 'video'){
		$ar = ($data->width / $data->height);
		$ar_mod = ( abs($ar-(4/3)) < abs($ar-(16/9)) ? 'ua-embed-4-x-3' : 'ua-embed-16-x-9');
		$html = preg_replace('/(width|height)="\d*"\s/', "", $html);
		$html = '<p class="ua-has-video ua-embed-responsive '.$ar_mod.'">'.$html.'</p>';
	}

	return $html;
}
add_filter('oembed_dataparse', 'entex_theme_embed_wrapper', 10, 3);






/* -------------------- */
// PLAYLIST SETUP - Here meanwhile

function entex_theme_wp_playlist_prepare_video(){
	
	/* remove curls from title */
	add_filter('gettext_with_context', function($translated, $text, $context, $domain){
		if($context = 'playlist item title' && $text == '&#8220;%s&#8221;') $translated = "%s";
		return $translated;
	}, 10, 4);
	
	/* prevent autoplay next */
	$add = "
jQuery(function ($) {
    $('.mejs-mediaelement video').on('ended', function (e) {
        e.preventDefault();
        $(this)[0].player.pause();
    });
	$('.mejs-mediaelement audio').on('ended', function (e) {
        e.preventDefault();
        $(this)[0].player.pause();
    });
});
	";
	
	wp_register_script('entex-theme-playlist', '', array('jquery'), '', true);
	wp_enqueue_script('entex-theme-playlist');
	wp_add_inline_script('entex-theme-playlist', $add);

	add_filter('do_shortcode_tag', function($output, $tag, $attr, $m){
		if($tag == 'playlist'){
			remove_filter('wp_get_attachment_link', 'wp_get_attachment_link_playlist_video', 30, 6);
		}
		return $output;
	}, 30, 4);
	
}
add_action('wp_playlist_scripts', 'entex_theme_wp_playlist_prepare_video');





/* -------------------- */
// IMAGES

if(!function_exists('entex_theme_setup_images')):
/* Create your own function to override in a child theme. */

function entex_theme_setup_images() {
	
	add_theme_support('custom-logo', array(
		'height'      => 300,
		'width'       => 300,
		'flex-width' => true,
		'flex-height' => true,
	));

	add_theme_support('post-thumbnails');
	entex_theme_setup_image_sizes();

	add_action('after_switch_theme', 'entex_theme_flush_images');

	// Add sizes to the 3.5 insert dialog
    add_filter('image_size_names_choose', 'entex_theme_image_size_names_choose');
	
	// Remove filters thats bang and destroys pure CSS solutions
	add_filter('img_caption_shortcode_width', '__return_false');
	add_filter('wp_calculate_image_srcset_meta', '__return_null');
	remove_filter('the_content', 'wp_make_content_images_responsive');

}
endif; // END Pluggable
add_action('after_setup_theme', 'entex_theme_setup_images');



/* Add sizes to the 3.5 insert dialog and Gutenberg */
function entex_theme_image_size_names_choose($sizes){
	
	/* Only WordPress public sizes are available as default */
	/* Lets add 'medium_large' as option as well */
	/* And rename for the user to be easy to understand as 'Normal' */
	
	global $_wp_additional_image_sizes;
	if(in_array('medium_large', get_intermediate_image_sizes())){
		$sizes['medium_large'] = esc_html_x('Normal', 'Admin', 'entex');
	}
	
    if(empty($_wp_additional_image_sizes)) return $sizes;
	
	/* Lets add custom added sizes, if any exists */
    foreach($_wp_additional_image_sizes as $id => $data){
        if(!isset($sizes[$id])) $sizes[$id] = ucfirst(str_replace('-', ' ', $id));
    }
	/* filter out post-thumbnail as we wanna use 'medium_large' as much as possible */
	if(isset($sizes['post-thumbnail'])) unset($sizes['post-thumbnail']);
	
	/* filter out hidden sizes as they exists in the array above */
	/* Entex theme doesnt need those 'responsive' images anyway */
	if(isset($sizes['1536x1536'])) unset($sizes['1536x1536']);
	if(isset($sizes['2048x2048'])) unset($sizes['2048x2048']);
	
	/* this thme dont use woocommerce images */
	if(isset($sizes['woocommerce_thumbnail'])) unset($sizes['woocommerce_thumbnail']);
	if(isset($sizes['woocommerce_single'])) unset($sizes['woocommerce_single']);
	if(isset($sizes['woocommerce_gallery_thumbnail'])) unset($sizes['woocommerce_gallery_thumbnail']);

	return $sizes;
}



/* -------------------- */
// IMAGE SIZE SETTINGS

if(!function_exists('entex_theme_setup_image_sizes')):
/* Create your own function to override in a child theme. */
function entex_theme_setup_image_sizes(){
	
	set_post_thumbnail_size(768, 0, true);
	add_image_size('entex-photo', 360, 450, true); // 4:5 

}
endif; // END Pluggable



function entex_theme_flush_images_message($message){
	if($message) $message .= ' ';
	$message .= esc_html_x('All image sizes has been set for Entex theme.', 'Admin', 'entex');
	return $message;
}

function entex_theme_flush_images_on_save_peramlinks(){
	entex_theme_flush_images();
}
add_action('entex_admin_save_options-permalink.php', 'entex_theme_flush_images_on_save_peramlinks');


if(!function_exists('entex_theme_flush_images')):
/* Create your own function to override in a child theme. */

function entex_theme_flush_images(){
	
	add_filter('entex_admin_save_message', 'entex_theme_flush_images_message', 10, 1);

	$in = 'post-thumbnail';
	update_option($in.'_size_w', 768);
	update_option($in.'_size_h', 0);
	update_option($in.'_crop', 1);
	
	$in = 'entex-photo';
	update_option($in.'_size_w', 360);
	update_option($in.'_size_h', 450);
	update_option($in.'_crop', 1);
	
	$in = 'thumbnail';
	update_option($in.'_size_w', 150);
	update_option($in.'_size_h', 150);
	update_option($in.'_crop', 1);
	
	$in = 'medium';
	update_option($in.'_size_w', 300);
	update_option($in.'_size_h', 300);
	update_option($in.'_crop', 1);

	$in = 'large';
	update_option($in.'_size_w', 1600);
	update_option($in.'_size_h', 0);
	update_option($in.'_crop', 0);
	
}
endif; // END Pluggable

if(defined('ENTEX_FLUSH_IMAGES')){
	add_action('after_setup_theme', 'entex_theme_flush_images');
}

/* ******************** */

// -- END FILE -- //