<?php if(!defined('ABSPATH')) die();
/**
 * Entex Theme Gutenberg functions and definitions
 * This file is never loaded if classic editor interface is in use
 * Most of WordPress backend doesnt use Gutenberg
 * Thats why entex_is_gutenberg() is checking if we are on a Gutenberg pageload
 *
 * Version: 2.21116
 *
 * Documentation: http://entex.info
 * Author: Jonas Lundman
 *
**/



/* -------------------- */
// LOAD ADMIN BACKEND ASSETS

function entex_admin_gutenberg_enqueue_style(){
	
	/* use default editor style, no Theme interactions */
	if(defined('ENTEX_GUTENBERG_THEME_DISABLE')) return;

	/* pure css */
	if(entex_is_gutenberg() && defined('ENTEX_GUTENBERG_CLEANUP')){
		$version = filemtime(get_template_directory().'/assets/css/entex-theme-admin-backend-gutenberg.css');
		wp_enqueue_style('entex-theme-admin-backend-gutenberg', get_template_directory_uri() .'/assets/css/entex-theme-admin-backend-gutenberg.css', array(), $version);
	}
}
add_action('admin_enqueue_scripts', 'entex_admin_gutenberg_enqueue_style', 30);


/* -------------------- */
// GUTENBERG WRAPPER
/* global backend only on Gutenberg pageload interface */ 

function entex_admin_gutenberg_styles() {

	/* use default editor style, no Theme interactions */
	if(defined('ENTEX_GUTENBERG_THEME_DISABLE')) return;
	
	if(!entex_is_gutenberg()) return;
	
	$add = '';
	$text_group_begins = esc_html_x('Group begins', 'Admin', 'entex');
	
	/* tmp */
	$add .= '.is-style-ua-border img { display: block; border-width: 1px 1px 1px 1px; border-style: solid; border-color: inherit; border-radius: 0px; }';
	$add .= '.wp-block-cover.is-style-ua-border { border-width: 1px 1px 1px 1px; border-style: solid; border-color: inherit; border-radius: 0px; }';
	$add .= '.ua-layer-text:not(#id) .wp-block-cover__gradient-background { z-index: 2; } ';
	
	/* classic */
	$add .= '.ua-content .mce-panel button { margin-top: 0px; }';
	
	if(defined('ENTEX_THEME_EDIT_CONTENT_WIDTH')) $width = ENTEX_THEME_EDIT_CONTENT_WIDTH;
		else $width = 640;
	
	/* critical */
	$add .= 'html { font-size: 16px !important; } ';
	$add .= 'html > body .wp-block { max-width: '. $width .'px } ';
	$add .= 'html .editor-styles-wrapper { line-height: 1.375; } ';
	$add .= 'html > body .wp-block.is-reusable { max-width: none; } ';
	
	/* critical extended */
	/* in front-end ua-w-content is 800px */
	/* ua-w-full is subtracting 1 rem as edges, so full ua-w-edge can be visible in the editor */
	$add .= 'html > body .wp-block.ua-w-full { max-width: calc(100% - 2rem); } ';
	$add .= 'html > body .wp-block.ua-w-full .wp-block:not(.ua-w-wide) { max-width: 100%; } ';
	$add .= 'html > body .wp-block.ua-w-full .wp-block.ua-w-content { max-width: '. $width .'px } ';
	
	/* in front-end ua-w-wide is 75rem (.ua-set-sitewidth) */
	$add .= 'html > body .wp-block.ua-w-wide { max-width: 75%; } ';
	$add .= 'html > body .wp-block.ua-w-wide .wp-block { max-width: 100%; } ';
	$add .= 'html > body .wp-block.ua-w-wide .wp-block.ua-w-content { max-width: '. $width .'px } ';
	
	/* ua-w-edge is scaling the media horizontally */
	$add .= '.ua-w-edge img { width: calc(100% + 2rem) !important; margin-left: -1rem !important; max-width: none !important; display: block !important; } ';
	$add .= '.ua-w-edge, .ua-w-edge * { overflow: visible !important; } ';
	$add .= '.ua-layer-caption > :first-child::after { width: calc(100% + 2rem) !important; margin-left: -1rem !important; } ';
	
	$add .= '.ua-w-full.ua-layer-caption figcaption, .ua-w-full .ua-layer-caption figcaption  { justify-self: center; } ';
	$add .= '.ua-w-wide.ua-layer-caption figcaption, .ua-w-wide .ua-layer-caption figcaption  { justify-self: center; } ';
	
	/*  */
	$add .= '.ua-margin-false:not(#id) { margin-top: 0px; margin-bottom: 0px; } ';
	
	/* Mark the group block */
	$add .= '.wp-block-group:before { border-width: 5px 0px 0px 0px; border-style: dotted; content: "'. $text_group_begins .'"; display: block; padding: 0.5em; color: #888; background-color: #f5f5f5; text-align: center; } ';
	$add .= '.wp-block-group:not([class*=ua-set-b]) { margin-top: 3em !important; margin-bottom: 3em !important; padding-bottom: 1em !important; border-width: 0px 0px 5px 0px !important; border-style: dotted !important; border-color: #f0f0f0 !important; } ';
	
	/* located content */
	$add .= 'html .is-root-container > [class*=-location-] { background-color: rgba(0,255,0,0.05); border: 5px dashed #dbdbdb; } ';

	/* IMAGE width & height manual fields */
	/* this is not responsive, disable fixed images */
	if(defined('ENTEX_GUTENBERG_CLEANUP')){
		//$add .= '.block-editor-image-size-control { display: none; opacity: 0.35; } ';
		/* make available click on label */
		$add .= '.block-editor-image-size-control-show .block-editor-image-size-control, .wp-block-image .components-resizable-box__container { display: block; } ';
	}
	
	/* Resize handle wrapper */
	/* let user use the menu only */
	if(defined('ENTEX_GUTENBERG_CLEANUP')){
		$add .= '.editor-styles-wrapper .wp-block-image .components-resizable-box__container > div { display: none !important; } ';
	}
	
	/* 5.9 Typo panel */
	/* Do not let user clutter with font sizes */
	/* Only design or layout objects are allowed, like the cover block */
	if(defined('ENTEX_GUTENBERG_CLEANUP')){
		/* vill be visible by javascript */
		/* on wp-block-cover */
		$add .= '.typography-block-support-panel { display: none !important; } ';
		$add .= '.typography-block-support-panel-show .typography-block-support-panel { display: block !important; } ';
	}
	
	/* development */
	
	$add .= '.ua-init:not(#whatever) .size-medium_large img { width: 100%; display: block; } ';
	$add .= '.ua-init:not(#whatever) .ua-filter-blur img { filter: blur(5px); } .ua-init:not(#whatever) .ua-filter-blur { overflow: hidden; } ';
	
	
	wp_register_style('entex-gutenberg-style', false);
	wp_enqueue_style('entex-gutenberg-style');
	wp_add_inline_style('entex-gutenberg-style', $add);
}
add_action('admin_head', 'entex_admin_gutenberg_styles');





/* -------------------- */
// MIMIC TEMPLATE BODY CLASS
function entex_theme_filter_gutenberg_admin_body_class($classnames){
	
	/* use default editor style, no Theme interactions */
	if(defined('ENTEX_GUTENBERG_THEME_DISABLE')) return $classnames;
	
	if(!entex_is_gutenberg()) return $classnames;
	
	$classes[] = 'entex-theme';
	$classes[] = 'wp-is-'.entex_fn_lowercase(get_bloginfo('language'));
	$classes[] = 'wp-is-singular';

	if(current_user_can('manage_options')) $classes[] = 'wp-user-is-administrator';
	if(current_user_can('manage_categories')) $classes[] = 'wp-user-is-editor';
	
	/* initial moved into javascript since 5.9 */
	
	$classnames .= ' '. implode(' ', $classes);
	return $classnames;
}
add_filter('admin_body_class', 'entex_theme_filter_gutenberg_admin_body_class');






/* -------------------- */
// GUTENBERG FILTER FRONT-END BLOCKS
/* font-end only */
/* In sync with entex-template-functions.php (entex_theme_fn_get_preamble()) */

function entex_theme_render_block_core($block_content, $block){
	
	if(is_admin()) return $block_content;
	if(apply_filters('entex_theme_render_block_default', false)) return $block_content;
	
	
	/* do not accept left overs or empty paragraphs from the editor */
	if((!$block['blockName'] && !$block['innerHTML']) || trim($block['innerHTML']) == '<p></p>') return '';

	if($block['blockName'] == 'core/preformatted') return $block_content;
	if($block['blockName'] == 'core/archives'){
		$block_content = '<div class="ua-set-nav-list">'. $block_content .'</div>';
	}
	if($block['blockName'] == 'core/latest-comments'){
		$block_content = '<div class="ua-set-nav-list ua-wrapper">'. $block_content .'</div>';
	}
	if($block['blockName'] == 'core/latest-posts'){
		$block_content = '<div class="ua-set-nav-list">'. $block_content .'</div>';
	}
	if($block['blockName'] == 'core/rss'){
		$block_content = '<div class="ua-set-nav-list">'. $block_content .'</div>';
	}
	if($block['blockName'] == 'core/calendar'){
		$block_content = str_replace('<div class="wp-block-calendar', '<div class="wp-block-calendar widget_calendar', $block_content);
	}
	if($block['blockName'] == 'core/group'){
		$block_content = str_replace('wp-block-group__inner-container', 'wp-block-group__inner-container ua-content', $block_content);
		if(mb_substr(trim($block_content), 0, 4) != '<div'){
			$block_content = str_replace('class="wp-block-group', 'class="wp-block-group ua-content', $block_content);
		}
	}
	
	if($block['blockName'] == 'core/cover'){
		$block_content = str_replace('wp-block-cover__inner-container', 'wp-block-cover__inner-container ua-content', $block_content);
		if(mb_substr(trim($block_content), 0, 4) != '<div'){
			$block_content = str_replace('class="wp-block-cover', 'class="wp-block-cover ua-content', $block_content);
		}
	}
	
	if($block['blockName'] == 'core/image'){

		/* this might be added by other plugins as well */
		if(isset($block['attrs']['linkDestination']) && $block['attrs']['linkDestination']){
			if(strpos($block_content, 'wp-block-image wp-has-link-') === FALSE){
				$block_content = str_replace('class="wp-block-image', 'class="wp-block-image wp-has-link-'.$block['attrs']['linkDestination'], $block_content);
			}
		}
	
		if(strpos($block_content, 'aligncenter') !== FALSE){
			if(strpos($block_content, '<a') === FALSE && strpos($block_content, '/></div><fig') === FALSE){
				$block_content = str_replace('<img', '<div><img', $block_content);
				$block_content = str_replace('/><fig', '/></div><fig', $block_content);
			}
		}
		if(strpos($block_content, 'alignleft') !== FALSE){
			$block_content = str_replace('<div class="wp-block-image', '<div data-align="left" class="wp-block-image', $block_content);
		}
		if(strpos($block_content, 'alignright') !== FALSE){
			$block_content = str_replace('<div class="wp-block-image', '<div data-align="right" class="wp-block-image', $block_content);
		}
	}
	
	if($block['blockName'] == 'core/gallery'){
		if(strpos($block_content, 'ua-set-equal') !== FALSE){
			if(strpos($block_content, '<a') === FALSE && strpos($block_content, '/></div><fig') === FALSE){
				$block_content = str_replace('<img', '<div><img', $block_content);
				$block_content = str_replace('/><fig', '/></div><fig', $block_content);
			}
		}
	}
	
	if($block['blockName'] == 'core/columns'){
		/* re-added replacement 2023 since is-style-flex arrived */
		if(strpos($block_content, 'is-not-stacked-on-mobile') !== FALSE){
			$block_content = str_replace('wp-block-columns', 'ua-block-columns', $block_content);
		} else {
			/* default by editor */
			$block_content = str_replace('wp-block-columns', 'ua-block-columns ua-block-wrap', $block_content);
		}
		/*
		$tmp = str_replace('wp-block-columns', '', $block_content);
		if(count(explode('wp-block-column', $tmp)) > 3){
			$block_content = str_replace('wp-block-columns', 'wp-block-columns ua-block-wrap', $block_content);
		}
		*/
		/* replace the children */
		$block_content = str_replace('wp-block-column', 'ua-block-column ua-content', $block_content);
	}
	
	/* dep 5.9 */
	$block_content = str_replace('is-style-ua-layer-caption', 'ua-layer-caption', $block_content);
	$block_content = str_replace('is-style-ua-layer-heading', 'ua-layer-heading', $block_content);
	
	$block_content = str_replace('is-style-ua-border', 'ua-border', $block_content);
	$block_content = str_replace('is-style-ua-clear', 'ua-clear', $block_content);
	$block_content = str_replace('has-small-font-size', 'ua-not-main', $block_content);
	
	/* CIRCUT on parsing in entex-template-selector.php MAYBE: we there remove the filter on current function */
	if(isset($GLOBALS['ENTEX-SIDEBAR-BLOCKS-PARSING']) && $GLOBALS['ENTEX-SIDEBAR-BLOCKS-PARSING']) return $block_content;
	
	static $found_first_preamble = false;
	if($block['blockName'] == 'core/paragraph' && !$found_first_preamble){
		if(strpos($block_content, 'is-style-ua-preamble') !== FALSE){
			$post_id = get_the_ID();
			/* filter */
			if(!apply_filters('entex_theme_render_block_preamble_'. $post_id, true)) {
				$block_content = '';
				/* prevent multiple preamble(s) to be ignored */
				$found_first_preamble = true;
			}
		}
	}
	
	if($block['blockName'] == 'core/block' && isset($block['attrs']['ref']) && $block['attrs']['ref']){
		if(isset($GLOBALS['ENTEX-SIDEBAR-BLOCKS']['ref'][$block['attrs']['ref']])) $block_content = '';
	}
	
	if(isset($block['attrs']['className']) && $block['attrs']['className']){
		if(isset($GLOBALS['ENTEX-SIDEBAR-BLOCKS-REMOVE'][$block['attrs']['className']])){
			$block_content = '';
		} else if(!is_singular()){
			$classnames = $block['attrs']['className'];
			$locations = array_keys(array_merge(apply_filters('entex_theme_locations', array()), array('entex-location-sidebar' => 'Current sidebar')));
			foreach($locations as $match){
				if(strpos($classnames, $match) !== FALSE){
					$block_content = '';
				}
			}
		}
	}

	return $block_content;
}
add_filter('render_block', 'entex_theme_render_block_core', 10, 2);



/* front end stylesheet */
/* and merge function with user customizer data - modified here for the editor screen */
/* we cant use 'enqueue_block_editor_assets' */
/* They filter and parse the stylesheets and breaks everything */
/* we use the admin head hook instead an enjoy the freedom! */
function entex_theme_gutenberg_backend_css(){
	
	/* use default editor style, no Theme interactions */
	if(defined('ENTEX_GUTENBERG_THEME_DISABLE')) return;
	
	if(!entex_is_gutenberg()) return;
	
	/* modification of the front-end theme stylesheet */
	/* everything is included, except the typographic part - modified without <body> element */
	$version = filemtime(get_template_directory().'/assets/ua-css/entex-gutenberg-backend.min.css');
	wp_register_style('entex-theme-gutenberg-backend', get_template_directory_uri() .'/assets/ua-css/entex-gutenberg-backend.min.css', array(), $version);
	wp_enqueue_style('entex-theme-gutenberg-backend');
	
	$G_CSS = get_theme_mod('entex_gutenberg_styles', array());
	if(!empty($G_CSS)){
		foreach($G_CSS as $_TARGET => $styles){
			foreach($styles as $style){
				if($style && trim($style)){
					$css = '';
					
					/* NOTE: THIS IS NOT UPDATED 5.9 YET */
					
					if($_TARGET == 'html'){
						
						$style = str_replace('body, .ua-nav li li, figcaption, html > body .ua-not-main {', 'div.ua-root[class*=ua-root], div.ua-root[class*=ua-root] .ua-nav li li, div.ua-root[class*=ua-root] figcaption, html > body div.ua-root[class*=ua-root] .ua-not-main {', $style);
						$style = str_replace('body, .ua-nav li li {', 'div.ua-root[class*=ua-root], div.ua-root[class*=ua-root] .ua-nav li li {', $style);
						$style = str_replace('.ua-main, .ua-main .ua-nav li li {', 'div.ua-root[class*=ua-root] .ua-main, div.ua-root[class*=ua-root] .ua-main .ua-nav li li {', $style);
						$style = str_replace('.ua-init th, .ua-init strong, p.ua-preamble:not(:only-child), .ua-comment-list div[class*=-meta] [rel=nofollow], .ua-comment-list p.moderate', '.ua-root[class*=ua-root] th, .ua-root[class*=ua-root] strong, .ua-root[class*=ua-root] p strong', $style);
						$style = str_replace('html {', 'div.editor-styles-wrapper[class*=editor-styles-wrapper]:not(.whatever) {', $style);
						$style = str_replace('p {', '.ua-root[class*=ua-root] p {', $style);
						
						$css = $style;
					}
					
					if($_TARGET == 'h1'){
						$style = str_replace('h1', '#editor .wp-block.editor-post-title', $style);
						$css = $style;
					}
					
					if($_TARGET == 'h1_span'){
						$style = str_replace('#main-header h1 span', '#editor .wp-block.editor-post-title textarea', $style);
						$css = $style;
					}
				
					if($_TARGET == 'h1_em'){
						$style = str_replace('h1 em', '#editor .wp-block.editor-post-title .extended', $style);
						$css = $style;
					}
					
					if($_TARGET == 'h2'){
						$style = str_replace('.entex-theme h2', '.entex-theme div.ua-root h2', $style);
						$style = str_replace('html > body.entex-theme .ua-not-main h2', 'html > body.entex-theme div.ua-root .ua-not-main h2', $style);
						$style = str_replace('.entex-theme .ua-main h2', '.entex-theme div.ua-root .ua-main h2', $style);
						$css = $style;
					}
					
					if($_TARGET == 'h2_span'){
						$style = str_replace('.entex-theme .entry-heading', '.entex-theme div.ua-root .entry-heading', $style);
						$style = str_replace('html > body.entex-theme .ua-not-main .entry-heading', 'html > body.entex-theme div.ua-root .ua-not-main .entry-heading', $style);
						$style = str_replace('.entex-theme .ua-main .entry-heading', '.entex-theme div.ua-root .ua-main .entry-heading', $style);
						$css = $style;
					}
					
					if($_TARGET == 'h3'){
						$style = str_replace('.entex-theme h3', '.entex-theme div.ua-root h3', $style);
						$style = str_replace('html > body.entex-theme .ua-not-main h3', 'html > body.entex-theme div.ua-root .ua-not-main h3', $style);
						$style = str_replace('.entex-theme .ua-main h3', '.entex-theme div.ua-root .ua-main h3', $style);
						$css = $style;
					}
					
					if($_TARGET == 'h4'){
						$style = str_replace('.entex-theme h4', '.entex-theme div.ua-root h4', $style);
						$css = $style;
					}
					
					if($_TARGET == 'preamble'){
						$style = str_replace('.entex-theme p.is-style-ua-preamble', '.entex-theme div.ua-root p.is-style-ua-preamble', $style);
						$style = str_replace('html > body.entex-theme .ua-not-main p.is-style-ua-preamble', 'html > body.entex-theme div.ua-root .ua-not-main p.is-style-ua-preamble', $style);
						$style = str_replace('.entex-theme .ua-main p.is-style-ua-preamble', '.entex-theme div.ua-root .ua-main p.is-style-ua-preamble', $style);
						$css = $style;
					}

					if($css) wp_add_inline_style('entex-theme-gutenberg-backend', $css);
				}
			}
		}
	}
	
	$add = '';
	$add .= 'html .acf-block-panel .acf-label { display: none; } ';
	$add .= 'html .acf-block-panel p.description { display: none; } ';
	$add .= 'html .block-editor .edit-post-sidebar .acf-fields > .acf-field-true-false + .acf-field-true-false { margin-top: -1em; } ';
	$add .= '.ua-content .acf-block-fields input { margin-top: 0px; } ';
	
	$add .= '.wp-block-freeform.block-library-rich-text__tinymce { margin-top: 20px !important;} ';
	$add .= '.wp-block-freeform.block-library-rich-text__tinymce, .wp-block-freeform.block-library-rich-text__tinymce li, .wp-block-freeform.block-library-rich-text__tinymce p { line-height: 1.4375; font-size: 1rem; } ';
	
	/* added in 5.9 */
	$add .= '.ua-root p { line-height: inherit; } ';
	
	wp_add_inline_style('entex-theme-gutenberg-backend', $add);
	
}
add_action('admin_footer', 'entex_theme_gutenberg_backend_css', 9999);




function entex_theme_gutenberg_editor_scripts(){ 
	
	/* use default editor style, no Theme interactions */
	if(defined('ENTEX_GUTENBERG_THEME_DISABLE')) return;


	$fonts_url = entex_theme_fonts_url();
	if($fonts_url) wp_enqueue_style('entex-theme-fonts', $fonts_url, array(), null);
	
	$fonts_url = entex_theme_customize_fonts_url();
	if($fonts_url) wp_enqueue_style('entex-theme-fonts-customizer', $fonts_url, array(), null);
	
	
	/* customizer settings */
	$set_initial_styles = '';
	$initial = entex_theme_load_initial_styles();
	if($initial && !defined('ENTEX_THEME_DISABLE_INITIAL_TYPO')) $set_initial_styles = 'wp-is-initial';
	
	$version = filemtime(get_template_directory().'/assets/js/entex-theme-gutenberg.js');

	$handle = 'entex-theme-gutenberg';
	wp_enqueue_script($handle, get_template_directory_uri() .'/assets/js/entex-theme-gutenberg.js', array('jquery', 'wp-blocks', 'wp-element', 'wp-components', 'wp-i18n'), $version, true);
	
	/* pass Theme locations */
	$A = array_merge(array('entex-location-sidebar' => esc_html_x('Current sidebar', 'Template locations', 'entex')), apply_filters('entex_theme_locations', array()));
	if(entex_is_gutenberg() && isset($A['entex-location-shortcode'])) unset($A['entex-location-shortcode']);
	$locations = json_encode($A);
	
	/* pass Theme placement for location Current sidebar */
	$A = apply_filters('entex_theme_current_sidebar_position', array());
	$positions = json_encode($A);
	
	/* pass Theme classnames */
	$B['core/all'] 		= apply_filters('entex_editor_core/all', array());
	$B['core/paragraph'] = apply_filters('entex_editor_core/paragraph', array());
	$B['core/heading'] = apply_filters('entex_editor_core/heading', array());
	$B['core/image'] = apply_filters('entex_editor_core/image', array());
	$B['core/table'] = apply_filters('entex_editor_core/table', array());
	$B['core/cover'] = apply_filters('entex_editor_core/cover', array());
	$B['core/group'] = apply_filters('entex_editor_core/group', array());
	$B['core/columns'] = apply_filters('entex_editor_core/columns', array());
	$B['core/media-text'] = apply_filters('entex_editor_core/media-text', array());
	$B['core/gallery'] = apply_filters('entex_editor_core/gallery', array());
	$B['core/block'] = apply_filters('entex_editor_core/block', array());

	/* pass Valid classnames for specific DOM element */
	$B['is'] = apply_filters('entex_editor_validate', array());
	$data = json_encode($B);
	
	$def_open = '';
	$def_cleanup = '';
	
	if(defined('ENTEX_GUTENBERG_CLEANUP')){
		$def_open = '1';
		$def_cleanup = '1';
	}
	
	/* filter */
	// NOTE: json, transported bool (0) will be true ('0')
	// Pass empty string to transport 0 as bool
	$def_open = apply_filters('entex_theme_gutenberg_editor_def_open', $def_open);
	$def_cleanup = apply_filters('entex_theme_gutenberg_editor_def_cleanup', $def_cleanup);

	wp_localize_script($handle, 'ENTEX_THEME_GUTENBERG_BACKEND', array(
		'txt_1' => esc_html_x('Additional CSS', 'Gutenberg metabox', 'entex'),
		'txt_2' => esc_html_x('Theme Locations', 'Gutenberg metabox', 'entex'),
		'txt_3' => esc_html_x('Remove current widgets', 'Gutenberg metabox', 'entex'),
		'txt_4' => esc_html_x('Sections cant handle more then 4 columns. Create groups or use another location.', 'Gutenberg metabox', 'entex'),
		'txt_5' => esc_html_x('Not supported by Entex Theme', 'Gutenberg metabox', 'entex'),
		'def_open' => $def_open,
		'def_cleanup' => $def_cleanup,
		'set_initial_styles' => $set_initial_styles,
		'data' => $data,
		'locations' => $locations,
		'positions' => $positions
	));
}
add_action('enqueue_block_editor_assets', 'entex_theme_gutenberg_editor_scripts');


function entex_editor_add_core_all($obj){
	$obj['ua-page-break'] 			= 	esc_html_x('Force pagebreak on print', 'Gutenberg metabox', 'entex');
	$obj['ua-w-full'] 				= 	esc_html_x('Full width', 'Gutenberg metabox', 'entex');
	$obj['ua-w-wide'] 				= 	esc_html_x('Site width', 'Gutenberg metabox', 'entex');
	$obj['ua-w-content'] 			= 	esc_html_x('Content width', 'Gutenberg metabox', 'entex');
	$obj['ua-w-edge'] 				= 	esc_html_x('Cover edges', 'Gutenberg metabox', 'entex');
	$obj['ua-w-cover'] 				= 	esc_html_x('Cover sides', 'Gutenberg metabox', 'entex');
	$obj['ua-margin-false'] 		= 	esc_html_x('Remove margins', 'Gutenberg metabox', 'entex');
	$obj['ua-not-main'] 			= 	esc_html_x('Mobile font size', 'Gutenberg metabox', 'entex');
	$obj['ua-filter-blur'] 			= 	esc_html_x('Blur image media', 'Gutenberg metabox', 'entex');
	return $obj;
}
add_filter('entex_editor_core/all', 'entex_editor_add_core_all', 10, 1);


function entex_editor_add_core_paragraph($obj){
	$obj['is-style-ua-preamble'] 	= 	esc_html_x('Preamble', 'Gutenberg metabox', 'entex');
	$obj['is-style-ua-indent'] 		= 	esc_html_x('Indent', 'Gutenberg metabox', 'entex');
	$obj['is-style-ua-hyphenate'] 	= 	esc_html_x('Hyphenate', 'Gutenberg metabox', 'entex');
	$obj['is-style-ua-box'] 		= 	esc_html_x('Content in box', 'Gutenberg metabox', 'entex');
	$obj['is-style-ua-box-border'] 	= 	esc_html_x('Border on box', 'Gutenberg metabox', 'entex');
	$obj['ua-text-shadow-light'] 	= 	esc_html_x('Text shadow light', 'Gutenberg metabox', 'entex');
	$obj['ua-text-shadow-dark'] 	= 	esc_html_x('Text shadow dark', 'Gutenberg metabox', 'entex');
	$obj['ua-cover-column'] 		= 	esc_html_x('Cover column', 'Gutenberg metabox', 'entex');
	return $obj;
}
add_filter('entex_editor_core/paragraph', 'entex_editor_add_core_paragraph', 10, 1);

function entex_editor_add_core_heading($obj){
	$obj['is-style-ua-box'] 		= 	esc_html_x('Content in box', 'Gutenberg metabox', 'entex');
	$obj['is-style-ua-box-border'] 	= 	esc_html_x('Border on box', 'Gutenberg metabox', 'entex');
	$obj['ua-text-shadow-light'] 	= 	esc_html_x('Text shadow light', 'Gutenberg metabox', 'entex');
	$obj['ua-text-shadow-dark'] 	= 	esc_html_x('Text shadow dark', 'Gutenberg metabox', 'entex');
	return $obj;
}
add_filter('entex_editor_core/heading', 'entex_editor_add_core_heading', 10, 1);

function entex_editor_add_core_image($obj){
	$obj['is-style-ua-border'] 			= 	esc_html_x('Border', 'Gutenberg metabox', 'entex');
	$obj['ua-layer-caption'] 			= 	esc_html_x('Layer caption', 'Gutenberg metabox', 'entex');
	$obj['ua-layer-heading'] 			= 	esc_html_x('Layer heading', 'Gutenberg metabox', 'entex');
	$obj['ua-cover-column'] 			= 	esc_html_x('Cover column', 'Gutenberg metabox', 'entex');
	$obj['ua-follow-height'] 			= 	esc_html_x('Follow Height', 'Gutenberg metabox', 'entex');
	$obj['ua-equal'] 					= 	esc_html_x('Equal height', 'Gutenberg metabox', 'entex');
	$obj['ua-equal-portrait'] 			= 	esc_html_x('Equal height portrait', 'Gutenberg metabox', 'entex');
	$obj['ua-equal-top'] 				= 	esc_html_x('Focus image from top', 'Gutenberg metabox', 'entex');
	$obj['ua-caption-hide'] 			= 	esc_html_x('Hide caption', 'Gutenberg metabox', 'entex');
	$obj['ua-border-radius'] 			= 	esc_html_x('Rounded corners', 'Gutenberg metabox', 'entex');
	$obj['ua-circle'] 					= 	esc_html_x('Image within circle', 'Gutenberg metabox', 'entex');
	$obj['ua-set-max-50-center'] 		= 	esc_html_x('Center 50%', 'Gutenberg metabox', 'entex');
	$obj['ua-set-max-80-center'] 		= 	esc_html_x('Center 80%', 'Gutenberg metabox', 'entex');
	return $obj;
}
add_filter('entex_editor_core/image', 'entex_editor_add_core_image', 10, 1);


function entex_editor_add_core_gallery($obj){
	$obj['is-style-ua-border'] 			= 	esc_html_x('Set Borders', 'Gutenberg metabox', 'entex');
	$obj['ua-set-equal'] 				= 	esc_html_x('Set equal height', 'Gutenberg metabox', 'entex');
	$obj['ua-set-equal-portrait'] 		= 	esc_html_x('Set equal height portrait', 'Gutenberg metabox', 'entex');
	$obj['ua-set-equal-top'] 			= 	esc_html_x('Focus images from top', 'Gutenberg metabox', 'entex');
	$obj['ua-merge'] 					= 	esc_html_x('Merge images', 'Gutenberg metabox', 'entex');
	$obj['ua-caption-hide'] 			= 	esc_html_x('Hide captions', 'Gutenberg metabox', 'entex');
	return $obj;
}
add_filter('entex_editor_core/gallery', 'entex_editor_add_core_gallery', 10, 1);

function entex_editor_add_core_table($obj){
	$obj['is-style-ua-table-border'] 	= 	esc_html_x('Border', 'Gutenberg metabox', 'entex');
	$obj['is-style-ua-table-deviders'] 	= 	esc_html_x('Deviders', 'Gutenberg metabox', 'entex');
	$obj['ua-table-left'] 				= 	esc_html_x('Last cell fillout', 'Gutenberg metabox', 'entex');
	$obj['ua-td-empty'] 				= 	esc_html_x('Display empty cell', 'Gutenberg metabox', 'entex');
	$obj['ua-table-nowrap'] 			= 	esc_html_x('No linebreaks', 'Gutenberg metabox', 'entex');
	$obj['ua-table-scroll'] 			= 	esc_html_x('Scrollable horizontal', 'Gutenberg metabox', 'entex');
	return $obj;
}
add_filter('entex_editor_core/table', 'entex_editor_add_core_table', 10, 1);

function entex_editor_add_core_cover($obj){
	$obj['is-style-ua-border'] 			= 	esc_html_x('Border', 'Gutenberg metabox', 'entex');
	$obj['ua-layer-text'] 				= 	esc_html_x('Layer text', 'Gutenberg metabox', 'entex');
	$obj['ua-layer-heading'] 			= 	esc_html_x('Layer heading', 'Gutenberg metabox', 'entex');
	$obj['ua-text-shadow-light'] 		= 	esc_html_x('Text shadow light', 'Gutenberg metabox', 'entex');
	$obj['ua-text-shadow-dark'] 		= 	esc_html_x('Text shadow dark', 'Gutenberg metabox', 'entex');
	$obj['ua-cover-column'] 			= 	esc_html_x('Cover column', 'Gutenberg metabox', 'entex');
	$obj['ua-follow-height'] 			= 	esc_html_x('Follow Height', 'Gutenberg metabox', 'entex');
	return $obj;
}
add_filter('entex_editor_core/cover', 'entex_editor_add_core_cover', 10, 1);

function entex_editor_add_core_group($obj){
	$obj['ua-set-border'] 		= 	esc_html_x('Border', 'Gutenberg metabox', 'entex');
	$obj['ua-cover-column'] 	= 	esc_html_x('Cover column', 'Gutenberg metabox', 'entex');
	$obj['ua-absolute'] 		= 	esc_html_x('Position absolute', 'Gutenberg metabox', 'entex');
	$obj['ua-bottom'] 			= 	esc_html_x('Position bottom', 'Gutenberg metabox', 'entex');
	$obj['entex-fader'] 		= 	esc_html_x('Entex Fader', 'Gutenberg metabox', 'entex');
	$obj['ua-size-landscape'] 	= 	esc_html_x('Force Fader Landscape', 'Gutenberg metabox', 'entex');
	return $obj;
}
add_filter('entex_editor_core/group', 'entex_editor_add_core_group', 10, 1);

function entex_editor_add_core_block($obj){
	$obj['ua-set-border'] 		= 	esc_html_x('Border', 'Gutenberg metabox', 'entex');
	$obj['ua-cover-column'] 	= 	esc_html_x('Cover column', 'Gutenberg metabox', 'entex');
	$obj['ua-absolute'] 		= 	esc_html_x('Position absolute', 'Gutenberg metabox', 'entex');
	$obj['ua-bottom'] 			= 	esc_html_x('Position bottom', 'Gutenberg metabox', 'entex');

	return $obj;
}
add_filter('entex_editor_core/block', 'entex_editor_add_core_block', 10, 1);

function entex_editor_add_core_columns($obj){
	$obj['ua-set-border'] 		= 	esc_html_x('Border', 'Gutenberg metabox', 'entex');
	$obj['ua-column-deviders'] 	= 	esc_html_x('Deviders', 'Gutenberg metabox', 'entex');
	$obj['ua-columns-start'] 	= 	esc_html_x('Remove margins', 'Gutenberg metabox', 'entex');
	return $obj;
}
add_filter('entex_editor_core/columns', 'entex_editor_add_core_columns', 10, 1);

function entex_editor_add_core_media_text($obj){
	$obj['ua-layer-heading'] 		= 	esc_html_x('Layer heading', 'Gutenberg metabox', 'entex');
	$obj['ua-text-shadow-light'] 	= 	esc_html_x('Text shadow light', 'Gutenberg metabox', 'entex');
	$obj['ua-text-shadow-dark'] 	= 	esc_html_x('Text shadow dark', 'Gutenberg metabox', 'entex');
	$obj['ua-follow-height'] 		= 	esc_html_x('Follow Height', 'Gutenberg metabox', 'entex');
	return $obj;
}
add_filter('entex_editor_core/media-text', 'entex_editor_add_core_media_text', 10, 1);

function entex_editor_add_validate($obj){
	$obj['is-style-ua-indent'] 			= 	'p + p';
	$obj['is-style-ua-box-border'] 		= 	'.is-style-ua-box';
	$obj['ua-cover-column'] 			= 	'[class*=-location-]';
	$obj['ua-layer-caption'] 			= 	'*:not([data-align] > *)';
	$obj['ua-layer-heading'] 			= 	'.ua-layer-caption, .wp-block-cover, .wp-block-media-text';
	$obj['ua-follow-height'] 			= 	'.entex-fader > *, .entex-fader .wp-block-group__inner-container > *';
	$obj['ua-size-landscape'] 			= 	'.entex-fader';
	$obj['ua-set-equal-top'] 			= 	'.ua-set-equal';
	$obj['ua-set-equal-portrait'] 		= 	'.ua-set-equal';
	$obj['ua-equal'] 					= 	':not(.wp-block-gallery) > .wp-block-image';
	$obj['ua-equal-top'] 				= 	'.ua-equal, .wp-block-gallery.ua-set-equal  > .wp-block-image';
	$obj['ua-equal-portrait'] 			= 	'.ua-equal';
	$obj['ua-page-break']				=	'.is-root-container > .wp-block';
	$obj['ua-w-full']					=	'.is-root-container > .wp-block:not(.ua-w-wide):not(.ua-w-content), .wp-block-block > div > *';
	$obj['ua-w-wide']					=	'.is-root-container > .wp-block:not(.ua-w-full):not(.ua-w-content), .ua-w-full .wp-block:not(.ua-w-content), .wp-block-block > div > *';
	$obj['ua-w-content']				=	'.is-root-container > [class*=-section-], .ua-w-full .wp-block:not(.ua-w-wide), .ua-w-wide .wp-block';
	$obj['ua-w-edge'] 					= 	'.ua-w-full .wp-block-image';
	$obj['ua-w-cover'] 					= 	'.ua-w-full *';
	$obj['ua-circle'] 					= 	':not(.ua-layer-caption)';
	$obj['ua-set-max-50-center'] 		= 	':not(.ua-set-max-80-center)';
	$obj['ua-set-max-80-center'] 		= 	':not(.ua-set-max-50-center)';
	return $obj;
}
add_filter('entex_editor_validate', 'entex_editor_add_validate', 10, 1);


// -- END FILE -- //