<?php if(!defined('ABSPATH')) die();

// version 2.20426


/* -------------------- */
// INIT CUSTOMIZER

if(!function_exists('entex_theme_customize_init')):
/* Create your own function to override in a child theme. */

function entex_theme_customize_init(){
	add_theme_support('custom-background');
	add_theme_support('customize-selective-refresh-widgets');
	add_filter('body_class', 'entex_theme_customize_body_class');
}
endif; // END Pluggable
add_action('after_setup_theme', 'entex_theme_customize_init');


function entex_theme_customize_body_class($classes){
	if(get_background_color() || get_background_image()) $classes[] = 'custom-background';
	if(get_background_image()) $classes[] = 'custom-background-image';
	return $classes;
}

function entex_theme_customize_has_extended_titles(){
	if(in_array('entex-extended-titles/entex-extended-titles.php', apply_filters('active_plugins', get_option('active_plugins')))){ 
		return true;
	}
	return false;
}

/* ******************** */
// END INIT







/* -------------------- */
// GOOGLE FONTS OUTPUT

/* Called by functions.php enqueue setup and editor setup processes */
function entex_theme_customize_google_output(){
	
	if(is_customize_preview()) return '';
	$mods = entex_theme_customize_registered_font_controls();
	if(empty($mods)) return '';

	foreach($mods as $index => $name){
		$value = get_theme_mod($name, 0);
		if($value){
			$google[] = (array) json_decode($value);
		}
	}
	if(empty($google)) return '';

	foreach($google as $index => $arr){
		if(!$arr['font']) continue;
		$font = str_replace(' ', '+', $arr['font']);
		if($arr['subset']) $subsets[] = $arr['subset'];
		if($arr['regularweight']) $fonts[$font][] = $arr['regularweight'];
		if($arr['italicweight']) $fonts[$font][] = $arr['italicweight'];
		if($arr['boldweight']) $fonts[$font][] = $arr['boldweight'];
		if(!isset($fonts[$font])) $fonts[$font][] = '';
			else $fonts[$font] = array_unique($fonts[$font]);
	}
	if(empty($fonts)) return '';
	foreach($fonts as $font => $variants){
		if(!empty($variants)) $families[] = $font.':'.implode(',', $variants);
	}
	
	if(!isset($families)) $families = array();
	if(!isset($subsets)) $subsets = array();
	
	$fonts_url = add_query_arg(array(
		'family' => implode('|', $families),
		'subset' => implode(',', array_unique($subsets)),
	), 'https://fonts.googleapis.com/css');
	
	return $fonts_url;	
}

/* helper */
function entex_theme_customize_registered_font_controls(){
	
	$mods[] = 'entex_theme_font_control_html';
	$arr = entex_theme_customize_register_data();
	if(empty($arr)) return;
	
	foreach($arr as $master => $settings){
		if(empty($settings)) break;
		foreach($settings as $_TARGET => $data){
			$mods[] = 'entex_theme_'. $_TARGET .'_font_control';
		}
	}
	
	$mods = apply_filters('entex_theme_customize_registered_font_controls_mods', $mods);
	return $mods;
}


/* ******************** */
// END: GOOGLE FONTS OUTPUT






/* -------------------- */
// CLEANUP THEME MOD STYLES
/* But keep widget settings etc etc */


if(defined('ENTEX_THEME_DELETE_CUSTOMIZER_DATA')){
	if(current_user_can('manage_options')){
		
		$initital_message = '';
		$initital_message .= _x('Note: Definition ENTEX_THEME_DELETE_CUSTOMIZER_DATA is active.', 'customizer', 'entex') .' ';
		$initital_message .= _x('Please paste the <code>?reset_theme_mods</code> manually in the address bar and hit enter.', 'customizer', 'entex') .' ';
		if(!defined('ENTEX_THEME_PRESERVE_CUSTOMIZER_WIDGET_MENUES')) $initital_message .= _x('Define ENTEX_THEME_PRESERVE_CUSTOMIZER_WIDGET_MENUES if you want to keep your widget and menu settings.', 'customizer', 'entex');
		
		if(isset($_GET['reset_theme_mods'])){
			$pid = get_theme_mod('custom_css_post_id');
			if(!empty($pid)) wp_delete_post($pid, true);
			$message = 'All customizer settings has been deleted.';
			if(defined('ENTEX_THEME_PRESERVE_CUSTOMIZER_WIDGET_MENUES')){
				$mods = get_theme_mods();
				$widgets = $mods['sidebars_widgets'];
				$menues = $mods['nav_menu_locations'];
				remove_theme_mods();
				set_theme_mod('sidebars_widgets', $widgets);
				set_theme_mod('nav_menu_locations', $menues);
				$message .= ' Widget and Menu settings are preserved.';
			} else {
				remove_theme_mods();
			}
			$message .= ' '. _x('Please remember to undefine all definitions in your functions.php, otherwise the stylesheet cache will not be generated.', 'customizer', 'entex');
			entex_page_message($message);
			$initital_message = '';
		}
		if($initital_message) entex_page_message($initital_message);
	}
} 


if(defined('ENTEX_THEME_CUSTOMIZER_CHANGESET_REMOVE_CONTINUE')){
	add_filter('customize_changeset_branching', '__return_true');
}



/* Google fonts fallback */
if(!defined('ENTEX_THEME_CUSTOMIZER_GOOGLE_FONTS_FALLBACK')){
	define('ENTEX_THEME_CUSTOMIZER_GOOGLE_FONTS_FALLBACK', 'arial, helvetica, sans-serif');
}

/* ******************** */






/* -------------------- */
// CUSTOMIZER LOAD / CACHE

if(is_customize_preview()){
	require get_template_directory() . '/customizer/customizer.php'; // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
} else if(!defined('ENTEX_THEME_DELETE_CUSTOMIZER_DATA')){
	
	/* note: The required options file is loaded in conditional below */
	
	/* This is the normal front-end condition */
	/* We need to know if 'entex_customizer_saved' is 'populated' or not */
	/* If empty, we are arriving from the customizer */
	/* ( The last thing customizer is doing after save is 'empty' this by removing it ) */
	/* If empty we wanna create a cache stylesheet - if allowed write to file */
	/* Else always populate theme mods as inline style */
	
	$saved = get_theme_mod('entex_customizer_saved', 0);

	if(!$saved){

		/* This will ALWAYS run after leaving saved customizer */
		/* lets try create the stylesheet cache file */
		/* or honor settings to always use embed style method */
		/* we need to run the panels (controllers) wp_head actions */
		/* lets load the refresh functions used by customizer mode */
		
		require get_template_directory() . '/customizer/customizer.php'; // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
		
		/* As we are NOT in customizer API mode */
		/* We make a call directly AFTER the panels executed inline 'wp_head' stuff - e.g. populating page-load / refresh inline styles from each controller */
		
		add_action('wp_head', 'entex_customize_populate_customizer_styles', 30);
		
		/* From here (above executed action) we know */
		/* If we load a created stylesheet in the future */
		/* Or need to populate embed styles in wp_head */
		
		/* This 'empty' dynamic panel url arguments */
		/* Propably should me moved one level up but there might be a reason for its here */
		delete_transient('entex_customize_edit_panels');
		
	} else {
		
		/* As customizer.php is NOT loaded as default */
		/* We ALWAYS need the options on front-end */
		
		require get_template_directory() . '/customizer/entex-customize-options.php'; // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
		
		/* Do we have a successful created file or broken file or never created file or forced to use inline style ? */
		
		$use_inline = get_theme_mod('entex_customizer_use_inline_styles', 0);
		$force_inline = get_theme_mod('entex_customizer_force_inline_styles', 0);
		if($force_inline) $use_inline = 1;
		if(!$use_inline && file_exists(get_stylesheet_directory() .'/'. entex_customize_get_stylesheet_name() .'.css')){
			add_action('wp_enqueue_scripts', 'entex_theme_wp_enqueue_scripts_customizer', 30);
		} else {
			add_action('wp_enqueue_scripts', 'entex_output_customizer_styles', 30);
		}
	}
} else {
	/* occurs on delete customizer data */
	require get_template_directory() . '/customizer/entex-customize-options.php'; // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
}

function entex_theme_wp_enqueue_scripts_customizer(){
	$cache = filemtime(get_stylesheet_directory().'/'. entex_customize_get_stylesheet_name() .'.css');
	wp_enqueue_style('entex-theme-customizer', get_stylesheet_directory_uri() .'/'. entex_customize_get_stylesheet_name() .'.css', array(), $cache);
}

function entex_output_customizer_styles(){
	
	$css = get_theme_mod('entex_customizer_inline_styles', '');
	$none = entex_customize_get_content_none();
	if($css == $none) return;
	
	if($css) $css = str_replace('¤', "\r\n", $css);
		else return;
		
	wp_register_style('entex-customizer-collection', false);
	wp_enqueue_style('entex-customizer-collection');
	wp_add_inline_style('entex-customizer-collection', $css);
}

function entex_theme_load_initial_styles(){
	$remove = get_theme_mod('entex_theme_remove_wp_is_initial', false);
	if($remove) return false;
		else return true;
}

/* helper */ // - prepared for multiple stylesheet choices
function entex_customize_get_stylesheet_name(){
	$stylesheet = 'customizer';
	return $stylesheet;
}

/* helper */
function entex_customize_get_content_none(){
	return '/* no customizer settings */'.'¤';
}





/* -------------------- */
// ADD TEMPLATES

function entex_customize_filter_template_default($_default, $_id, $_index, $_current, $_total){

	static $done = '';
	if($done) return $done;
	
	$_TARGET = 'template';
	$is = entex_theme_fn_get_is();
	if($is['format-type']){
		$index = 'is_post_format_'.$is['format-type'];
	} else if(is_tax()){
		$index = $is['dynamic-part'];
	} else {
		$index = $is['conditional'];
	}
	
	/* get first template returning as default / start template */
	$n = 1;
	$id = 'entex_theme_options_'. $_TARGET .'_'.$n.'_'.$index;
	$template = get_theme_mod($id, '');
	if($template){
		$done = $template;
	} else {
		$done = $_default;
		/* no need to continue */
		return $done;
	}
	
	/* sync with options panel */
	$n = 1;
	$breakpoints = array(1, 2, 3);
	foreach($breakpoints as $nr){

		$id = 'entex_theme_options_'. $_TARGET .'_'.$nr.'_'.$index.'_breakpoint_'.$nr;
		$breakpoint = get_theme_mod($id, 0);
		
		$id = 'entex_theme_options_'. $_TARGET .'_'.$nr.'_'.$index.'_min_'.$nr;
		$min = get_theme_mod($id, 0);

		if($min){
			if(((int) $breakpoint + 4) > $_total) break;
		}
		
		$n ++;
		$id = 'entex_theme_options_'. $_TARGET .'_'.$n.'_'.$index;
		$template = get_theme_mod($id, '');
		
		if($breakpoint && $template){

			add_filter('entex_entry_breakpoint_'.$nr, function($d, $b, $id, $i, $c, $t) use ($breakpoint){
				return $breakpoint;
			}, 60, 6);

			add_filter('entex_entry_template_breakpoint_'.$nr, function($d) use ($template){
				return $template;
			}, 60, 1);
		}
	}
	
	
	return $done;
	//add_filter('entex_current_specialised', 'entex_customize_filter_remove_specialised', 5, 1);

}
add_filter('entex_entry_template_default', 'entex_customize_filter_template_default', 60, 5);

/* helper */
function entex_customize_filter_remove_specialised($current){
	remove_filter('entex_current_specialised', 'entex_customize_filter_remove_specialised', 5, 1);
	return '';
}


// -- END FILE -- //