<?php if(!defined('ABSPATH')) die();

// UPDATED 2022 05 08


/* translations */
$translation = esc_html_x('Toggle children', 'Admin', 'entex');


/* -------------------- */
// THEME ACTIVATION

function entex_admin_theme_activation_notice(){
	
	$html = '';
	$message = '';
	$message .= _x('Thanks for activating Entex theme.', 'Admin', 'entex').' ';
	
	/* translators: */
	$message .= sprintf(_x('If you are using WordPress Classic Editor interface, please define the constant in functions.php like %s.', 'Admin', 'entex'), '<code>define(\'ENTEX_CLASSIC_EDITOR_INTERFACE\', true);</code>').' ';
	$message .= _x('Read the documentations how to cleanup Gutenberg interface or how to extend the default visual editor.', 'Admin', 'entex').' ';
	$message .= _x('To take advantage of this Theme, take a look at all free Entex Theme extensions and Entex plugins to run this Theme with full capacity.', 'Admin', 'entex').' ';
	$message .= _x('NOTE, this free and public version of Entex Theme, is a <strong> Release Candidate </strong> and is still under development to work with many common plugins and Gutenberg settings. Full compatibility with Woocommerce, Buddypress, WPML and many more, is on the radar to be released.', 'Admin', 'entex').' ';
	$message .= _x('Visit https://entex.info for more information, demo and documentation.', 'Admin', 'entex').' ';
	
    $html .= '<div class="notice notice-success is-dismissible">';
	$html .= '<p>'. trim(stripslashes($message)) .'</p>';
    $html .= '</div>';
	
	echo wp_kses_post($html);
}

function entex_admin_theme_activation_notice_woocommerce(){
	
	$html = '';
	$message = '';
	$message .= _x('In order to use WooCommerce with this theme, you need to install the Entex Theme WooCommerce plugin.', 'Admin', 'entex').' ';
    $html .= '<div class="notice notice-warning is-dismissible">';
	$html .= '<p>'. trim(stripslashes($message)) .'</p>';
    $html .= '</div>';
	
	echo wp_kses_post($html);
}

function entex_admin_theme_activation_message(){
	global $pagenow;
	$activated = entex_request_get('activated');
	if($activated && $pagenow == 'themes.php'){
		add_action('admin_notices', 'entex_admin_theme_activation_notice');
	}
	// Woocommerce notice
	if(in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))){ 
		if(!in_array('entex-theme-woocommerce/entex-theme-woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))){
			add_action('admin_notices', 'entex_admin_theme_activation_notice_woocommerce');
		}
	}
}
add_action('admin_init', 'entex_admin_theme_activation_message');

// END : ACTIVATION
/* ******************** */






/* -------------------- */
// LOAD ADMIN BACKEND ASSETS

function entex_admin_enqueue_style(){
	if(!entex_is_gutenberg() && defined('ENTEX_THEME_BACKEND_STYLE_ENABLE')){
		wp_enqueue_style('entex-theme-admin-backend', get_template_directory_uri() .'/assets/css/entex-theme-admin-backend.css');
	}
}
add_action('admin_enqueue_scripts', 'entex_admin_enqueue_style', 30);





/* -------------------- */
// EDIT ATTACHMENT SCREEN
/* Move field from bottom to publish button area */

function entex_attachments_submitbox_misc_actions($id){
	if(defined('ENTEX_THEME_BACKEND_STYLE_ENABLE')){
		echo wp_kses_post('<div class="misc-pub-section"></div>');
		echo wp_kses_post('<div class="misc-pub-section" id="entex-theme-submitbox-misc-actions"></div>');
		/* script */
		entex_attachments_submitbox_misc_actions_script(false);
	}
}
add_action('attachment_submitbox_misc_actions', 'entex_attachments_submitbox_misc_actions', 30, 1);


/* Moves ALL attachment fields to edit */
function entex_attachments_submitbox_misc_actions_script($id){
	
	$add = '';
	$add .=  "
;( function( $ ) {
	$(document).ready(function(){
		if($('table.compat-attachment-fields').get(0)){
			$('table.compat-attachment-fields').appendTo($('#entex-theme-submitbox-misc-actions')).find('p.description').remove();
		}
	});
})(jQuery);
	";
	
	wp_register_script('entex-admin-compat-attachment', '', array('jquery'), '', true);
	wp_enqueue_script('entex-admin-compat-attachment');
	wp_add_inline_script('entex-admin-compat-attachment', $add);
}

function entex_attachments_submitbox_misc_actions_style($hook){
	if(defined('ENTEX_THEME_BACKEND_STYLE_ENABLE')){
		$add = '/* added in: '. basename( __FILE__ ) .' */ '.entex_LBr();
		$add .= '#misc-publishing-actions .compat-attachment-fields label .alignleft { padding: 3px 0px 5px; } ';
		$add .= '#misc-publishing-actions .compat-field-cropthumbnails label { display: none; } .misc-pub-section:empty { padding: 0px; } ';
		$add .= '#entex-theme-submitbox-misc-actions .compat-attachment-fields, #entex-theme-submitbox-misc-actions .compat-attachment-fields > tbody, #entex-theme-submitbox-misc-actions .compat-attachment-fields > tbody > tr, #entex-theme-submitbox-misc-actions .compat-attachment-fields > tbody > tr > th, #entex-theme-submitbox-misc-actions .compat-attachment-fields > tbody > tr > td { display: block; } ';
	
		wp_add_inline_style('entex-theme-admin-backend', $add);
	}
}
add_action('admin_enqueue_scripts', 'entex_attachments_submitbox_misc_actions_style', 60, 1);

// END : EDIT ATTACHMENT SCREEN
/* ******************** */






/* -------------------- */
// MISC DATE METABOX FIX
/* Cleanup published date form within old metabox */

function entex_admin_cleanup_timestamp_wrap($post){

	if(defined('ICL_LANGUAGE_CODE')) {
		$langauge = ICL_LANGUAGE_CODE;
	} else {
		list($langauge, $stupid) = explode('_', get_locale(), 2);
		if(!$langauge) $langauge = 'en';
	}
	$label_mn = esc_html_x('Minutes', 'Admin', 'entex');
	$label_hh = esc_html_x('Hour', 'Admin', 'entex');
	$label_aa = esc_html_x('Year', 'Admin', 'entex');
	$label_jj = esc_html_x('Day', 'Admin', 'entex');
	$label_mm = esc_html_x('Month', 'Admin', 'entex');

	$add = "
	jQuery(document).ready(function($){
		if($('.timestamp-wrap').get(0)){
			var El = $('.timestamp-wrap');
			var la = '". $langauge ."';
			El.addClass('ua-timestamp-wrap');
			El.contents().filter(function(){
				return this.nodeType == 3;
			}).remove();
			
			if(la == 'sv'){
				$('#mm').before($('#jj'));
			}
			El.find('#mn').wrap($('<label>').text('". $label_mn ."').css('display', 'block').css('margin', '0.25em 0 0.25em 0'));
			El.find('#hh').wrap($('<label>').text('". $label_hh ."').css('display', 'block').css('margin', '0.25em 0 0.25em 0'));
			El.find('#aa').wrap($('<label>').text('". $label_aa ."').css('display', 'block').css('margin', '0.25em 0 0.25em 0'));
			El.find('#jj').wrap($('<label>').text('". $label_jj ."').css('display', 'block').css('margin', '0.25em 0 0.25em 0'));
			El.find('#mm').wrap($('<label>').text('". $label_mm ."').css('display', 'block').css('margin', '0.25em 0 0.25em 0'));
			El.find('input').focus(function(){
				if($(this).is('#mn')){
					$(this).val('00');
				} else {
					var x = $(this).val('');
				}
			
			});
		}
	});
	";
	wp_register_script('entex-admin-datebox', '', array('jquery'), '', true);
	wp_enqueue_script('entex-admin-datebox');
	wp_add_inline_script('entex-admin-datebox', $add);
}
add_action('post_submitbox_misc_actions', 'entex_admin_cleanup_timestamp_wrap', 10, 1);

// END : MISC DATE METABOX FIX
/* ******************** */






/* -------------------- */
// ADMIN BACKEND BODY CLASS

function entex_admin_body_class($classnames){
	$add[] = 'entex-admin';
	return $classnames .' '. implode(' ', $add);
}
add_filter('admin_body_class', 'entex_admin_body_class');







/* -------------------- */
// VALIDATE TERM(S)
/* Tags always lowercase */
/* Categories first letter uppercase */

function entex_admin_pre_insert_term($term, $taxonomy){
	if(!defined('ENTEX_VALIDATE_TERM_DISABLE')){
		if($taxonomy == 'post_tag') $term = mb_strtolower($term, 'UTF-8');
		if($taxonomy == 'category') $term = entex_mb_ucfirst($term, 'UTF-8', true);
	}
	return $term;
}
add_filter('pre_insert_term', 'entex_admin_pre_insert_term', 99, 2);







/* -------------------- */
// ENTEX THEME (GUTENBERG) METABOX
/* As default we dont use custom metaboxes */
/* Instead we have filtered in choices in default boxes within correct context */
/* Gutenberg does not allow this */
/* We create a custom metabox IF Gutenberg interface is in use on current pageload */
/* And use filters, to provide the content */

/* Only if Gutenberg is in use */
function entex_admin_gutenberg_metabox($post_type){
	if(entex_is_gutenberg()){
		
		$context = 'side';
		$post_types = get_post_types(array('public' => true));
		$post_types[] = 'contents';
		
		/* filter */
		$post_types = apply_filters('entex_gutenberg_metabox_post_types', $post_types);
		
		if(defined('DISABLE_ENTEX_GUTENBERG_METABOX_ATTACHMENT')){
			if(($key = array_search('attachment', $post_types)) !== false){
				unset($post_types[$key]);
			}
		}
		if(in_array($post_type, $post_types)){
			add_meta_box(
				'entex-gutenberg-metabox',
				_x('Entex Theme', 'Admin', 'entex'),
				'entex_admin_gutenberg_metabox_html',
				$post_type,
				$context,
				'high'
			);
		}
	}
}
add_action('add_meta_boxes', 'entex_admin_gutenberg_metabox', -5);


/* Only if Gutenberg is in use */
function entex_admin_gutenberg_metabox_html($post){
	
	/* Global HTML output */
	do_action('entex_gutenberg_metabox_html', $post);
	
	$S['options_featured_image'] = _x('Featured image options', 'Admin', 'entex');
	$S['options_menu'] = _x('Menu options', 'Admin', 'entex');
	$S['options_visibility'] = _x('Visibility options', 'Admin', 'entex');
	
	$sections = apply_filters('entex_admin_gutenberg_metabox_sections', $S);
	if(empty($sections) || !is_array($sections)) return;
	
	foreach($sections as $section => $label){
		$html = apply_filters('entex_admin_gutenberg_metabox_html_'. $section, '', $post->ID);
		if($html){
			echo '<h3>'. esc_html($label) .'</h3>';
			echo $html; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		}
	}
}


/* helper */
function entex_admin_metabox_css(){
	
	$add = '';
	$add .= '.ua-admin-label { display: block; } ';
	$add .= '.ua-admin-label.ua-admin-label-axis { width: 33%; float: left; } ';
	$add .= '.ua-admin-none { display: none; } ';
	$add .= '.ua-admin-set-border { border-width: 1px; border-style: solid; border-color: #666666; } ';
	$add .= '.ua-admin-set-hidden { opacity: 0.25; } ';
	
	if(!entex_is_gutenberg()){
		$add .= '#postimagediv .ua-admin-misc-wr { margin-left: -12px; margin-right: -12px; } ';
		$add .= '.ua-admin-misc-wr { padding: 6px 10px 8px; border-width: 1px 0px 0px 0px; border-style: solid; border-color: #f0f0f0; } ';
	} else {
		$add .= '.ua-admin-label { display: block; margin: 0.5em 0px; } ';
	}
	
	wp_register_style('entex-admin-gutenberg-metabox', false);
	wp_enqueue_style('entex-admin-gutenberg-metabox');
	wp_add_inline_style('entex-admin-gutenberg-metabox', $add);

	entex_admin_post_thumbnail_script();
}

/* Only in classic interface, Gutenberg added in its own enquened script file */
function entex_admin_post_thumbnail_script(){
	
	$add = "
	jQuery(document).ready(function($){
		if($('#entex_post_thumbnail_border').get(0)){
			if($('#set-post-thumbnail').get(0)){
				if($('#entex_post_thumbnail_border').is(':checked')) $('#set-post-thumbnail').find('img').addClass('ua-admin-set-border'); 
				$(document).on('click', '#entex_post_thumbnail_border', function(){
					if($('#entex_post_thumbnail_border').is(':checked')){
						$('#set-post-thumbnail').find('img').addClass('ua-admin-set-border');
					} else { 
						$('#set-post-thumbnail').find('img').removeClass('ua-admin-set-border');
					}
				});
			}
		}
	});
	";
	
	/* register script */
	wp_register_script('entex-admin-set-border', '', array('jquery'), '', true);
	wp_enqueue_script('entex-admin-set-border');
	wp_add_inline_script('entex-admin-set-border', $add);
}

/* helper */
function entex_admin_output_nonce(){
	echo '<input type="hidden" name="entex_admin_nonce" value="'. esc_attr(wp_create_nonce(basename(__FILE__))) .'" />';
	entex_admin_metabox_css();
}
add_action('post_submitbox_misc_actions', 'entex_admin_output_nonce', 60);
add_action('attachment_submitbox_misc_actions', 'entex_admin_output_nonce', 60);
add_action('entex_gutenberg_metabox_html', 'entex_admin_output_nonce', 60);






/* -------------------- */
// FEATURED IMAGE OPTIONS HTML

function entex_admin_options_featured_image_html($post_id = null){
	
	if(!$post_id){
		global $post;
		$post_id = $post->ID;
	}
	
	$html = '';
	
	$meta = get_post_meta($post_id, 'entex_post_thumbnail_border', true);
	$meta = ($meta == 'border' ? true : false);
	$label = _x('Set border', 'Admin', 'entex');
	$html .= '<div class="ua-admin-misc-wr">';
	$html .= '<label class="ua-admin-label"><input type="checkbox" value="border" name="entex_post_thumbnail_border" id="entex_post_thumbnail_border"'. ( $meta ? ' checked="checked"' : '' ) .' /> '. esc_html($label) .'</label>';
	$html .= '</div>';
	
	
	$meta = get_post_meta($post_id, 'entex_post_thumbnail_focus', true);
	$meta = ($meta == 'top' ? true : false);
	$label = _x('Focus on top', 'Admin', 'entex');
	$html .= '<div class="ua-admin-misc-wr">';
	$html .= '<label class="ua-admin-label"><input type="checkbox" value="top" name="entex_post_thumbnail_focus" id="entex_post_thumbnail_focus"'. ( $meta ? ' checked="checked"' : '' ) .' /> '. esc_html($label) .'</label>';
	$html .= '</div>';
	
	/* ghost - value will override 'top' above when saving */
	$meta = get_post_meta($post_id, 'entex_post_thumbnail_focus', true);
	$meta = ($meta == 'bottom' ? true : false);
	$label = _x('Focus on bottom', 'Admin', 'entex');
	$html .= '<div class="ua-admin-misc-wr">';
	$html .= '<label class="ua-admin-label"><input type="checkbox" value="bottom" name="entex_post_thumbnail_focus_bottom" id="entex_post_thumbnail_focus_bottom"'. ( $meta ? ' checked="checked"' : '' ) .' /> '. esc_html($label) .'</label>';
	$html .= '</div>';
	
	if(is_post_type_viewable(get_post_type($post_id))){
	$meta = get_post_meta($post_id, 'entex_post_thumbnail_hide', true);
	$meta = ($meta == 'hide' ? true : false);
	$label = _x('Hide on landing page', 'Admin', 'entex');
	$tt = _x('Thumbnail will only be used in category listings and on other places, except from this single page view.', 'Admin', 'entex');
	$html .= '<div class="ua-admin-misc-wr">';
	$html .= '<label class="ua-admin-label" title="'. esc_attr($tt) .'"><input type="checkbox" value="hide" name="entex_post_thumbnail_hide" id="entex_post_thumbnail_hide"'. ( $meta ? ' checked="checked"' : '' ) .' /> '. esc_html($label) .'</label>';
	$html .= '</div>';
	}
	
	return $html;
}


/* Gutenberg metabox */
function entex_admin_gutenberg_post_thumbnail_html($content, $post_id){
	$html = entex_admin_options_featured_image_html($post_id);
	if($html) return $content.$html;
		else return $content;
}
add_filter('entex_admin_gutenberg_metabox_html_options_featured_image', 'entex_admin_gutenberg_post_thumbnail_html', 20, 2);


/* Featured image built in metabox */
function entex_admin_post_thumbnail_html($content, $post_id){
	$html = entex_admin_options_featured_image_html($post_id);
	if($html) return $content.$html;
		else return $content;
}
add_filter('admin_post_thumbnail_html', 'entex_admin_post_thumbnail_html', 20, 2);

/* ******************** */






/* -------------------- */
// ARCHIVE IMAGE OPTIONS HTML

/* helper */
function entex_admin_post_term_has_archive_image($obj){
	
	$obj = entex_theme_fn_get_object($obj);
	if(!$obj) return '';
	$meta = null;
	
	$taxonomies = get_object_taxonomies($obj);
	if(!empty($taxonomies)){
		foreach($taxonomies as $taxonomy){
			if(is_taxonomy_hierarchical($taxonomy)){
				$terms = get_terms(array('taxonomy' => $taxonomy, 'hide_empty' => false));
				if(!empty($terms)){
					foreach($terms as $term){
						$meta = get_term_meta($term->term_id, 'entex_archive_image', true);
						if($meta) break;
							else $meta = null;
					}
				}
			}
		}
	}
	return $meta;
}



function entex_admin_options_archive_image_html($post_id = null){
	
	if(defined('ENTEX_ARCHIVE_IMAGE_DISABLE')){
		return '';
	}
	
	global $post;
	if(!entex_theme_fn_has_hierarchical_taxonomy($post)) return '';
	if(!entex_admin_post_term_has_archive_image($post)) $SET_STYLE = ' style="opacity: 0.5;"';
		else $SET_STYLE = '';
	
	if(!$post_id){
		$post_id = $post->ID;
	}
	
	$html = '';

	$meta = get_post_meta($post_id, 'entex_singular_taxonomy_image', true);
	$meta = ($meta == 'image' ? true : false);
	$label = _x('Set taxonomy image', 'Admin', 'entex');
	$tt = _x('If taxonomy image is set on any parent, the closest archive image appears together with the single post title.', 'Admin', 'entex');
	if($SET_STYLE) $tt .= ' '. _x('But it seems that no archive image exists.', 'Admin', 'entex');
	$html .= '<div class="ua-admin-misc-wr">';
	$html .= '<label'.$SET_STYLE.' class="ua-admin-label" title="'. esc_attr($tt) .'"><input type="checkbox" value="image" name="entex_singular_taxonomy_image" id="entex_singular_taxonomy_image"'. ( $meta ? ' checked="checked"' : '' ) .' /> '. esc_html($label) .'</label>';
	$html .= '</div>';
	
	return $html;
}


/* Gutenberg metabox */
function entex_admin_gutenberg_archive_image_html($content, $post_id){
	$html = entex_admin_options_archive_image_html($post_id);
	if($html) return $content.$html;
		else return $content;
}
add_filter('entex_admin_gutenberg_metabox_html_options_featured_image', 'entex_admin_gutenberg_archive_image_html', 22, 2);


/* Featured image built in metabox */
function entex_admin_archive_image_html($content, $post_id){
	$html = entex_admin_options_archive_image_html($post_id);
	if($html) return $content.$html;
		else return $content;
}
add_filter('admin_post_thumbnail_html', 'entex_admin_archive_image_html', 22, 2);

/* ******************** */







/* -------------------- */
// MENU REDIRECT OPTIONS HTML

function entex_admin_options_menu_html($post_id = null){
	
	global $post;
	if($post->post_type != 'page') return '';
	
	if(!$post_id){
		$post_id = $post->ID;
	}
	
	$html = '';
	
	$meta = get_post_meta($post_id, 'entex_page_redirect_to_child', true);
	$label = esc_html_x('Redirect to first child', 'Admin', 'entex');
	$html .= '<div class="ua-admin-misc-wr" id="entex_page_redirect_to_child_field">';
	$html .= '<label class="ua-admin-label" title="'. esc_attr_x('If this page becomes a parent and has subpages, this option redirects all urls to the first subpage, otherwise this page will be cloned in menues as first sublevel choice.', 'Admin', 'entex') .'"><input value="redirect" type="checkbox" name="entex_page_redirect_to_child" id="entex_page_redirect_to_child"' . ( $meta ? ' checked="checked"' : '' ) . ' /> '. esc_html($label) .'</label>';
	$html .= '</div>';
	
	return $html;
}


/* Gutenberg metabox */
function entex_admin_gutenberg_options_menu_html($content, $post_id){
	$html = entex_admin_options_menu_html($post_id);
	if($html) return $content.$html;
		else return $content;
}
add_filter('entex_admin_gutenberg_metabox_html_options_menu', 'entex_admin_gutenberg_options_menu_html', 20, 2);


/* Post Submit built in metabox */
function entex_admin_submitbox_options_menu_html($post){
	$post_id = $post->ID;
	$html = entex_admin_options_menu_html($post_id);
	if($html) echo $html; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
}
add_action('post_submitbox_misc_actions', 'entex_admin_submitbox_options_menu_html', 20, 1);
add_action('attachment_submitbox_misc_actions', 'entex_admin_submitbox_options_menu_html', 20, 1);

/* ******************** */







/* -------------------- */
// AUTOMENU ON PAGES

function entex_admin_options_automenu_html($post_id = null){
	
	global $post;
	if($post->post_type != 'page') return '';
	
	if(!$post_id){
		$post_id = $post->ID;
	}
	
	$html = '';
	$meta = '';
	$plugin = '';
	$ancestors = get_post_ancestors($post_id);
	if(!empty($ancestors)){
		$ancestors = array_reverse($ancestors);
		foreach ($ancestors as $ancestor_id){
			$meta = get_post_meta($ancestor_id, 'entex_page_automenu', true);
			if($meta){
				$plugin = ' '. _x('(active by parent)', 'Admin', 'entex');
				break;
			}
		}
	} 
	$meta = get_post_meta($post_id, 'entex_page_automenu', true);
	$label = _x('Auto submenu', 'Admin', 'entex').$plugin;
	$html .= '<div class="ua-admin-misc-wr" id="entex_page_automenu_field"'. ($plugin ? ' style="opacity: 0.65;"' : '') .'>';
	$html .= '<label class="ua-admin-label" title="'. ($plugin ? esc_attr(_x('Current subpages of:', 'Admin', 'entex') .' '. get_the_title($ancestor_id)) : esc_attr(_x('Menu will not show if this page have no subpages', 'Admin', 'entex'))) .'"><input value="'. ($plugin ? 'parent' : 'show') .'" type="checkbox" name="entex_page_automenu" id="entex_page_automenu"'. ( $plugin ? ' disabled="disabled"' : '' ) . ( $meta ? ' checked="checked"' : '' ) .' /> '. esc_html($label) .'</label>';
	$html .= '</div>';
	
	return $html;
}


/* Gutenberg metabox */
function entex_admin_gutenberg_options_automenu_html($content, $post_id){
	$html = entex_admin_options_automenu_html($post_id);
	if($html) return $content.$html;
		else return $content;
}
add_filter('entex_admin_gutenberg_metabox_html_options_menu', 'entex_admin_gutenberg_options_automenu_html', 30, 2);


/* Post Submit built in metabox */
function entex_admin_submitbox_options_automenu_html($post){
	$post_id = $post->ID;
	$html = entex_admin_options_automenu_html($post_id);
	if($html) echo $html; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
}
add_action('post_submitbox_misc_actions', 'entex_admin_submitbox_options_automenu_html', 30, 1);
add_action('attachment_submitbox_misc_actions', 'entex_admin_submitbox_options_automenu_html', 30, 1);

/* ******************** */







/* -------------------- */
// ASIDE SIZE ON PAGES

function entex_admin_options_not_main_html($post_id = null){
	
	global $post;
	if($post->post_type != 'page') return '';
	
	if(!$post_id){
		$post_id = $post->ID;
	}
	
	$html = '';
	$meta = '';
	$meta = get_post_meta($post_id, 'entex_page_content_not_main', true);
	$label = _x('Content as aside', 'Admin', 'entex');
	$html .= '<div class="ua-admin-misc-wr" id="entex_page_content_not_main_field">';
	$html .= '<label class="ua-admin-label" title="'. esc_attr_x('Content size will be the aside smaller font', 'Admin', 'entex') .'"><input value="not" type="checkbox" name="entex_page_content_not_main" id="entex_page_content_not_main"' . ( $meta ? ' checked="checked"' : '' ) . ' /> '. esc_html($label) .'</label>';
	$html .= '</div>';
	
	return $html;
}


/* Gutenberg metabox */
function entex_admin_gutenberg_options_not_main_html($content, $post_id){
	$html = entex_admin_options_not_main_html($post_id);
	if($html) return $content.$html;
		else return $content;
}
add_filter('entex_admin_gutenberg_metabox_html_options_visibility', 'entex_admin_gutenberg_options_not_main_html', 30, 2);


/* Post Submit built in metabox */
function entex_admin_submitbox_options_not_main_html($post){
	$post_id = $post->ID;
	$html = entex_admin_options_not_main_html($post_id);
	if($html) echo $html; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
}
add_action('post_submitbox_misc_actions', 'entex_admin_submitbox_options_not_main_html', 30, 1);
add_action('attachment_submitbox_misc_actions', 'entex_admin_submitbox_options_not_main_html', 30, 1);

/* ******************** */






/* -------------------- */
// INTERCEPT PREAMBLE

function entex_admin_options_preamble_html($post_id = null){

	if(!$post_id){
		global $post;
		$post_id = $post->ID;
	}
	
	/* filter */
	if(!in_array(get_post_type($post_id), apply_filters('entex_admin_options_preamble_post_types', array('post', 'page'), $post_id))){
		return '';
	}
	
	if(!is_post_type_viewable(get_post_type($post_id))){
		return '';
	}

	$WARNING = '';
	$NOT = '';
	$SET_STYLE = '';
	if(!entex_is_gutenberg()){
		$NOT = '';
		$WARNING = ' '. _x('Only works if content is rendered with Gutenberg block editor interface.', 'Admin', 'entex');
		$SET_STYLE = ' style="opacity: 0.5;"';
	}
	$html = '';
	$meta = '';
	$meta = get_post_meta($post_id, 'entex_preamble', true);
	$label = _x('Preamble before featured image', 'Admin', 'entex').$NOT;
	$hover = _x('Preamble as first block will be placed before featured image.', 'Admin', 'entex').$WARNING;
	$html .= '<div class="ua-admin-misc-wr" id="entex_preamble_field">';
	$html .= '<label'. $SET_STYLE .' class="ua-admin-label" title="'. esc_attr($hover) .'"><input value="preamble" type="checkbox" name="entex_preamble" id="entex_preamble"' . ( $meta ? ' checked="checked"' : '' ) . ' /> '. esc_html($label) .'</label>';
	$html .= '</div>';
	
	return $html;
}


/* Gutenberg metabox */
function entex_admin_gutenberg_options_preamble_html($content, $post_id){
	$html = entex_admin_options_preamble_html($post_id);
	if($html) return $content.$html;
		else return $content;
}
add_filter('entex_admin_gutenberg_metabox_html_options_visibility', 'entex_admin_gutenberg_options_preamble_html', 32, 2);


/* Post Submit built in metabox */
function entex_admin_submitbox_options_preamble_html($post){
	$post_id = $post->ID;
	$html = entex_admin_options_preamble_html($post_id);
	if($html) echo $html; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
}
add_action('post_submitbox_misc_actions', 'entex_admin_submitbox_options_preamble_html', 30, 1);

/* ******************** */







/* -------------------- */
// SAVE METABOX DATA

function entex_admin_save_metabox_data($post_id) {
	
	if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE){
		return;
	}
	global $post;
	if(!isset($_POST['entex_admin_nonce'])) return;
	if(!wp_verify_nonce(entex_request_post('entex_admin_nonce'), basename(__FILE__))){
		return;
	}
	if('page' == entex_request_post('post_type')){
		if(!current_user_can('edit_pages', $post_id)){
			return;
		}
	} else if(!current_user_can('edit_posts', $post_id)){
		return;
	}
	
	
	/* featured image options */
	
	$meta = '';
	$name = 'entex_post_thumbnail_hide';
	if(!empty($_POST[$name]) && $_POST[$name] == 'hide') $meta = 'hide';
	if($meta) update_post_meta($post_id, $name, $meta);
		else delete_post_meta($post_id, $name);
		
	$meta = '';
	$name = 'entex_post_thumbnail_border';
	if(!empty($_POST[$name]) && $_POST[$name] == 'border') $meta = 'border';
	if($meta) update_post_meta($post_id, $name, $meta);
		else delete_post_meta($post_id, $name);
		
	$meta = '';
	$name = 'entex_post_thumbnail_focus';
	if(!empty($_POST[$name]) && $_POST[$name] == 'top') $meta = 'top';
	if($meta) update_post_meta($post_id, $name, $meta);
		else delete_post_meta($post_id, $name);
		
	/* ghost */
	$meta = '';
	$key = 'entex_post_thumbnail_focus';
	$name = 'entex_post_thumbnail_focus_bottom';
	if(!empty($_POST[$name]) && $_POST[$name] == 'bottom') $meta = 'bottom';
	/* bottom overrides top */
	if($meta) update_post_meta($post_id, $key, $meta);
	delete_post_meta($post_id, $name);
		
	$meta = '';
	$name = 'entex_singular_taxonomy_image';
	if(!empty($_POST[$name]) && $_POST[$name] == 'image') $meta = 'image';
	if($meta) update_post_meta($post_id, $name, $meta);
		else delete_post_meta($post_id, $name);
	
	
	/* visibility options */
	
	$meta = '';
	$name = 'entex_preamble';
	if(!empty($_POST[$name]) && $_POST[$name] == 'preamble') $meta = 'preamble';
	if($meta) update_post_meta($post_id, $name, $meta);
		else delete_post_meta($post_id, $name);

	do_action('entex_admin_action_save_metabox_data', $post_id);
	
	if($post->post_type != 'page') return;
	
	if(isset($_POST['entex_page_automenu']) && $_POST['entex_page_automenu'] == 'show'){
		update_post_meta($post_id, 'entex_page_automenu', 'show');
	} else update_post_meta($post_id, 'entex_page_automenu', '');
	
	if(isset($_POST['entex_page_redirect_to_child']) && $_POST['entex_page_redirect_to_child'] == 'redirect'){
		update_post_meta($post_id, 'entex_page_redirect_to_child', 'redirect');
	} else update_post_meta($post_id, 'entex_page_redirect_to_child', '');
	
	if(isset($_POST['entex_page_content_not_main']) && $_POST['entex_page_content_not_main'] == 'not'){
		update_post_meta($post_id, 'entex_page_content_not_main', 'not');
	} else update_post_meta($post_id, 'entex_page_content_not_main', '');
	
}
add_action('save_post', 'entex_admin_save_metabox_data');
add_action('edit_attachment', 'entex_admin_save_metabox_data');



/* CLEAR META IF FEATURED IMAGE IS REMOVED */
function entex_admin_post_thumbnail_reset($meta_ids, $object_id, $meta_key, $_meta_value){
	
	$post_id = $object_id;
	if($meta_key == '_thumbnail_id'){
		$name = 'entex_post_thumbnail_hide';
		delete_post_meta($post_id, $name);
		$name = 'entex_post_thumbnail_border';
		delete_post_meta($post_id, $name);
		$name = 'entex_post_thumbnail_focus';
		delete_post_meta($post_id, $name);
	}
}
do_action('delete_post_meta', 'entex_admin_post_thumbnail_reset', 10, 4);

// END
/* ******************** */






/* -------------------- */
// SVAVE MESSAGES CONSTRUCTOR

function entex_admin_output_save_notice_message(){
	
	$message = apply_filters('entex_admin_save_message', '');
	if(!$message){
		$message = entex_request_get('entex_save_message');
		if(!$message) return;
	}
	
	$html = '';
    $html .= '<div class="notice notice-success is-dismissible">';
	$html .= '<p>'. trim(sanitize_text_field($message)) .'</p>';
    $html .= '</div>';
	
	echo wp_kses_post($html);

}
add_action('admin_notices', 'entex_admin_output_save_notice_message');



function entex_admin_add_save_notice_message(){

	global $pagenow;
	if(!empty($pagenow)){
		if(isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] == 'POST'){
			do_action('entex_admin_save_'.$pagenow);
			add_filter('wp_redirect', 'entex_admin_redirect_save_notice_message', 20, 1);
		}
	}
}
add_action('admin_init', 'entex_admin_add_save_notice_message');

function entex_admin_redirect_save_notice_message($location){
	remove_filter('wp_redirect', 'entex_admin_redirect_save_notice_message', 20, 1);
	$message = apply_filters('entex_admin_save_message', '');
	if($message) $location = add_query_arg(array('entex_save_message' => $message), $location);
	return $location;
}

// END 
/* ******************** */







/* -------------------- */
// TABLE COLUMN CHECKBOX 

/* Click nearby checkbox triggers the checkbox */
function entex_admin_checkbox_enhancement(){
	
    $add = "
	jQuery(document).ready(function($){
		$('.check-column').click(function(e){
			if(e.target.tagName.toUpperCase() == 'INPUT') return true;
			e.stopImmediatePropagation();
			$(this).find('input').trigger('click');
		});
	});";
	
	wp_register_script('entex-admin-checkbox', '', array('jquery'), '', true);
	wp_enqueue_script('entex-admin-checkbox');
	wp_add_inline_script('entex-admin-checkbox', $add);
}
add_action('admin_footer', 'entex_admin_checkbox_enhancement');






/* -------------------- */
// SIGNATURE

function entex_admin_footer_text($content) {
    return esc_html_x('Entex WordPress Theme by Jonas Lundman', 'Admin', 'entex');
}
add_filter('admin_footer_text', 'entex_admin_footer_text', 10, 1);



// -- END FILE -- //