<?php if(!defined('ABSPATH')) die();

// is_admin() ONLY 

// UPDATED 2021 06 01
// This file must run independent and safe off
// Always use if(function_exists()) 
// NOTICE: This file includes function ACF javascript validation off





/* -------------------- */
// CUSTOM FIELDS VALIDATION

/* Turn validation off to speed save */
/* Aslo save front end templates without validate */
function entex_admin_acf_remove_javascript_validate(){
	echo '<script type="text/javascript">'."\n";
	echo "if(typeof acf !== 'undefined') { acf.validation.active = 0; console.log('acf.validation.active = 0 BY entex theme, entex-setup-acf.php'); }"."\n";
	echo '</script>'."\n";
}
add_action('admin_footer', 'entex_admin_acf_remove_javascript_validate');






/* -------------------- */
// ACF API GOOGLE KEY
/* Should be defined in functions.php */
/* The old method is stored inside dev.php */

function entex_admin_acf_init() {
	if(defined('ENTEX_API_KEY_GOOGLE_MAPS')){
		acf_update_setting('google_api_key', ENTEX_API_KEY_GOOGLE_MAPS);
	}
}
add_action('acf/init', 'entex_admin_acf_init');




/* -------------------- */
// CUSTOM FIELDS ON EDIT TAXONOMIES
/* Make space on edit taxonomies */

/* Initial hiding by css */ 
function entex_admin_acf_taxonomy_css(){
	
	$add = "
body.edit-tags-php .acf-field:not([data-name=ua_acf_button_advanced]) { display: none; } 
body.edit-tags-php #acf-term-fields .acf-field { width: 100% !important; } 
body.edit-tags-php #acf-term-fields .acf-field, body.edit-tags-php #acf-term-fields .acf-tab-wrap { display: none; } 
body.edit-tags-php h2.ua-tmp-show { display: block !important; } 
body.edit-tags-php table.ua-tmp-show { display: table !important; } 
body.edit-tags-php table.ua-tmp-show { display: table !important; } 
	
body.term-php #edittag { max-width: none; } 
body.term-php #acf-form-data + * + table ~ * { display: none; } 
body.term-php #acf-form-data ~ table input { max-width: 25rem; } 
body.term-php form table + h2 { margin-top: 60px; } 
body.term-php form .acf-field .acf-label label { font-weight: normal; } 
body.term-php .form-table > tbody > .acf-field > .acf-input, body.term-php .form-table > tbody > .acf-field > .acf-label { padding: 10px 10px 10px 0px; } 
body.term-php .edit-tag-actions { display: block !important; } 
body.term-php h2.ua-tmp-show { display: block !important; } 
body.term-php table.ua-tmp-show { display: table !important; } 

	";
	wp_register_style('entex-admin-acf-assets-tax', false);
	wp_enqueue_style('entex-admin-acf-assets-tax');
	wp_add_inline_style('entex-admin-acf-assets-tax', $add);
}
add_action('admin_head', 'entex_admin_acf_taxonomy_css');


/* Add event listener to ACF button or checkbox */
function entex_admin_acf_taxonomy_javascript(){
	$add = "
(function($) {
	$(document).ready(function(){
		$('body.edit-tags-php').find('[data-name=\"ua_acf_button_advanced\"] label').click(function(){
			$(this).closest('.acf-field').siblings().toggle();
		});

		$('body.term-php').find('[data-name=\"ua_acf_button_advanced\"] label span').click(function(e){
			$(this).closest('.form-table').siblings().not('#acf-form-data + *').toggle();
		});
		
		$('#ua-acf-button-advanced :checked').prop('checked', false);
		$('body.term-php').find('[data-name*=\"entex_taxonomy_sort_\"]').closest('table').addClass('ua-tmp-show').prev().addClass('ua-tmp-show');
		$('body.term-php').find('[data-name*=\"entex_archive_image\"]').closest('table').addClass('ua-tmp-show').prev().addClass('ua-tmp-show');
	});
})(jQuery);
	";
	wp_register_script('entex-admin-acf-assets-tax', '', array('jquery'), '', true);
	wp_enqueue_script('entex-admin-acf-assets-tax');
	wp_add_inline_script('entex-admin-acf-assets-tax', $add);
}
add_action('admin_head', 'entex_admin_acf_taxonomy_javascript');


// END: CUSTOM FIELDS ON EDIT TAXONOMIES
/* ******************** */






/* -------------------- */
// ACF HELPER FUNCTIONS
// Posted ACF is not real field names
// They are keys related to the real custom fields
// To examine posted data we need to convert the names

function entex_admin_acf_get_posted_field($field, $taxonomy, $term_id){
	$key = entex_admin_acf_get_related_term_field($field, $taxonomy, $term_id);
	if(!$key || empty($_POST['acf'][$key])) return false;
		else return sanitize_text_field(wp_unslash($_POST['acf'][$key]));
}

function entex_admin_acf_get_related_term_field($field, $taxonomy, $term_id){
	$object = get_field_object($field, $taxonomy .'_'. $term_id);
	if($object['key']) return $object['key'];
		else return false;
}


// END: ACF HELPER FUNCTIONS
/* ******************** */





/* -------------------- */
// POPULATE GLOBAL FIELDS
/* Content selector metabox */
/* Template setup metabox */

/* populates templates */

function entex_admin_acf_load_entex_template_selector_populate($field, $type){
	
	$TYPE = 'template-'.$type;
	/* cached */
	$templates = wp_get_theme()->get_page_templates(null, $TYPE);
	
	if(!empty($templates)){
		foreach($templates as $key => $name){
			$arr[str_replace('.php', '', $key)] = $name;
		}
		ksort($arr, SORT_NATURAL);
		foreach($arr as $key => $name){
			$result[$key .'.php'] = $name;
		}
		$templates = $result;
	}

	if(!empty($templates)){
		$field['choices']['_'.$TYPE] = '';
		$field['choices'][$TYPE] = mb_strtoupper($type).' TEMPLATES';
		foreach($templates as $file => $name) {
			$populate = true;
			if(defined('ENTEX_TEMPLATE_USE_CHILD_THEME_ONLY')){
				if(is_child_theme()){
					if(file_exists(get_stylesheet_directory().'/'.$file)) $populate = true;
						else $populate = false;
					
				}
			} 
			if($populate) $field['choices'][esc_attr($file)] = esc_attr($name);
		}
	}
	return $field;
}

function entex_admin_acf_load_entex_template_selector_choices($field){

	$field['choices'] = array();
	$field['choices']['default'] = 'Default template';
	
	$types = array('entries', 'events', 'widgets', 'contents', 'sections', 'parts', 'custom');
	/* filter */
	$add = apply_filters('entex_theme_template_types', $types);
	if(is_array($add) && !empty($add)) $types = $add;
	
	foreach($types as $type) {
		$field = entex_admin_acf_load_entex_template_selector_populate($field, $type);
	}
    return $field;
}
add_filter('acf/load_field/name=entex_template_selector', 'entex_admin_acf_load_entex_template_selector_choices');
add_filter('acf/load_field/name=entex_entry_template_default', 'entex_admin_acf_load_entex_template_selector_choices');
add_filter('acf/load_field/name=entex_entry_template_breakpoint_1', 'entex_admin_acf_load_entex_template_selector_choices');
add_filter('acf/load_field/name=entex_entry_template_breakpoint_2', 'entex_admin_acf_load_entex_template_selector_choices');
add_filter('acf/load_field/name=entex_entry_template_breakpoint_3', 'entex_admin_acf_load_entex_template_selector_choices');
add_filter('acf/load_field/name=entex_entry_template_breakpoint_4', 'entex_admin_acf_load_entex_template_selector_choices');


/* populates options */
function entex_admin_acf_load_entex_entry_template_setup_choices($field){

	$field['choices'] = array();
	$field['choices'][''] = 'Select conditional';
	/* archive conditionals */
	$field['choices']['is_category'] = 'is_category';
	$field['choices']['is_tag'] = 'is_tag';	
	$field['choices']['is_tax'] = 'is_tax';
	//$field['choices']['is_tax_post_format'] = 'is_tax_post_format';
	//$field['choices']['is_taxonomy'] = 'is_taxonomy';
	$field['choices']['is_author'] = 'is_author';
	$field['choices']['is_year'] = 'is_year';
	$field['choices']['is_month'] = 'is_month';
	$field['choices']['is_day'] = 'is_day';
	$field['choices']['is_time'] = 'is_time';
	$field['choices']['is_date'] = 'is_date';
	$field['choices']['is_post_type_archive'] = 'is_post_type_archive';
	$field['choices']['is_search'] = 'is_search';
	$field['choices']['is_archive'] = 'is_archive';
	$field['choices']['is_home'] = 'is_home';
    return $field;
}
add_filter('acf/load_field/name=entex_entry_template_setup', 'entex_admin_acf_load_entex_entry_template_setup_choices');

// END: POPULATE GLOBAL FIELDS
/* ******************** */






/* -------------------- */
// ON SAVE TAXONOMY TERM

function entex_entry_template_setup_register_option($term_id, $taxonomy_id, $slug){

	if(empty($_POST['acf'])) return;
	
	$field = 'entex_entry_template_setup_delete';
	$delete = entex_admin_acf_get_posted_field($field, $slug, $term_id);

	$field = 'entex_entry_template_setup';
	$posted = entex_admin_acf_get_posted_field($field, $slug, $term_id);
	if(!$posted || $posted == 'default') return;

	if($delete) delete_option('entex_theme_entry_template_setup_'. $posted);
		else update_option('entex_theme_entry_template_setup_'. $posted, $term_id);

}
add_action('edited_term', 'entex_entry_template_setup_register_option', 30, 3);
add_action('created_term', 'entex_entry_template_setup_register_option', 30, 3);

$GLOBALS['PREVENT'] = false;
/* prevent meta from save */
function entex_entry_template_setup_prevent_meta($return, $term_id, $field){
	if($field == 'entex_entry_template_setup') return false;
	if($field == 'entex_entry_template_setup_delete') return false;
	if($field == 'entex_delete_selector') return false;
	
	return null;
}
add_filter('update_term_metadata', 'entex_entry_template_setup_prevent_meta', 10, 3);


// END: ON SAVE TAXONOMY TERM
/* ******************** */





/* -------------------- */
// POPULATE FIELDS
/* Content selector metabox */

/* populates locations (metabox) */
function entex_admin_acf_load_entex_location_selector_choices($field){
    
	$field['choices'] = array();
	
	global $post;
	if(isset($post->post_type) && $post->post_type == 'contents'){
		$field['choices']['default'] = 'Inherit (from the includer of contents)';
	} else {
		$field['choices']['default'] = 'Current sidebar';

		/* filter */
		$extended = apply_filters('entex_theme_locations', array());
		if(!empty($extended)){
			foreach($extended as $location => $name) {
				if($location && $name) $field['choices'][$location] = esc_attr($name);
			}
		}
	}
    return $field;
}
add_filter('acf/load_field/name=entex_location_selector', 'entex_admin_acf_load_entex_location_selector_choices');

/* populates current (metabox) */
function entex_admin_acf_load_entex_current_selector_choices($field){
    
	
	$meta = 'entex_selectors';
	global $pagenow;
	if($pagenow == 'term.php' || $pagenow == 'edit-tags.php'){
		$term_id = null;
		$value = entex_request_get('tag_ID');
		if($value) $term_id = $value;
		if($term_id) $selectors = get_term_meta($term_id, $meta, true);
	} else {
		global $post;
		$selectors = get_post_meta($post->ID, $meta, true);
	}
	$field['choices'] = array();
	
	if(!empty($selectors) && is_array($selectors)){
		foreach($selectors as $location => $name) {
			$field['choices'][$location] = $name;
		}
	} else $field['choices']['none'] = 'Nothing saved';
    return $field;
}
add_filter('acf/load_field/name=entex_current_selector', 'entex_admin_acf_load_entex_current_selector_choices');

// END: POPULATE FIELDS
/* ******************** */






/* -------------------- */
// ADMIN SELECTOR JAVASCIPT

/* Transport taxonomy change to custom field */
function entex_admin_acf_javascript_selector(){
	global $pagenow;
	if($pagenow == 'post.php'){
		$add = "
[data-name=\"entex_content_selector\"], [data-name=\"entex_location_selector\"], [data-name=\"entex_template_selector\"] { border-top-width: 5px !important; } 
.entex-taxonomy-selector-active .selection, [data-name=\"entex_taxonomy_selector\"] * { visibility: hidden; } 
.entex-taxonomy-selector-active [data-name=\"entex_taxonomy_selector\"] * { display: block; visibility: visible; } 
.entex-taxonomy-selector-active [data-filter=\"taxonomy\"] { background-color: #ffffe9; } 
.entex-taxonomy-selector-active .acf-relationship .filters.-f3 .filter:not(:last-child) { display: block; } 
.entex-taxonomy-selector-active .acf-relationship .filters.-f3 .filter:last-child { width: 50%; float: right; } 
		";
		wp_register_style('entex-admin-acf-assets-sel', false);
		wp_enqueue_style('entex-admin-acf-assets-sel');
		wp_add_inline_style('entex-admin-acf-assets-sel', $add);
		$add = "
(function($) {
	$(document).ready(function(){
		$(document).on('change', '[data-name=\"entex_content_selector\"] [data-filter=\"taxonomy\"]', function(){
			$('[data-name=\"entex_taxonomy_selector\"]').find('input').val($(this).val()).trigger('change');
		});
		$(document).on('click', '[data-name=\"entex_taxonomy_selector_active\"] :checkbox', function(){
			if($(this).is(':checked')) $('body').addClass('entex-taxonomy-selector-active');
				else $('body').removeClass('entex-taxonomy-selector-active');
		});
		if($('[data-name=\"entex_taxonomy_selector_active\"]').find('input:checked').get(0)) $('body').addClass('entex-taxonomy-selector-active');
	});
})(jQuery);
		";
		wp_register_script('entex-admin-acf-assets-sel', '', array('jquery'), '', true);
		wp_enqueue_script('entex-admin-acf-assets-sel');
		wp_add_inline_script('entex-admin-acf-assets-sel', $add);
	}
	
	if($pagenow == 'term.php'){
		$add = "
(function($) {
	$(document).ready(function(){
		$(document).on('change', '[data-name=\"entex_content_selector\"] [data-filter=\"taxonomy\"]', function(){
			$('[data-name=\"entex_taxonomy_selector\"]').find('input').val($(this).val()).trigger('change');
		});
	});
})(jQuery);
		";
		wp_register_script('entex-admin-acf-assets-sel', '', array('jquery'), '', true);
		wp_enqueue_script('entex-admin-acf-assets-sel');
		wp_add_inline_script('entex-admin-acf-assets-sel', $add);
	}
}
add_action('admin_head', 'entex_admin_acf_javascript_selector');

// END: JAVASCRIPT
/* ******************** */






/* -------------------- */
// SAVE FIELDS TAXONOMY

function entex_admin_save_current_selector_taxonomy($term_id, $taxonomy_id, $slug) {
	
	if(defined('DOING_AJAX') && DOING_AJAX) return;
	if(empty($_POST['acf'])) return;
	
	$field = 'entex_delete_selector';
	$delete = entex_admin_acf_get_posted_field($field, $slug, $term_id);

	$field = 'entex_location_selector';
	$location = entex_admin_acf_get_posted_field($field, $slug, $term_id);
	if(!$location || $location == 'none') return;
	
	$field = 'entex_content_selector';
	$content = entex_admin_acf_get_posted_field($field, $slug, $term_id);
	
	/* Bail if no content populated, except if delete */
	if(!$delete && empty($content)) return;

	$meta = 'entex_selectors';
	
	/* Get existing saved locations */
	$selectors = get_post_meta($post_id, $meta, true);
	if(!is_array($selectors)){
		unset($selectors);
		$selectors = array();
	}
	
	if($delete){
		
		/* Mission accomplished */
		// Filter added to return null

		delete_term_meta($term_id, 'entex_content_selector_'.$location);
		delete_term_meta($term_id, 'entex_position_selector_'.$location);
		delete_term_meta($term_id, 'entex_template_selector_'.$location);
		delete_term_meta($term_id, 'entex_inclusion_selector_'.$location);
		delete_term_meta($term_id, 'entex_location_selector_'.$location);
		
		if(!empty($selectors)){
			if(isset($selectors[$location])){
				unset($selectors[$location]);
			}
			if(!empty($selectors)){
				foreach($selectors as $next => $name) {
					if($next){
						$move = $next;
						break;
					}
				}
			}
		}
		
		if(isset($move)){
			
			update_term_meta($term_id, 'entex_content_selector', get_term_meta($term_id, 'entex_content_selector_'.$move, true));
			update_term_meta($term_id, 'entex_position_selector', get_term_meta($term_id, 'entex_position_selector_'.$move, true));
			update_term_meta($term_id, 'entex_template_selector', get_term_meta($term_id, 'entex_template_selector_'.$move, true));
			update_term_meta($term_id, 'entex_inclusion_selector', get_term_meta($term_id, 'entex_inclusion_selector_'.$move, true));
			update_term_meta($term_id, 'entex_location_selector', get_term_meta($term_id, 'entex_location_selector_'.$move, true));
			
			update_term_meta($term_id, 'entex_current_selector', $move);
			update_term_meta($term_id, $meta, $selectors);
			
		} else {
			
			delete_term_meta($term_id, 'entex_content_selector');
			delete_term_meta($term_id, 'entex_position_selector');
			delete_term_meta($term_id, 'entex_template_selector');
			delete_term_meta($term_id, 'entex_inclusion_selector');
			delete_term_meta($term_id, 'entex_location_selector');
			
			delete_term_meta($term_id, 'entex_current_selector');
			delete_term_meta($term_id, $meta);
		}
		
		
		return;
	}
	
	/* Always remove */
	// Filter added to return null
	
	/* Load (populate) if 'missmatch' with existing location */
	$field = 'entex_current_selector';
	$current = entex_admin_acf_get_posted_field($field, $slug, $term_id);
	
	if($current && isset($selectors[$location]) && $current != $location){
		
		update_term_meta($term_id, 'entex_content_selector', get_term_meta($term_id, 'entex_content_selector_'.$current, true));
		update_term_meta($term_id, 'entex_position_selector', get_term_meta($term_id, 'entex_position_selector_'.$current, true));
		update_term_meta($term_id, 'entex_template_selector', get_term_meta($term_id, 'entex_template_selector_'.$current, true));
		update_term_meta($term_id, 'entex_inclusion_selector', get_term_meta($term_id, 'entex_inclusion_selector_'.$current, true));
		update_term_meta($term_id, 'entex_location_selector', get_term_meta($term_id, 'entex_location_selector_'.$current, true));
			
		return;
	}

	/* Save new or override */
	
	/* In sync with available locations */
	$field = entex_admin_acf_load_entex_location_selector_choices(array());
	$name = $field['choices'][$location];
	$selectors[$location] = $name;

	/* Move ACF fields into suffix fields */
	update_term_meta($term_id, $meta, $selectors);
	
	//$field = entex_admin_acf_get_related_term_field($meta, $slug, $term_id);
	//update_field($field, $selectors, $term_id);
	
	update_term_meta($term_id, 'entex_content_selector_'.$location, get_term_meta($term_id, 'entex_content_selector', true));
	update_term_meta($term_id, 'entex_position_selector_'.$location, get_term_meta($term_id, 'entex_position_selector', true));
	update_term_meta($term_id, 'entex_template_selector_'.$location, get_term_meta($term_id, 'entex_template_selector', true));
	update_term_meta($term_id, 'entex_inclusion_selector_'.$location, get_term_meta($term_id, 'entex_inclusion_selector', true));
	update_term_meta($term_id, 'entex_location_selector_'.$location, get_term_meta($term_id, 'entex_location_selector', true));
	
	/* Finally, populate 'current' with this location */
	update_term_meta($term_id, 'entex_current_selector', $location);
	//die(var_dump(get_term_meta($term_id, $meta, true)));
	return;
	//update_term_meta($term_id, 'entex_current_selector', $location);
	//$field = entex_admin_acf_get_related_term_field('entex_current_selector', $slug, $term_id);
	//update_field($field, $location, $term_id);
	//die($field);
	
	add_filter('redirect_term_location', function($l) use ($field, $term_id, $location){ 
		//update_field('entex_current_selector', $location, 'category_'.$term_id);
		//update_term_meta($term_id, 'entex_current_selector', $location);
		//die(get_term_meta($term_id, 'entex_current_selector', true));
		return $l;
	});
	

}
add_action('edited_term', 'entex_admin_save_current_selector_taxonomy', 30, 3);
add_action('created_term', 'entex_admin_save_current_selector_taxonomy', 30, 3);


/* -------------------- */
// SAVE FIELDS SINGULAR

function entex_admin_save_current_selector_singular($post_id) {
	
	if(wp_is_post_revision($post_id)) return;
	if(defined('DOING_AJAX') && DOING_AJAX) return;
	if(!current_user_can('edit_posts', $post_id)) return;
	
	/* Bail if the 'key' field not populated */
	$location = get_post_meta($post_id, 'entex_location_selector', true);
	if(empty($location) || $location == 'none') return;
	
	$delete = get_post_meta($post_id, 'entex_delete_selector', true);

	/* Bail if no content or collection is populated, except if delete */
	if(!$delete && empty(get_post_meta($post_id, 'entex_content_selector', true)) && empty(get_post_meta($post_id, 'entex_taxonomy_selector', true))) return;

	$meta = 'entex_selectors';
	
	/* Get existing saved locations */
	$selectors = get_post_meta($post_id, $meta, true);
	if(!is_array($selectors)){
		unset($selectors);
		$selectors = array();
	}
	
	if($delete){
		
		/* Mission accomplished */
		delete_post_meta($post_id, 'entex_delete_selector');

		delete_post_meta($post_id, 'entex_inactive_selector_'.$location);
		delete_post_meta($post_id, 'entex_content_selector_'.$location);
		delete_post_meta($post_id, 'entex_position_selector_'.$location);
		delete_post_meta($post_id, 'entex_template_selector_'.$location);
		delete_post_meta($post_id, 'entex_inclusion_selector_'.$location);
		delete_post_meta($post_id, 'entex_location_selector_'.$location);
		delete_post_meta($post_id, 'entex_parent_selector_'.$location);
		delete_post_meta($post_id, 'entex_taxonomy_selector_'.$location);
		delete_post_meta($post_id, 'entex_taxonomy_selector_active_'.$location);

		if(!empty($selectors)){
			if(isset($selectors[$location])){
				unset($selectors[$location]);
			}
			if(!empty($selectors)){
				foreach($selectors as $next => $name) {
					if($next){
						$move = $next;
						break;
					}
				}
			}
		}
		
		if(isset($move)){
			
			update_post_meta($post_id, 'entex_inactive_selector', get_post_meta($post_id, 'entex_inactive_selector_'.$move, true));
			update_post_meta($post_id, 'entex_content_selector', get_post_meta($post_id, 'entex_content_selector_'.$move, true));
			update_post_meta($post_id, 'entex_position_selector', get_post_meta($post_id, 'entex_position_selector_'.$move, true));
			update_post_meta($post_id, 'entex_template_selector', get_post_meta($post_id, 'entex_template_selector_'.$move, true));
			update_post_meta($post_id, 'entex_inclusion_selector', get_post_meta($post_id, 'entex_inclusion_selector_'.$move, true));
			update_post_meta($post_id, 'entex_location_selector', get_post_meta($post_id, 'entex_location_selector_'.$move, true));
			update_post_meta($post_id, 'entex_parent_selector', get_post_meta($post_id, 'entex_paren_selector_'.$move, true));
			update_post_meta($post_id, 'entex_taxonomy_selector', get_post_meta($post_id, 'entex_taxonomy_selector_'.$move, true));
			update_post_meta($post_id, 'entex_taxonomy_selector_active', get_post_meta($post_id, 'entex_taxonomy_selector_active_'.$move, true));
			
			update_post_meta($post_id, 'entex_current_selector', $move);
			update_post_meta($post_id, $meta, $selectors);
			
		} else {
			
			delete_post_meta($post_id, 'entex_inactive_selector');
			delete_post_meta($post_id, 'entex_content_selector');
			delete_post_meta($post_id, 'entex_position_selector');
			delete_post_meta($post_id, 'entex_template_selector');
			delete_post_meta($post_id, 'entex_inclusion_selector');
			delete_post_meta($post_id, 'entex_location_selector');
			delete_post_meta($post_id, 'entex_parent_selector');
			delete_post_meta($post_id, 'entex_taxonomy_selector');
			delete_post_meta($post_id, 'entex_taxonomy_selector_active');
			
			delete_post_meta($post_id, 'entex_current_selector');
			delete_post_meta($post_id, $meta);
		}
		
		
		return;
	}
	
	/* Always remove */
	delete_post_meta($post_id, 'entex_delete_selector');
	
	/* Load (populate) if 'missmatch' with existing location */
	$current = get_post_meta($post_id, 'entex_current_selector', true);
	if($current && isset($selectors[$location]) && $current != $location){
		
		update_post_meta($post_id, 'entex_inactive_selector', get_post_meta($post_id, 'entex_inactive_selector_'.$current, true));
		update_post_meta($post_id, 'entex_content_selector', get_post_meta($post_id, 'entex_content_selector_'.$current, true));
		update_post_meta($post_id, 'entex_position_selector', get_post_meta($post_id, 'entex_position_selector_'.$current, true));
		update_post_meta($post_id, 'entex_template_selector', get_post_meta($post_id, 'entex_template_selector_'.$current, true));
		update_post_meta($post_id, 'entex_inclusion_selector', get_post_meta($post_id, 'entex_inclusion_selector_'.$current, true));
		update_post_meta($post_id, 'entex_location_selector', get_post_meta($post_id, 'entex_location_selector_'.$current, true));
		update_post_meta($post_id, 'entex_parent_selector', get_post_meta($post_id, 'entex_location_selector_'.$current, true));
		update_post_meta($post_id, 'entex_taxonomy_selector', get_post_meta($post_id, 'entex_taxonomy_selector_'.$current, true));
		update_post_meta($post_id, 'entex_taxonomy_selector_active', get_post_meta($post_id, 'entex_taxonomy_selector_active_'.$current, true));
			
		return;
	}
	
	/* Save new or override */
	
	/* In sync with available locations */
	$field = entex_admin_acf_load_entex_location_selector_choices(array());
	$name = $field['choices'][$location];
	$selectors[$location] = $name;

	/* Move ACF fields into suffix fields */
	update_post_meta($post_id, $meta, $selectors);
	update_post_meta($post_id, 'entex_inactive_selector_'.$location, get_post_meta($post_id, 'entex_inactive_selector', true));
	update_post_meta($post_id, 'entex_content_selector_'.$location, get_post_meta($post_id, 'entex_content_selector', true));
	update_post_meta($post_id, 'entex_position_selector_'.$location, get_post_meta($post_id, 'entex_position_selector', true));
	update_post_meta($post_id, 'entex_template_selector_'.$location, get_post_meta($post_id, 'entex_template_selector', true));
	update_post_meta($post_id, 'entex_inclusion_selector_'.$location, get_post_meta($post_id, 'entex_inclusion_selector', true));
	update_post_meta($post_id, 'entex_location_selector_'.$location, get_post_meta($post_id, 'entex_location_selector', true));
	update_post_meta($post_id, 'entex_parent_selector_'.$location, get_post_meta($post_id, 'entex_location_selector', true));
	update_post_meta($post_id, 'entex_taxonomy_selector_'.$location, get_post_meta($post_id, 'entex_taxonomy_selector', true));
	update_post_meta($post_id, 'entex_taxonomy_selector_active_'.$location, get_post_meta($post_id, 'entex_taxonomy_selector_active', true));
	
	/* Finally, populate 'current' with this location */
	update_post_meta($post_id, 'entex_current_selector', $location);

}
add_action('save_post', 'entex_admin_save_current_selector_singular', 30, 1);

// END: SAVE FIELDS
/* ******************** */


function entex_admin_acf_load_entex_map_latlong($field){

	global $post;
	if(isset($post->ID)){
		$meta = get_post_meta($post->ID, 'entex_map_latlong', true);
		if($meta) return $field;
		
		$data = get_post_meta($post->ID, '_wp_attachment_metadata', true);
		if(isset($data['image_meta']['latlng']) && $data['image_meta']['latlng']){
			list($lat, $lng) = explode(',', $data['image_meta']['latlng'], 2); 
			$field['center_lat'] = $lat;
			$field['center_lng'] = $lng;
		}
	}
	return $field;
}
add_filter('acf/load_field/name=entex_map_latlong', 'entex_admin_acf_load_entex_map_latlong');

function entex_admin_acf_load_entex_map_hidden($field){
	
	global $post;
	if(isset($post->ID)){
		$data = get_post_meta($post->ID, '_wp_attachment_metadata', true);
		if(isset($data['image_meta']['latlng']) && $data['image_meta']['latlng']){
			$field['value'] = $data['image_meta']['latlng'];
		}
		add_action('admin_footer', 'entex_admin_acf_javascript_entex_map_import');
	}
	return $field;
}
add_filter('acf/load_field/name=entex_map_hidden', 'entex_admin_acf_load_entex_map_hidden');

function entex_admin_acf_javascript_entex_map_import(){

		$add = "
(function($) {
	$(document).ready(function(){
		$(document).on('click', '[data-name=entex_map_import] [value=import]', function(){
			var value = $('[data-name=entex_map_hidden]').find('input').val();
			if(value){
				$('[data-name=entex_map_latlong]').find('input.search').val(value).trigger('change');
				$('[data-name=entex_map_latlong]').find('[data-name=search]').trigger('click');
			}
			$(this).prop('checked', false);
		});
	});
})(jQuery);
		";
		wp_register_script('entex-admin-acf-assets-map', '', array('jquery'), '', true);
		wp_enqueue_script('entex-admin-acf-assets-map');
		wp_add_inline_script('entex-admin-acf-assets-map', $add);
}

function entex_admin_acf_save_entex_map_import($post_id){ 
	
	$values = get_fields($post_id);
	//echo '<pre>'. var_dump($values) .'</pre>'; die();
	if(isset($values['entex_map_import'][0]) && $values['entex_map_import'][0] == 'remove'){
		$data = get_post_meta($post_id, '_wp_attachment_metadata', true);
		if(empty($data)) return;
		$data['image_meta']['latlng'] = '';
		remove_action('acf/save_post', 'entex_admin_acf_save_entex_map_import', 20);
		wp_update_attachment_metadata($post_id, $data);
		delete_post_meta($post_id, 'entex_map_import');
		delete_post_meta($post_id, 'entex_map_hidden');
		
	} else if(isset($values['entex_map_latlong']['lat']) && $values['entex_map_latlong']['lat']){
		$meta = $values['entex_map_latlong']['lat'] .','. $values['entex_map_latlong']['lng'];
		$data = get_post_meta($post_id, '_wp_attachment_metadata', true);
		if(empty($data)) return;
		$data['image_meta']['latlng'] = $meta;
		remove_action('acf/save_post', 'entex_admin_acf_save_entex_map_import', 20);
		wp_update_attachment_metadata($post_id, $data);
	}
}
add_action('acf/save_post', 'entex_admin_acf_save_entex_map_import', 20);





/* -------------------- */
// CUSTOM FIELD: GOOGLE MAP
/* populates the initial zoom to admin ACF custom field */
function entex_admin_acf_load_entex_map_location_choices($field){
	
	$meta = false;
	global $pagenow;
	if($pagenow == 'term.php' || $pagenow == 'edit-tags.php'){
		$term_id = null;
		$value = entex_request_get('tag_ID');
		if($value) $term_id = $value;
		if($term_id){
			$meta = get_term_meta($term_id, 'entex_map_zoom', true);
			if($meta) $field['zoom'] = absint($meta);
			$meta = get_term_meta($term_id, 'entex_map_height', true);
			if($meta) $field['height'] = absint($meta);
		}
	} else {
		global $post;
		if(isset($post->ID)){
			$meta = get_post_meta($post->ID, 'entex_map_zoom', true);
			if($meta) $field['zoom'] = absint($meta);
			$meta = get_post_meta($post->ID, 'entex_map_height', true);
			if($meta) $field['height'] = absint($meta);
		}
	}
    return $field;
}
add_filter('acf/load_field/name=entex_map_location', 'entex_admin_acf_load_entex_map_location_choices');


/* Transport zoom click on map to custom field */
function entex_admin_acf_javascript_maps(){
	$add = "
(function($) {
	$(document).ready(function(){
		$(document).on('click', '.gm-bundled-control-on-bottom button.gm-control-active[type=\"button\"]', function(){
			var value = $('[data-name=\"entex_map_zoom\"]').find('input').val();
			if($(this).is(':first-child')) value++;
				else value--;
			$('[data-name=\"entex_map_zoom\"]').find('input').val(value).trigger('change');
		});
		$(document).on('change', '[data-name=\"entex_map_height\"] input[type=\"range\"]', function(){
			$('[data-name=\"entex_map_location\"]').find('.canvas').css('height', $(this).val() + 'px');
		});

	});
})(jQuery);

(function($) {
	$(document).ready(function(){
		$(document).on('change', '[data-filter=\"taxonomy\"]', function(){
			$(this).closest('.inside.acf-fields').find('[data-name=\"entex_taxonomy_selector\"]').find('input').val($(this).val());
		});

	});
})(jQuery);
	
	";
	wp_register_script('entex-admin-acf-assets-zoom', '', array('jquery'), '', true);
	wp_enqueue_script('entex-admin-acf-assets-zoom');
	wp_add_inline_script('entex-admin-acf-assets-zoom', $add);
}
add_action('admin_footer', 'entex_admin_acf_javascript_maps');


// END: GOOGLE MAP
/* ******************** */

// -- END FILE -- //