<?php if(!defined('ABSPATH')) die();

// Updated 2022 09 28

// YOAST PLUGIN
/* Entex theme support for: Yoast SEO */
/* Single functions, actions and filters */ 



/* -------------------- */
// ALWAYS USE POST-THUMBNAIL
/* same as medium_large */
function entex_theme_wpseo_opengraph_image_size($default){
	if(has_post_thumbnail()) return 'post-thumbnail';
		else return $default;
}
add_filter('wpseo_opengraph_image_size', 'entex_theme_wpseo_opengraph_image_size', 30, 1);



/* -------------------- */
// CUSTOM REPLACEMENT
/* Yoast settings for front-end output */
/* add %%entex%% to replacement field setup */
/* NOTE: THE TITLE IS INCLUDED - remove the default yoast title placeholder ! */

function entex_wpseo_replacement_entex(){
	if(is_admin()){
		// placeholder should never occur in back-end ! //
		$title = esc_html_x('NOTE: entex replacement should not occur', 'Admin', 'entex');
	} else {
		
		$is = entex_theme_fn_get_is();
		$title = $is['title'];
		
		// KEEP IN SYNC WITH DOCUMENT TITLE FILTER
		/* translators: */ 
		$title = sprintf(_x('%1$s at %2$s', 'Document title: Headline at Sitename', 'entex'), $title, get_bloginfo('name', 'display'));
		
		/* skip blogname on multipages */
		/* multipage variable contains page 1 of ... and we skip that on first paged page on archives */
		if($is['is-multipage'] != 'No' && $is['is-paged'] == 'Yes'){
			$title = $is['title'];
			$title = $title .' - '. mb_strtolower($is['is-multipage']);
		}
		
		/* filter */ // SHARED WITH DOCUMENT TITLE FILTER
		$title = strip_tags(apply_filters('entex_theme_document_title_archive', $title));
		$title = esc_attr(trim($title));

	}
	return $title;
}

function entex_wpseo_register_extended_title_replacements(){
	wpseo_register_var_replacement('%%entex%%', 'entex_wpseo_replacement_entex', 'advanced', 'Use entex contextual title');
}
add_action('wpseo_register_extra_replacements', 'entex_wpseo_register_extended_title_replacements');



/* replace %%title%% and populate the entex replacement */
/* this is running on all front-end pageloads */
function entex_theme_filter_option_wpseo_titles($wpseo_titles){

	$original = $wpseo_titles;
	remove_filter('option_wpseo_titles', 'entex_theme_filter_option_wpseo_titles', 30, 1);
	
	/* use entex theme css */
	$wpseo_titles['breadcrumbs-boldlast'] = '';
	$wpseo_titles['breadcrumbs-sep'] = '';
	
	/* circut */
	//return $wpseo_titles;
		
	/* Entex theme handle archives as default */
	if(defined('ENTEX_THEME_EXTENDED_TITLE_ARCHIVE_DEFAULT_YOAST')) return $wpseo_titles;
	
	/* the only thing this do with current definitions is populate the schema with same as document title */

	if(!is_admin()){
		foreach($wpseo_titles as $index => $value){
			$validate = entex_theme_validate_option_wpseo_titles($index, $value, $original);
			if($validate){
				$wpseo_titles[$index] = '%%entex%%';
			} 
		}
	}
	return $wpseo_titles;
}
add_filter('option_wpseo_titles', 'entex_theme_filter_option_wpseo_titles', 30, 1);


/* helper */
function entex_theme_validate_option_wpseo_titles($index, $value, $original){
	
	/* note, conditionals like is_author() not initiated by WordPress yet */
	$protected = apply_filters('entex_theme_protected_keys_option_wpseo_titles', array(
		'title-search-wpseo',
		'title-404-wpseo'
	), $index, $value, $original);
	
	if(in_array($index, $protected)) return false;
	if(substr($index, 0, 6) != 'title-') return false;
	if(strpos($value, '%%') === FALSE) return false;

	return true;
}



/* -------------------- */
// USE ENTEX EXCERPT SYSTEM

function entex_theme_add_wpseo_metadesc($metadesc){
	if(is_admin()) return $metadesc;
	if(!$metadesc){
		if(is_singular()){
			add_filter('entex_theme_excerpt_indicate', 'entex_return_false', 30, 1);
			$metadesc = get_the_excerpt();
			remove_filter('entex_theme_excerpt_indicate', 'entex_return_false', 30, 1);
		} else {
			$is = entex_theme_fn_get_is();
			$metadesc = $is['description'];
			/* filter */
			$metadesc = apply_filters('entex_theme_wpseo_archive_description', $metadesc, $is);
		}
	}
	/* wpautop might be applied by entex theme */
	return trim(esc_attr(strip_tags($metadesc)));
}
add_filter('wpseo_metadesc', 'entex_theme_add_wpseo_metadesc', 30, 1);

/* -------------------- */
// OVERRIDE REPLACEMENTS 

function entex_theme_filter_wpseo_replacements_excerpt($replacements){
	if(isset($replacements['%%excerpt%%'])){
		add_filter('entex_theme_excerpt_indicate', 'entex_return_false', 30, 1);
		$excerpt = get_the_excerpt();
		remove_filter('entex_theme_excerpt_indicate', 'entex_return_false', 30, 1);
		if($excerpt) $replacements['%%excerpt%%'] = $excerpt;
	}
	return $replacements;
}
add_filter('wpseo_replacements', 'entex_theme_filter_wpseo_replacements_excerpt', 30, 1);




/* -------------------- */
// BACKEND JAVASCRIPT REPLACEMENTS
/* load excerpt to snippets preview */
/* loading: assets/js/entex-theme-admin-yoast.js */

function entex_admin_enqueue_scripts_yoast($hook){
	
	if(!function_exists('entex_theme_get_extended_main_title')) return;
	
	global $post;
	if(isset($post->ID) && class_exists('WPSEO_Option_Titles')){

		$post_id = $post->ID;
		$meta = entex_theme_get_extended_main_title($post_id);
		if(!$meta) return;

		$handle = 'entex-theme-admin-yoast';
		wp_enqueue_script($handle, get_template_directory_uri().'/assets/js/'. $handle .'.js', array('jquery'), null);
	
		add_filter('entex_theme_excerpt_indicate', 'entex_return_false', 30, 1);
		$excerpt = get_the_excerpt();
		remove_filter('entex_theme_excerpt_indicate', 'entex_return_false', 30, 1);
		
		wp_localize_script($handle, 'ENTEX_THEME_ADMIN_YOAST', array(
			'excerpt' => $excerpt
		));
	}
	
}
add_action('admin_enqueue_scripts', 'entex_admin_enqueue_scripts_yoast', 30, 1);

/* ******************** */




/* -------------------- */
// YOAST BREADCRUMBS 

function entex_theme_wp_seo_last_crumb($link_info, $index, $crumbs){

	if(is_front_page()){
		
		/* this does not affect schemas as it is not applied on startpage */
		/* translators: */
		$welcome = sprintf(_x('Welcome to %s', 'Breadcrumbs', 'entex'), entex_theme_fn_get_blogname());
	
		/* filter */ // return false to disable
		$welcome = apply_filters('entex_breadcrumbs_label_welcome', $welcome);
		if($welcome) $link_info['text'] = $welcome;
		
		return $link_info;
	}
	
	$n = 1;
	if(is_paged()){
		foreach($crumbs as $crumb){
			foreach($crumb as $key => $arr){
				if($key == 'hide_in_schema') $n++;
			}
		}
	}
	$last = (count($crumbs) - $n);

	/* This is the only way to target the closest parent crumb */
	if(isset($link_info['title'])) unset($link_info['title']);
	if($index == ($last - 1)) $link_info['title'] = _x('Closest level up', 'Breadcrumbs', 'entex');

	/* This is the only way to target the first (Home) crumb */
	if(!defined('ENTEX_BREADCRUMBS_SHOW_HOME_ON_TOP_LEVEL_PAGES') && is_singular()){
		if(count($crumbs) == 2 && $index == 0) $link_info['title'] = '¤'; 
	}
	return $link_info;
}


function entex_theme_init_wp_seo_last_crumb(){
	add_filter('wpseo_breadcrumb_single_link_info', 'entex_theme_wp_seo_last_crumb', 10, 3);
}
add_action('after_setup_theme', 'entex_theme_init_wp_seo_last_crumb', 30, 1);


/* -------------------- */
// TEMPLATE BODY CLASS
function entex_theme_filter_body_class_wpseo($classes){
	if(defined('ENTEX_BREADCRUMBS_YOAST')) $classes[] = 'ua-crumbs-wpseo';
	if(defined('ENTEX_BREADCRUMBS_YOAST_SHOW_ALL')) $classes[] = 'ua-crumbs-wpseo-all';
	return $classes;
}
add_filter('body_class', 'entex_theme_filter_body_class_wpseo');

// END : YOAST BREADCRUMBS
/* ******************** */



/* -------------------- */
// THEME CASE - enhance attachemnts SEO
/* Yoast + entex index visibility plugin */
/* IF Yoast accept attachment pages, AND allow search engines to find them */
/* The visibility plugin hides them if conditionals are met: */
/* Only attached media with proper description (post_content) are passing through */
/* If so, the attachment page is scaled down, no sidebars and no comments */
/* But enhanced with author box, social sharing and meta description taken from the content -instead of the propably smaller caption */
/* All other attachment pages will be treated No index, Not in sitemaps, and all hidden visibility functions that the plugin provide */
/* Any individual attachment edit settings (by any plugin) will override this function below */
// REMEMBER: If Yoast attachment redirect away from attachment pages is turned ON, this will not have any effect 

function entex_theme_enhance_attachment_pages($page_template){
	
	/* in case */
	if(is_admin()) return $page_template;
	if(function_exists('entex_noindex')){
		if(!defined('ENTEX_PLUGIN_INDEX_VISIBILITY_FILTER_ATTACHMENT_ENABLE')) return $page_template;
		if(entex_noindex()) return $page_template;
	}
	
	add_filter('entex_template_filter_output_sticky_sidebar', '__return_false');
	
	/* Override column settings */
	add_filter('body_class', function($classes){
		$classes[] = 'ua-doc-set-full';
		return $classes;
	}, 10, 1);

	/* Remove 'sidebar' */
	add_filter('entex_template_aside', function($render){
		return false;
	}, 10, 1);
	
	/* force content as description */
	add_filter('wpseo_metadesc', function($metadesc){
		global $post;
		return esc_attr(strip_tags($post->post_content));
	}, 999, 1);
	
	/* remove location map */
	add_filter('entex_template_render_entry_post_thumbnail_map', '__return_false');
	
	/* remove comments utils */
	add_filter('comments_open', '__return_false');
	
	return $page_template;
}
add_filter('attachment_template', 'entex_theme_enhance_attachment_pages', 10 , 1);

// END 
/* ******************** */




// -- END FILE -- //