<?php 

// Updated 2021 12 17

// SCRIPTLESS SOCIAL SHARING
/* Entex theme support for: Scriptless social sharing */
/* Single functions, actions and filters */ 

/* Remember that this functionality only add the link to each social media or services */
/* The target page included in the url argument should be optimized with OpenGraph meta */
/* Scriptless does NOT add any meta tags or additional information, except the title - if sharing service not 'using' meta - like email */
/* As of default, we always allow scriptless to render the buttons */
/* As we use them in 'entries' on all archives and custom post types - by the choice of template and where the buttons are filtered in */
/* As this is scriptless, no javascript needed to render the links, only our theme ajax 'show sharing links' listener is always loaded */


/* -------------------- */
// ALLOW HANDLERS AND ADDITIONAL STYLE

function entex_plugin_scriptless_social_sharing_styles(){
	
	$add = '';
	$add .= '.scriptlesssocialsharing a.button { text-shadow: none; } .ua-init .scriptlesssocialsharing__heading { margin-bottom: 0.5em; } ';
	$add .= '.ua-init .article-is-loop .scriptlesssocialsharing__heading { display: none; } ';
	$add .= '.scriptlesssocialsharing:last-child { margin-bottom: 0px; } ';
	
	$handle = 'entex-theme-social-sharing';
	wp_register_style($handle, false);
	wp_enqueue_style($handle); 
	wp_add_inline_style($handle, $add);

}
add_action('wp_enqueue_scripts', 'entex_plugin_scriptless_social_sharing_styles', 10, 60);




/* -------------------- */
// ACTIVATE ALWAYS (almost)
/* The theme takes care of validation */

function entex_plugin_scriptless_social_sharing_cando($cando){
	if(is_feed()) return $cando;
	if(!wp_doing_ajax() && is_admin()) return $cando;
	return true;
}
add_filter('scriptlesssocialsharing_can_do_buttons', 'entex_plugin_scriptless_social_sharing_cando', 10, 1);



/* -------------------- */
// ACTIVATE ON FILTER ARGUMENT
/* make shure we have a unique filter instead of __return_true */
/* in case plugins filter as well on the same priority */
/* should be filtered in and filtered out on priority 20 */

function entex_plugin_scriptless_social_sharing_force($cando){
	return true;
}



/* -------------------- */
// Manually disable singular ids from child theme functions.php
// Note: Global scope, both on singular and each entry, uses $post->ID
// PRIORITY: 40 - default Entex plugins uses 30 as priority

function entex_plugin_scriptless_social_sharing_manually_disabled($cando){
	if(defined('ENTEX_THEME_SOCIAL_SHARING_DISABLED_IDS')){
		if(!is_array(ENTEX_THEME_SOCIAL_SHARING_DISABLED_IDS)){
			$str = ENTEX_THEME_SOCIAL_SHARING_DISABLED_IDS;
			$array = explode(',', $str);
		} else $array = ENTEX_THEME_SOCIAL_SHARING_DISABLED_IDS;
		if(!empty($array) && is_array($array)){
			if(in_array(get_the_ID(), $array)) $cando = false;
		}
	}
	return $cando;
}
add_filter('scriptlesssocialsharing_can_do_buttons', 'entex_plugin_scriptless_social_sharing_manually_disabled', 40, 1);



/* -------------------- */
// FILTER 'IN' CONTENT - To the default theme wrapper
/* make shure validate argument is in use - save some speed */
/* template actions might check if there are valid buttons for entries */
/* The entry meta filter is in use by default to render sharing links by ajax */

function entex_plugin_get_scriptless_social_sharing($content, $indent, $force, $validate_only = false){
	
	/* this can never be filtered out: */
	$is_disabled = get_post_meta(get_the_ID(), '_scriptlesssocialsharing_disable', true);
	if(!$is_disabled && function_exists('entex_noindex')){
		$is_disabled = entex_noindex(get_the_ID());
	}
	if($is_disabled) return '';
	if($force) add_filter('scriptlesssocialsharing_can_do_buttons', 'entex_plugin_scriptless_social_sharing_force', 20, 1);
	
	$cando = apply_filters('scriptlesssocialsharing_can_do_buttons', false);
	if(!$cando) return '';
	
	/* everything validated */
	if($validate_only) $content = true;
		else $content = scriptlesssocialsharing_do_buttons();
		
	/* cleanup filters */
	if($force) remove_filter('scriptlesssocialsharing_can_do_buttons', 'entex_plugin_scriptless_social_sharing_force', 20, 1);
	return $content;
}
add_filter('entex_template_get_social_sharing_content', 'entex_plugin_get_scriptless_social_sharing', 10, 4);



/* -------------------- */
// USE THEME RENDERING HOOKS 

/* filter in extended titles */
function entex_plugin_scriptless_social_sharing_title($title){
	$title = entex_template_get_the_title(get_the_ID(), true, false);
	$title = html_entity_decode($title);
	return $title;
}
add_filter('scriptlesssocialsharing_posttitle', 'entex_plugin_scriptless_social_sharing_title', 10, 1);


/* make shure we provide an excerpt and without any read more or tags */
function entex_plugin_scriptless_social_sharing_description($description){
	
	add_filter('entex_theme_excerpt_indicate', 'entex_return_false', 30, 1);
	$description = get_the_excerpt();
	remove_filter('entex_theme_excerpt_indicate', 'entex_return_false', 30, 1);
	$description = trim(esc_attr(strip_tags($description)));
	return $description;
}
add_filter('scriptlesssocialsharing_description', 'entex_plugin_scriptless_social_sharing_description', 10, 1);


/* Set permalink to the link url on post format link */
/* NOTE: This means sharing the linked page, not your entry or post */
function entex_plugin_scriptlesssocialsharing_url($permalink, $name, $attributes){

	if((in_the_loop() && get_post_format() == 'link') || (wp_doing_ajax() && get_post_format() == 'link')){
		$permalink = entex_theme_filter_post_link_subtitle_url(get_permalink());
	}
	return $permalink;
}
add_filter('scriptlesssocialsharing_get_permalink', 'entex_plugin_scriptlesssocialsharing_url', 10, 3);


/* set Entex theme normal image size (medium_large = post-thumbnail) */
function entex_plugin_scriptlesssocialsharing_image_size($size){
	return 'post-thumbnail';
}
/* this filter only apply to the hidden content image when using individual post meta box settings */
add_filter('scriptlesssocialsharing_pinterest_image_size', 'entex_plugin_scriptlesssocialsharing_image_size', 10, 1);


function entex_plugin_scriptlesssocialsharing_image_url($url){
	$post_id = get_the_ID();
	$attachment_id = get_post_meta($post_id, '_scriptlesssocialsharing_pinterest', true);
	if(!$attachment_id) $attachment_id = get_post_meta($post_id, '_thumbnail_id', true);
	if($attachment_id){
		$source = wp_get_attachment_image_src($attachment_id, 'post-thumbnail', false);
		if(isset($source[0])) $url = $source[0];
	}
	return $url;
}
add_filter('scriptlesssocialsharing_image_url', 'entex_plugin_scriptlesssocialsharing_image_url', 10, 1);


/* pinterest description - default uses featured image alt attribute */
/* if individual post meta box not set, we use the featured image caption instead */
/* as this is often more related content description - what user expected to share - not an image explanation */
function entex_plugin_scriptlesssocialsharing_get_post_metadata($value, $post_id, $meta_key){
	remove_filter('get_post_metadata', 'entex_plugin_scriptlesssocialsharing_get_post_metadata', 10, 3);
	if($meta_key == '_scriptlesssocialsharing_description'){
		$default = get_post_meta($post_id, $meta_key, true);
		if(!$default){
			$attachment_id = get_post_meta($post_id, '_thumbnail_id', true);
			if($attachment_id){
				$attachment = get_post($attachment_id);
				if($attachment->post_excerpt) $value = trim(esc_attr(strip_tags($attachment->post_excerpt)));
			}
		}
	}
	add_filter('get_post_metadata', 'entex_plugin_scriptlesssocialsharing_get_post_metadata', 10, 3);
	return $value;
}
add_filter('get_post_metadata', 'entex_plugin_scriptlesssocialsharing_get_post_metadata', 10, 3);





/* -------------------- */
// THEME AJAX META BUTTON

function entex_template_get_entry_share_link($content){
	$link = entex_template_get_meta_share_link();
	$content .= $link;
	return $content;
}
add_filter('entex_template_add_entry_meta_content', 'entex_template_get_entry_share_link', 30, 1);


function entex_template_get_meta_share_link(){
	
	/* last argument only return bool of valid output of 'filtered in' buttons */
	$content = apply_filters('entex_template_get_social_sharing_content', '', 0, true, true);
	if(!$content) return '';
	
	/* remove footer share */
	remove_action('entex_template_entry_footer_content', 'entex_template_output_social_sharing', 10, 1);
	$label = esc_attr_x('Share this', 'Meta: Share this label', 'entex');
	
	$cl = 'ua-meta-share';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '<i title="'. $label .'"></i></span>';//<span><a class="ua-meta-share-icon" href="#"></a></span>';
	return $SP_S. entex_theme_fn_get_share_link() .$SP_E;
}


function entex_theme_ajax_output_share_this_callback(){
	
	$post_id = entex_request_get('post_id');
	if(!$post_id) return '';
	
	global $post; 
	$post = get_post($post_id); // phpcs:ignore
	setup_postdata($post);
	
	ob_start();
	entex_template_output_social_sharing(1, true);
	$response = ob_get_clean();
	
	wp_reset_postdata();

	wp_send_json($response);
}
add_action('wp_ajax_entex_theme_ajax_output_share_this', 'entex_theme_ajax_output_share_this_callback');
add_action('wp_ajax_nopriv_entex_theme_ajax_output_share_this', 'entex_theme_ajax_output_share_this_callback');

/* -------------------- */
// ASSETS: SHARE THIS LINK

function entex_theme_enqueue_scripts_share_this(){
	
	$current = entex_theme_fn_get_is();

	$add = '

.entex-wrapper-share-this.ua-button-loading { padding: 1em; } 
@media screen and (min-width: 768px) { .entex-wrapper-share-this svg { display: none; } .entex-wrapper-share-this svg + .sss-name { margin-left: 0px; margin-right: 0px; } } 

.ua-ajax-share:after { content: " | "; display: inline; padding: 0px 5px 0px 3px; color: #dbdbdb; }
.ua-ajax-share + i:before { content: ""; padding-left: 1em; background-repeat: no-repeat; background-position: left calc(50% + 1px); opacity: 0.55; } 
.ua-ajax-share + i:before { cursor: pointer; background-image: url("data:image/svg+xml;charset=utf8,%3Csvg%20xmlns%3D%27http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%27%20viewBox%3D%270%200%2020%2020%27%3E%3Cpath%20d%3D%27M14.5%2012q1.24%200%202.12.88T17.5%2015t-.88%202.12-2.12.88-2.12-.88T11.5%2015q0-.34.09-.69l-4.38-2.3Q6.32%2013%205%2013q-1.24%200-2.12-.88T2%2010t.88-2.12T5%207q1.3%200%202.21.99l4.38-2.3q-.09-.35-.09-.69%200-1.24.88-2.12T14.5%202t2.12.88T17.5%205t-.88%202.12T14.5%208q-1.3%200-2.21-.99l-4.38%202.3Q8%209.66%208%2010t-.09.69l4.38%202.3q.89-.99%202.21-.99z%27%20fill%3D%27%2382878c%27%2F%3E%3C%2Fsvg%3E"); }
.ua-ajax-share + i:hover:before { opacity: 1; } 

.ua-expander.ua-is-closed .entex-wrapper-share-this { display: none; }

	';
	
	wp_register_style('entex-theme-share-this', false);
	add_action('get_footer', function() use ($add) { wp_enqueue_style('entex-theme-share-this'); wp_add_inline_style('entex-theme-share-this', $add); });
	
	
	$text = esc_html_x('Please wait, loading ...', 'While loading (content)', 'entex');
	$add = '';
	$add .= "
;( function( $ ) {
	
	$(document).ready(function(){
		if($('.ua-ajax-share').get(0)){
			$(document).on('click', '.ua-ajax-share', function(){

				if($(this).hasClass('ua-fn-is-active')){
					$(this).removeClass('ua-fn-is-active');
					$(this).closest('article').find('header .entex-wrapper-share-this').remove();
					return false;
				}
				
				$(this).addClass('ua-fn-is-active');
				var obj = this;
				var id = $(this).attr('data-post-id');

				var info = ''; // not in use
				var wrapper = $('<div/>').addClass('ua-wrapper ua-relative ua-button-loading ua-not-main entex-wrapper-share-this').text('". $text ."');
				$(this).closest('article').find('header').append(info, wrapper);
				
				var data = { action: 'entex_theme_ajax_output_share_this', 'post_id': id };
				var ajaxurl = '".admin_url('admin-ajax.php')."';
				
				$.get(ajaxurl, data, function(response){
					wrapper.removeClass('ua-button-loading');
					wrapper.html(response);
					$('html, body').stop().animate({ scrollTop: (wrapper.offset().top) - 50 }, 500);
				});
				return false;
			});
			
			$(document).on('click', '.ua-ajax-share + i', function(){
				$(this).prev().trigger('click');
				return false;
			});
		}
	});
	
})(jQuery);
	";
	
	wp_register_script('entex-theme-share-this', '', array('jquery'), '', true);
	wp_enqueue_script('entex-theme-share-this');
	wp_add_inline_script('entex-theme-share-this', $add);
	
	
}
add_action('wp_enqueue_scripts', 'entex_theme_enqueue_scripts_share_this', 10);

// END : THEME AJAX
/* ******************** */


// -- END FILE -- //