<?php if(!defined('ABSPATH')) die(); 

// ENTEX TEMPLATE SOURCECODE
/* For education and our students */
/* For better structured sourcecode */
/* Theme developers can easy find current function or hook in use */

/**
 * Templates sourcecode hooks, actions and functions
 * Every template has a standard action
 * At the beginning and at the end of each template file
 * The latter might be obmitted if there is no purpose
 *
 * Those actions can be diabled global by constants, 
 * individually removed or replaced in your child theme
 * Suggest de-register between 'after_setup_theme' and 'wp_head' hooks
 *
 * But they should remain as they is extreme useful
 * They do not impact on performance and they are only
 * visible calculated for administrators
 *
 * UPDATED 2021 07 10
 *
**/

// Developers:
// All available filters are pre-commented with: /* filter */ for easy search




/* -------------------- */
// ALL TEMPLATE ACTIONS 'hooks'

/* header.php */
add_action('wp_head', 'entex_template_output_action_comment', -5, 1);
add_action('entex_template_header_column_1', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_header_column_2', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_before_main_section', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_before_main_content', 'entex_template_output_action_comment', 5, 1); 

/* footer.php */ 
add_action('entex_template_after_main_content', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_before_sidebar', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_sidebar', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_after_main_section', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_footer_column_1', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_footer_column_2', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_footer_column_3', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_before_wp_footer', 'entex_template_output_action_comment', 5, 1);
add_action('wp_footer', 'entex_template_output_action_comment', -5, 1);

/* index.php */
add_action('entex_template_before_archive_title', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_after_archive_title', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_before_archive_loop', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_after_archive_loop', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_archive_footer', 'entex_template_output_action_comment', 5, 1);

/* article.php */ 
// AND SINGULAR TEMPLATE FILES
add_action('entex_template_before_singular_title', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_after_singular_title', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_before_singular_content', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_after_singular_content', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_singular_footer_before_content', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_singular_footer_content', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_singular_footer_after_content', 'entex_template_output_action_comment', 5, 1); 
add_action('entex_template_singular_end', 'entex_template_output_action_comment', 5, 1);

/* article-entries.php */ 
// AND ENTRIES TEMPLATE FILES
add_action('entex_template_before_entry_header', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_before_entry_title', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_after_entry_title', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_before_entry_content', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_after_entry_content', 'entex_template_output_action_comment', 5, 1);

add_action('entex_template_entry_footer_before_content', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_entry_footer_content', 'entex_template_output_action_comment', 5, 1);
add_action('entex_template_entry_footer_after_content', 'entex_template_output_action_comment', 5, 1);


/* -------------------- */
// ALL TEMPLATE ACTIONS FUNCTION

/**
 * Keeps the linebreak flow intact 
 * on empty actions inside html sourcecode 
 * This action circuit early if not administrator
 *
**/

function entex_template_output_action_comment($indent = 0){
	
	if(defined('ENTEX_SOURCECODE_COMMENT_ACTION_DISABLE')) return '';
	if(!current_user_can('activate_plugins')){
		$note = _x('A', 'Source code helper: DO NOT TRANSLATE', 'entex');
		entex_OUT('<!-- '. $note .' -->');
		return;
	}
	
	global $wp_filter;
	$hook = current_filter();

	/**
	 * Render how many uses the current hook
	 * Use as 'hint', same priority will not be calculated 
	 * we just need to know if 'any else' is hooked 
	 * Use 'not calculated' ('nc') on none entex functions for now
	 *
	**/
	
	$callbacks = (count($wp_filter[current_filter()]->callbacks) -1);
	if(!$callbacks) $note = _x('possible action', 'Source code helper: DO NOT TRANSLATE', 'entex');
		else $note = _x('action', 'Source code helper: DO NOT TRANSLATE', 'entex');

	
	if(strpos($hook, 'entex') === FALSE) $callbacks = _x('nc', 'Source code helper: DO NOT TRANSLATE', 'entex');
	$note = _x('action', 'Source code helper: DO NOT TRANSLATE', 'entex') .' : '. current_filter() .' ('. $callbacks .')';
	
	entex_OUT('<!-- '. $note .' -->');
}






/* -------------------- */
// MAIN OUTPUT FUNCTION

/**
 * Render current template in use inside HTML sourcecode 
 * This 'end chain' function does not use $indent, as the 'caller' should already be in place 
 * However, if caller is chained inside PHP scope, the $indent might be needed 
 * The indent must be rendered before this function call manually from case to case  
 *
**/

function entex_template_output_source_comment($note = '', $file = '', $backtrace = ''){
	
	/* In case this function is in use outside entex theme */
	/* Otherwise this is already checked by default hook functions */
	if(defined('ENTEX_SOURCECODE_COMMENT_DISABLE')) return;

	if(!$note) $note = _x('TEMPLATE START', 'Source code helper: DO NOT TRANSLATE', 'entex');
	if(!current_user_can('manage_options')) $output = entex_CMN(0, $note);
		else $output = '<!-- '. $note . ($file ? ' : '. basename($file) : '') . ($backtrace ? ' '. _x('INCLUDED BY', 'Source code helper: DO NOT TRANSLATE', 'entex') .' : '. $backtrace : '') .' -->';
	entex_OUT($output);
}





/* -------------------- */
// ADDED AS ACTIONS FROM TEMPLATES

/**
 * This call is only allowed inside included template part files
 * This function does not use $indent, as the 'caller' should already be in place 
 * The current indent is passed through this action anyway
 * In case of other kind of hook usage
**/

function entex_template_comment_before_template($indent, $note = '', $file = '', $backtrace = '', $devider = true){
	
	if(defined('ENTEX_SOURCECODE_COMMENT_DISABLE')) return;
	if(!$note) $note = _x('TEMPLATE START', 'Source code helper: DO NOT TRANSLATE', 'entex');
	if($devider) entex_OUT(entex_CML());
	entex_template_output_source_comment($note, $file, $backtrace);
}
add_action('entex_template_before_template', 'entex_template_comment_before_template', 10, 5);


function entex_template_comment_after_template($indent, $note = '', $file = '', $backtrace = '', $devider = true){
	
	if(defined('ENTEX_SOURCECODE_COMMENT_DISABLE')) return;
	/* this hook uses (swaps) $backtrace argument as $file */
	if(!$note) $note = _x('BACK TO', 'Source code helper: DO NOT TRANSLATE', 'entex');
	if(!current_user_can('manage_options')) $note = _x('Template end', 'Source code helper: DO NOT TRANSLATE', 'entex');
	if($backtrace){
		$file = $backtrace;
		$backtrace = '';
	}
	entex_template_output_source_comment($note, $file, $backtrace);
	if($devider) entex_OUT(entex_CML());
}
add_action('entex_template_after_template', 'entex_template_comment_after_template', 10, 5);







/* -------------------- */
// ADDED AS ACTIONS FROM FUNCTIONS

/**
 * Render current function in use inside HTML sourcecode 
 * Should be used inside functions that are called 'directly' from a template file 
 *
**/

function entex_template_comment_before_function($indent, $note = '', $file = '', $backtrace = '', $fn = '', $line = ''){
	
	if(defined('ENTEX_SOURCECODE_COMMENT_DISABLE')) return;
	if($indent) echo wp_kses_post(entex_IND($indent, 0));
	
	if(!$note) $note = 'FUNCTION';
	$content = $note;
	$content .= ($file ? ' '. _x('in', 'Source code helper: DO NOT TRANSLATE', 'entex') .' : '. basename($file) : '');
	$content .= ($fn ? ' : '. $fn .'()' : '');
	$content .= ($line ? ' '. _x('on line', 'Source code helper: DO NOT TRANSLATE', 'entex') .' '. $line : '');
	if(!current_user_can('manage_options')) $content = _x('F', 'Source code helper: DO NOT TRANSLATE', 'entex');
	entex_template_output_source_comment($content, '', $backtrace);
}
add_action('entex_template_before_function', 'entex_template_comment_before_function', 10, 6);


function entex_template_comment_after_function($indent, $note = '', $file = '', $backtrace = ''){
	
	if(defined('ENTEX_SOURCECODE_COMMENT_DISABLE')) return;
	/* this hook uses (swaps) $backtrace argument as $file */
	if(!$note) $note = _x('BACK TO', 'Source code helper: DO NOT TRANSLATE', 'entex');
	if($backtrace){
		$file = $backtrace;
		$backtrace = '';
	}
	entex_template_output_source_comment($note, $file, $backtrace);
}
add_action('entex_template_after_function', 'entex_template_comment_after_function', 10, 4);



// -- END FILE -- //