<?php if(!defined('ABSPATH')) die(); 

// ENTEX TEMPLATE ELECTOR 
// UPDATED 2021 12 05

// Developers:
// All available filters are pre-commented with: /* filter */ for easy search

function entex_theme_output_selected_template($ids, $included, $_template, $_inclusion, $loop = 0){

	global $post;
	if(!$loop && strpos($_template, '-section-') !== FALSE){
		$_inclusion = false;
	}	
	$_index = 0;
	$current_init_post = $post;
	$posts_per_page = (string) count($ids);

	$r = new WP_Query(
		apply_filters('entex_selector_arguments', 
			array(
				'post_type' => 'any', 
				'post_status' => 'any', 
				'post__in' => $ids, 
				'orderby' => 'post__in', 
				'offset' => '0', 
				'posts_per_page' => $posts_per_page,
				'ignore_sticky_posts' => true
			), $ids, $included, $_template, $_inclusion
		)
	);
	
	if($r->have_posts()){
		while($r->have_posts()) : $r->the_post();

			$currentPost = $post;

			if(!$loop) $template = apply_filters('entex_theme_selected_template', $_template, $post);
				else $template = $_template;
			
			if($template != $_template && strpos(str_replace('\\', '/', $template), '/wp-content/') !== FALSE){
				load_template($template, false, get_query_var('args'));
			} else {
			
				/* note: template must exists, we dont validate deleted templates or changed filenames here */
				if($template) get_template_part(str_replace('.php', '', $template), get_post_type(), get_query_var('args'));
					else get_template_part(str_replace('.php', '', ENTEX_TEMPLATE_DEFAULT_ENTRIES), get_post_type(), get_query_var('args'));
			}
			
			/* inclusion within inclusion */
			$bail = get_post_meta(get_the_ID(), 'entex_inactive_selector', true);
			if($_inclusion && !$bail){ 
				$ids = entex_selector_taxonomy_ids(get_the_ID(), false, false);
				if(empty($ids)){ 
					$ids = get_post_meta(get_the_ID(), 'entex_content_selector', true);
				}
			} else $ids = array();

			if($_inclusion && !empty($ids)){
				$ids = array_diff($ids, $included);
				if(!empty($ids)){
					$loop++;
					$included = array_merge($included, $ids);

					$template = get_post_meta(get_the_ID(), 'entex_template_selector', true);
					if($template == 'default') $template = '';
					$inclusion = get_post_meta(get_the_ID(), 'entex_inclusion_selector', true);
			
					entex_theme_output_selected_template($ids, $included, $template, $inclusion, $loop);
					$loop--;
					$post = $currentPost; // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
				}
			} 
			
		endwhile;
		wp_reset_postdata();
	}
	
	$post = $current_init_post; // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
}


// END : CONTENT SELECTOR
/* ******************** */


// USED BY SHORTCODES
/* no location, uses current loaded selector data from current post */
/* NOTE: You should use output buffering if calling directly */

function entex_template_output_selector(){
	
	/* comment */
	do_action('entex_template_before_function', 0, 
		'', 
		__FILE__, ua_backtrace(2), 
		__FUNCTION__, __LINE__
	);

	$bail = get_post_meta(get_the_ID(), 'entex_inactive_selector', true);
	if($bail) return '';

	$included = array(get_the_ID());
	$ids = get_post_meta(get_the_ID(), 'entex_content_selector', true);

	if(!empty($ids)){
		$ids = array_diff($ids, $included);
		if(!empty($ids)){

			$included = array_merge($included, $ids);
			$template = get_post_meta(get_the_ID(), 'entex_template_selector', true);
			if($template == 'default') $template = '';
			$inclusion = get_post_meta(get_the_ID(), 'entex_inclusion_selector', true);
			
			entex_theme_output_selected_template($ids, $included, $template, $inclusion, $loop = 0);
		}
	}
}


// -- END FILE -- //