<?php if(!defined('ABSPATH')) die(); 

// ENTEX TEMPLATE POST DATA

/**
 * Template sourcecode hooks, actions and functions
 * These are the actions and functions that manipulates post data
 * Such as quries and passing template variables
 * These are in fact template actions
 * But they resident in seperate file as they take space
 * And they doesnt render the HTML output themselfs
 *
 * Updated: 2021 07 18
 *
**/

// Developers:
// All available filters are pre-commented with: /* filter */ for easy search
// removed set_query_var( in setup data



/* -------------------- */
// QUERY MORE ENTRIES ON SEARCH RESULTS etc

function entex_template_add_more_entries($query){
	
	if(is_admin() || !$query->is_main_query()) return;
	if(is_author() || is_date() || is_search()){
		$default = absint(get_option('posts_per_page'));
		$query->set('posts_per_page', ($default * 2));
	}
}
add_action('pre_get_posts', 'entex_template_add_more_entries', 9999, 1);






/* -------------------- */
// QUERY REMOVE REDUNDANCY POSTS

/**
 * This idea is still under development but seems stable
 * Any post that already is rendered on the page-load
 * Are excluded by the next query
 * To keep SEO friendly content
 * And reduce same 'recent post' in widgets
 * thats already promoted elsewhere or
 * is the current post
 *
 * NOTE:
 * This affects everything!
 * Use the constant to turn this on/off
 *
**/

function entex_template_remove_rendered_entries($query){
	
	if(!is_admin()){
		if(isset($GLOBALS['ENTEX-IDS-IN-LOOP'])){
			if(defined('ENTEX_FILTER_REDUNDANCY_POSTS')) $query->set('post__not_in', $GLOBALS['ENTEX-IDS-IN-LOOP']);
		}
	}
}
add_action('pre_get_posts', 'entex_template_remove_rendered_entries');





/* -------------------- */
// ENTEX TEMPLATE SETUP
// Makes variables available in template file scope
// REMARK: This is a global action, every single queried post is passing through this hook

/**
 * This is the Theme template core function
 * 
 * This function is called everytime 'while (have_posts()) : the_post();' is running
 * Its main purpose is to provide a few unique variables for any theme template
 * It also makes it possible to switch templates within the same Query (list of entries)
 * And finally decide templates for each type, taxonomy or term through custom fields or filters
 *
 * This function does not hurt anything for plugins or custom queries and other templates
 * It is a standard WordPress way and more flexible since 4.4 made second query argument available
 * As long as plugin templates not interfear with the names:
 *
 * $_entex_current_template
 * $_entex_current_specialised
 * $_breakpoint
 *
 * The use of theese are exactly the same as: get_template_part('', '')
 * We just populate them here instead
 *
 * The other reserved namespaces are:
 *
 * $args['index'] 	= each entry of current loop, start on 1 NOT zero, resets on paged scope
 * $args['init'] 	= first entry (1) of the complete query within current paged scope
 * $args['total'] 	= last entry (and number of total entries) of the complete query within current paged scope
 * $args['id']  	= id of each entry (like $post->ID or get_the_ID())
 *
 * Each $_breakpoint (1-4) may switch template, if defined, 5 diffrent layout can be use on each query
 * The following variables below are relative to each 'new' loaded template:
 *
 * $args['current'] = counter (1 -> ) from first entry assigned to current template
 * $args['start'] 	= true if first entry of current loop, or first entry after breakpoint
 * $args['end'] 	= true if last entry of current loop, or last entry before next breakpoint
 * $args['odd'] 	= based on $args['current
 * $args['even'] 	= based on $args['current
 *
 *
 * TRANSPORTED DATA between templates / scope
 * The $args variable is reset here on each entry
 * But templates can be 'chained' and the 'master' template can pass the data to the next included template
 * Since version 5.0 WordPress allow us to pass the arguments like: get_template_part('', '', $args)
 * When using 'flex' template layout(s), the $args['start'] and $args['start'] should be manually adjusted
 * 
 *
 * IMPORTANT: The standard use of global $post object must be intact
 *
 * The variables are only accessible in immediately loaded template
 * To accesss within function calls use like: get_query_var('args') without the $ prefix
 *
 * NOTE: Variables are only accessible within new WP_query, NOT get_posts() and foreach() - use entex_theme_get_entex() for that
 * But $_breakpoint is global, if defined within plugins, $args['current'] and $args['end'] will be set
 *
 *
 * FINALLY: The inclusion contents & widget engine are using the same function, means
 * you can 'template output' everywhere inside the Theme locations, sidebars and defined areas
 * as long as: new WP_query is in use by: the_post()
 *
**/

$GLOBALS['ENTEX-INCLUDED'] = false;
function entex_fn_setup_postdata($post, $query){

	if(empty($query->posts)) return;

	$included = false;
	if($GLOBALS['ENTEX-INCLUDED']) $included = true;

	// ALL:

	$post_format = get_post_format();
	$post_type = get_post_type();
	$id = get_the_ID();
	
	if(is_paged()) $paged = true;
		else $paged = false;
	
	$index = absint($query->current_post);
	$index++;
	$current = $index;
	$total = count($query->posts);
		
	if($index == 1 && !$paged) $init = true;
		else $init = false;
		
	if($index == $total) $end = true;
		else $end = false;
		
	// ENTEX ONLY:
	
	if(!is_admin() && in_the_loop() && !$included){ 

		/* talks with index.php */
		/* ToDo: this will be passed as arguments later */
		global $_entex_current_template;
		global $_entex_current_specialised;
		
		if($post_format) $_entex_current_specialised = $post_format;
			else $_entex_current_specialised = $post_type;
			
		/* default overrides */
		/* equalizes the template call (no specialized) for complete query */
		/* as we dont want the entries to jump between post types or formats */
		/* We cant reach those conditionals through custom fields */
		
		$extended = false;
		if(defined('ENTEX_EXTENDED_TEMPLATES_ENABLE')){
			
			if(is_author()){
				if(!defined('ENTEX_EXTENDED_TEMPLATES_DISABLE_AUTHOR')){
					$extended = true;
					$_entex_current_specialised = 'author';
				}
			}
			if(is_search()){
				if(!defined('ENTEX_EXTENDED_TEMPLATES_DISABLE_SEARCH')){
					/* this occurs when &s= on archives */
					/* like woocommerce shop page on seach products */
					if(!is_post_type_archive()){
						$extended = true;
						$_entex_current_specialised = 'search';
					} else {
						$value = filter_input(INPUT_GET, 'post_type', FILTER_SANITIZE_STRING);
						if($value){
							/* make shure the template return null */
							/* if you dont wanna render wrong post type */
							/* Example is 'product' */
							/* Pages are always in search but the product template only accepts true post type product */
							$extended = true;
							$_entex_current_specialised = $value;
						}
					}
				}
			}
			if(is_date()){
				if(!defined('ENTEX_EXTENDED_TEMPLATES_DISABLE_DATE')){
					$extended = true;
					$_entex_current_specialised = 'date';
				}
			}
			if(is_tax() || is_category() || is_tag()){
				if(!defined('ENTEX_EXTENDED_TEMPLATES_DISABLE_TAXONOMY')){
					/* NOTE: calling front-end contextual data */
					/* This is not allowed to run in backend */
					$is = entex_theme_fn_get_is();
					if($is['taxonomy']){
						$extended = true;
						$locate = $post_type.'-'.'taxonomy';
					}
				}
			}
			if(is_home()){
				/* note: always the more template */
				if(defined('ENTEX_EXTENDED_TEMPLATES_ENABLE_MORE_ON_HOME')){
					$extended = true;
					$_entex_current_specialised = 'more';
				}
			}
		}
		
		if(!$extended && defined('ENTEX_EXTENDED_TEMPLATES_ENABLE_MORE_FIRST')){
			/* check this last */
			if($init && !is_singular()){
				$more = entex_theme_fn_has_more();
				if($more) {
					$_entex_current_specialised = 'more';
					/* early priority - let everyone else override this */
					add_filter('entex_entry_breakpoint_1', 'entex_entry_add_breakpoint_1', -5);
				}
			}
		}
		

		// && $id == get_queried_object_id()
		if(is_singular() && $total == 1){
		
			$default = ENTEX_TEMPLATE_DEFAULT_SINGULAR;
			
			/* filter */ 
			// Note: Only use this filter as default Theme setting, otherwise scroll down ...
			$_entex_current_template = apply_filters('entex_singular_template_default', $default, $id, $index, $current, $total);
		
		} else {

			$default = ENTEX_TEMPLATE_DEFAULT_ENTRIES;
			
			/* filter */
			// Note: Only use this filter as default Theme setting in rare cases, otherwise scroll down ...
			$_entex_current_template = apply_filters('entex_entry_template_default', $default, $id, $index, $current, $total);

			
			/**
			 * Breakpoints are set by Theme customizer mod or custom fields
			 * Or on taxonomies edit screen, through ACF fields API
			 * The fields are filtered in here, if populated
			**/
		
			/* filter */
			$breakpoint_1 = apply_filters('entex_entry_breakpoint_1', 0, 1, $id, $index, $current, $total);
			$breakpoint_2 = apply_filters('entex_entry_breakpoint_2', 0, 2, $id, $index, $current, $total);
			$breakpoint_3 = apply_filters('entex_entry_breakpoint_3', 0, 3, $id, $index, $current, $total);
			$breakpoint_4 = apply_filters('entex_entry_breakpoint_4', 0, 4, $id, $index, $current, $total);
		
			if($breakpoint_1 && $index == $breakpoint_1) $end = true;

			if($breakpoint_1 && $index > $breakpoint_1){
				/* filter */
				$_entex_current_template = apply_filters('entex_entry_template_breakpoint_1', $_entex_current_template, 1, $id, $index, $current, $total);
				$current = ($index - $breakpoint_1);
				if($index == $breakpoint_2) $end = true;
			}
			if($breakpoint_2 && $index > $breakpoint_2) {
				/* filter */
				$_entex_current_template = apply_filters('entex_entry_template_breakpoint_2', $_entex_current_template, 2, $id, $index, $current, $total);
				$current = ($index - $breakpoint_2);
				if($index == $breakpoint_3) $end = true;
			}
			if($breakpoint_3 && $index > $breakpoint_3){
				/* filter */
				$_entex_current_template = apply_filters('entex_entry_template_breakpoint_3', $_entex_current_template, 3, $id, $index, $current, $total);
				$current = ($index - $breakpoint_3);
				if($index == $breakpoint_4) $end = true;
			}
			if($breakpoint_4 && $index > $breakpoint_4){
				/* filter */
				$_entex_current_template = apply_filters('entex_entry_template_breakpoint_4', $_entex_current_template, 4, $id, $index, $current, $total);
				$current = ($index - $breakpoint_4);
			}
		}
		
		if(isset($locate)){
			$template = str_replace('.php', '', $_entex_current_template).'-'.$locate.'.php';
			$located = locate_template($template, false);
			if($located) $_entex_current_specialised = $locate;
			//	else $_entex_current_specialised = $post_type;
		} else $locate = '';
		


		/* filter */ // MAIN FILTERS - use in case of filter templates from other templates
		$_entex_current_template = str_replace('.php', '', apply_filters('entex_current_template', $_entex_current_template, $post_format, $post_type, $locate, $included));
		$_entex_current_specialised = apply_filters('entex_current_specialised', $_entex_current_specialised, $post_format, $post_type, $locate, $included);
		
		// RECORDING IDS
		$GLOBALS['ENTEX-IDS-IN-LOOP'][] = $id;
		
		// END ENTEX ONLY
		
	} else {

		// ALL:
		/* Provide to all queries ONE breakpoint option */
		/* You must define and global the $_breakpoint in your plugin */
		/* The $_breakpoint must be unset() after your custom loop */
		
		global $_breakpoint;

		if(isset($_breakpoint)){
			if($index == $_breakpoint) { $end = true; }
			if($_breakpoint && $index > $_breakpoint) { $current = ($index - $_breakpoint); }
		}
	}
	
	// ALL:
	
	$start = ($current == 1 ? true : false);

	/* Relative to current template: */
	
	if($current & 1) $odd = true;
		else $odd = false;
	if(!$odd) $even = true;
		else $even = false;

	/* PLEASE SYNC THIS WITH entex_theme_get_entex() */
	$_entex['init'] = $init;
	$_entex['index'] = $index;
	$_entex['start'] = $start;
	$_entex['total'] = $total;
	$_entex['current'] = $current;
	$_entex['id'] = $id;
	$_entex['odd'] = $odd;
	$_entex['even'] = $even;
	$_entex['end'] = $end;
	$_entex['paged'] = $paged;
	$_entex['included'] = $included;
	
	/* reset */
	$_entex['chain'] = false;
	$_entex['flex'] = false;
	
	/* reset */
	$_entex['HEADING'] = '';
	$_entex['HEADER_CLASS'] = '';
	$_entex['TEMPLATE_CLASS'] = '';
	
	set_query_var('_entex', $_entex); //- dep
	set_query_var('args', $_entex);

}
add_action('the_post', 'entex_fn_setup_postdata', 10, 2);





// MAKE THEME TEMPLATES COMPATIBLE WITH THIRD PART EXTENSIONS
// if any loop not using new WP Query, the_post filter not passing query data
// This occurs like get_posts() and foreach ...

/* Call this when get_posts() is looped */
/* $args = entex_theme_get_entex(); */
/* pass current nr in loop as index (start on zero) */
/* pass count($posts) as $total */
/* When using get_post() or only ONE post is setup no arguments are needed */
/* NOTE: You shuld use: setup_postdata($post) to make shure ALL wp fn is working */

function entex_theme_get_entex($index = 0, $total = 1, $id = null){
	
	$index++;
	$current = $index;
	$paged = false;
	if($index == 1 && !$paged) $init = true;
		else $init = false;
	$start = ($current == 1 ? true : false);
		
	if($index == $total) $end = true;
		else $end = false;

	if($current & 1) $odd = true;
		else $odd = false;
	if(!$odd) $even = true;
		else $even = false;
		
	if(!$id) $id = get_the_ID();
	$included = false;
	if($GLOBALS['ENTEX-INCLUDED']) $included = true;

	$_entex['init'] = $init;
	$_entex['index'] = $index;
	$_entex['start'] = $start;
	$_entex['total'] = $total;
	$_entex['current'] = $current;
	$_entex['id'] = $id;
	$_entex['odd'] = $odd;
	$_entex['even'] = $even;
	$_entex['end'] = $end;
	$_entex['paged'] = $paged;
	$_entex['included'] = $included;
	$_entex['continue'] = ''; // dep
	
	/* reset */
	$_entex['chain'] = false;
	$_entex['flex'] = false;
	
	/* reset */
	$_entex['HEADING'] = '';
	$_entex['HEADER_CLASS'] = '';
	$_entex['TEMPLATE_CLASS'] = '';
	
	return $_entex;
}

// END : TEMPLATE SETUP
/* ******************** */

/* helper */
function entex_entry_add_breakpoint_1(){
	return 1;
}
/* helper */
function entex_entry_add_breakpoint_2(){
	return 5;
}

// -- END FILE -- //