<?php if(!defined('ABSPATH')) die(); 

// ENTEX TEMPLATE OUTPUT
/* Mostly NOT attached as add_action */


/**
 * These are the HTML 'output' functions 'called' directly from template files
 * They are NOT attached as add_action 
 * All functions that constructs HTML markup should remain here
 * Many functions inside functions are resident in diffrent files
 * Those functions only collects the data
 * Note,
 * Some expected HTML might be a WordPress filter
 * WordPress Filters are not handled here
 * Any filter function in this file, 
 * are here because they are direct related to an actions below
 *
 * @version 2.221110
 *
**/

// Developers:
// All available filters are pre-commented with: /* filter */ for easy search




/* -------------------- */
// CONTENT
/**
 * This output content only without any surrounded wrappers
 * This should be used in templates that includes other content
 * Content allows shortcodes
 * And content might contain shortcodes that reset post data
 * This fixes that
 *
**/


function entex_template_output_content($indent = 0, $more = ''){
	entex_OUT(entex_template_get_content($indent, $more));
}

function entex_template_get_content($indent = 0, $more = ''){
	
	if(post_password_required()) return '';
	
	/* comment */
	do_action('entex_template_before_function', 0, 
		'', 
		__FILE__, entex_backtrace(2), 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';
	
	/* Allow shortcodes within entries */
	/* But they might reset post data */
	
	global $post;
	$currentPost = $post;
	
	if($more){
		$more = entex_theme_fn_get_more();
		if($more) $content = get_the_content(true);
			else $content = get_the_content();
	} else $content = get_the_content();

	
	$content = apply_filters('the_content', $content);
    $content = str_replace(']]>', ']]&gt;', $content);
	
	/* Restore current post variable */
	$post = $currentPost; // phpcs:ignore

	if(!$content) return '';
	$html .= entex_CMD(esc_html_x('content', 'DO NOT TRANSLATE', 'entex')).$content.entex_CMD();
	
	/* filter */
	$html = apply_filters('entex_template_get_content_html', $html, $content);
	$output = $html;
	return $output;
}

/* -------------------- */
// CONTENT AS SHORTCODE: 
// NOTE uses ob_start(); MUST return ob_end_clean() NOT return '' after ob_start();
/* Allow function call or template based output */

function entex_template_get_content_shortcode($atts){
	
	extract(shortcode_atts(array( 
		'id' => null, 
		'template' => '',
		'taxonomy' => '',
		'slug' => ''
    ), $atts));
	
	if(!$taxonomy){
		if(!$id || empty($id)) return '';
		$ids = array_map('trim', explode(',', $id));
	} else {
		
		$args = array(
			'post_type' => 'any', 
			'post_status' => 'any',
			'posts_per_page' => -1, // phpcs:ignore
			'ignore_sticky_posts' => true,
			'tax_query' => array(
				array(
					'taxonomy' => $taxonomy,
					'field' => 'slug',
					'terms' => $slug,
				)
			)
		);
	
		$posts = new WP_Query($args);
		$ids = wp_list_pluck($posts->posts, 'ID');
		unset($posts);
	}
	
	$source_id = get_the_ID();
	$ids = array_diff($ids, array($source_id));
	$included = array_merge($ids, array($source_id));

	if(!$template){
		$output = '';
		remove_filter('the_content', 'entex_theme_filter_the_content_article_end', -5, 1);
		foreach($ids as $id){
			$content = get_the_content(false, false, $id);
			$content = apply_filters('the_content', $content);
			$content = str_replace(']]>', ']]&gt;', $content);
			if($content) $output .= $content;
		}
		add_filter('the_content', 'entex_theme_filter_the_content_article_end', -5, 1);
		
		/* circut */
		if($output) return $output;
			else return '';
	}
	
	if($template) $_template = $template;
		else $_template = 'tmpl-contents/tmpl-contents-content.php';
	$_inclusion = false;
	
	ob_start();
	
	/* comment */
	do_action('entex_template_before_function', 0, 
		'', 
		__FILE__, ua_backtrace(2), 
		__FUNCTION__, __LINE__
	);
	
	entex_theme_output_selected_template($ids, $included, $_template, $_inclusion);
	$output = ob_get_contents();
	ob_end_clean();
	
	return $output;
}
/* shortcode moved into Entex Theme shortcodes plugin */






/* -------------------- */
// PREAMBLE
/* Move out the preamble from the content */
/* Output separate by actions elsewhere inside the Theme */
/* By default in use on singular content, added by action */
/* But works on entries as well as long as the templates can handle the extra element */
/* NOTE: many templates using GRID CSS Layout */

function entex_template_output_preamble($indent = 0, $data = array()){
	entex_OUT(entex_template_get_preamble($indent, $data));
}

function entex_template_get_preamble($indent = 0, $data = array()){
	
	if(post_password_required()) return '';
	
	/* comment */
	do_action('entex_template_before_function', 0, 
		'', 
		__FILE__, entex_backtrace(2), 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';
	
	if(isset($data['validate']) && $data['validate']) $validate = true;
		else $validate = false;
		
	$classname = 'is-style-ua-preamble';
	if(isset($data['classname']) && $data['classname']) $classname .= ' '. trim($data['classname']);

	/* if using custom field */
	if($validate) $meta = entex_theme_get_meta_preamble();
		else $meta = true;
		
	if($meta) $content = entex_theme_fn_get_preamble($element = false);
		else $content = '';
	if(!$content) return '';
	
	/* make shure the content not render the block */
	/* we asume the swap is only in use within the_loop */
	/* if not, this filter might has to be removed later on in the chain */
	add_filter('entex_theme_render_block_preamble_'. get_the_ID(), '__return_false');
		
	$SET_CLASS = '';
	if($classname) $SET_CLASS = ' class="'. esc_attr($classname) .'"';

	$html .= entex_IND($indent, 0).'<p'. $SET_CLASS .'>'. $content .'</p>'.entex_LBR();
	
	/* filter */
	$html = apply_filters('entex_template_get_preamble_html', $html, $content);
	$output = $html;
	return $output;
}



/* helper */
/* NOTE: Validate from template if necessary */
function entex_template_has_preamble($validate = false){
	if($validate){
		$meta = entex_theme_get_meta_preamble();
		if(!$meta) return false;
	}
	if(entex_theme_fn_get_preamble()) return true;
		else return false;
}

/* helper */
/* Action wrapper for singular content */
function entex_template_output_singular_preamble($indent = 0){
	
	/* comment */
	do_action('entex_template_before_function', 0, 
		'', 
		__FILE__, entex_backtrace(2), 
		__FUNCTION__, __LINE__
	);
	
	entex_template_output_preamble($indent, $data = array('validate' => true));
}
add_action('entex_template_before_singular_content', 'entex_template_output_singular_preamble', 9, 1);



/* -------------------- */
// ENTRY CONTENT

function entex_template_output_entry_content($indent = 0, $data = null){
	entex_OUT(entex_template_get_entry_content($indent, $data));
}

function entex_template_get_entry_content($indent = 0, $data = null){
	
	if(post_password_required()) return '';
	
	/* comment */
	do_action('entex_template_before_function', 0, 
		'', 
		__FILE__, entex_backtrace(2), 
		__FUNCTION__, __LINE__
	);
	
	$replacement = '';
	if(isset($data['empty'])){
		$empty = true;
		if(is_string($data['empty'])){
			$replacement = $data['empty'];
		} 
	} else $empty = false;
	
	$output = '';
	$html = '';
	$content = '';
	
	/* Allow shortcodes within entries */
	/* But they might reset post data */
	
	global $post;
	$currentPost = $post;
	
	if(isset($data['more']) && $data['more']) $more = true;
		else $more = false;
	if(isset($data['loop']) && $data['loop'] && !in_the_loop()) $more = false;
	
	if($more){
		if(get_post_type() == 'attachment'){
			$content = get_the_content();
		} else {
			$has_more = entex_theme_fn_get_more();
			if($has_more) $content = get_the_content(true);
		} 
		/* calling entry-content directly from template will return nothing if more does not exists */
		/* use entry-summary with more argument to auto replace with excerpt */
	} else $content = $post->post_content;
	
	$content = apply_filters('the_content', $content);
	
	/* remove undone/ leftowers shortcodes */
	if($content) $content = entex_fn_strip_shortcode($content);

	/* Restore current post variable */
	//$post = $currentPost;

	if(!$content && !$empty) return '';
	if(!$content && $replacement) $content = $replacement;
	
	if(isset($data['classname']) && $data['classname']) $classname = ' '. trim($data['classname']);
		else $classname = '';
	
	if(get_post_type() == 'attachment'){
		/* intercept the attribute values */
		if(strpos($content, 'wp-video') !== FALSE) $classname = ' ua-media-content ua-video-content'.$classname;
		if(strpos($content, 'wp-audio') !== FALSE) $classname = ' ua-media-content ua-audio-content'.$classname;
	}

	if($content){
		$html .= entex_IND($indent, 0).'<div class="entry-content ua-content'. esc_attr($classname) .'">'.entex_LBR();
		$html .= entex_CMD(esc_html_x('content', 'DO NOT TRANSLATE', 'entex')).$content.entex_CMD();
		$html .= entex_IND($indent, 0).'</div>'.entex_LBR();
	} else {
		$html .= entex_IND($indent, 0).'<div class="entry-content ua-content'. esc_attr($classname) .'"></div>'.entex_LBR();
	}
	
	/* filter */
	$data['indent'] = $indent;
	$html = apply_filters('entex_template_get_entry_content_html', $html, $content, $data);
	$output = $html;
	return $output;
}





/* -------------------- */
// ENTRY EXCERPT 

/**
 * The native wp_trim_excerpt() is removed within 'after_setup_theme' action 
 * The excerpt is filtered and re-created by entex_theme_wp_trim_excerpt() 
 * We want character count, not words, and default is set to Googles limited length  
 * The main function has: apply_filters('entex_theme_excerpt_length', 156) 
 * The $length can be passed as the second argument when called as function inside template file 
 *
**/

function entex_template_output_entry_excerpt($indent = 0, $data = null){
	if(get_post_type() == 'attachment') entex_OUT(entex_template_get_entry_content($indent, $data));
		else entex_OUT(entex_template_get_the_excerpt($indent, $data));
}

/* alias: get without p element */
function entex_template_get_entry_excerpt($indent = 0, $data = null){
	return strip_tags(entex_template_get_the_excerpt($indent, $data));
}

/* global - remark the function name */
function entex_template_get_the_excerpt($indent = 0, $data = null){
	
	/* comment */
	do_action('entex_template_before_function', 0, 
		'', 
		__FILE__, entex_backtrace(2), 
		__FUNCTION__, __LINE__
	);
	
	if(post_password_required()) return '';
	
	if(isset($data['more']) && $data['more']) $more = true;
		else $more = false;
	if(isset($data['loop']) && $data['loop'] && !in_the_loop()){
		$more = false;
	}
	
	
	if($more){
		$has_more = entex_theme_fn_get_more();
		if($has_more){
			/* circut */
			return entex_template_get_entry_content($indent, $data);
		} 
	}
	
	$replacement = '';
	if(isset($data['empty'])){
		$empty = true;
		if(is_string($data['empty'])){
			$replacement = $data['empty'];
		} 
	} else $empty = false;
	
	$tabindex = null;
	if(isset($data['tabindex']) && $data['tabindex']){
		if(is_bool($data['tabindex'])) $tabindex = '0';
			else $tabindex = $data['tabindex'];
	}
	
	if(isset($data['length'])){
		if($data['length'] === true) $GLOBALS['ENTEX-EXCERPT-CHAR-LENGTH'] = true;
			else $GLOBALS['ENTEX-EXCERPT-CHAR-LENGTH'] = (int) $data['length'];
	}
	
	if(isset($data['indicate'])){
		if(is_string($data['indicate'])){
			$indicate = entex_template_get_the_excerpt_more($data['indicate']);
		} else if($data['indicate'] === false){
			$indicate = '';
		} 
	} else $indicate = entex_template_get_the_excerpt_more();

	$classname = '';
	if(isset($data['classname']) && $data['classname']) $classname = ' '. $data['classname'];

	$output = '';
	$html = '';

	$content = get_the_excerpt();
	
	if(isset($GLOBALS['ENTEX-EXCERPT-CHAR-LENGTH'])){
		unset($GLOBALS['ENTEX-EXCERPT-CHAR-LENGTH']);
	}

	if(!$content && !$empty) return '';
	if(!$content && $replacement) $content = wp_kses_post($replacement);
		else if(!$content && $empty) $indicate = '';
	if($tabindex !== null) $SET_TABINDEX = ' tabindex="'. esc_attr($tabindex) .'"';
		else $SET_TABINDEX = '';
	if($content || $empty) $html .= entex_IND($indent, 0).'<p'. $SET_TABINDEX .' class="entry-summary'. esc_attr($classname) .'">'. $content . $indicate .'</p>'.entex_LBR();

	
	/* filter */
	$data['indent'] = $indent;
	$html = apply_filters('entex_template_get_the_excerpt_html', $html, $content, $data);
	$output = $html;
	return $output;
}


/* -------------------- */
// Read more constructor

function entex_template_get_the_excerpt_more($text = '', $post_id = null){
	
	$html = '';
	if(!$post_id) $post_id = get_the_ID();
	$default = apply_filters('entex_template_get_the_excerpt_more_indicate', '<span class="ua-indicate" style="white-space: nowrap;">&nbsp;...&nbsp;</span>', $post_id);
	
	/* variants translation ready */
	$more = esc_html_x('read more', 'Excerpt: Indication at the end', 'entex');
	$more = esc_html_x('Read more', 'Excerpt: Indication at the end', 'entex');
	if($text) $more = wp_kses_post($text);
	
	/* translators: */
	$hover = sprintf( _x('Continue reading %s', 'Excerpt: Continue reading [ page-title ]', 'entex'), strip_tags(entex_template_get_the_title($post_id)) );
	$reader = '<span class="screen-reader-text">'. esc_html($hover) .'</span>';
	$html .= ' ';
	$wrap = '<a class="ua-read-more" href="'. esc_url(get_permalink($post_id)) .'" title="'. esc_attr($hover) .'">'. $reader . $default .' <span class="ua-read-more-indicate" aria-hidden="true">'. $more .'</span></a>';
	$html .= '<span class="ua-read-more-wr ua-not-main">'. $wrap .'</span>';

	return $html;
}





/* -------------------- */
// POST THUMBNAIL

/**
 * Render or get the post thumbnail as image ONLY
 * Content source for many post thumbnail functions
 * But can render as stand alone if wanted image only
 * If post type is attachment, calculations are made
 *
 * Note: This function accepts fetch from ID:
 * Do not mixup the objectives, keep the $post flow in your planning
 * only pass ID if you totally replace the post-thumbnail with something else
 * The function bails if content by ID found, otherwise 
 *
**/

function entex_template_output_the_post_thumbnail($indent = 0, $size = 'post-thumbnail', $ID = null){
	entex_OUT(entex_template_get_the_post_thumbnail($indent, $size, $ID));
}

function entex_template_get_the_post_thumbnail($indent = 0, $size = 'post-thumbnail', $ID = null){
	
	
	/* this function is in use by filters ('post_class') */
	/* and should be separated later from the template output architecture */
	/* The comment action is removed - as filters might get the comment echoed - returning true */
	/* filters need the true fact if image is delivered by the theme */
	/* this 'template' function add placeholders or might returning other things */
	/* filters just wanna know if output will be done or not */
	

	/* comment */
	/* removed for now, read above */
	
	$output = '';
	$html = '';
	$content = '';
	
	/* new from 2020 07 */
	// -- CIRCUT -- //
	
	if($ID){
		$content = wp_get_attachment_image($ID, $size);
		if($content){
			$html = $content;
			/* filter */
			$html = apply_filters('entex_template_get_the_post_thumbnail_html', $html, $content, $size, $ID);
			$output = $html;
			return $output;
		}
	}
	
	if(get_post_type() == 'attachment' && !has_post_thumbnail()){
		if(wp_attachment_is_image()) $content = wp_get_attachment_image(get_the_ID(), $size);
			else $content = wp_get_attachment_image(get_the_ID(), $size, true);

	} else {
		/* this might be a document icon or so */
		$content = get_the_post_thumbnail(get_the_ID(), $size);
	}
	
	global $_entex_placeholder;
	if(!$content && isset($_entex_placeholder) && $_entex_placeholder){
		$content = wp_kses($_entex_placeholder, entex_wp_kses());
	}
	
	/* filter */
	$content = apply_filters('entex_template_get_the_post_thumbnail_placeholder', $content, $size, $ID);
	
	if(!$content) return '';
	$html = $content;
	
	/* filter */
	$html = apply_filters('entex_template_get_the_post_thumbnail_html', $html, $content, $size, $ID);
	$output = $html;
	return $output;
}



/* -------------------- */
// DEFAULT FILTERS 
/* available for template files */

function entex_template_get_the_theme_post_thumbnail_placeholder($content = '', $size = null){
	
	if(!$content){
		/* note: in child theme use: get_stylesheet_directory_uri() */
		$src = get_template_directory_uri() .'/assets/images/entex-theme-placeholder.png';
		$alt = get_bloginfo('name', 'display');
		$alt = get_the_title();
		$content = '<img src="'. esc_url($src) .'" alt="'. esc_attr($alt) .'" />';
	}
	return $content;
}


/* -------------------- */
// AS SHORTCODE:
/* Note: uses output buffering */

function entex_template_get_singular_post_thumbnail_shortcode($atts){

	extract(shortcode_atts(array( 
		'size' => 'post-thumbnail'
    ), $atts));
	
	$indent = 0;
	
	ob_start();
	
	/* comment */
	do_action('entex_template_before_function', 0, 
		'Indent not passed', 
		__FILE__, ua_backtrace(2), 
		__FUNCTION__, __LINE__
	);
	
	add_filter('entex_theme_filter_option_hide_post_thumbnail', 'entex_return_false', 30, 1);
	$content = entex_template_get_singular_post_thumbnail($indent, $size);
	remove_filter('entex_theme_filter_option_hide_post_thumbnail', 'entex_return_false', 30, 1);
	
	entex_OUT($content);
	$output = ob_get_contents();
	ob_end_clean();
	
	return $output;
}
/* shortcode moved into Entex Theme shortcodes plugin */






/* -------------------- */
// ATTACHMENT IMAGE BY ID

/**
 * Render or get the attachment as image ONLY
 * Note: This function accepts fetch from ID:
 * Do not mixup the objectives, keep the $post flow in your planning
 * This might be in use to render something else than post-thumbnail
 * Or call the image media as self-content on attachment pages
 * Handy when images has featured image to 'dubble-up' presentations
 * defult size is 'medium_large' instead of post-thumbnail
 * as we asume we want the whole captured image
 * 
**/

function entex_template_output_attachment_image($indent = 0, $size = 'medium_large', $ID = null, $data = null){
	entex_OUT(entex_template_get_attachment_image($indent, $size, $ID, $data));
}

function entex_template_get_attachment_image($indent = 0, $size = 'post-thumbnail', $ID = null, $data = null){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, entex_backtrace(2), 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';
	$content = '';
	
	if(!$ID) $ID = get_the_ID();
	if($ID){
		$content = wp_get_attachment_image($ID, $size);
	}
	if(!$content) return '';
	
	$caption = '';
	if(isset($data['caption']) && $data['caption']) $caption = get_the_excerpt($ID);
	
	$html .= entex_IND($indent, 0).'<figure>'.entex_LBR();
	$html .= entex_IND($indent, 1).'<a href="'. esc_url(wp_get_attachment_url($ID)) .'" target="_blank">'.entex_LBR();
	$html .= entex_IND($indent, 2).$content.entex_LBR();
	$html .= entex_IND($indent, 1).'</a>'.entex_LBR();
	if($caption) $html .= entex_IND($indent, 1).'<figcaption>'. $caption .'</figcaption>'.entex_LBR();
	$html .= entex_IND($indent, 0).'</figure>'.entex_LBR();
	
	/* filter */
	$html = apply_filters('entex_template_get_attachment_image_html', $html, $content, $size, $ID, $data);
	$output = $html;
	return $output;
}



/* -------------------- */
// SINGULAR POST THUMBNAIL

/**
 * Singular post thumbnail has no link wrapper
 * Singular is treated as 'main' thumbnail
 * It can also be hidden on landing page by Theme custom field
 * Other calculations like sizes might appear by filters
 * Or, not exists at all
 *
**/

function entex_template_output_singular_post_thumbnail($indent = 0, $size = ''){
	entex_OUT(entex_template_get_singular_post_thumbnail($indent, $size));
}

function entex_template_get_singular_post_thumbnail($indent = 0, $size = ''){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	if(post_password_required()) return '';
	$args = entex_get_multipage();
	if($args['page'] > 1) return '';
	
	/* Theme custom field */
	if(function_exists('entex_theme_get_meta_post_thumbnail_hide')){
		if(entex_theme_get_meta_post_thumbnail_hide()) return '';
	}
	
	$output = '';
	$html = '';
	
	if(!$size){
		if(is_attachment()) $size = 'medium_large';
			else $size = 'medium_large';
	}
	
	$content = entex_template_get_the_post_thumbnail($indent, $size);
	if(!$content) return '';
	
	$border = false;
	if(strpos($content, 'ua-image-border') !== FALSE) $border = 'ua-attachment-border';

	$SET_CLASS = '';
	$SET_STYLE = '';
	
	$classes = entex_theme_fn_get_post_thumbnail_classes($size);
	$classes[] = 'ua-attachment-singular';
	if($border) $classes[] = $border;
	
	if(is_attachment()) $attr = entex_fn_extract_attachment(get_the_ID(), apply_filters('entex_theme_filter_extract_attachment_max_value', 600));
	if(is_attachment() && !$attr['data-file-post-thumbnail'] && $attr['data-file-background']){
		if($attr['data-file-media-type'] == 'image'){
			$SET_STYLE = ' style="background-image: url('. esc_url($attr['data-file-background']) .');"';
			if($attr['data-file-repeat'] == 'repeat') $classes[] = ' ua-attachment-background ua-attachment-repeat';
				else $classes[] = ' ua-attachment-background';

		} else {
			$SET_STYLE = ' style="background-image: url('. esc_url($attr['data-file-background']) .');"';
			$classes[] = ' ua-attachment-background ua-attachment-icon';
		}
	}
	
	/* Above is a cached version of: */
	/*
	if(is_attachment() && !has_post_thumbnail()){
		if(wp_attachment_is_image()){
			list($width, $height) = getimagesize(get_attached_file(get_the_ID()));
			if($width < 600){
				$SET_STYLE = ' style="background-image: url('. wp_get_attachment_url(get_the_ID()) .');"';
				if($width < 5) $classes[] = ' ua-attachment-background ua-attachment-repeat';
					else $classes[] = ' ua-attachment-background';
			}
		} else {
			$SET_STYLE = ' style="background-image: url('. wp_mime_type_icon(get_the_ID()) .');"';
			$classes[] = ' ua-attachment-background ua-attachment-icon';
		}
	}
	*/

	$SET_CLASS = implode(' ', $classes);
	$caption = '';
	if(is_attachment()){
		global $post;
		$caption = strip_tags($post->post_excerpt);
	} else if(!defined('ENTEX_THEME_SINGULAR_CAPTION_DISABLE')){
		$attachment_id = get_post_thumbnail_id();
		if($attachment_id){
			$excerpt = strip_tags(get_the_excerpt($attachment_id));
			if($excerpt) $caption = $excerpt;
		}
	}
	
	$html .= entex_IND($indent, 0).'<div class="'. $SET_CLASS .'"'. $SET_STYLE .'>'.entex_LBR();
	$html .= entex_IND($indent, 1).$content.entex_LBR();
	
	/* filter */
	$html .= apply_filters('entex_template_get_singular_post_thumbnail_html_before_close', '', $indent, $size);
	
	/* action */
	do_action('entex_template_singular_post_thumbnail_html_before_close', $indent, $size);
	
	$html .= entex_IND($indent, 0).'</div>'.entex_LBR();
	if($caption) $html .= entex_IND($indent, 0).'<p class="ua-caption ua-not-main">'. strip_tags($caption) .'</p>'.entex_LBR();
	
	/* filter */
	$html = apply_filters('entex_template_get_singular_post_thumbnail_html', $html, $content, $size);
	$output = $html;
	return $output;
}






/* -------------------- */
// ENTRY POST THUMBNAIL

/**
 * Render the post thumbnail with permalink wrapper
 * In cases when post is restricted (password)
 * Or the post type is not a public landing page
 * Visibility must be calculated, and more
 * 
 * Note:
 * Circuits on post type attachment to another 'get'
 *
**/

function entex_template_output_entry_post_thumbnail($indent = 0, $size = 'post-thumbnail', $data = null){
	entex_OUT(entex_template_get_entry_post_thumbnail($indent, $size, $data));
}

function entex_template_get_entry_post_thumbnail($indent = 0, $size = 'post-thumbnail', $data = null){

	/* comment */
	do_action('entex_template_before_function', 0, 
		'', 
		__FILE__, entex_backtrace(2), 
		__FUNCTION__, __LINE__
	);
	
	if(post_password_required()) return '';
	
	/* filter */
	$public = apply_filters('entex_theme_unlink_post', true);
		
	/* Theme custom field */ 
	if(!$public){
		/* allow hidden featured images on none public post types */
		if(function_exists('entex_theme_get_meta_post_thumbnail_hide')){
			if(entex_theme_get_meta_post_thumbnail_hide()) return '';
		}
	}
	
	if(!$size) $size = 'post-thumbnail';
	
	global $post;
	
	$caption = '';
	$SET_CLASS = '';
	$SET_STYLE = '';
	
	$replacement = '';
	if(isset($data['empty']) && $data['empty'] !== FALSE){
		$empty = true;
		if(is_string($data['empty'])){
			/* not making sense yet */
			$replacement = wp_kses($data['empty'], entex_wp_kses());
		} 
	} else $empty = false;
	
	$permalink = true;
	if(isset($data['permalink']) && !$data['permalink']) $permalink = false;
	
	$background = false;
	if(isset($data['background']) && $data['background']) $background = $data['background'];
	
	$classname = '';
	if(isset($data['classname']) && $data['classname']) $classname = $data['classname'];
	
	$caption = false;
	$excerpt = '';
	if(isset($data['caption']) && $data['caption']) $caption = $data['caption'];
	
	$figure = false;
	if(isset($data['figure']) && $data['figure']) $figure = $data['figure'];
	
	$role = '';
	if(isset($data['role']) && $data['role']) $role = ' role="'. esc_attr($data['role']) .'"';
	
	if($figure) $element = 'figure';
		else $element = 'div';
		
	// BEGIN FETCH - might circut
	$content = entex_template_get_the_post_thumbnail($indent, $size);
	if(!$content && !$empty){
		return '';
	} else if(!$content && $empty){
		if($permalink) $SET_HREF = ' href="'. esc_url(get_permalink()) .'"';
			else $SET_HREF = ' rel="nofollow" href="javascript:void(0)"';
		$html = entex_IND($indent, 0).'<'.$element.' class="post-thumbnail ua-attachment-border ua-attachment-empty '. esc_attr($classname) .'"><a'. $role . $SET_HREF  .'>'. $replacement .'</a></'.$element.'>'.entex_LBR();
		return $html;
	}
	
	$border = false; // ? dep
	if(strpos($content, 'ua-image-border') !== FALSE) $border = 'ua-attachment-border';
	
	/* we need the $attr here */
	if(get_post_type() == 'attachment'){
		$attr = entex_fn_extract_attachment(get_the_ID(), $max = apply_filters('entex_theme_filter_extract_attachment_max_value', 600));
		if($caption) $excerpt = get_the_excerpt();
	} else if($caption && has_post_thumbnail()){
		$post_thumbnail_id = get_post_thumbnail_id();
		// new 2022 11 10
		if($post_thumbnail_id){
			$obj = get_post($post_thumbnail_id);
			if(isset($obj->post_excerpt)) $excerpt = $obj->post_excerpt;
				else $excerpt = '';
		}
	}

	/* validate up-sized images */
	/* Comparsion is made on original image, up-scaled sizes are unknown in the attr-function */
	/* Make everything ok if correct $size exists */
	if(isset($attr['data-file-size-'.$size])) $attr['data-file-background'] = '';
	
	$classes = entex_theme_fn_get_post_thumbnail_classes($size);
	if($border) $classes[] = $border;
	
	if(get_post_type() == 'attachment' && has_post_thumbnail()){
		if($attr['data-file-media-type'] != 'image'){
			$SET_STYLE = ' style="background-image: url('. esc_url($attr['data-file-background']) .');"';
			$classes[] = ' ua-attachment-background ua-attachment-icon';
		}
	} else if(get_post_type() == 'attachment' && !has_post_thumbnail() && $attr['data-file-background']){
		if($attr['data-file-media-type'] == 'image'){
			$SET_STYLE = ' style="background-image: url('. esc_url($attr['data-file-background']) .');"';
			if($attr['data-file-repeat'] == 'repeat') $classes[] = ' ua-attachment-background ua-attachment-repeat';
				else $classes[] = ' ua-attachment-background';

		} else {
			$SET_STYLE = ' style="background-image: url('. esc_url($attr['data-file-background']) .');"';
			$classes[] = ' ua-attachment-background ua-attachment-icon';
		}
	}
	
	/* filter */ // $background argument is false as default
	if(apply_filters('entex_theme_filter_set_post_thumbnail_background', $background)){
		$SET_STYLE = ' style="background-image: url('. esc_url(get_the_post_thumbnail_url()) .');"';
	}
	
	/* filter */
	$add = apply_filters('entex_template_get_entry_post_thumbnail_classes', array(), $classes, $size);
	if(!empty($add)){
		if(is_array($add)) $classes = array_merge($classes, $add);
			else $classes[] = $add;
	}
	/* passed argument */
	if($classname) $classes[] = $classname;
	if($excerpt) $classes[] = 'ua-attachment-caption';
	$SET_CLASS = implode(' ', $classes);
	
	$SET_TITLE = '';
	if(get_post_type() == 'attachment' && $permalink) $SET_TITLE = ' title=". esc_attr(basename($post->guid)) ."';
	
	$SET_HREF = '';
	
	if($permalink){
		if(get_post_type() == 'attachment'){
			
			if($permalink == 'media'){
				$SET_HREF = ' href="'. esc_url(wp_get_attachment_url()) .'" target="_blank"';
			} else if($permalink == 'page'){
				$SET_HREF = ' href="'. esc_url(get_permalink()) .'"';
			} else if($permalink == 'parent'){
				if(!$post->post_parent) $SET_HREF = ' rel="nofollow" href="javascript:void(0)"';
					else $SET_HREF = ' href="'. esc_url(get_permalink($post->post_parent)) .'"';
			} else if($permalink == 'link'){
				// Not in use yet
				$sniffer = '';
			} else {
				$SET_HREF = ' href="'. esc_url(wp_get_attachment_url()) .'" target="_blank"';
			}
			
		} else {
			$SET_HREF = ' href="'. esc_url(get_permalink()) .'"';
		}
	} else $SET_HREF = ' rel="nofollow" href="javascript:void(0)"';
	
	
	$html = entex_IND($indent, 0).'<'.$element.' class="'. $SET_CLASS .'">'.entex_LBR();

	if($public){
		$html .= entex_IND($indent, 1).'<a'. $role . $SET_HREF . $SET_STYLE .'>'.entex_LBR();
		$html .= entex_IND($indent, 2).$content.entex_LBR();
		$html .= entex_IND($indent, 1).'</a>'.entex_LBR();
		if($excerpt && $element == 'div') $html .= entex_IND($indent, 1).'<p class="ua-caption ua-not-main">'. strip_tags($excerpt) .'</p>'.entex_LBR();
		if($excerpt && $element == 'figure') $html .= entex_IND($indent, 1).'<figcaption>'. strip_tags($excerpt) .'</figcaption>'.entex_LBR();
	} else {
		$html .= entex_IND($indent, 1).$content.entex_LBR();
	}
	
	/* filter */
	$html .= apply_filters('entex_template_get_entry_post_thumbnail_html_before_close', '', $indent, $size, $data);

	/* action */
	do_action('entex_template_entry_post_thumbnail_html_before_close', $indent, $size, $data);
	
	$html .= entex_IND($indent, 0).'</'.$element.'>'.entex_LBR();
	
	/* filter */
	$html = apply_filters('entex_template_get_entry_post_thumbnail_html', $html, $content, $size, $data);
	$output = $html;
	return $output;
}

/* -------------------- */
// DEFAULT FILTER:
/*
 * example:
 * Remove permalink from 'contents' entries, as this post-type dont have landing pages 
 *
**/
function entex_template_get_entry_post_thumbnail_contents($public){
	if(get_post_type() == 'contents') $public = false;
	return $public;
}
add_filter('entex_theme_unlink_post', 'entex_template_get_entry_post_thumbnail_contents', 10, 2);


// END: POST THUMBNAILS
/* -------------------- */





/* -------------------- */
// POST THUMBNAIL FILTERS
/* Renders inside post thumbnail before close */
/* Used in both singular and archive */
/* Use the filter(s) to combine away the default */
/* There are many combinations */

// ONLY : MAP:
/* note: incoming $content must be returned */
function entex_template_get_entry_post_thumbnail_map($content, $indent, $size){
	
	$render = false;
	if(is_single() && in_the_loop() && get_post_format() == 'status') $render = true;
	if(is_attachment() && in_the_loop()) $render = true;
	if(is_tax() && in_the_loop() && get_post_type() == 'attachment' && wp_attachment_is_image()) $render = true;
	
	/* filter */
	$render = apply_filters('entex_template_render_entry_post_thumbnail_map', $render);
	if(!$render) return $content;
	
	$map = entex_template_get_the_post_thumbnail_map(1);
	if(!$map) return $content;
	
	$html = '';
	$html .= entex_IND($indent, 0).'<div class="post-thumbnail-meta">'.entex_LBR();
	$html .= $map;
	$html .= entex_IND($indent, 0).'</div>'.entex_LBR();
		
	$content .= $html;
	return $content;
}
add_filter('entex_template_get_singular_post_thumbnail_html_before_close', 'entex_template_get_entry_post_thumbnail_map', 10, 3);
add_filter('entex_template_get_entry_post_thumbnail_html_before_close', 'entex_template_get_entry_post_thumbnail_map', 10, 3);


// ONLY : AUTHOR AVATAR
/* note: incoming $content must be returned */
function entex_template_get_entry_post_thumbnail_avatar($content, $indent, $size){
	
	$render = false;
	if(is_search() && in_the_loop()) $render = true;
	if(is_day() && in_the_loop()) $render = true;
	
	/* filter */
	$render = apply_filters('entex_template_render_entry_post_thumbnail_avatar', $render);
	if(!$render) return $content;
	
	/* defualt size adapted for single page main post thumbnail */
	if(!$size) $size = 'entex-photo';
	
	$avatar = entex_template_get_the_author_avatar(1, $size, true);
	if(!$avatar) return $content;
	
	$html = '';
	$html .= entex_IND($indent, 0).'<div class="post-thumbnail-meta">'.entex_LBR();
	$html .= $avatar;
	$html .= entex_IND($indent, 0).'</div>'.entex_LBR();
		
	$content .= $html;
	return $content;
}
/* use this if you need the data directly */
//add_filter('entex_template_get_entry_post_thumbnail_html_before_close', 'entex_template_get_entry_post_thumbnail_avatar', 10, 3);


// AVATAR + MAP (latter if location exists)
/* note: incoming $content must be returned */
function entex_template_get_entry_post_thumbnail_avatar_map($content, $indent, $size){
	
	$render = false;
	if(is_home() && get_post_format() == 'status') $render = true;
	if(is_category() && get_post_format() == 'status') $render = true;
	
	/* filter */
	$render = apply_filters('entex_template_render_entry_post_thumbnail_avatar_map', $render);
	if(!$render) return $content;
	
	$count = 2;
	$output = '';
	$add = '';
	
	/* defualt size adapted for entries */
	/* the filter has the post thumbnail argumets */
	/* we need to force another size here */
	/* note: The map should not change the default size as the google responce zoom depending on size */
	/* Our defualt is '180x225' as for traveller around the world... */
	
	$size = 'thumbnail';
	$size = apply_filters('entex_template_filter_avatar_map_avatar', $size);
	
	$html_1 = entex_template_get_the_author_avatar(1, $size, true);
	if(!$html_1) $count--;
		else $output .= $html_1;
		
	$size = '180x180';
	$size = apply_filters('entex_template_filter_avatar_map_map', $size);
	
	$html_2 = entex_template_get_the_post_thumbnail_map(1, $size);
	if(!$html_2) $count--;
		else $output .= $html_2;
	
	if($count == 2) $add = '-duo';
	
	if($count){
		$html = '';
		$html .= entex_IND($indent, 0).'<div class="post-thumbnail-meta">'.entex_LBR();
		$html .= $output;
		$html .= entex_IND($indent, 0).'</div>'.entex_LBR();
		$content .= $html;
	}
	return $content;
}
add_filter('entex_template_get_entry_post_thumbnail_html_before_close', 'entex_template_get_entry_post_thumbnail_avatar_map', 10, 3);

// END: FILTERS
/* -------------------- */






/* -------------------- */
// POST THUMBNAIL MAP
/* Requieres a valid google API key */

function entex_template_output_the_post_thumbnail_map($indent = 0, $size = 0, $link = true){
	entex_OUT(entex_template_get_the_post_thumbnail_map($indent, $size, $link));
}

function entex_template_get_the_post_thumbnail_map($indent = 0, $size = 0, $link = true){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';
	
	$latlng = entex_theme_fn_get_post_thumbnail_meta_latlng();
	if(!$latlng) return '';
	
	$development = false;
	if(defined('ENTEX_API_KEY_GOOGLE_MAPS_STATIC_DEVELOPMENT')){
		$development = true;
		if(!$size) $url = get_template_directory_uri() .'/assets/images/staticmap-photo.png';
			else $url = get_template_directory_uri() .'/assets/images/staticmap-thumbnail.png';
		$placeholder = '<img src="'. esc_url($url) .'">';
	}
	
	$GKey = '';
	if(!$development){
		if(defined('ENTEX_API_KEY_GOOGLE_MAPS_STATIC') && ENTEX_API_KEY_GOOGLE_MAPS_STATIC){
			$GKey = 'key='. ENTEX_API_KEY_GOOGLE_MAPS_STATIC .'&';
		} else return '';
	}
	
	/* defualt size adapted for single page main post thumbnail */
	if(!$size) $size = '180x225';
	
	/* filter */
	$gmap_url = 'https://maps.google.com/maps?q=' .$latlng. '&ll=' .$latlng. '&z=14';
	$gmap_url = apply_filters('entex_template_filter_the_post_thumbnail_map_gmap_url', $gmap_url);
	
	/*filter */
	$image = '<img src="'. esc_url('https://maps.googleapis.com/maps/api/staticmap?'. $GKey .'center='. $latlng .'&zoom=3&scale=false&size='. $size .'&maptype=terrain&sensor=false&format=png&visual_refresh=true&markers=size:mid%7Ccolor:red%7Clabel:%7C'. $latlng) .'" alt="'. esc_attr__('Google Map', 'entex') .'">';
	$image = apply_filters('entex_template_filter_the_post_thumbnail_map_image', $image, $latlng, $GKey, $link);
	if($development) $image = $placeholder;
	
	$html .= entex_IND($indent, 0).'<figure class="ua-post-thumbnail-map">'.entex_LBR();
	if($link){
		$html .= entex_IND($indent, 1). '<a rel="nofollow" href="'. esc_url($gmap_url) .'" target="_blank">' .entex_LBR();
		$html .= entex_IND($indent, 2). $image .entex_LBR();
		$html .= entex_IND($indent, 1). '</a>'.entex_LBR();
	} else {
		$html .= entex_IND($indent, 1). $image .entex_LBR();
	}
	$html .= entex_IND($indent, 0).'</figure>'.entex_LBR();

	/* filter */
	$html = apply_filters('entex_template_get_the_post_thumbnail_map_html', $html, $image, $size, $link);
	$output = $html;
	return $output;
}






/* -------------------- */
// ENTRY GALLERY 
/* Rettrives the first gallery and output complete HTML */
/* This model keep compat between Guteberg and the old shortcode */
/* As add_filter('get_post_gallery') not targeting Gutenberg correct (yet) */

function entex_template_output_entry_gallery($indent = 0, $data = null){
	entex_OUT(entex_template_get_entry_gallery($indent, $data));
}

/* global - remark the function name */
function entex_template_get_entry_gallery($indent = 0, $data = null){

	if(defined('ENTEX_DISABLE_ENTRY_GALLERY')) return '';
	if(post_password_required()) return '';
	
	if(isset($data['format']) && !empty($data['format'])){
		if(!is_array($data['format'])) $formats = array($data['format']);
			else $formats = $data['format'];
	} else $formats = array();
	
	if(!empty($formats)){
		if(!in_array(get_post_format(), $formats)) return '';
	}
	
	/* comment */
	do_action('entex_template_before_function', 0, 
		'', 
		__FILE__, entex_backtrace(2), 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';
	$content = '';
	
	if(isset($data['native']) && $data['native']) $native = true;
		else $native = false;
		
	if(isset($data['size']) && $data['size']) $size = $data['size'];
		else $size = '';

	if(isset($data['id']) && $data['id']) $post_id = (int) $data['id'];
		else $post_id = null;
	
	/* native = force gallery shortcode instead of gutenberg */
	if($native){
		add_filter('entex_get_post_block_gallery_native', 'entex_theme_native_gallery_return_true', 10);
		if($size) add_filter('entex_get_post_block_gallery_native_size', function($thumbnail) use ($size){ return $size; }, 10);
	}
	
	if(!$post_id) $post_id = get_the_ID();

	$gallery = get_post_gallery($post_id);

	if($native){
		remove_filter('entex_get_post_block_gallery_native', 'entex_theme_native_gallery_return_true', 10);
		if($size) remove_filter('entex_get_post_block_gallery_native_size', function($thumbnail) use ($size){ return $size; }, 10);
	}
	if(!$gallery) return '';

	$classname = '';
	if(isset($data['classname']) && $data['classname']) $classname = ' '. trim($data['classname']);
	
	$content .= entex_IND($indent, 0).'<div class="entry-gallery'. esc_attr($classname) .'">'.entex_LBR();
	$content .= entex_IND($indent, 1). $gallery .entex_LBR();
	$content .= entex_IND($indent, 0).'</div>'.entex_LBR();
	
	$html .= entex_CMD(esc_html_x('gallery', 'DO NOT TRANSLATE', 'entex')).$content.entex_CMD();
	
	/* filter */
	$html = apply_filters('entex_template_get_entry_gallery_html', $html, $content);
	$output = $html;
	return $output;
}

// MOVE THIS LATER INTO core file 
function entex_fn_get_post_block_gallery($native = false, $post = null){
	
	if(!$post) global $post;
	if(!function_exists('has_block')) return '';
	
	$size = 'thumbnail';
	$link = 'file';
	
	if(has_block('gallery', $post->post_content)){
		$post_blocks = parse_blocks($post->post_content);
		$blocks = array();
		foreach($post_blocks as $block){
			if($block['blockName'] == 'core/gallery'){
				$blocks[] = $block;
			}
		}
		
		/* grab the first gallery */
		if(isset($blocks[0]['attrs']['ids'])){
			$attachment_ids = $blocks[0]['attrs']['ids'];
		} else {
			/* wp 5.9 */
			foreach($blocks[0]['innerBlocks'] as $innerBlock){
				$attachment_ids[] = $innerBlock['attrs']['id'];
			}
			$linkTo = '';
			if(isset($blocks[0]['attrs']['sizeSlug'])) $size = $blocks[0]['attrs']['sizeSlug'];
			if(isset($blocks[0]['attrs']['linkTo'])) $linkTo = $blocks[0]['attrs']['linkTo'];
			/* always file for now */
			/* link attribute shold be removed as default links to attachment page */
			if($linkTo == 'attachment') $link = 'file';
		}
	} else return '';
	
	/* filter */
	$native = apply_filters('entex_get_post_block_gallery_native', false, $native);

	$gallery = '';
	if(isset($blocks[0]['innerHTML']) && !$native){
		
		$gallery = render_block($blocks[0]);
		/* filter */ // - compatible with 'render_block filter' and returning values
		$gallery = apply_filters('entex_get_post_block_gallery', $gallery, $blocks[0]);
		
	} else if($attachment_ids){
		
		$count = count($attachment_ids);
		if($count > 5) $count = 5;
		$string = implode(',', $attachment_ids);
		
		/* returns default thumbnail sizes - as Gutenberg dont provide the size for the gallery before 5.9 */
		/* filter */ // Template might pass size or link argument
		$size = apply_filters('entex_get_post_block_gallery_native_size', $size, $attachment_ids);
		$link = apply_filters('entex_get_post_block_gallery_native_link', $link, $attachment_ids);

		$shortcode = '[gallery link="'. $link .'" columns="'. $count .'" ids="'. $string. '" size="'. $size .'"]';
		$gallery = do_shortcode($shortcode);
	}
	return $gallery;
}

function entex_theme_get_post_block_gallery($gallery, $post, $galleries){
	/* since 5.9 this filter has been changed */
	//if($gallery && strpos($gallery, '<img') !== FALSE) return $gallery;
	$native = false;
	/* make shure the post object is an object, not only id */
	$gallery = entex_fn_get_post_block_gallery($native, get_post($post));
	return $gallery;
}
add_filter('get_post_gallery', 'entex_theme_get_post_block_gallery', 60, 3);

/* helper */
function entex_theme_native_gallery_return_true(){
	return true;
}





/* -------------------- */
// ENTEX SHORTCODE THEME WRAPPER
/* keep sanitized content flow */

function entex_template_output_shortcode($data){
	$shortcode = do_shortcode($data);
	$shortcode = apply_filters('entex_template_output_shortcode', $shortcode, $data);
	if(!$shortcode) return '';
	entex_OUT($shortcode);
}

/* -------------------- */
// ENTEX ARTICLE END-MARKER
/* keep sanitized content flow */

function entex_template_output_article_marker($indent){
	$content = '<hr class="ua-end">';
	$content = apply_filters('entex_theme_the_content_article_end_marker', $content);
	$html = entex_IND($indent, 0).$content.entex_LBR();
	$output = $html;
	entex_OUT($output);
}


// -- END FILE -- //