<?php if(!defined('ABSPATH')) die(); 

// ENTEX TEMPLATE (SIDEBAR) SELECTOR and LOCATIONS OUTPUT
// UPDATED 2022 09 28

/**
 * AS LONG AS GUTENBERG IS CHANGING 
 * WE USE SUPERGLOBALS UNTIL STABLE RELEASE OF GUTENBERG
 *
**/

// Developers:
// All available filters are pre-commented with: /* filter */ for easy search


/* -------------------- */
// PRE-PARSE LOCATIONS
/* in conjuction with entex-setup-gutenberg.php */
/* If Advanced "Additional CSS class(es)" is populated with a 'class' location */
/* The block is grabbed here, populated into a array */
/* The content render block will then ignore the block */
/* And the selector (or sidebar) will pull out the block into that location instead */
/* In this case, the content inside a post or a page is always intact */
/* If switching theme, the posts are output as normal */

function entex_template_parse_locations(){
	
	if(is_admin() || !is_singular()) return;
	if(!function_exists('parse_blocks')) return;
	if(!function_exists('entex_theme_render_block_core')) return;
	
	if(!isset($GLOBALS['ENTEX-SIDEBAR-BLOCKS']['parsed'])){
		global $post;
		/* or remove filter */
		$GLOBALS['ENTEX-SIDEBAR-BLOCKS-PARSING'] = true;
		$locations = array_keys(array_merge(apply_filters('entex_theme_locations', array()), array('entex-location-sidebar' => esc_html_x('Current sidebar', 'Template locations', 'entex'))));
		$blocks = parse_blocks( $post->post_content );
		if(!empty($blocks)){
			foreach($blocks as $block){
				$CONTENT = '';
				if($block['blockName'] == 'core/block' && isset($block['attrs']['ref']) && $block['attrs']['ref']){
					$P = get_post($block['attrs']['ref']);
					$C = $P->post_content;
					
					if(strpos($C, 'className":"') !== FALSE){
						$c = explode('className":"', $C, 2);
						list($cn, $dummie) = explode('"', $c[1], 2);
						$block['attrs']['className'] = trim($cn);
						$CONTENT = preg_replace('/<!--(.|\s)*?-->/', '', $C);
						
					}
				} 
				if(isset($block['attrs']['className']) && $block['attrs']['className']){
					$classnames = $block['attrs']['className'];
					foreach($locations as $match){
						if(strpos($classnames, $match) !== FALSE){
							if($CONTENT) $block_content = $CONTENT;
								else $block_content = render_block($block);
							if($block_content && trim($block_content)){
								$GLOBALS['ENTEX-SIDEBAR-BLOCKS'][$match][] = $block_content;
								$GLOBALS['ENTEX-SIDEBAR-BLOCKS-REMOVE'][$classnames] = true;
								$GLOBALS['ENTEX-SIDEBAR-BLOCKS']['parsed'] = true;
								if($CONTENT) $GLOBALS['ENTEX-SIDEBAR-BLOCKS']['ref'][$block['attrs']['ref']] = true;
								if(strpos($classnames, 'entex-position-replace') !== FALSE){
									$GLOBALS['ENTEX-SIDEBAR-BLOCKS']['replace'][$match] = true;
								}
							}
						}
					}
				}
			}
		}
		$GLOBALS['ENTEX-SIDEBAR-BLOCKS-PARSING'] = false;
	}
}
add_action('wp_body_open', 'entex_template_parse_locations');









/* -------------------- */
// REGISTER LOCATION(S)

add_filter('entex_theme_locations', function($locations){
	$locations['entex-location-section-1'] = esc_html_x('Section 1 above', 'Template locations', 'entex');
	$locations['entex-location-section-2'] = esc_html_x('Section 2 above', 'Template locations', 'entex');
	$locations['entex-location-section-3'] = esc_html_x('Section 3 below', 'Template locations', 'entex');
	$locations['entex-location-section-4'] = esc_html_x('Section 4 below', 'Template locations', 'entex');
	return $locations;
}, 20, 1);

function entex_template_output_location_section_1($indent = 0, $context = ''){
	$sidebar = null;
	entex_template_output_dynamic_selector('entex-location-section-1', $sidebar, $context);
}
add_action('entex_template_before_main_section', 'entex_template_output_location_section_1', 11, 2);

function entex_template_output_location_section_2($indent = 0, $context = ''){
	$sidebar = null;
	entex_template_output_dynamic_selector('entex-location-section-2', $sidebar, $context);
}
add_action('entex_template_before_main_section', 'entex_template_output_location_section_2', 12, 2);

function entex_template_output_location_section_3($indent = 0, $context = ''){
	$sidebar = null;
	entex_template_output_dynamic_selector('entex-location-section-3', $sidebar, $context);
}
add_action('entex_template_after_main_section', 'entex_template_output_location_section_3', 13, 2);

function entex_template_output_location_section_4($indent = 0, $context = ''){
	$sidebar = null;
	entex_template_output_dynamic_selector('entex-location-section-4', $sidebar, $context);
}
add_action('entex_template_after_main_section', 'entex_template_output_location_section_4', 14, 2);




/* -------------------- */
// REGISTER INSTRUCTIONS
// Through classnames in editor
/* Current sidebar (default) location */

add_filter('entex_theme_current_sidebar_position', function($position){
	$position['entex-position-above'] = esc_html_x('Position above sidebar content', 'Template locations', 'entex');
	$position['entex-position-replace'] = esc_html_x('Replace sidebar content', 'Template locations', 'entex');
	$position['entex-position-below'] = esc_html_x('Position below sidebar content', 'Template locations', 'entex');
	return $position;
}, 20, 1);



/* -------------------- */
// SIDEBAR OUTPUT

function entex_template_output_sidebar($indent = 0){
	entex_template_output_dynamic_selector('default', 'sidebar-1');
}
add_action('entex_template_sidebar', 'entex_template_output_sidebar', 10, 1);


function entex_template_output_dynamic_selector($location = 'default', $sidebar = null, $context = ''){
	
	/* comment */
	do_action('entex_template_before_function', 0, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	if($location == 'default') $theme_location = 'entex-location-sidebar';
		else $theme_location = $location;

	if(isset($GLOBALS['ENTEX-SIDEBAR-BLOCKS'][$theme_location])){
		$section = false;
		if(strpos($theme_location, '-section-') !== FALSE) $section = true;
		$cols = count($GLOBALS['ENTEX-SIDEBAR-BLOCKS'][$theme_location]);
		$n = 0;
		$full = false;
		foreach($GLOBALS['ENTEX-SIDEBAR-BLOCKS'][$theme_location] as $html){
			if($section){
				$n++;
				add_action('entex_template_section_column_'.$n, function($indent, $identifier) use ($html){
					if(strpos($html, 'data-is-sanitized=') !== FALSE) echo wp_kses($html, entex_wp_kses()); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
						else echo apply_filters('the_content', wp_kses($html, entex_wp_kses())); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				}, ($n * 10), 2);
				if($cols == 1 && strpos($html, 'ua-w-full') !== FALSE){
					$full = true;
				}
			} else {
				if(strpos($html, 'data-is-sanitized=') !== FALSE) echo wp_kses($html, entex_wp_kses()); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
					else echo apply_filters('the_content', wp_kses($html, entex_wp_kses())); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			}
		}
		if($section) {
			$section_id_prefix = '';
			if(strpos($context, '-above') !== FALSE) $section_id_prefix = 'section-id-above-';
			if(strpos($context, '-below') !== FALSE) $section_id_prefix = 'section-id-below-';
			if($n > 4) $n = 4;
			$d = $n;
			if($location == 'entex-location-section-1') $d = '1';
			if($location == 'entex-location-section-2') $d = '2';
			if($location == 'entex-location-section-3') $d = '3';
			if($location == 'entex-location-section-4') $d = '4';
			add_filter('entex_template_section_id', function($section_id) use ($d, $section_id_prefix){ return $section_id_prefix.$d; }, 10, 1);
			add_filter('entex_template_section_context', function($classname, $filename) use ($context){ return $context; }, 10, 2);
			if($full) get_template_part('tmpl-sections/tmpl-section-full');
				else get_template_part('tmpl-sections/tmpl-section-'. $n .'-col');
			for($i = 0; $i < $n; $i++){
				remove_all_actions('entex_template_section_column_'.($i + 1));
			}
			$full = false;
			remove_filter('entex_template_section_context', function($classname, $filename) use ($context){ return $context; }, 10, 2);
			remove_filter('entex_template_section_id', function($section_id) use ($d, $section_id_prefix){ return $section_id_prefix.$d; }, 10, 1);
		}
		if(isset($GLOBALS['ENTEX-SIDEBAR-BLOCKS']['replace'][$theme_location])) return;
	}
	
	if(defined('ENTEX_TEMPLATE_NO_SIDEBARS') && ENTEX_TEMPLATE_NO_SIDEBARS){
		entex_OUT(entex_CMN(0, 'ENTEX_TEMPLATE_NO_SIDEBARS DEFINED BY THEME'));
		do_action('entex_template_no_sidebars', $location, $sidebar);
		return '';
	}
	
	entex_OUT(entex_CMN(0, 'Theme Location: '. $location));
	
	$position = '';
	$automenu = '';
	$automenu_below_sticky = false;
	$automenu_remove_sticky = false;
	

	/* fetch registered sidebars from entex-setup-sidebars.php */
	$sidebars = apply_filters('entex_theme_filter_registered_sidebars', array());
	$intercepted = apply_filters('entex_theme_filter_registered_sidebars_intercepted', array());
	
	/* calculate default sidebar */
	if($location == 'default'){

		$is = entex_theme_fn_get_is();
		$dynamic_part = $is['dynamic-part'];

		/* insert front page, as its not a dynamic-part registered variable */
		if(is_front_page()) $dynamic_part = 'is_front_page';

		/* calculate and get auto menu for pages */
		if(is_page()){
			$meta = false;
			$ancestors = get_post_ancestors(get_queried_object_id());
			if(!empty($ancestors)){
				$ancestors = array_reverse($ancestors);
				foreach ($ancestors as $ancestor_id){
					$meta = get_post_meta($ancestor_id, 'entex_page_automenu', true);
					if($meta) break;
				}
			} 
			if(!$meta){
				$meta = get_post_meta(get_queried_object_id(), 'entex_page_automenu', true);
				if($meta) $ancestor_id = get_queried_object_id();
			}
			if($meta && isset($ancestor_id)){
				
				$title = 'auto';
				
				/* filter */
				$title = apply_filters('entex_sidebar_page_automenu_title', $title, $ancestor_id);
				if(defined('ENTEX_THEME_PAGE_AUTOMENU_CLASSNAMES')) $classnames = ENTEX_THEME_PAGE_AUTOMENU_CLASSNAMES;
					else $classnames = 'ua-nav-clean ua-set-sub ua-set-nav-list ua-set-after ua-fn-accordion';
					
				/* filter */
				$classnames = apply_filters('entex_sidebar_page_automenu_classnames', $classnames, $ancestor_id);
				
				$automenu = entex_sidebar_auto_menu($title, $classnames, $ancestor_id);
				if($automenu){
					if(defined('ENTEX_THEME_PAGE_AUTOMENU_BELOW_STICKY_SIDEBAR')) $automenu_below_sticky = true;
					if(defined('ENTEX_THEME_PAGE_AUTOMENU_REMOVE_STICKY_SIDEBAR')) $automenu_remove_sticky = true;
				}
				unset($ancestor_id, $title);
			}
			unset($meta, $ancestors);
		}
		
		// OUTPUT BEGINS
		
		if($automenu && !$automenu_below_sticky){
			echo wp_kses($automenu, entex_wp_kses());
		}
		
		/* filter */
		if(apply_filters('entex_template_filter_output_sticky_sidebar', true, $dynamic_part)){
			if($position != 'replace' && is_active_sidebar('sticky-1') && !$automenu_remove_sticky){
				entex_OUT(entex_CMN(0, esc_html_x('Active sidebar: ', 'DO NOT TRANSLATE', 'entex') . $sidebars['sticky-1']));
				dynamic_sidebar('sticky-1');
			}
		}
		
		if($automenu && $automenu_below_sticky){
			echo wp_kses($automenu, entex_wp_kses());
		}
		
		if($automenu){
			/* remove default sidebars */
			if(!defined('ENTEX_THEME_PAGE_AUTOMENU_KEEP_DEFAULT_SIDEBAR')) $position = 'replace';
			unset($automenu);
		}
		
		
		// CHOOSE DEFAULT SIDEBAR KEY ('is_') 
		/* Note: front page does not respond to 'is_page()' or 'is_singular()' */
		/* We exclude searching for front page when checking fallbacks */
		/* But first, we check for intercepted active sidebar */
		/* If true, we intercept the default fallback conditional tree */
		/* If merge is true, intercepted sidebars appears below instead as fallback */
		/* But only to first level sidebars (the condition that has the intercepted fallback) */
		
		$intercept = false;
		if(isset($intercepted[$dynamic_part])){
			if(is_active_sidebar($intercepted[$dynamic_part])) $intercept = $intercepted[$dynamic_part];
		}
		
		/* Merged mode */
		$merge = false;
		$merged = false;
		$merge = apply_filters('entex_template_filter_output_merge_intercepted_sidebar', $merge, $dynamic_part);
		
		if(is_active_sidebar($dynamic_part)){
			$sidebar = $dynamic_part;
			if($merge) $merged = $intercept;
		} else if(!is_front_page()){
			if($intercept){
				$sidebar = $intercept;
			} else {
				foreach($is['conditionals'] as $conditional){
					if($conditional == $dynamic_part) continue;
					if(is_active_sidebar($conditional)) $sidebar = $conditional;
				}
			}
		}
	
		/* Note: if no dynamic $sidebar active, fallback is the passed argument */
		$sidebar = $sidebar;
	}
	
	if(isset($sidebars[$sidebar]) && !is_array($sidebars[$sidebar])) $name = $sidebars[$sidebar];
		else $name = $sidebar;
	if(!isset($merged)) $merged = false;
	
	$id = get_queried_object_id();
		
	if(!$id){
		/* circuit */
		if($sidebar && is_active_sidebar($sidebar)){
			entex_OUT(entex_CMN(0, esc_html_x('Active sidebar: ', 'DO NOT TRANSLATE', 'entex') . $name));
			dynamic_sidebar($sidebar); 
		}
		if($merged && is_active_sidebar($merged)){
			entex_OUT(entex_CMN(0, esc_html_x('Active sidebar: Merged', 'DO NOT TRANSLATE', 'entex')));
			dynamic_sidebar($merged); 
		}
		return;
	}
	
	// BEGIN SIDEBAR
	
	/* actions in here later */

	if($position != 'replace'){
		if($sidebar && is_active_sidebar($sidebar)){
			entex_OUT(entex_CMN(0, esc_html_x('Active sidebar: ', 'DO NOT TRANSLATE', 'entex') . $name));
			dynamic_sidebar($sidebar); 
		}
	}
	
	/* actions in here later */
}

// END : SELECTOR OUTPUT
/* ******************** */






/* -------------------- */
// SIDEBAR AUTO MENU

function entex_sidebar_auto_menu($title = '', $classnames = '', $id = 0){
	
	$output = '';
	if(!is_page()) return $output;
	
	if(!$id){
		global $wp_query;
		if(empty($wp_query->post->post_parent)) $parent = $wp_query->post->ID;
			else $parent = $wp_query->post->post_parent;
	} else $parent = $id;
	if($title == 'auto') $title = get_the_title($parent);
	
	/* filter available in caller */
	if(!$classnames) $classnames = 'ua-nav-y ua-set-after ua-fn-accordion ua-set-nav-list';
	$classnames = 'ua-nav '.$classnames;
	
	$content = wp_list_pages("title_li=&child_of=$parent&echo=0&sort_column=menu_order");
	
	if($content){
		if($title) $output .= '<h4>'. esc_attr($title) .'</h4>';
		$output .= '<nav class="'. esc_attr($classnames) .'">'."\r\n";
		$output .= '<ul>'."\r\n";
		$output .= $content."\r\n";
		$output .= '</ul>'."\r\n";
		$output .= '</nav>'."\r\n";
	}
	
	return $output;
}



// -- END FILE -- //