<?php 

// UPDATED 2022 05 09

// GLOBAL FRONT-END (entex-template) FILTERS
/* No direct echo HTML output here please */
/* Template HTML filters are within entex-template-actions.php */
/* WordPress global function filters are inside corresponding setup context */
/* Back-end filters resident inside setup/entex-setup-admin.php */


// -- TRANSLATION READY CHILD FUNCTIONS -- //
/* As functions.php strings is NOT a translated file (Loco settings) */
/* Any translatable strings to be be copied to child themes remains inside included files */

/* -------------------- */
// HOME BREADCRUMB LABEL ON STARTPAGE
/* Copy and uncomment this to your child theme if needed */
/* This filter is translated here as default */
/* Note: Custom text is NOT translated */
/* Return false to remove breadcrumb on startpage */
/* Default is: $Welcome = sprintf(_x('Welcome to %s', 'Breadcrumbs', 'entex'), entex_theme_fn_get_blogname()); */
/*
if(!function_exists('entex_filter_breadcrumbs_label_welcome')){
	function entex_filter_breadcrumbs_label_welcome($text){
		return esc_html__('Welcome', 'entex');
	}
	add_filter('entex_breadcrumbs_label_welcome', 'entex_filter_breadcrumbs_label_welcome', 10, 1);
}
*/

/* -------------------- */
// HOME BREADCRUMB WITHIN TRAIL LABEL
/* Copy and uncomment this to your child theme if needed */
/* This filter is translated here as default */
/* Note: Custom text is NOT translated */
/*
if(!function_exists('entex_breadcrumbs_filter_label_home')){
	function entex_breadcrumbs_filter_label_home($text){
		return esc_html__('Start', 'entex');
	}
	add_filter('entex_breadcrumbs_label_home', 'entex_breadcrumbs_filter_label_home', 10, 1);
}
*/
// END
/* ******************** */



/* -------------------- */
// DEFAULT SHORTCUT TABS

/**
 * Defaults if individual page-loads not populated 
 * Other filter available in: inc/entex-template-custom-fields.php
 * 
 * 'entex_shortcut_tab_1_bookmark' = default 'main' (Main column)
 * 'entex_shortcut_tab_2_bookmark' = default 'aside' (Aside column)
 * 'entex_shortcut_tab_3_bookmark' = default ''
 * 'entex_shortcut_tab_4_bookmark' = default ''
 * 
 * The shortcut tab 3 'can' be intercepted by tab 4
 * Means, if 4 is populated, appears before tab 3
 *
 * Shortcut tabs (always) can be disabled in functions.php
 * ENTEX_TEMPLATE_SHORTCUT_TABS_DISABLE
 *
 * Other filters available in action:
 * entex_template_output_shortcut_tabs()
 *
**/

function entex_shortcut_tab_1_label_default($label){
	return esc_html_x('Content', 'Shortcut label', 'entex');
}
add_filter('entex_shortcut_tab_1_label', 'entex_shortcut_tab_1_label_default', 10, 1);

function entex_shortcut_tab_2_label_default($label){
	return esc_html_x('Related', 'Shortcut label', 'entex');
}
add_filter('entex_shortcut_tab_2_label', 'entex_shortcut_tab_2_label_default', 10, 1);

function entex_shortcut_tab_3_label_default($label){
	return esc_html_x('Footer', 'Shortcut label', 'entex');
}
add_filter('entex_shortcut_tab_3_label', 'entex_shortcut_tab_3_label_default', 10, 1);

function entex_shortcut_tab_4_label_default($label){
	return esc_html_x('Cart', 'Shortcut label', 'entex');
}
add_filter('entex_shortcut_tab_4_label', 'entex_shortcut_tab_4_label_default', 10, 1);

/* translations ready */
$translation = esc_html_x('Product', 'Shortcut label', 'entex');
$translation = esc_html_x('Products', 'Shortcut label', 'entex');
$translation = esc_html_x('Contents', 'Shortcut label', 'entex');
$translation = esc_html_x('Categories', 'Shortcut label', 'entex');
$translation = esc_html_x('Filter', 'Shortcut label', 'entex');
$translation = esc_html_x('Filters', 'Shortcut label', 'entex');
$translation = esc_html_x('Search', 'Shortcut label', 'entex');
$translation = esc_html_x('Form', 'Shortcut label', 'entex');
$translation = esc_html_x('Forms', 'Shortcut label', 'entex');
$translation = esc_html_x('Information', 'Shortcut label', 'entex');
$translation = esc_html_x('Additional', 'Shortcut label', 'entex');
$translation = esc_html_x('Contact', 'Shortcut label', 'entex');
$translation = esc_html_x('Address', 'Shortcut label', 'entex');
$translation = esc_html_x('Addresses', 'Shortcut label', 'entex');
$translation = esc_html_x('Location', 'Shortcut label', 'entex');
$translation = esc_html_x('Locations', 'Shortcut label', 'entex');
$translation = esc_html_x('Map', 'Shortcut label', 'entex');

/* ******************** */



/* -------------------- */
// PROTECTED TITLE FORMAT
function entex_theme_protected_title_format($content) {
	/* translators: */
	return _x('Password : %s', 'Protected title format', 'entex');
}
add_filter('protected_title_format', 'entex_theme_protected_title_format');

function entex_theme_private_title_format($content) {
	/* translators: */
	return _x('Private : %s', 'Private title format', 'entex');
}
add_filter('private_title_format', 'entex_theme_private_title_format');






/* -------------------- */
// MONITOR MENUES
/**
 * Remove private posts from menues (If they where public before)
 * Remove drafts from menues (If they where published before)
 * Remove hidden status posts from menues (extendsion)
 * Replace login/ logout custom link url with correct url
 * (Custom link with ex href #entex-url-logout)
 * 
 * Recources:
 * https://www.daggerhartlab.com/dynamically-add-item-to-wordpress-menus/
 *
**/
function entex_theme_exclude_menu_items($items, $menu, $args){
	
	if( is_admin() ) return $items;
	$access = 0;
	if(current_user_can('read_private_pages')) $access = 1;

    foreach ( $items as $key => $item ) {

		if($item->type == 'post_type'){
			$ps = get_post_status($item->object_id);
			if(!$access && $ps == 'private') unset( $items[$key] );
				else if($ps == 'private') $items[$key]->title = esc_html_x('P', 'Menu marker: P = Private', 'entex') .' : '.$items[$key]->title;
			if(!$access && $ps == 'draft') unset( $items[$key] );
				else if($ps == 'draft')$items[$key]->title = esc_html_x('D', 'Menu marker: D = Draft', 'entex') .' : '.$items[$key]->title;
			if($ps == 'hidden') unset( $items[$key] );
		} else {
			$meta = get_term_meta($item->object_id, 'ua-hidden-taxonomy', true);
			if($meta == 'yes') unset( $items[$key] );
		}
		if(strpos($item->url, 'entex-url-logout') !== FALSE){
			if(is_user_logged_in()){
				if(!is_single() && isset($_SERVER['REQUEST_URI'])) $url = esc_url_raw(wp_unslash($_SERVER['REQUEST_URI']));
					else $url = get_permalink();
				$items[$key]->url = wp_logout_url($url);
				$items[$key]->title = esc_html__('Logout', 'entex');
			} else unset( $items[$key] );
		}
		if(strpos($item->url, 'entex-url-login') !== FALSE){
			if(!is_user_logged_in()){
				if(!is_single() && isset($_SERVER['REQUEST_URI'])) $url = esc_url_raw(wp_unslash($_SERVER['REQUEST_URI']));
					else $url = get_permalink();
				$items[$key]->url = wp_login_url($url);
				$items[$key]->title = esc_html__('Login', 'entex');
			} else unset( $items[$key] );
		}

		if($item->menu_item_parent){
			if(!isset($dummie[$item->menu_item_parent])){

				$pid = $item->menu_item_parent;
				$dummie[$pid] = true;
				
				if(isset($_before) && !isset($_before->redirected)){
					
					$apply = true;
					if($_before->type == 'custom') $apply = false;
					
					/* filter */
					$apply = apply_filters('entex_insert_nav_menu_item_'. $menu->slug, $apply, $_before, $item, $items, $menu, $args);
					
					if($apply){
				
						$n = $pid * 2;
						$_before->ID = $n;
						$_before->db_id = $n;
						$_before->menu_order = $n;
						$_before->menu_item_parent = $item->menu_item_parent;
						if($_before->attr_title) $_before->title = $_before->attr_title;
						$_before->cloned = true;
						
						$_before = apply_filters('entex_insert_nav_menu_item_cloned', $_before, $item, $items, $menu, $args);
				
						$B[] = clone $_before;
					}
				}
			}
		}

		if($item->type == 'post_type'){
			$meta = entex_theme_get_meta_page_redirect($item->object_id, $calculate = false);
			if($meta) $items[$key]->redirected = true;
		}
		if(isset($items[$key]) && is_object($items[$key])){
			$_before = clone $items[$key];
		} else if(isset($_before)){
			unset($_before);
		}
    }
	
	if(isset($B)){
		$items = array_merge($B, $items);
	}

    return $items;
}
add_filter('wp_get_nav_menu_items', 'entex_theme_exclude_menu_items', null, 3);

/* default constant for 'main-menu' */
function entex_theme_filter_insert_nav_menu_item_primary($apply, $_before, $item, $items, $menu, $args){
	if(defined('ENTEX_THEME_MENU_INSERT_PRIMARY_FALSE')) return false;
	return $apply;
}
add_filter('entex_insert_nav_menu_item_main-menu', 'entex_theme_filter_insert_nav_menu_item_primary', 10, 6);



/* -------------------- */
// MENU CLASSES AND ID CLEANUP

function entex_cleanup_navigation_items(){
	
	if(is_admin()) return;
	
	/* entex css dependency */
	add_filter('nav_menu_css_class', 'entex_fi_cleanup_nav_objects_classnames', 99, 3);
	
	if(!defined('ENTEX_CLEANUP_NAVIGATION_ITEMS_DISABLE')){
		add_filter('wp_nav_menu', 'entex_fi_cleanup_nav_objects_classes');
		add_filter('nav_menu_item_id', 'entex_fi_cleanup_nav_objects_id', 10, 3 );
	}
}
add_action('init', 'entex_cleanup_navigation_items');


function entex_fi_cleanup_nav_objects_classes($menu) {

	$menu = str_replace(' class=""', '', $menu);
	$menu = str_replace('  ', ' ', $menu);
	$menu = str_replace("\t", ' ', $menu);
	$menu = str_replace('><li', ">\r\n<li", $menu);
	return $menu."\r\n";
}


function entex_fi_cleanup_nav_objects_classnames($classes, $item, $args){

	if(!is_array($classes)) return $classes;
	if(isset($item->cloned)){
		if(in_array('current-page-parent', $classes)) return array();
		if(in_array('current-page-ancestor', $classes)) return array();
	}
	$needle = 'current';
	$matches = array_filter($classes, function($haystack) use ($needle){
		return(strpos($haystack, $needle) !== FALSE);
	});
	if(!empty($matches)){
		if(!defined('ENTEX_CLEANUP_NAVIGATION_ITEMS_DISABLE')){
			$classes = array_diff($classes, $matches);
		}
		$classes = array_merge($classes, array('selected', 'selected-onload'));
	}
	
	/* break the cleanup if defined */
	if(defined('ENTEX_CLEANUP_NAVIGATION_ITEMS_DISABLE')){
		return $classes;
	}
	
	/* filter */
	$needle = apply_filters('entex_cleanup_menu_classnames_needle', 'item');
	$matches = array_filter($classes, function($haystack) use ($needle){
		return(strpos($haystack, $needle) !== FALSE);
	});
	if(!empty($matches)){
		$classes = array_diff($classes, $matches);
	}
	
	return $classes;
}

/* remove attr id */
function entex_fi_cleanup_nav_objects_id($id, $item, $args) {
	return '';
}



/* -------------------- */
// CLEANUP WALKER ATTRIBUTES

function entex_cleanup_category_css_class($classes){
	
	if(is_admin()) return $classes;
	if(defined('ENTEX_CLEANUP_NAVIGATION_ITEMS_DISABLE')){
		return $classes;
	}
	if(!is_array($classes)) return $classes;
	if(!empty(array_intersect($classes, array('current-cat')))) {
		$c[] = apply_filters('nav_class_current_menu_item', 'current-menu-item');
		$c[] = apply_filters('nav_class_current', 'selected'); 
		$c[] = apply_filters('nav_class_current_onload', 'selected-onload');
		$current = true;
	}
	if(!empty(array_intersect($classes, array('current-cat-parent')))) $c[] = apply_filters('nav_class_current_menu_parent', 'current-menu-parent');
	if(!empty(array_intersect($classes, array('current-cat-ancestor')))) $c[] = apply_filters('nav_class_current_menu_ancestor', 'current-menu-ancestor');
	
	$populate_ancestors = apply_filters('entex_cleanup_populate_ancestors', true);
	if(!$populate_ancestors) $current = 1;
	if(isset($c) && !isset($current)){ 
		$c[] = apply_filters('nav_class_current', 'selected'); 
		$c[] = apply_filters('nav_class_current_onload', 'selected-onload'); 
	} else if(!isset($c)) $c = array();
	$classes = $c;

	return $classes;
}
add_filter('category_css_class', 'entex_cleanup_category_css_class', 10, 1);


function entex_cleanup_page_css_class($classes){
	
	if(is_admin()) return $classes;
	if(defined('ENTEX_CLEANUP_NAVIGATION_ITEMS_DISABLE')){
		return $classes;
	}
	if(!is_array($classes)) return $classes;
	if(!empty(array_intersect($classes, array('current_page_item')))) {
		$c[] = apply_filters('nav_class_current_menu_item', 'current-menu-item');
		$c[] = apply_filters('nav_class_current', 'selected'); 
		$c[] = apply_filters('nav_class_current_onload', 'selected-onload');
		$current = true;
	}
	if(!empty(array_intersect($classes, array('current_page_parent')))) $c[] = apply_filters('nav_class_current_menu_parent', 'current-menu-parent');
	if(!empty(array_intersect($classes, array('current_page_ancestor')))) $c[] = apply_filters('nav_class_current_menu_ancestor', 'current-menu-ancestor');
	
	$populate_ancestors = apply_filters('entex_cleanup_populate_ancestors', true);
	if(!$populate_ancestors) $current = 1;
	if(isset($c) && !isset($current)){ 
		$c[] = apply_filters('nav_class_current', 'selected'); 
		$c[] = apply_filters('nav_class_current_onload', 'selected-onload'); 
	} else if(!isset($c)) $c = array();
	$classes = $c;

	return $classes;
}
add_filter('page_css_class', 'entex_cleanup_page_css_class', 10, 1);


function entex_cleanup_wp_list_pages($menu){
	if(is_admin()) return $menu;
	if(defined('ENTEX_CLEANUP_NAVIGATION_ITEMS_DISABLE')){
		return $menu;
	}
	$menu = str_replace(' class=""', '', $menu);
	return $menu;
}
add_filter('wp_list_pages', 'entex_cleanup_wp_list_pages');
add_filter('wp_list_categories', 'entex_cleanup_wp_list_pages');



/* -------------------- */
// AUTHOR TEMPLATE (is_author()) 
/* Keep wpautop as taxonomy description still does */
add_filter('get_the_author_description', 'wptexturize');
add_filter('get_the_author_description', 'convert_chars');
add_filter('get_the_author_description', 'wpautop');
add_filter('get_the_author_description', 'shortcode_unautop');



/* -------------------- */
// EXCERPT
/* Replaces the default wp hook */
/* Called (and un-hooked) inside: entex_theme_setup() */

function entex_theme_filter_wp_trim_excerpt($excerpt, $obj){
	return entex_theme_fn_get_excerpt($obj);
}



/* -------------------- */
// THE CONTENT
/* Add Article end square marker on post type 'post' */
function entex_theme_filter_the_content_article_end($content){
	if(is_admin()) return $content;
	if(is_singular() && in_the_loop()){
		global $post;
		global $page, $numpages, $multipage;
		if($post->post_type != 'post') return $content;
		if($multipage && $page != $numpages) return $content;
		if($post->ID == get_queried_object_id()){
			$output = $content .'<div class="article-end"><hr class="ua-end"></div>';
			/* filter */
			$content = apply_filters('entex_theme_the_content_article_end_marker', $output, $content);
		}
	}
	return $content;
}
add_filter('the_content', 'entex_theme_filter_the_content_article_end', -5, 1);



/* -------------------- */
// MORE - want this same and translated all the time
/* 'more' page break link (not excerpt read more) */
function entex_template_get_the_content_more_link($html, $more_link_text, $text = ''){
	if(!$text) $text = _x('Read more', 'Devided content read more button', 'entex');
	return '<nav class="ua-more"><a class="more-link" href="'. esc_url(get_permalink()) .'">'. esc_html($text) .'</a></nav>';
}
add_filter('the_content_more_link', 'entex_template_get_the_content_more_link', 10, 2);



/* -------------------- */
// PRE ATTACHMENT FILTER
/* removes built in output of images and uses post-thumbnail instead inside the output template */
function entex_theme_filter_prepend_attachment($p){
	global $post;
	if(wp_attachment_is('image', $post)) return '';
	if(wp_attachment_is('video', $post) || wp_attachment_is('audio', $post)) return $p;
	/* translators: */
	$label = sprintf(_x('Open %s', 'Attachment: Open file LIKE: Open Instructions about the theme.pdf', 'entex'), get_the_title()) . ' ( ' . entex_theme_fn_get_attachment_extension() .' - '. entex_theme_fn_get_attachment_filesize() .' )';
	$p = '<a class="ua-button" href="'. esc_url(wp_get_attachment_url()) .'" target="_blank">'. esc_html($label) . '</a>';
	return $p;
}
add_filter('prepend_attachment', 'entex_theme_filter_prepend_attachment', 10, 1);

// END: PRE ATTACHMENT FILTER
/* ******************** */



/* -------------------- */
// DOCUMENT TITLE FILTER
function entex_theme_filter_pre_get_document_title($title){
	
	if(is_admin()) return $title;
	/* Yoast doesnt use replacements on date archive */
	if(defined('ENTEX_YOAST_ACTIVE')){

		global $wp_query;
		if(is_singular()){
			
			/* Yoast and plugins handle singular as default */
			if(!defined('ENTEX_THEME_EXTENDED_TITLE_SINGULAR_DEFAULT_THEME')) return $title;
			
			/* if not, make shure individual field not manually populated */
			$object = $wp_query->get_queried_object();
			$field = WPSEO_Meta::get_value('title', $object->ID);
			if($field) return $title;
			
		} else {
			/* Entex theme handle archives as default */
			if(defined('ENTEX_THEME_EXTENDED_TITLE_ARCHIVE_DEFAULT_YOAST')) return $title;
			
			/* if so, make shure individual field not manually populated */
			$is = entex_theme_fn_get_is();
			if(is_author()){
				$field = get_the_author_meta('wpseo_title', get_query_var('author'));
				if($field) return $title;
			} else if($is['is-taxonomy'] == 'Yes'){
				$object = $wp_query->get_queried_object();
				$field = trim(WPSEO_Taxonomy_Meta::get_term_meta($object, $object->taxonomy, 'title'));
				if($field) return $title;
			}
		}
	}
	
	$is = entex_theme_fn_get_is();
	$title = $is['title'];
	
	if(is_singular()){
		/* translators: */
		$title = sprintf(_x('%1$s - %2$s', 'Document title: Headline - Sitename', 'entex'), $title, get_bloginfo('name', 'display'));
		if($is['is-multipage'] != 'No' && $is['is-paged'] == 'Yes') $title = $title .' - '. mb_strtolower($is['is-multipage']);
		/* filter */
		$title = apply_filters('entex_theme_document_title_singular', $title);
	} else {
		/* translators: */
		$title = sprintf(_x('%1$s at %2$s', 'Document title: Headline at Sitename', 'entex'), $title, get_bloginfo('name', 'display'));
		if($is['is-multipage'] != 'No' && $is['is-paged'] == 'Yes') $title = $title .' - '. mb_strtolower($is['is-multipage']);
		/* filter */
		$title = apply_filters('entex_theme_document_title_archive', $title);
	}
	
	$title = esc_attr($title);
	
	add_filter('wpseo_opengraph_title', function($wpseo_title) use ($title){
		return $title;
	}, 60, 1);
	return $title;
}
add_filter('pre_get_document_title', 'entex_theme_filter_pre_get_document_title', 60, 1);



/* -------------------- */
// ARCHIVE TITLE FILTER
function entex_theme_filter_the_archive_title($title){
	$title = entex_theme_fn_get_the_current_title();
	return $title;
}
add_filter('get_the_archive_title', 'entex_theme_filter_the_archive_title', 10, 1);



/* -------------------- */
// SINGLE PAGE CONTENT FILTER
function entex_theme_filter_page_content_not_main($classes){
	if(is_page()){
		$meta = entex_theme_get_meta_content_not_main();
		if($meta) $classes[] = 'ua-not-main';
	}
	return $classes;
}
add_filter('entex_theme_singular_class', 'entex_theme_filter_page_content_not_main', 10, 1);



/* -------------------- */
// PAGE REDIRECT
/**
 * Only affectes permalinks (for pages) including within menues
 * This objectives are mainly to use parent pages as menu navigation headings
 * But tey need to redirect to first subpage inside breadcrumbs
 * 
 * As of YOAST started indexing things, we must go ahead even deeper and use
 * internal WP filters
 *
**/

// NEW FILTER:
function entex_theme_redirect_get_page_link($link, $post_id){
	if(is_admin()) return $link;
	
	if(function_exists('entex_theme_get_meta_page_redirect')){
		$id = entex_theme_get_meta_page_redirect($post_id);
		if($id) $link = get_permalink($id);
	}
	return $link;
}
add_filter('_get_page_link', 'entex_theme_redirect_get_page_link', 60, 2);




/* -------------------- */
// TEMPLATE HTML CLASS
function entex_theme_filter_html_class($classes){
	if(defined('ENTEX_SITE_SCALE')) $classes[] = 'ua-is-scaled';
	return $classes;
}
add_filter('entex_theme_html_class', 'entex_theme_filter_html_class', 10, 1);




/* -------------------- */
// TEMPLATE POST CLASS
/* NOTE: THIS IS APPLIED IN ADMIN AS WELL */
function entex_theme_filter_post_class($classes){

	/* cleanup as array */
	$classes = explode(' ', implode(' ', $classes));
	
	if(in_array(get_post_format(), array('status', 'gallery')) && get_post_gallery()) $classes[] = 'article-is-gallery';

	$main = false;
	static $main_done = false;

	if(is_singular() && in_the_loop() && !$main_done){
		$classes[] = 'article-is-main';
		$main = true;
		$main_done = true;
    } else if(!is_singular() && in_the_loop()){
		$classes[] = 'article-is-loop';
		$classes[] = 'article-is-main-loop';
	} else {
		$classes[] = 'article-is-loop';
		$classes[] = 'article-is-not-main-loop';
	}
	
	if(entex_theme_fn_is_current_term_id()){
		$classes[] = 'article-is-current-term';
	}
	$classes[] = 'article-is-'.(get_post_format() ? : 'standard');
	$classes[] = 'article-is-'.get_post_type();

	if(get_post_type() == 'attachment'){
		global $post;
		if(wp_attachment_is('image', $post)){
			$classes[] = 'article-is-image';
		} else if(wp_attachment_is('video', $post)){
			$classes[] = 'article-is-video';
		} else if(wp_attachment_is('audio', $post)){
			$classes[] = 'article-is-audio';
		} else {
			$classes[] = 'article-is-media';
		}
	}
	
	if(!$main && in_the_loop()){
		global $wp_query;
		$nr = absint($wp_query->current_post);
		$nr++;
		/* NEW */
		$args = get_query_var('args');
		if(isset($args['index'])){
			$nr = $args['index'];
		}
		$classes[] = 'article-is-number-'. $nr;
	}
	if($main && is_page() && in_the_loop()){
		$classes = array_diff($classes, array('hentry'));
	}
	
	return $classes;
}
add_filter('post_class', 'entex_theme_filter_post_class', 10, 1);



/* -------------------- */
// TEMPLATE BODY CLASS
function entex_theme_filter_body_class($classes){
	
	$classes[] = 'entex';
	$classes[] = 'entex-theme';
	if(defined('ENTEX_SITE_WIDE')) $classes[] = 'ua-is-wide';
	$classes[] = 'wp-is-'.entex_fn_lowercase(get_bloginfo('language'));
	if(is_admin_bar_showing()) $classes[] = 'wp-is-admin-bar';
	
	if(is_front_page()) $classes[] = 'wp-is-front-page';
	if(is_home()) $classes[] = 'wp-is-home';
	if(!is_page()) $classes[] = 'hfeed';
	if(is_singular()) $classes[] = 'wp-is-singular';
		else $classes[] = 'wp-is-archive';
	if(is_date()){
		$classes[] = 'wp-is-date';
		if(is_day()) $classes[] = 'wp-is-day';
		if(is_month()) $classes[] = 'wp-is-month';
		if(is_year()) $classes[] = 'wp-is-year';
		if(is_time()) $classes[] = 'wp-is-time';
	}
	if(is_author()) $classes[] = 'wp-is-author';
	if(is_search()) $classes[] = 'wp-is-search';
	if(is_attachment()) $classes[] = 'wp-is-attachment';
	
	if(current_user_can('manage_options')) $classes[] = 'wp-user-is-administrator';
	if(current_user_can('manage_categories')) $classes[] = 'wp-user-is-editor';
	
	if(defined('ENTEX_BREADCRUMBS_SHOW_ALL')) $classes[] = 'ua-crumbs-all';
	if(!get_theme_mod('entex_theme_remove_wp_is_initial', 0)) $classes[] = 'wp-is-initial';

	return $classes;
}
add_filter('body_class', 'entex_theme_filter_body_class');



/* -------------------- */
// TEMPLATE ARCHIVE WRAPPER CLASS
/* prepared */
function entex_theme_filter_archive_class($classes, $data = array()){
	return $classes;
}
add_filter('entex_theme_archive_class', 'entex_theme_filter_archive_class', 10, 2);



/* -------------------- */
// FRONT-END ADMIN EDIT LINK
function entex_theme_filter_get_edit_post_link_front_end_remove($link){
	if(is_admin()) return $link;
	if(defined('ENTEX_THEME_EDIT_POST_LINK_FALSE')) $link = false;
	return $link;
}
add_filter('get_edit_post_link', 'entex_theme_filter_get_edit_post_link_front_end_remove', 10, 1);



/* -------------------- */
// LOGIN LOGOUT PAGE MESSAGE

function entex_theme_login_redirect_message($redirect_to, $request, $user){
	$redirect_to = add_query_arg('page_message', 'login', $redirect_to);
	return $redirect_to;
}
add_filter('login_redirect', 'entex_theme_login_redirect_message', 60, 3);


function entex_theme_logout_redirect_message($redirect_to, $request, $user){
	$redirect_to = add_query_arg('page_message', 'logout', $redirect_to);
	return $redirect_to;
}
add_filter('logout_redirect', 'entex_theme_logout_redirect_message', 60, 3);

function entex_theme_get_page_message_login_logout(){
	
	$message = '';
	if(!$message = filter_input(INPUT_GET, 'page_message', FILTER_SANITIZE_STRING)) return '';
	
	if($message == 'logout'){
		$message = esc_html(__('You are now logged out', 'entex'));
	}
	if($message == 'login'){
		$message = esc_html(__('You are now logged in', 'entex'));
	}
	return $message;
}

function entex_template_page_message_login_logout(){
	$message = entex_theme_get_page_message_login_logout();
	if($message) entex_template_output_page_message($indent = 0, $message);
}
add_action('entex_template_before_main_content', 'entex_template_page_message_login_logout', 30);



// -- END FILE -- //