<?php 

// UPDATED 2022 05 08 

// This file must run independent and 'safe' to not be included within the Theme
// Do not manually populate default values here for empty fields

// These are the functions that fetches data from theme related custom & meta fields
// And gives the values back to current template functions
// How they are stored is not important here
// Some fields are populated by filters or manual metaboxes, or ACF plugin
// However, if any filter or metabox is deactivated or replaced
// These fields are rendered anyway
// As those are THEME LAYOUT / PRESENTATION related data, not extensions or plugin stuff




/* -------------------- */
// GET HIDE POST THUMBNAIL ON LANDING PAGE

function entex_theme_get_meta_post_thumbnail_hide(){
	global $post;
	$meta = get_post_meta($post->ID, 'entex_post_thumbnail_hide', true);
	$meta = ($meta == 'hide' ? true : false);
	return apply_filters('entex_theme_filter_get_meta_post_thumbnail_hide', $meta);
}



/* -------------------- */
// GET POST THUMBNAIL BORDER

function entex_theme_get_meta_post_thumbnail_border($post_id = null){
	if(!$post_id){
		global $post;
		if(isset($post->ID)) $post_id = $post->ID;
			else return false;
	}
	$meta = get_post_meta($post_id, 'entex_post_thumbnail_border', true);
	$meta = ($meta == 'border' ? true : false);
	return $meta;
}


/* changed 2.20508 to return string (meta) */
function entex_theme_get_meta_post_thumbnail_focus($post_id = null){
	if(!$post_id){
		global $post;
		if(isset($post->ID)) $post_id = $post->ID;
			else return false;
	}
	$meta = get_post_meta($post_id, 'entex_post_thumbnail_focus', true);
	return $meta;
}

/* core: apply the border or the object-position on img element */
function entex_admin_set_attachment_image_attributes($attr, $attachment, $size){
	$meta = entex_theme_get_meta_post_thumbnail_border();
	if($meta){
		if(!isset($attr['class'])) $attr['class'] = 'ua-image-border';
			else $attr['class'] .= ' ua-image-border';
	}
	$meta = entex_theme_get_meta_post_thumbnail_focus();
	if($meta){
		if(!isset($attr['class'])) $attr['class'] = 'ua-image-focus ua-image-focus-'.$meta;
			else $attr['class'] .= ' ua-image-focus ua-image-focus-'.$meta;
	}
	return $attr;
}
add_filter('wp_get_attachment_image_attributes', 'entex_admin_set_attachment_image_attributes', 10, 3);

/* -------------------- */






/* -------------------- */
// GET PREAMBLE BEFORE POST-THUMBNAIL
/* might be bypassed by templates as do not 'validate' */

function entex_theme_get_meta_preamble($post_id = null){
	if(!$post_id){
		global $post;
		if(isset($post->ID)) $post_id = $post->ID;
			else return false;
	}
	if(defined('ENTEX_CLASSIC_EDITOR_INTERFACE')) return false;
	$meta = get_post_meta($post_id, 'entex_preamble', true);
	$meta = ($meta == 'preamble' ? true : false);
	return apply_filters('entex_theme_filter_get_meta_preamble', $meta);
}





/* -------------------- */
// CUSTOM FIELD: ANCHOR TABS

function entex_theme_get_meta_tab($name){
	
	$id = get_queried_object_id();
	if(!$id) return false;
	
	if(is_singular() || is_home()) $term = false;
		else $term = true;
	if($term) $meta = get_term_meta($id, $name, true);
		else $meta = get_post_meta($id, $name, true);
	if(empty($meta)) return false;
		else return $meta;
}

function entex_theme_get_meta_shortcut_tabs($indent, $position){

	/* comment */
	do_action('entex_template_before_function', 0, 
		'', 
		__FILE__, entex_backtrace(2), 
		__FUNCTION__, __LINE__
	);
	
	$meta = entex_theme_get_meta_tab('entex_shortcut_tabs_disable');
	if($meta) return 'off';
	
	/* Labels and Targets */
	
	$label_1 = apply_filters('entex_shortcut_tab_1_label', esc_html_x('Content', 'Shortcut label', 'entex'));
	$meta = entex_theme_get_meta_tab('entex_shortcut_tab_1_label');
	if($meta) $label_1 = $meta;
	
	$target_1 = esc_attr(apply_filters('entex_shortcut_tab_1_bookmark', 'main'));
	$meta = entex_theme_get_meta_tab('entex_shortcut_tab_1_bookmark');
	if($meta) $target_1 = $meta;
	
	$show_1 = true;
	
	
	$label_2 = apply_filters('entex_shortcut_tab_2_label', esc_html_x('Related', 'Shortcut label', 'entex'));
	$meta = entex_theme_get_meta_tab('entex_shortcut_tab_2_label');
	if($meta) $label_2 = $meta;
	
	$target_2 = esc_attr(apply_filters('entex_shortcut_tab_2_bookmark', 'aside'));
	$meta = entex_theme_get_meta_tab('entex_shortcut_tab_2_bookmark');
	if($meta) $target_2 = $meta;
	
	$show_2 = true;
	$meta = entex_theme_get_meta_tab('entex_shortcut_tab_2_hide');
	if($meta) $show_2 = false;
	
	
	$label_3 = apply_filters('entex_shortcut_tab_3_label', esc_html_x('Footer', 'Shortcut label', 'entex'));
	$meta = entex_theme_get_meta_tab('entex_shortcut_tab_3_label');
	if($meta) $label_3 = $meta;
	
	$target_3 = esc_attr(apply_filters('entex_shortcut_tab_3_bookmark', '#ua-id-footer'));
	$meta = entex_theme_get_meta_tab('entex_shortcut_tab_3_bookmark');
	if($meta) $target_3 = $meta;
	
	$show_3 = false;
	$meta = entex_theme_get_meta_tab('entex_shortcut_tab_3_show');
	if($meta) $show_3 = true;
	
	
	$label_4 = apply_filters('entex_shortcut_tab_4_label', esc_html_x('Cart', 'Shortcut label', 'entex'));
	$meta = entex_theme_get_meta_tab('entex_shortcut_tab_4_label');
	if($meta) $label_4 = $meta;
	
	$target_4 = esc_attr(apply_filters('entex_shortcut_tab_4_bookmark', '#ua-bookmark-4'));
	$meta = entex_theme_get_meta_tab('entex_shortcut_tab_4_bookmark');
	if($meta) $target_4 = $meta;
	
	$show_4 = false;
	$meta = entex_theme_get_meta_tab('entex_shortcut_tab_4_show');
	if($meta) $show_4 = true;
	
	$intercept = false;
	$meta = entex_theme_get_meta_tab('entex_shortcut_tab_4_intercept');
	if($meta) $intercept = true;
	
	/* filter */
	// Overrides all if filtered in by array
	$data = apply_filters('entex_theme_tabs_data', array());
	if(!empty($data)){
		
		if(!empty($data[1]['show'])) $show_1 = $data[1]['show'];
		if(!empty($data[1]['label'])) $label_1 = $data[1]['label'];
		if(!empty($data[1]['target'])) $target_1 = $data[1]['target'];
		
		if(!empty($data[2]['show'])) $show_2 = $data[2]['show'];
		if(!empty($data[2]['label'])) $label_2 = $data[2]['label'];
		if(!empty($data[2]['target'])) $target_2 = $data[2]['target'];
		
		if(!empty($data[3]['show'])) $show_3 = $data[3]['show'];
		if(!empty($data[3]['label'])) $label_3 = $data[3]['label'];
		if(!empty($data[3]['target'])) $target_3 = $data[3]['target'];
		
		if(!empty($data[4]['show'])) $show_4 = $data[4]['show'];
		if(!empty($data[4]['label'])) $label_4 = $data[4]['label'];
		if(!empty($data[4]['target'])) $target_4 = $data[4]['target'];
		if(!empty($data[4]['intercept'])) $intercept = $data[4]['intercept'];
	}
	
	
	/* Build the tags */
	// NOTE: href are id not escaped urls
	
	$default = '';
	if($show_1) $default .= entex_IND($indent, 0).'<li class="ua-shortcut-1 selected"><a class="ua-tab-bookmark-1" href="'. esc_attr($target_1) .'">'. esc_html($label_1) .'</a></li>'.entex_LBR();
	if($intercept){
		if($show_4) $default .= entex_IND($indent, 0).'<li class="ua-shortcut-4"><a class="ua-tab-bookmark-4" href="'. esc_attr($target_4) .'">'. esc_html($label_4) .'</a></li>'.entex_LBR();
	}
	if($show_2) $default .= entex_IND($indent, 0).'<li class="ua-shortcut-2"><a class="ua-tab-bookmark-2" href="'. esc_attr($target_2) .'">'. esc_html($label_2) .'</a></li>'.entex_LBR();
	if($show_3) $default .= entex_IND($indent, 0).'<li class="ua-shortcut-3"><a class="ua-tab-bookmark-3" href="'. esc_attr($target_3) .'">'. esc_html($label_3) .'</a></li>'.entex_LBR();
	if(!$intercept){
		if($show_4) $default .= entex_IND($indent, 0).'<li class="ua-shortcut-4"><a class="ua-tab-bookmark-4" href="'. esc_attr($target_4) .'">'. esc_html($label_4) .'</a></li>'.entex_LBR();
	}
	
	
	/* Visibility and Events */
	$meta = entex_theme_get_meta_tab('entex_shortcut_tabs_visibility');
	if($meta) $x = '';
	
	return $default;
}


// END: ANCHOR TABS
/* ******************** */






/* -------------------- */
// CUSTOM FIELD: REDIRECT

function entex_theme_get_meta_page_redirect($post_id, $calculate = true){
	
	$redirect = get_post_meta($post_id, 'entex_page_redirect_to_child', true);
	if($redirect == 'redirect'){
		/* used by menu filter */
		if(!$calculate) return true;
		$children = get_pages('child_of='. $post_id .'&sort_column=menu_order');
		if(!empty($children[0])) return absint($children[0]->ID);
			else return false;
	} else return false;
}

/* ADMIN TABLE */

function entex_admin_display_post_states_redirect($post_states, $post){
	
	$post_id = $post->ID;
	$meta = null;

	$redirect = get_post_meta($post_id, 'entex_page_redirect_to_child', true);
	if($redirect == 'redirect'){
		$conditional = '';
		$children = get_pages('child_of='. $post_id .'&sort_column=menu_order');
		if(!empty($children[0])){
			$title = esc_html(get_the_title($children[0]->ID));
		} else {
			$conditional = '<span style="color: #0073aa; font-weight: 400;">'. esc_html_x('WARNING', 'Admin: Status notice', 'entex') .'</span>';
			$title = esc_html_x('No child page found', 'Admin: Status notice', 'entex');
		}
		/* sanitized */
		$post_states[] = esc_html_x('Redirected', 'Admin: Status notice', 'entex') .': '. $conditional .' <span style="color: #999; font-weight: 400;">'. $title .'</span>';
		return $post_states;
	}
	
	return $post_states;
}

function entex_admin_init_display_post_states_redirect(){
	add_filter('display_post_states', 'entex_admin_display_post_states_redirect', 10, 2);
}
add_action('admin_head-edit.php', 'entex_admin_init_display_post_states_redirect');







/* -------------------- */
// CUSTOM FIELD: CONTENT NOT MAIN
/* Only available for pages */

function entex_theme_get_meta_content_not_main(){
	global $post;
	if(get_post_meta($post->ID, 'entex_page_content_not_main', true)) return true;
		else return false;
}






/* -------------------- */
// CUSTOM FIELD: SINGULAR MAIN HEADER IMAGE
/* uses closest taxonomy image */

function entex_theme_get_meta_singular_header_image($term_id = null){
	
	if(is_page()) return '';
	
	static $cache = null;
	if($cache) return $cache;
	
	$term_id = entex_theme_fn_get_parent_id();
	$meta = get_term_meta($term_id, 'entex_archive_image', true);
	if(!$meta){
		$parents = entex_theme_fn_get_term_parents($term_id);
		if(empty($parents)) return '';
		foreach($parents as $term_id){
			$meta = get_term_meta($term_id, 'entex_archive_image', true);
			if($meta) break;
		}
	}
	
	if($meta) $cache = $meta;
	if($meta) return $meta;
		else return '';
}



/* -------------------- */
// CUSTOM FIELD: ARCHIVE MAIN HEADER IMAGE

function entex_theme_get_meta_archive_image($term_id = null){
	
	static $cache = null;
	if($cache) return $cache;
	
	$current = entex_theme_fn_get_is();
	if(!$term_id) $term_id = $current['id'];
	
	$meta = get_term_meta($term_id, 'entex_archive_image', true);
	if(!$meta){
		$parents = entex_theme_fn_get_term_parents($term_id);
		if(empty($parents)) return '';
		foreach($parents as $term_id){
			$meta = get_term_meta($term_id, 'entex_archive_image', true);
			if($meta) break;
		}
	}
	if($meta) $cache = $meta;
	if($meta) return $meta;
		else return '';
}



/* -------------------- */
// ADMIN TABLE: THEME ARCHIVE IMAGE

function entex_admin_archive_image_column_content($content, $column_name, $term_id){
	if(!defined('ENTEX_ARCHIVE_IMAGE_DISABLE')){
		switch ($column_name) {
			case 'archive-image':
				$image_id = get_term_meta($term_id, 'entex_archive_image', true);
				$image_id = apply_filters('entex_theme_archive_image_id', $image_id, $term_id);
				if($image_id) $content = wp_get_attachment_image($image_id, 'thumbnail');
					else $content = '-';
				break;
			default:
				break;
		}
	}
	return $content;
}
add_filter('manage_category_custom_column', 'entex_admin_archive_image_column_content', 1, 3);

function entex_admin_archive_image_column($columns){
	if(!defined('ENTEX_ARCHIVE_IMAGE_DISABLE')) $columns['archive-image'] = esc_html_x('Image', 'Admin', 'entex');
	return $columns;
}
add_filter('manage_edit-category_columns', 'entex_admin_archive_image_column' , 1, 1);

function entex_admin_archive_image_style($hook){
	if(!defined('ENTEX_ARCHIVE_IMAGE_DISABLE')){
		$add = '';
		$add .= '/* added in: '. basename( __FILE__ ) .' */ '.entex_LBR();
		$add .= '.archive-image.column-archive-image img { max-width: 60px; border: 1px solid #dbdbdb; height: auto !important; }';

		wp_register_style('entex-admin-archive-image', false);
		wp_enqueue_style('entex-admin-archive-image');
		wp_add_inline_style('entex-admin-archive-image', $add);
	}
}
add_action('admin_enqueue_scripts', 'entex_admin_archive_image_style', 60, 1);






// -- END FILE -- //