<?php if(!defined('ABSPATH')) die();

/**
 * Template for comments and pingbacks.
 * Buddypress compatible hybrid (from 2009)
 * To override this walker in a child theme without modifying the comments template
 * simply create your own bp_dtheme_blog_comments(), and that function will be used instead.
 *
 * Used as a callback by wp_list_comments() for displaying the comments.
 * NOTE: Edit comment link is hidden by CSS for now
 *
 * @param mixed $comment Comment record from database
 * @param array $args Arguments from wp_list_comments() call
 * @param int $depth Comment nesting level
 * @see wp_list_comments()
 *
 * NOTE: All collected HTML inside this file must be escaped or sanitized
 *
 * @version 2.10826
 */




if( !function_exists( 'bp_dtheme_blog_comments' )) :

function bp_dtheme_blog_comments($comment, $args, $depth){

	global $post;
	if('pingback' == $comment->comment_type) return false;
	if(function_exists('bp_is_user')) $buddypress = true;
		else $buddypress = false;

	if(1 == $depth) $avatar_size = 50;
		else $avatar_size = 25;
		
	$indent = 0;
	entex_OUT(entex_CML());
	static $started = false;
	
	do_action('entex_template_before_function', 0, '', __FILE__, entex_backtrace(8), __FUNCTION__, __LINE__);
	entex_OUT(entex_CMN($indent, 'level '.$depth));
	$started = true;
	
	if($buddypress && $comment->user_id){
		$avatar = wp_kses_post(bp_core_fetch_avatar(array('item_id' => $comment->user_id, 'width' => $avatar_size, 'height' => $avatar_size, 'email' => $comment->comment_author_email)));
	} else {
		$avatar = wp_kses_post(get_avatar($comment, $avatar_size, 'mystery', '', array('force_default' => true)));
	}
	if(!$avatar) $avatar = '<img class="avatar photo" alt="User avatar" src="'. esc_url(get_stylesheet_directory_uri().'/assets/images/mystery-man.jpg') .'" />';
	/* translators: */
	$hover = esc_html(sprintf(_x('%1$s commented on %2$s', 'Commments: Name commented on Date', 'entex'), get_comment_author(), get_comment_date()));
	
	$html = '';
	$html .= entex_IND($indent, 0).'<li title="'. esc_attr($hover) .'" class="'. esc_attr(join( ' ', apply_filters('comment_class', array('ua-wrapper', 'depth-'.$depth), array(), $comment->comment_ID, $comment, $post) )) .'" id="comment-'. $comment->comment_ID .'">'.entex_LBR();
	$html .= entex_IND($indent, 1).'<article class="level-'.$depth .'">'.entex_LBR();
	
	/* avatar */
	$html .= entex_IND($indent, 2).'<div class="comment-avatar acomment-avatar">'.entex_LBR();
	$html .= entex_IND($indent, 3).'<a href="'. get_comment_author_url() .'" rel="nofollow">'.$avatar.'</a>'.entex_LBR();
	$html .= entex_IND($indent, 2).'</div>'.entex_LBR();
	
	/* prepare meta time */
	if((time() - (86400*365)) < get_comment_date('U')){
		$ago = human_time_diff(get_comment_date('U'), current_time('timestamp'));
		/* translators: */
		$ago = sprintf(_x('%s ago', 'Comments meta LIKE: 10 days ago', 'entex'), $ago);
		$ago = '<time class="comment-date published updated" datetime="'. get_comment_date('c') .'">'. esc_html($ago) .'</time>';
	} else {
		$ago = get_comment_date();
		$ago = '<time class="comment-date published updated" datetime="'. get_comment_date('c') .'">'. esc_html($ago) .'</time>';
	}
	
	/* prepare meta user and vocabulary */
	if(get_current_user_id() == $comment->user_id){
		/* translators: */
		if(1 == $depth) $pattern = esc_html_x('%1$s _MARKER_ said %2$s', 'Comments meta LIKE: You said two days ago', 'entex');
			/* translators: */
			else $pattern = esc_html_x('%1$s _MARKER_ replied %2$s', 'Comments meta LIKE: You replied two days ago', 'entex');
		$person = esc_html_x('You', 'Comments meta LIKE: You said | You replied two days ago', 'entex');
	} else {
		/* translators: */
		if(1 == $depth) $pattern = esc_html_x('%1$s _MARKER_ said %2$s', 'Comments meta LIKE: Username said two days ago', 'entex');
			/* translators: */
			else $pattern = esc_html_x('%1$s _MARKER_ replied %2$s', 'Comments meta LIKE: Username replied two days ago', 'entex');
		$person = get_comment_author();
	}
	
	$pattern = str_replace(' _MARKER_ ', '</a> <span>', $pattern);
	$pattern = '<a href="%3$s" rel="nofollow">'. $pattern .'</span>';
	$url = get_comment_author_url();
	$meta = sprintf($pattern, $person, $ago, $url);
	
	/* edit link */
	$edit = '';
	if(current_user_can('edit_comment', $comment->comment_ID)){
		/* translators: */
		$edit = sprintf('<a style="float: right;" class="comment-edit-link bp-secondary-action" href="%1$s" title="%2$s">%3$s</a>', get_edit_comment_link($comment->comment_ID), esc_attr(_x('Edit comment', 'Comments', 'entex')), esc_html_x('Edit', 'Comments', 'entex'));
	}
	
	/* comment meta */
	$html .= entex_IND($indent, 2).'<div class="comment-meta acomment-meta">'. $meta .' '. $edit .'</div>'.entex_LBR();
	
	/* comment content */
	$html .= entex_IND($indent, 2).'<div class="comment-content acomment-content ua-content">'.entex_LBR();
	if($comment->comment_approved == '0') $html .= entex_IND($indent, 3).'<p class="moderate">'. esc_html_x('Your comment is awaiting moderation.', 'Comments', 'entex') .'</p>'.entex_LBR();
	$html .= entex_CMD('Posted comment');
	$html .= apply_filters('comment_text', get_comment_text($comment), $comment, array());
	$html .= entex_template_get_admin_edit_comment_wrapper(($indent + 2));
	$html .= entex_CMD('END Posted comment');
	$html .= entex_IND($indent, 2).'</div>'.entex_LBR();

	/* comment options */
	if(comments_open() || current_user_can('edit_comment', $comment->comment_ID)){
		$html .= entex_IND($indent, 2).'<div class="comment-options acomment-options">'.entex_LBR();
		/* reply */
		if(comments_open()){
			$link = get_comment_reply_link(array('reply_text' => esc_html_x('Reply to this comment', 'Comments', 'entex'), 'login_text' => esc_html_x('Please login to reply', 'Comments', 'entex'), 'depth' => $depth, 'max_depth' => $args['max_depth']));
			if($link) $html .= entex_IND($indent, 3).$link.entex_LBR();
		}
		$html .= entex_IND($indent, 2).'</div>'.entex_LBR();
	}

	$html .= entex_IND($indent, 1).'</article>'.entex_LBR();
	
	/* All collected HTML is sanitized */
	echo $html; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	entex_OUT(entex_CMN($indent, 'comment article end'));
}
endif;

// -- END FILE -- //