<?php if(!defined('ABSPATH')) die(); 

// ENTEX TEMPLATE ACTIONS
/* Attached as add_action */

/**
 * These are the HTML 'output by actions' functions 'called' from template files
 * All functions that constructs HTML markup should remain here
 * They are attached by add_action 
 * All registered actions below are within this file
 * However, many functions inside functions are resident in diffrent files
 * Those functions only collects the data
 * Note,
 * Some expected HTML might be a WordPress filter
 * WordPress Filters are not handled here
 * Any filter function in this file, 
 * are here because they are direct related to an actions below
 *
 * @version 2.30325
 *
**/

// Developers:
// All available filters are pre-commented with: /* filter */ for easy search


/* -------------------- */
// POST TYPE PAGE
/* remove comments feaute for pages */

function entex_theme_remove_comment_support_pages() {
	if(defined('ENTEX_COMMENTS_IS_PAGE_DISABLE')){
		remove_post_type_support('page', 'comments');
	}
}
add_action('init', 'entex_theme_remove_comment_support_pages', 60);



/* -------------------- */
// WordPress POST CLASS

/**
 * WordPress post_class standard hook replacement
 * This is a 'global' template output function
 * Simplified for cleaner templates as this applied standard filter is the most used snippet within template files:
 * echo 'class="' . join( ' ', apply_filters('post_class', array('hentry'), array(), get_the_ID()) ) . '"';
 * All post classes should/ must run through this wp standard
 * Pass the argument as array() (original) or space separated classname string
 * This hook converts them correctly because
 * The WordPress filter will always handle the classnames as an array
 *
 * Note, the post_class filter is wide in use by this theme and many plugins
 * Entex theme populates the filter inside entex-template-filters.php
 *
**/


/* -------------------- */
// ENTRIES (template) CLASS

function entex_template_output_post_class($classes = array()){
	if(!is_array($classes)) $arr = explode(' ', $classes);
		else $arr = $classes;
	echo esc_attr(join(' ', apply_filters('post_class', $arr, array(), get_the_ID())));
}



/* -------------------- */
// HTML (header.php) CLASS

function entex_template_output_html_class($classes = array(), $data = array()){
	if(!is_array($classes)) $arr = explode(' ', $classes);
		else $arr = $classes;
	echo esc_attr(join(' ', apply_filters('entex_theme_html_class', $arr, $data)));
}


/* -------------------- */
// ARCHIVE (index.php) CLASS

function entex_template_output_archive_class($classes = array(), $data = array()){
	if(!is_array($classes)) $arr = explode(' ', $classes);
		else $arr = $classes;
	echo esc_attr(join(' ', apply_filters('entex_theme_archive_class', $arr, $data)));
}


/* -------------------- */
// SINGULAR (template) CLASS

function entex_template_output_singular_class($classes = array(), $data = array()){
	if(!is_array($classes)) $arr = explode(' ', $classes);
		else $arr = $classes;
	echo esc_attr(join(' ', apply_filters('entex_theme_singular_class', $arr, $data)));
}






/* -------------------- */
// TEMPLATE OUTPUT ACTIONS

/**
 *
 * All registered actions below are within this file OR entex-template-output.php
 * All actions below, can be removed and replaced in your child theme
 * Suggest de-register between 'after_setup_theme' and 'wp_head' hooks
 *
 * Note: Some actions might be registered in other setup files
 * As they are related to specific contextual enviroment
 *
 * Note: Early actions, actions to actions, or hooks outside the template scope
 * Are as default registered below each function, not exactly here below
 *
**/

/* Also: ENTEX_CLEANUP_JAVASCRIPT_DETECTION_DISABLE */
add_action('wp_head', 'entex_template_output_javascript_detection', -5);
add_action('wp_head', 'entex_template_output_wp_head_default', -5);
/* This action is removed if YOAST is handle open graphs */
add_action('wp_head', 'entex_template_output_wp_head_preview_data', 10);

/* header.php */
add_action('entex_template_header_column_1', 'entex_template_output_header_branding', 10, 2); 
add_action('entex_template_before_main_content', 'entex_template_output_page_message', 10, 2);
add_action('entex_template_before_main_content', 'entex_template_output_breadcrumbs', 20, 1); // Prio changed

/* mixed */
add_action('entex_template_shortcut_tabs', 'entex_template_output_shortcut_tabs', 10, 3);

/* specified */
add_action('entex_template_shortcut_tabs_top', 'entex_template_output_shortcut_tabs', 10, 3);
add_action('entex_template_shortcut_tabs_bottom', 'entex_template_output_shortcut_tabs', 10, 3);

/* footer.php */ 
add_action('entex_template_footer_column_1', 'entex_template_output_footer_branding', 10, 1);
add_action('entex_template_footer_column_3', 'entex_template_output_footer_signature', 10, 1);

/* index.php */
add_action('entex_template_before_archive_title', 'entex_template_output_the_archive_header_image', 10, 1);
add_action('entex_template_after_archive_title', 'entex_template_output_archive_meta', 10, 1);
add_action('entex_template_before_archive_loop', 'entex_template_output_archive_description', 10, 1);
add_action('entex_template_archive_footer', 'entex_template_output_the_posts_pagination', 10, 1);

/* article.php */ 
// SINGULAR TEMPLATE FILES
add_action('entex_template_before_singular_title', 'entex_template_output_the_singular_header_image', 5, 1);
add_action('entex_template_before_singular_title', 'entex_template_output_before_singular_title', 10, 1);
add_action('entex_template_after_singular_title', 'entex_template_output_admin_edit_post_wrapper', 30, 1);
add_action('entex_template_before_singular_content', 'entex_template_output_singular_post_thumbnail', 10, 2);
add_action('entex_template_after_singular_content', 'entex_template_output_wp_link_pages', 10, 1);
add_action('entex_template_singular_end', 'entex_template_output_the_post_navigation', 10, 1);

/* article-entries.php */ 
// ENTRIES TEMPLATE FILES
/* Most of the calls are made from the template files as much as possible to make it esasier to clone to custom ones */
add_action('entex_template_before_entry_title', 'entex_template_output_before_entry_title', 10, 1);
add_action('entex_template_before_entry_end', 'entex_template_output_admin_edit_post_wrapper', 30, 1);

/* dynamic actions */


/* ******************** */






/* -------------------- */
// ACTION BEFORE EACH TEMPLATE
/* removable within templates, but always restored */

function entex_template_action_before_template(){
	/* hook */
	do_action('entex_template_add_action_before_template');
}
add_action('the_post', 'entex_template_action_before_template');


/* default registered action */
function entex_template_add_action_before_template_social_sharing(){
	add_action('entex_template_entry_footer_content', 'entex_template_output_social_sharing', 10, 1);
}
add_action('entex_template_add_action_before_template', 'entex_template_add_action_before_template_social_sharing');





/* -------------------- */
// EARLY ACTIONS

/**
 * These are the Theme´s template 'early' actions
 * Before templates are in use, No HTML output
 * All early actions below, can be removed and replaced in your child theme
 * Suggest de-register inside 'after_setup_theme' or before 'wp' hook
 *
**/


/* -------------------- */
// EARLY ACTION: Caches the contextual engine
/* contextual/entex-contextual-functions.php */

function entex_template_init_current(){
	/* just run only */
	if(!is_admin()) $cache = entex_theme_fn_get_is();
}
add_action('wp', 'entex_template_init_current', -5);







/* -------------------- */
// WP HEAD - Default

function entex_template_output_javascript_detection() { 

	/* Adds immediately a 'js' class to the root '<html>' element when JavaScript is detected. */
	echo "<script>(function(html){html.className = html.className.replace(/\bno-js\b/,'js')})(document.documentElement);</script>\n";
	/* Adds immediately a 'touch' class to the root '<html>' element when Touch screen device is detected. */
	echo "<script>document.documentElement.className += (('ontouchstart' in document.documentElement) ? ' ua-is-touch' : ' ua-not-touch');</script>\n";
}


function entex_template_output_wp_head_default(){

	$output = '';
	$output .= '<meta charset="'. get_bloginfo('charset') .'">'.entex_LBR();
	$output .= '<meta name="viewport" content="width=device-width, initial-scale=1">'.entex_LBR();

	$output .= apply_filters('entex_template_fi_wp_head_profile_link', '<link rel="profile" href="http://gmpg.org/xfn/11">'.entex_LBR());
	if(is_singular() && pings_open(get_queried_object())){
		$output .= '<link rel="pingback" href="'. esc_url(get_bloginfo('pingback_url')) .'">'.entex_LBR();
	}

	entex_OUT($output);
}





/* -------------------- */
// WP HEAD - Preview data
/* Not in use if YOAST plugin handles open graphs */

function entex_template_output_wp_head_preview_data(){

	if(defined('ENTEX_OPENGRAPH_DISABLE')) return;
	if(defined('ENTEX_YOAST_ACTIVE')) return;
	if(is_singular() && function_exists('entex_noindex')){
		if(entex_noindex()) return;
	}

	$output = "".entex_LBR();
	
	$preview = get_site_icon_url();
	if(is_singular() || is_home()){
		$title = get_the_title();
		$post_thumbnail = get_the_post_thumbnail_url(null, 'large');
		if($post_thumbnail) $preview = $post_thumbnail;

	} else {
		$title = get_the_archive_title();
	}

	$output .= '<meta property="og:title" content="'. esc_attr(wp_strip_all_tags($title, true)) .'" />'.entex_LBR();
	if($preview) $output .= '<meta property="og:image" content="'. $preview .'" />'.entex_LBR();

	entex_OUT($output);
}






/* -------------------- */
// SITE HEADER

function entex_template_output_header_branding($indent = 0){

	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';
	$content = '';
	
	/* Generate the markup might be false by customizer */
	
	$G_LOGO = get_theme_mod('entex_theme_custom_logo_visibility');
	$G_LOGO = ($G_LOGO ? false : true);
	
	$G_TITLE = get_theme_mod('entex_theme_site_title_visibility');
	$G_TITLE = ($G_TITLE ? false : true);
	
	$G_DESCRIPTION = get_theme_mod('entex_theme_site_description_visibility');
	$G_DESCRIPTION = ($G_DESCRIPTION ? false : true);

	if($G_LOGO){
		$custom_logo_id = get_theme_mod('custom_logo');
		if($custom_logo_id){
			$content = get_custom_logo();
		} else {
			if(defined('ENTEX_THEME_INITIAL_LOGO')) $logo = ENTEX_THEME_INITIAL_LOGO;
				else $logo = 'theme-logo-initial.png';
			$src = get_template_directory_uri() .'/assets/images/'.$logo;
			$content = '<img src="'. esc_url($src) .'" alt="'. esc_attr(get_bloginfo('name', 'display')) .'" />';
			if(!is_front_page()){
				$content = '<a href="'. esc_url(home_url('/')) .'" class="site-logo-link custom-logo-link">'. $content .'</a>';
			}
		}
	}
	
	if($content){
		$html .= entex_IND($indent, 0).'<div id="ua-id-logo-main" class="site-logo ua-site-logo">'.entex_LBR();
		$html .= entex_IND($indent, 1). $content .entex_LBR();
		$html .= entex_IND($indent, 0).'</div>'.entex_LBR();
	}
	
	if($G_TITLE || $G_DESCRIPTION){
		$html .= entex_IND($indent, 0).'<div id="ua-branding-inner-wr">'.entex_LBR();
		if($G_TITLE){
			$html .= entex_IND($indent, 1).'<div class="site-title">'.entex_LBR();
			/* do not link on front page */
			if(!is_front_page()) $html .= entex_IND($indent, 2).entex_theme_fn_get_home_link() .entex_LBR();
				else $html .= entex_IND($indent, 2). get_bloginfo('name') .entex_LBR();
			$html .= entex_IND($indent, 1).'</div>'.entex_LBR();
		}
		if($G_DESCRIPTION){
			$bloginfo = get_bloginfo('description', 'display');
			if($bloginfo) $html .= entex_IND($indent, 1).'<div class="site-description">'. $bloginfo .'</div>'.entex_LBR();
		}
		$html .= entex_IND($indent, 0).'</div>'.entex_LBR();
	}
	

	/* filter */
	$html = apply_filters('entex_template_output_header_branding_html', $html, $indent);
	$output = $html;
	
	entex_OUT($output);
}





/* -------------------- */
// SHORTCUT TABS
/* When $root = true, the template section markup is provided */
/* If you only need the navigation, set $root as false */

function entex_template_output_shortcut_tabs($indent = 0, $position = '', $root = true){
	entex_OUT(entex_template_get_shortcut_tabs($indent, $position, $root));
}

function entex_template_get_shortcut_tabs($indent = 0, $position = '', $root = true){

	if(defined('ENTEX_TEMPLATE_SHORTCUT_TABS_DISABLE')) return '';
	
	/* comment */
	do_action('entex_template_before_function', 0, 
		'', 
		__FILE__, entex_backtrace(2), 
		__FUNCTION__, __LINE__
	);
	
	$html = '';
	$output = '';
	
	if(!$position) $position = 'default';

	if(!function_exists('entex_theme_get_meta_shortcut_tabs')){
		
		$default = '';
		
		/* The default setup has only 2 tabs as we dont know the content structure */
		/* Targets (#id href) are Main column and Aside column as default */
		
		$label_1 = apply_filters('entex_shortcut_tab_1_label', _x('Content', 'Shortcut label', 'entex'));
		$label_2 = apply_filters('entex_shortcut_tab_2_label', _x('Related', 'Shortcut label', 'entex'));
		
		$default .= entex_IND(0, 0).'<li class="selected"><a href="main">'. esc_html($label_1) .'</a></li>'.entex_LBR();
		$default .= entex_IND(0, 0).'<li><a href="aside">'. esc_html($label_2) .'</a></li>'.entex_LBR();
		
		/* The default setup is not needed on full-width-pages as there is nothing to 'tab' to */
		if(false == apply_filters('entex_template_aside', true)) return '';
		
		/* filter */
		$content = apply_filters('entex_template_default_shortcut_tabs', $default, $indent, $position);
		
	} else {
		
		/* <li> elements */
		/* Indent removed */
		$content = entex_theme_get_meta_shortcut_tabs(0, $position, $root);
		if($content == 'off') return '';
		$content = apply_filters('entex_template_custom_shortcut_tabs', $content, $indent, $position, $root);

		/* The setup is not needed on full-width-pages as there is nothing to 'tab' to */
		/*
		if($content && count(explode('</li>', $content)) == 3){
			if(false == apply_filters('entex_template_aside', true)) return '';
		}
		*/
	}
	
	if($root){
		
	$html .= entex_IND($indent, 0).'<div class="ua-root ua-root-tabs-'. esc_attr($position) .'">'.entex_LBR();
	$html .= entex_IND($indent, 1).'<div class="ua-grid-root ua-set-sitewidth ua-grid-margin">'.entex_LBR();
	$html .= entex_IND($indent, 2).'<div class="ua-grid-item-1">'.entex_LBR();

	$html .= entex_IND($indent, 3).'<nav class="ua-row-tabs ua-tabs-'. esc_attr($position) .' ua-nav ua-nav-x">'.entex_LBR();
	$html .= entex_IND($indent, 4).'<ul>'.entex_LBR();
	$html .= $content;
	$html .= entex_IND($indent, 4).'</ul>'.entex_LBR();
	$html .= entex_IND($indent, 3).'</nav>'.entex_LBR();
	
	$html .= entex_IND($indent, 2).'</div>'.entex_LBR();
	$html .= entex_IND($indent, 1).'</div>'.entex_LBR();
	$html .= entex_IND($indent, 0).'</div>'.entex_LBR();
		
	} else {

	$html .= entex_IND($indent, 0).'<nav class="ua-row-tabs ua-tabs-'. esc_attr($position) .' ua-nav ua-nav-x">'.entex_LBR();
	$html .= entex_IND($indent, 1).'<ul>'.entex_LBR();
	$html .= $content;
	$html .= entex_IND($indent, 1).'</ul>'.entex_LBR();
	$html .= entex_IND($indent, 0).'</nav>'.entex_LBR();
	
	}
	
	/* filter */
	$html = apply_filters('entex_template_get_shortcut_tabs_html', $html, $content, $indent, $position, $root);
	$output = $html;
	return $output;
}





/* -------------------- */
// PAGE MESSAGE

function entex_template_output_page_message($indent = 0, $message = '', $status = ''){
	entex_OUT(entex_template_get_page_message($indent, $message, $status));
}

function entex_template_get_page_message($indent = 0, $message = '', $status = 'ua-message-attention'){

	/* comment */
	do_action('entex_template_before_function', 0, 
		'', 
		__FILE__, entex_backtrace(2), 
		__FUNCTION__, __LINE__
	);
	
	$html = '';
	$output = '';
	$content = '';

	if($message){
		$content = $message;
	} else {
		if(is_singular() || is_front_page()){
			$message = apply_filters('entex_theme_filter_get_post_message', $message, get_the_ID());
			if($message) $content = $message;
		} else {
			$term_id = get_queried_object_id();
			if($term_id) $message = apply_filters('entex_theme_filter_get_term_message', $message, $term_id);
			if($message) $content = $message;
		}
	}
	
	if(!$content) return '';
	
	if($status) $status = ' '. esc_attr($status);
		else $status = '';

	$html .= entex_IND($indent, 0).'<p class="ua-box'. $status .'">'.entex_LBR();
	$html .= $content;
	$html .= entex_IND($indent, 0).'</p>'.entex_LBR();
	
	/* filter */
	$html = apply_filters('entex_template_get_page_message_html', $html, $content, $message);
	$output = $html;
	return $output;
}






/* -------------------- */
// BREADCRUMBS
/**
 * Entex built in or Yoast
 * Define in functions.php which to use
 * Define Debug of JSON Schema to view correct sync
 * Breadcrumbs core is handled by inc/entex-core-breadcrumbs.php
 * All content filters and hooks are handled from there
 * Current <nav> wrapper classname is 'ua-crumbs'
 * All CSS is applied within '.ua-crumbs' as parent
 *
 * To use your own breadcrumb, remove the complete action
 *
**/

//define('ENTEX_BREADCRUMBS_SHOW_HOME_ON_TOP_LEVEL_PAGES', true);
//define('ENTEX_BREADCRUMBS_HIDE_HOME_ON_HOME', true);

function entex_template_output_breadcrumbs($indent = 0){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';

	if(is_front_page()) $wrapper = 'div';
		else $wrapper = 'nav';
	
	/* filter */
	$wrapper = apply_filters('entex_template_output_breadcrumbs_wrapper', $wrapper);
	
	/* filter */
	$classname = apply_filters('entex_template_output_breadcrumbs_classname', 'ua-crumbs');
	
	$is = entex_theme_fn_get_is();
	
	if(defined('ENTEX_BREADCRUMBS_YOAST')){
		$title = $is['breadcrumb'];
		if($is['breadcrumb-visible'] == 'No') $visible = ' class="screen-reader-text"';
			else $visible = '';
		if(defined('ENTEX_BREADCRUMBS_HIDE_HOME_ON_HOME') && is_front_page()) $classname .= ' screen-reader-text';
		if(!defined('ENTEX_BREADCRUMBS_SHOW_HOME_ON_TOP_LEVEL_PAGES') && is_singular()) $classname .= ' _|_';

		$output = yoast_breadcrumb('<div tabindex="0" class="'. esc_attr($classname) .'">', '<em'. $visible .' aria-current="page">'.$title.'</em></div>', false);
		$output .= entex_LBR().entex_LBR();
		
		/* toDo: paged pages still hides the whole wrapper instead of targeting first crumb class, as entex breadcrumbs do */
		/* this is the only way to target the html markup on first breadcrumb together with - inc/plugins/entex-plugin-wpseo.php */
		if(!defined('ENTEX_BREADCRUMBS_SHOW_HOME_ON_TOP_LEVEL_PAGES') && is_singular()){
			if(strpos($output, '¤') !== FALSE) {
				$output = str_replace('_|_', 'screen-reader-text', $output);
				$output = str_replace('¤', esc_attr_x('Go to startpage', 'Breadcrumbs', 'entex'), $output);
			} $output = str_replace('_|_', '', $output); // should not occur
		} else if(strpos($output, '¤') !== FALSE) {
			/* this should not occur */
			$output = str_replace('_|_', '', $output);
			$output = str_replace('¤', esc_attr_x('Go to startpage', 'Breadcrumbs', 'entex'), $output);
		}
		
		entex_OUT($output);
		
		/* circuit */
		return;
	}

	if(defined('ENTEX_BREADCRUMBS_DISABLE')) return $output;
	if(!function_exists('entex_breadcrumbs_populate_crumbs')) return $output;
	
	$hide = false;
	$hide_home = false;
	if(defined('ENTEX_BREADCRUMBS_HIDE')) $hide = true;
	if(defined('ENTEX_BREADCRUMBS_HIDE_HOME_WITHIN') && !is_front_page()) $hide_home = true;
	if(defined('ENTEX_BREADCRUMBS_HIDE_HOME_ON_HOME') && is_front_page()) $hide = true;
	
	
	$crumbs = entex_breadcrumbs_populate_crumbs();
	if(!$crumbs) return $output;

	if(!defined('ENTEX_BREADCRUMBS_SHOW_HOME_ON_TOP_LEVEL_PAGES') && !is_front_page() && is_singular()){
		if(count($crumbs) == 2){
			if($is['is-multipage'] == 'No') $hide = true;
				else $crumbs[0]['class'] = 'screen-reader-text';
		} 
	}

	$links = entex_breadcrumbs_populate_data($crumbs);
	if(empty($links)) return $output;

	if($hide){
		$classname .= ' screen-reader-text';
	} else if($hide_home){
		if(count($links) == 2){
			if(strpos($links[1], 'screen-reader-text') !== FALSE) $classname .= ' screen-reader-text';
		}
	}

	$content = '';
	foreach($links as $link){
		$content .= entex_IND($indent, 1). wp_kses_post($link) .entex_LBR();
	}
	if(!$content) return $output;
	if(strpos($content, 'href') === FALSE && $wrapper == 'nav') $wrapper = 'div';
	
	$html .= entex_IND($indent, 0).'<'. $wrapper .' tabindex="0" class="'. esc_attr($classname) .'">'.entex_LBR();
	$html .= $content;
	$html .= entex_IND($indent, 0).'</'. $wrapper .'>'.entex_LBR();
	
	$output = $html;
	entex_OUT($output);

}

/* -------------------- */




/* -------------------- */
// ARCHIVE DESCRIPTION

function entex_template_output_archive_description($indent = 0){
	entex_OUT(entex_template_get_archive_description($indent));
}

function entex_template_get_archive_description($indent = 0){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';
	
	$content = get_the_archive_description();
	if(!$content) return $output;
	if(!defined('ENTEX_LIMIT_SHORT_ARCHIVE_DESCRIPTION')){
		$threshold = 50;
		if(defined('ENTEX_LIMIT_SHORT_ARCHIVE_DESCRIPTION_THRESHOLD')) $threshold = ENTEX_LIMIT_SHORT_ARCHIVE_DESCRIPTION_THRESHOLD;
		if(strlen($content) < $threshold) return '';
	}
	
	/* ( content has wpautop()) */
	$html .= entex_IND($indent, 0).'<div class="ua-archive-description ua-content">'.entex_LBR();
	$html .= entex_IND($indent, 1). wp_kses_post($content) .entex_LBR();
	$html .= entex_IND($indent, 1).'</div>'.entex_LBR();
	
	/* filter */
	$html = apply_filters('entex_template_get_archive_description_html', $html, $content);
	$output = $html;
	return $output;
}






/* -------------------- */
// ARCHIVE META
/**
 * Archive meta appears below main archive title
 * This action covers everything that is NOT conditional: is_singular()
 * The default wrapper markup is <div>
 * The resident content is provided (building up) with filter(s)
 * The individual filter name follows Entex contextuals dynamic part
 * Each dynamic part will be found within Entex front-end monitor
 *
**/

function entex_template_output_archive_meta($indent = 0){
	entex_OUT(entex_template_get_archive_meta($indent));
}

function entex_template_get_archive_meta($indent = 0){

	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$content = '';
	
	$is = entex_theme_fn_get_is();
	$is = $is['dynamic-part'];
	
	// Default contextual meta
	/* translators: */
	$default = sprintf(_x( 'Content published at %s', 'Meta LIKE: Content published at Entex media LTD', 'entex'), entex_theme_fn_get_home_link());
	$default = entex_template_get_archive_meta_output($default);
	$content = apply_filters('entex_template_filter_archive_meta_default', $default);

	// Applies to current conditional
	$content = apply_filters('entex_template_add_archive_meta_'.$is, $content);
	
	// Applies to all conditionals
	$content = apply_filters('entex_template_add_archive_meta_content', $content);
	
	if(!$content) return '';
	$element = apply_filters('entex_template_get_archive_meta_element', 'div');
	
	$html = '';
	$html .= entex_IND($indent, 0).'<'. $element .' class="ua-meta ua-main-meta">'. wp_kses($content, entex_wp_kses()) .'</'. $element .'>';
	
	/* filter */
	$html = apply_filters('entex_template_get_archive_meta_html', $html, $content);
	$output = $html;
	return $output;
}


/* -------------------- */
// DEFAULT FILTERS FOR
// ARCHIVE META


/* ARCHIVE META default */
function entex_template_get_archive_meta_default($content = ''){
	
	$contextual = entex_template_get_archive_meta_contextual();
	/* replace if populated */
	if($contextual) $content = $contextual;
	return $content;
}
add_filter('entex_template_filter_archive_meta_default', 'entex_template_get_archive_meta_default', 20, 1);


/* ARCHIVE META category */
function entex_template_get_archive_meta_is_category($content = ''){
	
	/* replace */
	/* translators: */
	$content = sprintf(_x( 'Published posts at %s', 'Meta LIKE: Published posts at Entex media LTD', 'entex'), entex_theme_fn_get_home_link());
	$content = entex_template_get_archive_meta_output($content);
	return $content;
}
/* example of usage */
//add_filter('entex_template_add_archive_meta_is_category', 'entex_template_get_archive_meta_is_category', 10, 1);


/* ARCHIVE META content */
/* global filter - applies to all archive pages */
function entex_template_get_archive_meta_content($content = ''){
	
	/* add */
	$content .= entex_template_get_archive_meta_count();
	return $content;
}
add_filter('entex_template_add_archive_meta_content', 'entex_template_get_archive_meta_content', 20, 1);


// END ARCHIVE META
/* ******************** */






/* -------------------- */
// Archive META resident GET functions
// Should represent the archive META content

function entex_template_get_archive_meta_output($content, $cl = 'ua-meta-contextual'){
	
	if(!$content) return '';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. $content .$SP_E;
}


function entex_template_get_archive_meta_contextual(){
	
	$content = entex_theme_fn_get_archive_meta_contextual();
	if(!$content) return '';
	
	$cl = 'ua-meta-contextual';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. $content .$SP_E;
}


function entex_template_get_archive_meta_count(){

	$content = entex_theme_fn_get_counted_posts();
	if(!$content) return '';
	
	$cl = 'ua-meta-count';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. $content .$SP_E;
}


// END GET functions
/* ******************** */
/* -------------------- */






/* -------------------- */
// TITLES
/* Singular and entries template output replaces get_the_title() to use entex extended titles module */
/* Archive titles are filtered inside entex-template-filters.php */

function entex_template_get_the_title($post_id = null, $extended = true, $html = true){
	
	if(!$post_id) $post_id = get_the_ID();
	$title = get_the_title($post_id);
	
	if($extended){
		if(in_the_loop() && get_queried_object_id() == $post_id) $title = entex_theme_fn_get_the_current_title($title);
			else $title = entex_theme_fn_get_the_entry_title($title, $post_id);
	}
	if(!$html) $title = strip_tags($title);
	
	/* filter */
	$title = apply_filters('entex_template_get_the_title_html', $title, $post_id, $html, $extended);
	
	return $title;
}

// END: TITLES
/* ******************** */






/* -------------------- */
// BEFORE SINGULAR TITLE

function entex_template_output_before_singular_title($indent = 0, $data = null){
	entex_OUT(entex_template_get_before_singular_title($indent, $data));
}

function entex_template_get_before_singular_title($indent = 0, $data = null){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$content = '';
	
	$post_type = get_post_type();

	// Applies to current post type
	$content = apply_filters('entex_template_add_before_singular_title_is_'.$post_type, $content);
	
	// Applies to all post types
	$content = apply_filters('entex_template_add_before_singular_title_content', $content, $post_type);
	
	if(!$content) return '';
	
	$SET_CLASS = '';
	if(isset($data['classname'])){
		if($data['classname']) $SET_CLASS = ' class="'. esc_attr($data['classname']) .'"';
	} else $SET_CLASS = ' class="ua-above-title"';
	
	$html = '';
	$html .= entex_IND($indent, 0).'<div'.$SET_CLASS.'>'. wp_kses($content, entex_wp_kses()) .'</div>';
	
	/* filter */
	$html = apply_filters('entex_template_get_event_before_singular_title_html', $html, $content, $post_type);
	$output = $html;
	return $output;
}

/* -------------------- */






/* -------------------- */
// SINGULAR META
/**
 * Singular meta appears below main single post-type title
 * Replaces Subtitle
 * Shares the resident GET functions with ENTRY meta
 * The default wrapper markup is <h6>
 * The resident content is provided (building up) with filter(s)
 * Each filter calls resident GET function
 * The GET function carries HTML with the following rule:
 * Each direct child content is enclosed by span
 * Span devider is by default CSS ' | '
 * Each span is using classname 'ua-meta-' + defined
 * More information above the GET function section
 * 
**/

function entex_template_output_singular_meta($indent = 0, $classname = ''){
	entex_OUT(entex_template_get_singular_meta($indent, $classname));
}

function entex_template_get_singular_meta($indent = 0, $classname = ''){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);

	$output = '';
	$content = '';
	
	$post_type = get_post_type();

	// Applies to current post type
	$content = apply_filters('entex_template_add_singular_meta_is_'.$post_type, $content);
	
	// Applies to all post types
	$content = apply_filters('entex_template_add_singular_meta_content', $content, $post_type);
	
	if(!$content) return '';
	$element = apply_filters('entex_template_get_singular_meta_element', 'div');
	
	if($classname) $classname = ' class="'. esc_attr($classname) .'"';
		else $classname = 'ua-meta';
	
	$html = '';
	$html .= entex_IND($indent, 0).'<'. $element.$classname .'>'. wp_kses($content, entex_wp_kses()) .'</'. $element .'>';
	
	/* filter */
	$html = apply_filters('entex_template_get_singular_meta_html', $html, $content, $post_type);
	$output = $html;
	return $output;
}


/* -------------------- */
// DEFAULT FILTERS FOR
// SINGULAR META

/* SINGULAR META post */
function entex_template_get_singular_meta_is_post($content = ''){

	$content .= entex_template_get_meta_posted_on();
	$content .= entex_template_get_meta_by_author();
	$content .= entex_template_get_meta_comments();
	$content .= entex_template_get_meta_callback('the_views', false);
	return $content;
}
add_filter('entex_template_add_singular_meta_is_post', 'entex_template_get_singular_meta_is_post', 10, 1);


/* SINGULAR META attachment */
function entex_template_get_singular_meta_is_attachment($content = ''){

	$content .= entex_template_get_meta_posted_on();
	$content .= entex_template_get_meta_by_author();
	$content .= entex_template_get_meta_attachment_media_summary();
	$content .= entex_template_get_meta_attachment_dimension();
	$content .= entex_template_get_meta_comments();
	$content .= entex_template_get_meta_callback('the_views', false);
	return $content;
}
add_filter('entex_template_add_singular_meta_is_attachment', 'entex_template_get_singular_meta_is_attachment', 10, 1);


/* SINGULAR META page */ // - No meta as default - might use subtitles instead
function entex_template_get_singular_meta_is_page($content = ''){
	
	$content .= '';
	return $content;
}
add_filter('entex_template_add_singular_meta_is_page', 'entex_template_get_singular_meta_is_page', 10, 1);


// END SINGULAR META
/* ******************** */






/* -------------------- */
// ENTRY META
/**
 * Entry meta appears below EACH entry title
 * Shares the GET functions with SINGULAR meta
 * The default wrapper markup is <h6>
 * Accepts argument of classname
 * The resident content is provided by 'entex_template_get_meta' + defined
 * Each content is enclosed by spans
 * Each span is using classname 'ua-meta-' + defined
 * 
**/ 


function entex_template_output_entry_meta($indent = 0, $data = null){
	entex_OUT(entex_template_get_entry_meta($indent, $data));
}

/* Entries meta is global */
/* Please hook and unhook filters before and after your context */
/* Otherwise your filter is inherited by widgets and the rest of the page */

function entex_template_get_entry_meta($indent = 0, $data = null){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	if(defined('ENTEX_DISABLE_ENTRY_META')) return '';
	
	$output = '';
	$content = '';
	
	$post_type = get_post_type();

	// Applies to current post type
	$content = apply_filters('entex_template_add_entry_meta_is_'.$post_type, $content, $data);
	
	// Applies to all post types
	$content = apply_filters('entex_template_add_entry_meta_content', $content, $data, $post_type);
	
	if(!$content) return '';
	if(isset($data['classname']) && $data['classname']) $classname = trim($data['classname']);
		else $classname = '';
	if($classname) $SET_CLASS = ' class="entry-meta '. esc_attr($classname) .'"';
		else $SET_CLASS = ' class="entry-meta"';
	
	$html = '';
	$html .= entex_IND($indent, 0).'<div'.$SET_CLASS.'>'. wp_kses($content, entex_wp_kses()) .'</div>';
	
	/* filter */
	$data['indent'] = $indent;
	$html = apply_filters('entex_template_get_entry_meta_html', $html, $content, $data, $post_type);
	$output = $html;
	return $output;
}


/* -------------------- */
// DEFAULT FILTERS FOR
// ENTRY META

/* ENTRY META post */
function entex_template_get_entry_meta_is_post($content = ''){
	
	$content .= entex_template_get_meta_by_author();
	$content .= entex_template_get_meta_comments();
	if(is_search() || is_author()) $content .= entex_template_get_meta_callback('the_views', false);
	return $content;
}
add_filter('entex_template_add_entry_meta_is_post', 'entex_template_get_entry_meta_is_post', 10, 1);


/* ENTRY META post */
function entex_template_get_entry_meta_is_attachment($content = ''){
	
	/* example of variation */
	//$content .= entex_template_get_meta_updated_on();
	$content .= entex_template_get_meta_by_author();
	$content .= entex_template_get_meta_attachment_summary();
	$content .= entex_template_get_meta_attachment_dimension();
	/* example of variation */
	//$content .= entex_template_get_meta_attachment_filesize();
	if(in_the_loop()) $content .= entex_template_get_meta_comments();
	return $content;
}
add_filter('entex_template_add_entry_meta_is_attachment', 'entex_template_get_entry_meta_is_attachment', 10, 1);


/* ENTRY META page */ // - No meta as default
function entex_template_get_entry_meta_is_page($content = ''){
	
	$content .= '';
	return $content;
}
add_filter('entex_template_add_entry_meta_is_page', 'entex_template_get_entry_meta_is_page', 10, 1);


function entex_template_get_entry_edit_post_link($content){
	$link = entex_template_get_meta_edit_post_link();
	$content .= $link;
	return $content;
}
//add_filter('entex_template_add_entry_meta_content', 'entex_template_get_entry_edit_post_link', 10, 1);

// END ENTRY META
/* ******************** */






/* -------------------- */
// (ENTRY) PRE-HEADER
/**
 * Entry pre-header appears (only) above each ENTRY 'title'
 * But is rendered BEFORE (pre) <head> article section
 * Think 'Replaces' singular Breadcrumbs
 * The default wrapper markup is <div>
 * The resident content is provided (building up) with filter(s)
 * Each filter calls GET (meta) function(s)
 * The GET function carries HTML with the following rule:
 * Each direct child content is enclosed by span
 * Span devider is by default CSS ' / ' within the 'ua-pre-header' wrapper classname
 * Each direct child span is using classname 'ua-meta-' + defined
 *
 * Follow these rules if applied custom content directly inside filters
 * More information above the GET function section
 * 
**/

function entex_template_output_entry_pre_header($indent = 0, $data = null){
	entex_OUT(entex_template_get_entry_pre_header($indent, $data));
}

function entex_template_get_entry_pre_header($indent = 0, $data = null){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);

	$output = '';
	$content = '';
	$classname = 'ua-pre-header';
	
	$replace = '';
	if(isset($data['replace']) && $data['replace']){
		if(is_string($data['replace'])){
			$replace = '<span class="ua-meta-parent">'. wp_kses_post($data['replace']) .'</span>';
		}
	}
	
	/* only if no content (like parent or a date) is found */
	$replacement = '&nbsp;';
	if(isset($data['empty']) && $data['empty']){
		$empty = true;
		if(is_string($data['empty'])){
			$replacement = '<span class="ua-meta-parent">'. wp_kses_post($data['empty']) .'</span>';
		}
	} else $empty = false;
	
	if(isset($data['classname']) && $data['classname']) $classname .= ' '. $data['classname'];

	$post_type = get_post_type();

	// Applies to current post type
	$content = apply_filters('entex_template_add_entry_pre_header_is_'.$post_type, $content, $data);
	
	// Applies to all post types
	$content = apply_filters('entex_template_add_entry_pre_header_content', $content, $post_type, $data);
	
	if(!$replace){
		if(!$content && !$empty) return '';
		if(!$content && $replacement && $empty) $content = $replacement;
		if(!$content && $replacement == '&nbsp;') $classname .= ' ua-is-empty';
	} else {
		$content = $replace;
	}
	$html = '';
	$html .= entex_IND($indent, 0).'<div class="'. esc_attr($classname) .'">'.entex_LBR();
	if($content) $html .= entex_IND($indent, 1). wp_kses($content, entex_wp_kses()) .entex_LBR();
	$html .= entex_IND($indent, 0).'</div>'.entex_LBR();
	
	/* filter */
	$html = apply_filters('entex_template_get_entry_pre_header_html', $html, $content, $post_type, $data);
	$output = $html;
	return $output;
}


/* -------------------- */
// DEFAULT FILTERS FOR
// (ENTRY) PRE-HEADER 

/* (ENTRY) PRE-HEADER post */
function entex_template_get_entry_pre_header_is_post($content = ''){

	$content .= entex_template_get_meta_date();
	$content .= entex_template_get_meta_time();
	$content .= entex_template_get_meta_time_ago();
	$content .= entex_template_get_meta_parent_link();
	return $content;
}
add_filter('entex_template_add_entry_pre_header_is_post', 'entex_template_get_entry_pre_header_is_post', 10, 1);
add_filter('entex_template_add_entry_pre_header_is_attachment', 'entex_template_get_entry_pre_header_is_post', 10, 1);


/* (ENTRY) PRE-HEADER page */ // - (Current only on inclusions and on search results)
function entex_template_get_entry_pre_header_is_page($content = ''){

	$content .= entex_template_get_meta_parent_link();
	return $content;
}
add_filter('entex_template_add_entry_pre_header_is_page', 'entex_template_get_entry_pre_header_is_page', 10, 1);


/* filter only */
/* (ENTRY) PRE-HEADER contents AND attachment */ // - (Only on inclusions)
function entex_template_filter_add_entry_pre_header_is_contents($content = ''){

	$content .= entex_template_get_meta_parent();
	return $content;
}
add_filter('entex_template_add_entry_pre_header_is_contents', 'entex_template_filter_add_entry_pre_header_is_contents', 10, 1);
/* example of usage on attachment */
//add_filter('entex_template_add_entry_pre_header_is_attachment', 'entex_template_filter_add_entry_pre_header_is_contents', 10, 1);


/* example of usage */
/* (ENTRY) PRE-HEADER location */
function entex_template_get_entry_pre_header_is_wpseo_locations($content = ''){
	
	$content .= entex_template_get_meta_post_meta('_wpseo_business_city');
	$content .= entex_template_get_meta_parent_link();
	return $content;
}
add_filter('entex_template_add_entry_pre_header_is_wpseo_locations', 'entex_template_get_entry_pre_header_is_wpseo_locations', 10, 1);


// END (ENTRY) PRE-HEADER
/* ******************** */






/* -------------------- */
// BEFORE ENTRY TITLE

function entex_template_output_before_entry_title($indent = 0, $data = null){
	entex_OUT(entex_template_get_before_entry_title($indent, $data));
}

function entex_template_get_before_entry_title($indent = 0, $data = null){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$content = '';
	
	$post_type = get_post_type();

	// Applies to current post type
	$content = apply_filters('entex_template_add_before_entry_title_is_'.$post_type, $content);
	
	// Applies to all post types
	$content = apply_filters('entex_template_add_before_entry_title_content', $content, $post_type);
	
	if(!$content) return '';
	
	$SET_CLASS = '';
	if(isset($data['classname'])){
		if($data['classname']) $SET_CLASS = ' class="'. esc_attr($data['classname']) .'"';
	} else $SET_CLASS = ' class="ua-above-title"';
	
	$html = '';
	$html .= entex_IND($indent, 0).'<div'.$SET_CLASS.'>'. wp_kses($content, entex_wp_kses()) .'</div>';
	
	/* filter */
	$html = apply_filters('entex_template_get_event_before_entry_title_html', $html, $content, $post_type);
	$output = $html;
	return $output;
}

/* -------------------- */







/* -------------------- */
// SUBTITLE (Singular & entries)
/**
 * Subtitle appears directly below the title
 * The default wrapper markup is <h5>
 * Subtitle has higher priority then existsing meta
 * Any meta appears below the subtitle as default
 * 
**/

function entex_template_output_subtitle($indent = 0, $classname = '', $source = ''){
	entex_OUT(entex_template_get_subtitle($indent, $classname, $source));
}

function entex_template_get_subtitle($indent = 0, $classname = '', $source = ''){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';
	$content = '';
	
	$post_type = get_post_type();

	// Applies to current post type
	$content = apply_filters('entex_template_add_subtitle_is_'.$post_type, $content);
	
	// Applies to all post types
	$content = apply_filters('entex_template_add_subtitle_content', $content, $post_type);
	
	// Overrides if template sending source
	if($source) $content = $source;
	
	if(!$content) return '';
	
	if($classname) $classname = ' class="'. esc_attr($classname) .'"';
		else $classname = '';
	
	$html = '';
	$html .= entex_IND($indent, 0).'<h5'.$classname.'>'. wp_kses($content, entex_wp_kses()) .'</h5>';
	
	/* filter */
	$html = apply_filters('entex_template_get_subtitle_html', $html, $content);
	$output = $html;
	return $output;
}

/* -------------------- */
// SUBTITLE URL HOOKS

/* Also might be added inside template */
/* Open url instead of permalink, argument $link is an url */
function entex_theme_filter_post_link_subtitle_url($link){
	
	if(is_admin() && !wp_doing_ajax()) return $link; // maybe dep
	if(!function_exists('entex_theme_get_extended_sub_title')) return $link;
	$url = entex_theme_get_extended_sub_title_url();
	if($url) return $url;
		else return $link; 
}

function entex_template_add_filter_subtitle_url(){
	/* comment */
	do_action('entex_template_before_function', 0, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	add_filter('post_link', 'entex_theme_filter_post_link_subtitle_url', 10, 1);
}

function entex_template_remove_filter_subtitle_url(){
	/* comment */
	do_action('entex_template_before_function', 0, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	remove_filter('post_link', 'entex_theme_filter_post_link_subtitle_url', 10, 1);
}

function entex_theme_get_target_subtitle_url($post_id = null){
	if(!function_exists('entex_theme_get_extended_sub_title')) return '';
	if(!$post_id) $post_id = get_the_ID();
	$url = entex_theme_get_extended_sub_title_url($post_id);
	if($url) return ' target="_blank"';
		else return ''; 
}

function entex_theme_post_class_subtitle($classes){
	if(!function_exists('entex_theme_get_extended_sub_title')) return $classes;
	$url = entex_theme_get_extended_sub_title_url();
	if($url){
		$classes[] = 'article-is-external';
	}
	return $classes;
}
add_filter('post_class', 'entex_theme_post_class_subtitle', 10, 1);



/* -------------------- */
// DEFAULT FILTERS FOR
// SUBTITLE

/* SUBTITLE post */
function entex_template_get_subtitle_is_post($content = ''){ 

	$content .= entex_template_get_meta_subtitle();
	return $content;
}
add_filter('entex_template_add_subtitle_is_post', 'entex_template_get_subtitle_is_post', 10, 1);


/* SUBTITLE page */
function entex_template_get_subtitle_is_page($content = ''){ 
	
	$content .= entex_template_get_meta_subtitle();
	return $content;
}
add_filter('entex_template_add_subtitle_is_page', 'entex_template_get_subtitle_is_page', 10, 1);
add_filter('entex_template_add_subtitle_is_contents', 'entex_template_get_subtitle_is_page', 10, 1);


/* SUBTITLE attachment */ // This overrides post-meta if populated
function entex_template_get_subtitle_is_attachment($content = ''){ 
	
	$content .= entex_template_get_meta_subtitle();
	return $content;
}
add_filter('entex_template_add_subtitle_is_attachment', 'entex_template_get_subtitle_is_attachment', 10, 1);


// PLUGIN - move out - function name is user based
/* SUBTITLE Yoast SEO Location */
function entex_template_get_subtitle_is_wpseo_locations($content = ''){ 
	
	$content .= entex_template_get_meta_subtitle();
	return $content;
}
add_filter('entex_template_add_subtitle_is_wpseo_locations', 'entex_template_get_subtitle_is_wpseo_locations', 10, 1);


// END SUBTITLE
/* ******************** */






/* -------------------- */
// META resident GET functions
// Should represent the article META content

/**
 *
 * Each direct child content is enclosed by spans
 * Each span should carry the 'ua-meta-' classname
 * Span devider is by default CSS
 * Classnames might impact responsive presentations
 * Using .parent-wrapper-class > [class*=ua-meta-] properites
 *
**/
 
// GET WordPress content
// get functions are sanitized

function entex_template_get_meta_linebreak(){
	
	/* Mobile newline */
	$content = '<br />';
	return $content;
}

function entex_template_get_meta_time(){
	$cl = 'ua-meta-time';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. entex_theme_fn_get_time() .$SP_E;
}

function entex_template_get_meta_time_ago(){
	$cl = 'ua-meta-time-ago';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. entex_theme_fn_get_time_ago() .$SP_E;
}

function entex_template_get_meta_date($set_today = true, $set_updated = false){
	$cl = 'ua-meta-date';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. entex_theme_fn_get_date($set_today, $set_updated) .$SP_E;
}

function entex_template_get_meta_date_link(){
	$cl = 'ua-meta-date';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. entex_theme_fn_get_date_link() .$SP_E;
}

function entex_template_get_meta_posted_on(){
	$cl = 'ua-meta-date';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	/* translators: */
	return $SP_S. sprintf(_x('<span class="ua-posted-on">Posted on</span> %1$s', 'Meta vocabulary: Posted on Date', 'entex'), entex_theme_fn_get_date_link(false)) .$SP_E;
}

function entex_template_get_meta_updated_on(){
	$cl = 'ua-meta-date';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	/* translators: */
	return $SP_S. sprintf(_x('<span class="ua-posted-on">Updated on</span> %1$s', 'Meta vocabulary: Updated on Date', 'entex'), entex_theme_fn_get_date_link(false, true)) .$SP_E;
}

function entex_template_get_meta_by_author($hci = false){
	$cl = 'ua-meta-author';
	/* If true, classname 'ua-is-current-id' is provided with space */
	if($hci) $cl .= (entex_theme_fn_is_current_id(get_the_author_meta('ID')) ?: '');
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	/* translators: */
	return $SP_S. sprintf(_x('<span class="ua-by">By</span> %1$s', 'Meta vocabulary: By Author', 'entex'), entex_theme_fn_get_author_link()) .$SP_E;
}

function entex_template_get_meta_posted_by_author($hci = false){
	$cl = 'ua-meta-author';
	/* If true, classname 'ua-is-current-id' is provided with space */
	if($hci) $cl .= (entex_theme_fn_is_current_id(get_the_author_meta('ID')) ?: '');
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	/* translators: */
	return $SP_S. sprintf(_x('<span class="ua-posted-by">Posted by</span> %1$s', 'Meta vocabulary: Posted by Author', 'entex'), entex_theme_fn_get_author_link()) .$SP_E;
}

function entex_template_get_meta_published_by_author($hci = false){
	$cl = 'ua-meta-author';
	/* If true, classname 'ua-is-current-id' is provided with space */
	if($hci) $cl .= (entex_theme_fn_is_current_id(get_the_author_meta('ID')) ?: '');
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	/* translators: */
	return $SP_S. sprintf(_x('<span class="ua-published-by">Published by</span> %1$s', 'Meta vocabulary: Published by Author', 'entex'), entex_theme_fn_get_author_link()) .$SP_E;
}

function entex_template_get_meta_edit_post_link(){
	$link = entex_theme_fn_get_edit_post_link();
	if(!$link) return '';
	$cl = 'ua-meta-edit';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. $link .$SP_E;
}

function entex_template_get_meta_attachment_mime(){
	$cl = 'ua-meta-mime';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. entex_theme_fn_get_attachment_mime() .$SP_E;
}

function entex_template_get_meta_attachment_summary(){
	$cl = 'ua-meta-summary';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. entex_theme_fn_get_attachment_summary() .$SP_E;
}

function entex_template_get_meta_attachment_media_summary(){
	$cl = 'ua-meta-media-summary';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. entex_theme_fn_get_attachment_media_summary() .$SP_E;
}

function entex_template_get_meta_attachment_filename(){
	$cl = 'ua-meta-filename';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. entex_theme_fn_get_attachment_filename() .$SP_E;
}

function entex_template_get_meta_attachment_extension(){
	$cl = 'ua-meta-extension';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. entex_theme_fn_get_attachment_extension() .$SP_E;
}

function entex_template_get_meta_attachment_filesize(){
	$cl = 'ua-meta-filesize';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. entex_theme_fn_get_attachment_filesize() .$SP_E;
}

function entex_template_get_meta_attachment_dimension(){
	
	$content = entex_theme_fn_get_attachment_dimension();
	if(!$content) return '';
	
	$cl = 'ua-meta-dimension';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. $content .$SP_E;
}

function entex_template_get_meta_attachment_parent(){
	
	$content = entex_theme_fn_get_attachment_parent();
	if(!$content) return '';
	
	$cl = 'ua-meta-attachment-parent';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. $content .$SP_E;
}

function entex_template_get_meta_attachment_parent_link(){
	
	$content = entex_theme_fn_get_attachment_parent_link();
	if(!$content) return '';
	
	$cl = 'ua-meta-attachment-parent';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. $content .$SP_E;
}

function entex_template_get_meta_comments(){

	$cl = '';
	$content = '';
	/* Check the password requirement, maybe on entries as well */
	if(!comments_open()) $cl = ' ua-comments-closed';
	if(!is_singular() && !post_password_required() && (comments_open() || get_comments_number())){
		// Entries:
		$content = '<span class="ua-meta-comments'. esc_attr($cl) .'">'. entex_theme_fn_get_comments_link() .'</span>';
	} else if(comments_open() || get_comments_number()){
		// Singular:
		$content = '<span class="ua-meta-comments'. esc_attr($cl) .'">'. entex_theme_fn_get_comments_link() .'</span>';
	}
	return $content;
}

/* plural */
function entex_template_get_meta_comments_last(){

	$cl = 'ua-meta-comment-last';
	/* global */
	$content = entex_theme_fn_get_comments_last_link();
	if(!$content) return '';
	
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	/* translators: */
	return $SP_S. sprintf(_x('Last comment posted on %s', 'Meta: Comments', 'entex'), $content) .$SP_E;
}

/* singular */
function entex_template_get_meta_comment_last(){

	$cl = 'ua-meta-comment-last';
	/* current post */
	$content = entex_theme_fn_get_comment_last_link();
	if(!$content) return '';
	
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	/* translators: */
	return $SP_S. sprintf(_x('Last comment posted on %s', 'Meta: Comments', 'entex'), $content) .$SP_E;
}


// GET extended by ENTEX content

function entex_template_get_meta_parent(){
	
	$parent_id = entex_theme_fn_get_parent_id();
	if(!$parent_id) return '';
	$cl = 'ua-meta-parent';
	
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. entex_theme_fn_get_parent() .$SP_E;
}

function entex_template_get_meta_parent_link($hci = true){
	
	$parent_id = entex_theme_fn_get_parent_id();
	if(!$parent_id) return '';
	$cl = 'ua-meta-parent';
	
	/* If true, classname 'ua-is-current-id' is provided with space */
	if($hci) $cl .= ' '. (entex_theme_fn_is_current_id($parent_id) ? : '');
	$cl = trim($cl);
	
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. entex_theme_fn_get_parent_link() .$SP_E;
}

function entex_template_get_meta_terms($post_id = null, $taxonomy = null, $sep = ', '){
	
	$terms = entex_theme_fn_get_post_taxonomy_terms($post_id, $taxonomy, $sep, false);
	if(!$terms) return '';
	
	$cl = 'ua-meta-terms';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. $terms .$SP_E;
}

function entex_template_get_meta_terms_link($post_id = null, $taxonomy = null, $sep = ', '){
	
	$terms = entex_theme_fn_get_post_taxonomy_terms($post_id, $taxonomy, $sep, true);
	if(!$terms) return '';
	
	$cl = 'ua-meta-terms';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. $terms .$SP_E;
}


// USER POST-META BASED
/* post meta key must be provided */
function entex_template_get_meta_post_meta($meta_key = null, $_true = '', $_false = ''){
	
	if(!$meta_key) return '';
	$content = get_post_meta(get_the_ID(), $meta_key, true);
	if(!$content) return $_false;
	if($_true) $content = $_true;
	$cl = 'ua-meta-post-meta ua-'.$meta_key;
	
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. $content .$SP_E;
}


// USER PLUGGABLE BASED
/** 
 * Simple callback wrapper 
 * Callback must return valid string
 * Use this to output data from 'maybe' installed plugins or functions
 * This mecanism also has a fallbeck argument
 *
**/

function entex_template_get_meta_callback($callback, $arguments = null, $fallback = ''){

	if(!function_exists($callback)) return $fallback;
	
	if($arguments === null){
		$content = call_user_func($callback);
	} else {
		$content = call_user_func($callback, $arguments);
	}
	if(!is_string($content) || !$content) return $fallback;
	
	$cl = 'ua-meta-callback';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. wp_kses($content, entex_wp_kses()) .$SP_E;
}


// ENTEX THEME DEFAULT MODULES
/**
 * Entex extended titles 
 * We could use: entex_template_get_meta_post_meta('entex_extended_sub_title')
 * We could use: entex_template_get_meta_callback('entex_theme_get_extended_sub_title') 
 * But this extension allows shortcodes 
 *
**/

function entex_template_get_meta_subtitle(){
	
	if(!function_exists('entex_theme_get_extended_sub_title')) return '';
	$content = entex_theme_get_extended_sub_title();
	if(!$content) return '';
	
	if(get_post_format() == 'link'){
		$url = entex_theme_get_extended_sub_title_url();
		$host = parse_url($url, PHP_URL_HOST);
		list($p) = explode($host, $url, 2);
		$content = $p.$host.'/';
		if($url){
			$content = '<a href="'. esc_url($url) .'" target="_blank" title="'. esc_attr(_x('Open url', 'Meta: Instructions', 'entex')) .'">'. wp_kses($content, entex_wp_kses()) .'</a>';
		}
	}
	
	$cl = 'ua-meta-subtitle';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. $content .$SP_E;
}

/* Extended title as subtitle */
function entex_template_get_meta_extended_main_title(){
	
	if(!function_exists('entex_theme_get_extended_main_title')) return '';
	$content = entex_theme_get_extended_main_title();
	if(!$content) return '';
	
	$cl = 'ua-meta-extended-title';
	$SP_S = '<span class="'. esc_attr($cl) .'">';
	$SP_E = '</span>';
	return $SP_S. $content .$SP_E;
}


// END GET functions
/* ******************** */
/* -------------------- */






/* -------------------- */
// POST FOOTER META 

function entex_template_output_footer_meta($indent = 0){
	entex_OUT(entex_template_get_footer_meta($indent));
}

function entex_template_get_footer_meta($indent = 0){ 

	/* comment */
	do_action('entex_template_before_function', 0, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);

	$output = '';
	$html = '';
	
	$format = (entex_theme_fn_get_format_link() ? true : false);
	$labels = (entex_theme_fn_get_post_tag_link() ? true : false);
	
	/* translators: */
	$placeholder = _x('Published on %1$s by %2$s as %3$s in %4$s and tagged with %5$s', 'Meta vocabulary: Posted on Date by Author as Format in Category/s and tagged with Tag/s', 'entex');
	/* translators: */
	if(!$labels) $placeholder = _x('Published on %1$s by %2$s as %3$s in %4$s', 'Meta vocabulary: Posted on Date by Author as Format in Category/s', 'entex');
	/* translators: */
	if(!$format) $placeholder = _x('Published on %1$s by %2$s in %4$s and tagged with %5$s', 'Meta vocabulary: Posted on Date by Author in Category/s and tagged with Tag/s', 'entex');
	/* translators: */
	if(!$labels && !$format) $placeholder = _x('Published on %1$s by %2$s in %4$s', 'Meta vocabulary: Posted on Date by Author in Category/s', 'entex');
	
	/* translators: */
	$default = sprintf($placeholder, 
		entex_theme_fn_get_date_link(), 
		entex_theme_fn_get_author_link(),
		entex_theme_fn_get_format_link(),
		entex_theme_fn_get_parents_link(),
		entex_theme_fn_get_post_tag_link()
	);
	
	$html .= entex_IND($indent, 0).'<p>'. wp_kses($default, entex_wp_kses()) .'</p>'.entex_LBR();

	$output = $html;
	return $output;
}





/* -------------------- */
// OUTPUT POST TAG (TERM) LIST
/* works with any taxonomy */

function entex_template_output_post_taglist($indent = 0, $taxonomy = 'post_tag'){
	entex_OUT(entex_template_get_post_taglist($indent, $taxonomy));
}

function entex_template_get_post_taglist($indent = 0, $taxonomy = 'post_tag'){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';
	
	$content = entex_theme_fn_get_post_taxonomy_terms(get_the_ID(), $taxonomy);
	if(!$content) return '';
	
	$prefix = esc_html__('Tags', 'entex').' : ';
	$html .= entex_IND($indent, 0).'<p>' . $prefix . wp_kses_post($content) . '</p>'.entex_LBR();
	
	/* filter */
	$html = apply_filters('entex_template_get_post_taglist_html', $html, $content);
	$output = $html;
	return $output;
}


// END: TAG LIST
/* ******************** */






/* -------------------- */
// OUTPUT SOCIAL SHARING
/* This is the Theme wrapper that should be in use */
/* for any filtered in links or manually populated positions */
/* last argument only return bool of valid output of 'filtered in' buttons */
/* please make shure your filtered in plugin always deliver all 4 arguments */

function entex_template_output_social_sharing($indent = 0, $force = false){
	entex_OUT(entex_template_get_social_sharing($indent, $force));
}

function entex_template_get_social_sharing($indent = 0, $force = false){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';

	/* this is where you filter in your plugin */
	$content = apply_filters('entex_template_get_social_sharing_content', '', $indent, $force, $validate = false);
	if(!$content) return '';
	
	$html = wp_kses($content, entex_wp_kses());
	
	/* filter */
	$html = apply_filters('entex_template_get_social_sharing_html', $html, $content, $force);
	$output = $html;
	return $output;
}


// END: OUTPUT SOCIAL SHARING 
/* ******************** */

/* filter - unhook to change this default settings */
/* We only need any output if in the loop, but not if 'more' tag is present */
function entex_template_filter_social_sharing_default($content, $indent, $force){
	if($force) return $content;
	if(!in_the_loop()) return '';
	$has_more = 0;//entex_theme_fn_has_more();
	if($has_more) return '';
	return $content;
}
//add_filter('entex_template_get_social_sharing_content', 'entex_template_filter_social_sharing_default', 30, 3);





/* -------------------- */
// SINGULAR HEADER IMAGE

function entex_template_output_the_singular_header_image($indent = 0, $size = null){
	entex_OUT(entex_template_get_the_singular_header_image($indent, $size));
}

function entex_template_get_the_singular_header_image($indent = 0, $size = null){
	
	/* comment */ // Indent removed as already applied in template
	do_action('entex_template_before_function', 0, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';
	$content = '';

	
	if(!$size) $size = apply_filters('entex_template_get_the_singular_header_image_size', 'medium', $size);
	
	$content = entex_template_get_the_singular_image(($indent + 0), $size);
	if(!$content) return '';
	
	$html .= entex_IND($indent, 0).'<div class="ua-header-content">'.entex_LBR();
	$html .= wp_kses($content, entex_wp_kses());
	$html .= entex_IND($indent, 0).'</div>'.entex_LBR();
	
	/* filter */ 
	$html = apply_filters('entex_template_get_the_singular_header_image_html', $html, $content, $indent, $size);

	$output = $html;
	return $output;
}





/* -------------------- */
// SINGULAR HEADER IMAGE

function entex_template_get_the_singular_image($indent = 0, $size = 'thumbnail'){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';

	
	if(get_post_type() == 'post' && defined('ENTEX_SHOW_TAXONOMY_IMAGE_ON_POST')) $meta = true;
		else $meta = get_post_meta(get_the_ID(), 'entex_singular_taxonomy_image', true);
	/* filter */
	$meta = apply_filters('entex_theme_show_taxonomy_image_singular', $meta);
	if(!$meta) return '';

	$image_id = entex_theme_get_meta_singular_header_image();
	if(!$image_id) return '';
	
	$image = wp_get_attachment_image($image_id, $size);
	if(!$image) return $output;
	
	$html .= entex_IND($indent, 0).'<figure class="ua-avatar">'.entex_LBR();
	$html .= entex_IND($indent, 1). wp_kses($image, entex_wp_kses()) .entex_LBR();
	$html .= entex_IND($indent, 0).'</figure>'.entex_LBR();

	/* filter */
	$html = apply_filters('entex_template_get_the_singular_image_html', $html, $image, $indent, $size);
	$output = $html;
	return $output;
}





/* -------------------- */
// ARCHIVE HEADER IMAGE

function entex_template_output_the_archive_header_image($indent = 0, $size = null){
	entex_OUT(entex_template_get_the_archive_header_image($indent, $size));
}

function entex_template_get_the_archive_header_image($indent = 0, $size = null){
	
	/* comment */ // Indent removed as already applied in template
	do_action('entex_template_before_function', 0, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';
	$content = '';
	
	if(!$size) $size = apply_filters('entex_template_get_the_archive_header_image_size', 'medium', $size);
	
	if(is_author()) $content = entex_template_get_the_author_avatar(($indent + 0), $size);
		else $content = entex_template_get_the_archive_image(($indent + 0), $size);
	if(!$content) return '';
	
	$html .= entex_IND($indent, 0).'<div class="ua-header-content">'.entex_LBR();
	$html .= wp_kses($content, entex_wp_kses());
	$html .= entex_IND($indent, 0).'</div>'.entex_LBR();
	
	/* filter */ 
	$html = apply_filters('entex_template_get_the_archive_header_image_html', $html, $content, $indent, $size);

	$output = $html;
	return $output;
}



/* -------------------- */
// AUTHOR AVATAR

function entex_template_output_the_header_author_avatar($indent = 0, $size = 'entex-photo', $link = false, $args = null){
	entex_OUT(entex_template_get_the_author_avatar($indent, $size, $link, $args));
}

function entex_template_get_the_author_avatar($indent = 0, $size = 0, $link = false, $args = null){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';

	$avatar = entex_theme_fn_get_author_avatar($size, $link, $args);
	if(!$avatar) return $output;
	
	$html .= entex_IND($indent, 0).'<figure class="ua-avatar ua-author-avatar">'.entex_LBR();
	$html .= entex_IND($indent, 1). wp_kses($avatar, entex_wp_kses()) .entex_LBR();
	$html .= entex_IND($indent, 0).'</figure>'.entex_LBR();

	/* filter */
	$html = apply_filters('entex_template_get_the_author_avatar_html', $html, $avatar, $indent, $size, $link, $args);
	$output = $html;
	return $output;
}





/* -------------------- */
// ARCHIVE HEADER IMAGE
/* uses the ua-author-avatar wrapper */
/* ToDo: change the header image architecture since v.2.20508 (header inner) */
/* We added the $classname so we can call this tmpl func from outside */

function entex_template_get_the_archive_image($indent = 0, $size = 'entex-photo', $classname = 'ua-avatar'){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';

	$image = entex_theme_fn_get_archive_image($size);
	if(!$image) return $output;
	
	$html .= entex_IND($indent, 0).'<figure class="'. esc_attr($classname) .'">'.entex_LBR();
	$html .= entex_IND($indent, 1). wp_kses($image, entex_wp_kses()) .entex_LBR();
	$html .= entex_IND($indent, 0).'</figure>'.entex_LBR();

	/* filter */
	$html = apply_filters('entex_template_get_the_archive_image_html', $html, $image, $indent, $size);
	$output = $html;
	return $output;
}






/* -------------------- */
// ABOUT THE AUTHOR BOX

function entex_template_output_the_author_box($indent = 0, $data = null){
	entex_OUT(entex_template_get_the_author_box($indent, $data));
}

function entex_template_get_the_author_box($indent = 0, $data = null){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';
	
	$render = true;
	$render = apply_filters('entex_template_filter_the_author_box_output', $render);
	if(!$render) return $output;

	$description = get_the_author_meta('description');
	if(!$description) return $output;
	
	$size = 0;
	if(isset($data['size']) && $data['size']) $size = $data['size'];
	$image = true;
	if(isset($data['image']) && !$data['image']) $image = false;
	$link = true;
	if(isset($data['link']) && !$data['link']) $link = false;

	$user_id = get_the_author_meta('ID');
	$title = _x('About the author', 'Post author information headline', 'entex');
	if(isset($data['title']) && $data['title']) $title = esc_html($data['title']);
	
	$avatar = '';
	if($image) $avatar = entex_theme_fn_get_author_avatar($size, true);
	
	$html .= entex_IND($indent, 0).'<div class="ua-content ua-box author vcard">'.entex_LBR();
	$html .= entex_IND($indent, 1).'<h3>'. esc_html($title) .'</h3>'.entex_LBR();
	if($avatar) $html .= entex_IND($indent, 1).'<figure class="alignleft ua-border">'.entex_LBR();
	if($avatar) $html .= entex_IND($indent, 2). wp_kses($avatar, entex_wp_kses()) .entex_LBR();
	if($avatar) $html .= entex_IND($indent, 1).'</figure>'.entex_LBR();
	$html .= entex_IND($indent, 1).wpautop($description);
	
	if($link){
		$url = esc_url(get_author_posts_url($user_id));
		$hover = entex_theme_fn_get_author_link_hover();
		/* translators: */
		$text = sprintf(_x('View all posts by %s', 'Meta vocabulary: View all posts by Author', 'entex'), get_the_author());
		$link = '<a href="'. esc_url($url) .'" class="url fn n" title="'. esc_attr($hover) .'">'. esc_html($text) .'</a>';
	
		/* filter */
		$link = apply_filters('entex_template_get_the_author_box_link', $link, $user_id, $text, $url, $hover);
		$html .= entex_IND($indent, 1). $link .entex_LBR();
	}
	
	/* filter */
	$content = '';
	$html .= apply_filters('entex_template_add_get_the_author_box_content', $content, $user_id);
	$html .= entex_IND($indent, 0).'</div>'.entex_LBR();
	
	/* filter */
	$html = apply_filters('entex_template_get_the_author_box_html', $html, $user_id, $title, $avatar, $description, $link, $content);
	$output = $html;
	return $output;
}






/* -------------------- */
// POSTS PAGINATION

/* Archive footer */
/* The main footer wrapper uses ua-not-main font size classname */

function entex_template_output_the_posts_pagination($indent = 0){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, entex_backtrace(5), 
		__FUNCTION__, __LINE__
	);
	
	$args = array(
		'mid_size' => 2,
		'prev_text' => esc_html_x('Previous page', 'Pagination', 'entex'),
		'next_text' => esc_html_x('Next page', 'Pagination', 'entex'),
		'before_page_number' => '<span class="meta-nav screen-reader-text">'. esc_html_x('Page', 'Pagination: Before page number', 'entex') .' </span>',
	);
	
	$content = entex_IND($indent, 0). trim(str_replace("\t", '', str_replace("\n", ' ', get_the_posts_pagination($args))));
	
	entex_OUT($content);
}






/* -------------------- */
// WP LINK PAGES PAGINATION

/* Singular after content */
/* Mimics post pagination markup (used on archive pages) */
/* This nav wrapper uses ua-not-main font size classname */

function entex_template_output_wp_link_pages($indent = 0){ 
	
	global $multipage;
	if(!$multipage) return;
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, entex_backtrace(5), 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';
	
	/* filter */
	$next_or_number = apply_filters('entex_template_output_wp_link_pages_next_or_number', 'number');
	
	if($next_or_number == 'number') $cls = 'pagination page-pagination';
		else $cls = 'post-navigation page-navigation';

	$html .= entex_IND($indent, 0).'<nav class="navigation ua-not-main '.$cls.'" role="navigation">'.entex_LBR();
	$html .= entex_IND($indent, 1).'<h2 class="screen-reader-text">'. esc_html_x('Content navigation', 'Pagination', 'entex') .'</h2>'.entex_LBR();
	$html .= entex_IND($indent, 1).'<div class="nav-links">'.entex_LBR();
	$html .= entex_IND($indent, 2).'<p>'. esc_html_x('This content is devided in pages', 'Pagination', 'entex') .'</p>'.entex_LBR();

	$prev_exists = '';
	$next_exists = '';
	$wr_before = '';
	$wr_after = '';
	$span_class = 'page-number';
	
	if($next_or_number == 'next'){
		global $page, $numpages;
		if(($page - 1) > 0) $prev_exists = '<span class="page-number prev"></span>';
		if(($page + 1) <= $numpages) $next_exists = '<span class="page-number next"></span>';
		if($prev_exists && !$next_exists) $wr_before = '<div class="nav-previous">';
		if($next_exists && !$prev_exists) $wr_before = '<div class="nav-next">';
		if($wr_before) $wr_after = '</div>';
		$span_class = 'page-title';
	}
	$links = wp_link_pages(
		array(
			'echo' => false,
			'before' => $wr_before,
			'after' => $wr_after,
			'link_before' => $prev_exists.'<span class="'. $span_class .'">',
			'link_after' => '</span>'.$next_exists,
			'next_or_number'   => $next_or_number,
			'separator' => '',
		)
	); 
	$html .= entex_IND($indent, 2). trim(str_replace("\t", '', str_replace("\n", ' ', $links))).entex_LBR();
	$html .= entex_IND($indent, 1).'</div>'.entex_LBR();
	$html .= entex_IND($indent, 0).'</nav>'.entex_LBR();
	
	$output = $html;
	entex_OUT($output);
}






/* -------------------- */
// NEXT & PREV PAGINATION (ECHOES)

/* Singular Next and Prev post */
function entex_template_output_the_post_navigation($indent = 0){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	if(is_singular('attachment')){
		$prev_text = esc_html_x('This media is published in', 'Pagination: Attachment post parent', 'entex');
		$links = get_the_post_navigation();
		if($links) $links = str_replace('<a ', '<p>'. $prev_text .' : <a ', $links);
		if($links) $links = str_replace('</a>', '</a></p>', $links);
		entex_OUT(entex_IND($indent, 0).$links);
	} else if(is_singular('post')){
		/* swap the links by calling 'entex_get_the_post_navigation(...' */
		$links = get_the_post_navigation( array(
			'prev_text' => '<span class="screen-reader-text">' . esc_html_x( 'Previous post:', 'Pagination: Screen reader text', 'entex' ) . '</span>' . '<span class="page-number prev"></span><span class="page-title">%title</span>',
			'next_text' => '<span class="screen-reader-text">' . esc_html_x( 'Next post:', 'Pagination: Screen reader text', 'entex' ) . '</span>' . '<span class="page-title">%title</span><span class="page-number next"></span>',
			'in_same_term'       => true,
			'screen_reader_text' => esc_html_x('Post navigation', 'Pagination: Screen reader text', 'entex')
		));
		if($links) $links = str_replace("\t", '', $links);
		if($links) $links = str_replace("\n", '', $links);
		entex_OUT(entex_IND($indent, 0).$links);
	}
}

/* filter in classname */
function entex_template_filter_navigation_markup_template($template, $class){
	return str_replace('nav class="navigation', 'nav class="ua-not-main navigation', $template);
}
add_filter('navigation_markup_template', 'entex_template_filter_navigation_markup_template', 10, 2);

// END: PAGINATION
/* -------------------- */







/* -------------------- */
// SITE FOOTER

function entex_template_output_footer_branding($indent = 0){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);

	$output = '';
	$html = '';
	$content = '';
	
	$G_LOGO = get_theme_mod('entex_theme_footer_logo_visibility');
	$G_LOGO = ($G_LOGO ? false : true);
	
	$G_DESCRIPTION = get_theme_mod('entex_theme_footer_description_visibility');
	$G_DESCRIPTION = ($G_DESCRIPTION ? false : true);
	
	if($G_LOGO){
		$footer_logo_url = get_theme_mod('entex_theme_footer_logo_image');
		if($footer_logo_url){
			$footer_logo_id = get_theme_mod('entex_theme_footer_logo_image_id');
			if($footer_logo_id) $content = wp_get_attachment_image($footer_logo_id, 'medium_large');
		} 
		if(!$content){
			$custom_logo_id = get_theme_mod('custom_logo');
			if($custom_logo_id){
				$content = get_custom_logo();
			} else {
				if(defined('ENTEX_THEME_INITIAL_LOGO')) $logo = ENTEX_THEME_INITIAL_LOGO;
					else $logo = 'wordpress-logo.png';
				$src = get_template_directory_uri() .'/assets/images/'.$logo;
				$content = '<img src="'. esc_url($src) .'" alt="'. esc_attr(get_bloginfo('name', 'display')) .'" />';
				if(!is_front_page()){
					$content = '<a href="'. esc_url(home_url('/')) .'" class="custom-logo-link">'. $content .'</a>';
				}
			}
		}
	}

	if($content){
		$html .= entex_IND($indent, 0).'<div id="ua-id-logo-bottom" class="site-logo ua-site-logo">'.entex_LBR();
		$html .= entex_IND($indent, 1). wp_kses($content, entex_wp_kses()) .entex_LBR();
		$html .= entex_IND($indent, 0).'</div>'.entex_LBR();
	}
	
	if($G_DESCRIPTION){
		if(defined('ENTEX_THEME_HIDDEN_LOGIN')){
			$onclick = "location.href = '". entex_theme_fn_get_login_logout_url() ."'; return false;";
			$html .= entex_IND($indent, 0).'<p onclick="'. $onclick .'">'. get_bloginfo('description', 'display') .'</p>'.entex_LBR();
		} else {
			$html .= entex_IND($indent, 0).'<p>'. get_bloginfo('description', 'display') .'</p>'.entex_LBR();
		}
	}
	
	/* filter */
	$html = apply_filters('entex_template_output_footer_branding_html', $html, $content);
	$output = $html;
	
	entex_OUT($output);
}


function entex_template_output_footer_signature($indent = 0){

	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';
	$content = '';
	
	$signature = apply_filters('entex_template_footer_signature',
		array(
			'pre' => 'Media Management © '. date('Y'),
			'href' => 'https://entex.info',
			'label' => 'Entex Theme'
		)
	);
	if(!empty($signature['label'])) $signature['label'] = esc_html(trim(strip_tags($signature['label'])));
		else $signature['label'] = 'Entex Theme';
	if(!empty($signature['href'])) $content = '<a href="'. esc_url($signature['href']) .'" target="_blank">'. $signature['label'] .'</a>';
		else $content = $signature['label'];
	if(!empty($signature['pre'])) $content = esc_html(trim(strip_tags($signature['pre']))).' '.$content;
		
	$html .= entex_IND($indent, 0).'<p class="ua-signature">'. wp_kses($content, entex_wp_kses()) .'</p>'.entex_LBR();
	
	/* filter */
	$html = apply_filters('entex_template_output_footer_signature_html', $html);
	$output = $html;
	
	entex_OUT($output);
}

// END: SITE FOOTER
/* -------------------- */





/* -------------------- */
// OUTPUT EDIT POST WRAPPER
/* plugin like dublicate posts might share the content */

function entex_template_output_admin_edit_post_wrapper($indent = 0){
	entex_OUT(entex_template_get_admin_edit_post_wrapper($indent));
}

function entex_template_get_admin_edit_post_wrapper($indent = 0){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';
	
	$content = entex_theme_fn_get_edit_post_link();
	$content = apply_filters('entex_template_admin_edit_post_wrapper', $content, $indent);
	if(!$content) return '';
	
	$html .= entex_IND($indent, 0).'<div class="wp-edit-post-wr ua-set-inline ua-set-deviders ua-meta">' . wp_kses_post($content) . '</div>'.entex_LBR();
	
	/* filter */
	$html = apply_filters('entex_template_get_admin_edit_post_wrapper_html', $html, $content);
	$output = $html;
	return $output;
}





/* -------------------- */
// OUTPUT EDIT COMMENT WRAPPER
/* Sharing CSS with post edit link */

function entex_template_output_admin_edit_comment_wrapper($indent = 0){
	entex_OUT(entex_template_get_admin_edit_comment_wrapper($indent));
}

function entex_template_get_admin_edit_comment_wrapper($indent = 0){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';
	
	$content = entex_theme_fn_get_edit_comment_link();
	$content = apply_filters('entex_template_admin_edit_comment_wrapper', $content, $indent);
	if(!$content) return '';
	
	$html .= entex_IND($indent, 0).'<div class="wp-edit-post-wr ua-set-inline ua-set-deviders">' . wp_kses_post($content) . '</div>'.entex_LBR();
	
	/* filter */
	$html = apply_filters('entex_template_get_admin_edit_comment_wrapper_html', $html, $content);
	$output = $html;
	return $output;
}





/* -------------------- */
// FACEBOOK PLACEHOLDER AFTER BODY TAG
// Note, the action must be applied when needed in functions.php (child theme)
// add_action('wp_body_open', 'entex_template_output_facebook_root_placeholder', 10, 1);

function entex_template_output_facebook_root_placeholder($indent = 0){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';
	
	$html .= entex_IND($indent, 0).'<div id="fb-root"></div>'.entex_LBR();

	$output = $html;
	entex_OUT($output);
}

// END: PLACEHOLDER
/* ******************** */




/* -------------------- */
// FACEBOOK SCRIPT DATA AFTER BODY TAG
// script data for like and timeline or whatever
// Placeholder fb-root must be filtered in by action (above)
// The script data should cover all Facebook API
// You only need one script for both or any of them
// This action is called by default
// Returns empty if child theme does not filter needed data in

function entex_template_output_facebook_data($indent = 0){
	entex_OUT(entex_template_get_facebook_data($indent));
}
add_action('wp_body_open', 'entex_template_output_facebook_data', 20, 1);

function entex_template_get_facebook_data($indent = 0){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';
	
	$content = '';
	$content = apply_filters('entex_template_get_facebook_data_content', $content, $indent);
	if(!$content) return '';
	
	$html .= entex_IND($indent, 0). $content .entex_LBR();
	
	/* filter */
	$html = apply_filters('entex_template_get_facebook_data_html', $html, $content);
	$output = $html;
	return $output;
}



/* -------------------- */
// FACEBOOK LIKE and SHORTCODE FUNCTION
/* button like output */
// Returns empty if child theme does not filter needed data in

function entex_template_output_facebook_like($indent = 0){
	entex_OUT(entex_template_get_facebook_like($indent));
}

function entex_template_get_facebook_like($indent = 0){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';
	
	/* make shure data is provided */
	$data = apply_filters('entex_template_get_facebook_data_content', '');
	if(!$data) return _x('Facebook data is not filtered in', 'Social', 'entex');
	
	$content = '';
	$content = apply_filters('entex_template_get_facebook_like_content', $content, $indent);
	if(!$content) return '';

	$html .= entex_IND($indent, 0). '<div class="ua-content">' .entex_LBR();
	$html .= entex_IND($indent, 1). $content .entex_LBR();
	$html .= entex_IND($indent, 0). '</div>' .entex_LBR();
	
	/* filter */
	$html = apply_filters('entex_template_get_facebook_like_html', $html, $content);
	$output = $html;
	return $output;
}
/* shortcode moved into Entex Theme shortcodes plugin */


add_filter('entex_template_get_facebook_like_content', function($content){
	$url = entex_theme_fn_get_social_url('facebook');
	if($url) $content = '<div class="fb-like" data-href="'. esc_url($url) .'" data-width="280px" data-layout="button" data-action="like" data-size="large" data-share="true"></div>';
	return $content;
}, 10);

// END: LIKE 
/* ******************** */




/* -------------------- */
// FACEBOOK TIMELINE and SHORTCODE
/* timeline (iframe) output */
// Returns empty if child theme does not filter needed data in

function entex_template_output_facebook_timeline($indent = 0){
	entex_OUT(entex_template_get_facebook_timeline($indent));
}

function entex_template_get_facebook_timeline($indent = 0){
	
	/* comment */
	do_action('entex_template_before_function', $indent, 
		'', 
		__FILE__, false, 
		__FUNCTION__, __LINE__
	);
	
	$output = '';
	$html = '';
	
	/* make shure data is provided */
	$data = apply_filters('entex_template_get_facebook_data_content', '');
	if(!$data) return _x('Facebook data is not filtered in', 'Social', 'entex');
	
	$content = '';
	$content = apply_filters('entex_template_get_facebook_timeline_content', $content, $indent);
	if(!$content) return '';
	
	$html .= entex_IND($indent, 0). '<div class="ua-content">' .entex_LBR();
	$html .= entex_IND($indent, 1). $content .entex_LBR();
	$html .= entex_IND($indent, 0). '</div>' .entex_LBR();
	
	/* filter */
	$html = apply_filters('entex_template_get_facebook_timeline_html', $html, $content);
	$output = $html;
	return $output;
}
/* shortcode moved into Entex Theme shortcodes plugin */

add_filter('entex_template_get_facebook_timeline_content', function($content){
	$label = get_bloginfo('name');
	$url = entex_theme_fn_get_social_url('facebook');
	if($url) $content = '<div class="fb-page" data-href="'. esc_url($url) .'" data-tabs="timeline" data-width="" data-height="600" data-small-header="false" data-adapt-container-width="true" data-hide-cover="false" data-show-facepile="true"><blockquote cite="'. esc_url($url) .'" class="fb-xfbml-parse-ignore"><a href="'. esc_url($url) .'">'. esc_html($label) .'</a></blockquote></div>';
	return $content;
}, 10);

// END: TIMELINE
/* ******************** */

// -- END FILE -- //