<?php 

// Updated 2021 11 20


/* -------------------- */
// DECLARE THEME
define('ENTEX_THEME', true);


/* -------------------- */
// DISABLE BLOCK WIDGET 
/* We are not implementing block widgets in Entex */
/* Use Entex Theme Locations instead */
add_filter('gutenberg_use_widgets_block_editor', '__return_false', 100);
add_filter('use_widgets_block_editor', '__return_false');




/* -------------------- */
// SETUP CUSTOM OPTIONS
require get_template_directory() . '/options.php'; // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound



/* -------------------- */
// VALIDATE WP VERSION
/* Entex theme "only" works in WordPress 5.4 or later */
if(version_compare($GLOBALS['wp_version'], '5.4', '<')){
	require get_template_directory() .'/inc/back-compat.php'; // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
}



/* -------------------- */
// LAZY LOADING - dont use in this theme
/* keep SEO and this theme has already balanced weights */
if(!defined('ENTEX_THEME_LAZY_LOADING_ENABLED')){
	add_filter('wp_lazy_loading_enabled', '__return_false');
}



/* -------------------- */
// WP GLOBAL WIDTH

/**
 * This is a WordPress variable and must be adjusted to current layout
 * Global content width is in use by calculating image downsize or other stuff related to your content
 * The visual editor in backend is also using this value as body width
 * However, this theme is trying to avoid the use of WordPress built in server-side responsive calucaltions
 * The advanced stylesheets queries take care of this.
 */

if(!function_exists('entex_theme_global_content_width')):
/* Create your own function to override in a child theme. */

function entex_theme_global_content_width(){
	if(isset($GLOBALS['content_width'])) unset($GLOBALS['content_width']);
}
add_action('after_setup_theme', 'entex_theme_global_content_width');

// Removes within current scope
if(isset($content_width)) unset($content_width);

endif; // END: exists

/* ******************** */



/* -------------------- */
// WIDGETS RECENT COMMENTS CLEANUP
function entex_cleanup_remove_recent_comments_style() {
	if(defined('ENTEX_CLEANUP_RECENT_COMMENTS_STYLE_DISABLE')){
		return false;
	}
	global $wp_widget_factory;
	remove_action('wp_head', array($wp_widget_factory->widgets['WP_Widget_Recent_Comments'], 'recent_comments_style'));
}
add_action('widgets_init', 'entex_cleanup_remove_recent_comments_style');



/* -------------------- */
// DEFAULT TEMPLATES
/* Used by: entex_fn_setup_postdata() */

if(!defined('ENTEX_TEMPLATE_DEFAULT_SINGULAR')){
	/* Will also be filtered by: entex_singular_template_default */
	define('ENTEX_TEMPLATE_DEFAULT_SINGULAR', 'tmpl-defaults/tmpl-singular-article.php');
}

if(!defined('ENTEX_TEMPLATE_DEFAULT_ENTRIES')){
	/* Will also be filtered by: entex_entry_template_default */
	define('ENTEX_TEMPLATE_DEFAULT_ENTRIES', 'tmpl-defaults/tmpl-entries-article.php');
}



/* -------------------- */
// OPTIONS EXCERPT

if(!defined('ENTEX_EXCERPT_CHAR_LENGTH')) define('ENTEX_EXCERPT_CHAR_LENGTH', 156);
if(!defined('ENTEX_EXCERPT_CHAR_LENGTH_FROM_CONTENT')) define('ENTEX_EXCERPT_CHAR_LENGTH_FROM_CONTENT', 156);
if(!defined('ENTEX_EXCERPT_RECOMMENDED_CHAR_LENGTH_MIN')) define('ENTEX_EXCERPT_RECOMMENDED_CHAR_LENGTH_MIN', 99);
if(!defined('ENTEX_EXCERPT_RECOMMENDED_CHAR_LENGTH_MAX')) define('ENTEX_EXCERPT_RECOMMENDED_CHAR_LENGTH_MAX', 156);



/* -------------------- */
// DEFAULT INITITAL LOGO
if(!defined('ENTEX_THEME_INITIAL_LOGO')){
	define('ENTEX_THEME_INITIAL_LOGO', 'theme-logo-initial.png');
}



/* -------------------- */
// SETUP EDITOR
/* Since 2021 Gutenberg is default editor */
/* Classic moved as a plugin */
/* However, This theme makes it easy to remove Gutenberg */
/* By the model below */

if(!defined('ENTEX_CLASSIC_EDITOR_INTERFACE')){
	$define = apply_filters('entex_theme_classic_editor_interface', false);
	if($define) define('ENTEX_CLASSIC_EDITOR_INTERFACE', true);
}

if(defined('ENTEX_CLASSIC_EDITOR_INTERFACE')){
	add_filter('use_block_editor_for_post_type', '__return_false', 10);
} else {
	add_theme_support('editor-styles');
	define('ENTEX_CLEANUP_EMBEDS_DISABLE', true);
	/* including front-end filters and back-end functions */
	require get_template_directory() . '/inc/setup/entex-setup-gutenberg.php'; // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
}

/* ******************** */







/* -------------------- */
// CORE ACF (Advanced Custom Fields)
/* Optional to use ACF GUI in this Theme backend to populate fields and blocks */

if(in_array('advanced-custom-fields/acf.php', apply_filters('active_plugins', get_option('active_plugins')))){ 
	define('ENTEX_ACF_ACTIVE', true);
} else if(in_array('advanced-custom-fields-pro/acf.php', apply_filters('active_plugins', get_option('active_plugins')))){ 
	define('ENTEX_ACF_ACTIVE', true);
}



/* -------------------- */
// CORE ACF SECONDARY LOADPOINT
/* Optional to use ACF GUI in this Theme backend to populate fields and blocks */

if(!defined('ENTEX_ACF_LOAD_PARENT_JSON_DISABLE')){
	function entex_core_acf_load_parent_json($paths){
		if(is_child_theme()) $paths[] = get_template_directory().'/acf-json';
		return $paths;
	}
	add_filter('acf/settings/load_json', 'entex_core_acf_load_parent_json', 10, 1);
}






/* -------------------- */
// CORE FUNCTIONS
require get_template_directory() . '/inc/core/entex-core-functions.php'; // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound



/* -------------------- */
// BREADCRUMBS

if(!in_array('wordpress-seo/wp-seo.php', apply_filters('active_plugins', get_option('active_plugins')))){ 
	if(!is_admin()) require get_template_directory() . '/inc/core/entex-core-breadcrumbs.php'; // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
} else if(class_exists('WPSEO_Options')){
	define('ENTEX_YOAST_ACTIVE', true);
	if(WPSEO_Options::get('breadcrumbs-enable', false)){
		define('ENTEX_BREADCRUMBS_YOAST', true);
	} else {
		if(!is_admin()) require get_template_directory() . '/inc/core/entex-core-breadcrumbs.php'; // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
	}
	require get_template_directory() . '/inc/plugins/entex-plugin-wpseo.php';	// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
}





/* -- NO MORE DEFINITIONS FROM HERE PLEASE -- */
/* ------------------------------------------------------------- */
// SETUP:

require get_template_directory() . '/inc/setup/entex-setup-sidebars.php';	// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require get_template_directory() . '/inc/setup/entex-setup-images.php';		// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require get_template_directory() . '/inc/setup/entex-setup-widgets.php';	// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require get_template_directory() . '/inc/setup/entex-setup-customizer.php'; // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound

if(is_admin()){
	require get_template_directory() . '/inc/setup/entex-setup-admin.php';			// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
	require get_template_directory() . '/inc/setup/entex-setup-visual-editor.php'; 	// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
}



/* -------------------- */
// CONTEXTUAL:

if(!is_admin()) require get_template_directory() . '/inc/contextual/entex-contextual-functions.php'; 	// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
if(!is_admin()) require get_template_directory() . '/inc/contextual/entex-contextual-filters.php'; 		// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound



/* -------------------- */
// TEMPLATE RELATED:

require get_template_directory() . '/inc/entex-template-functions.php'; 	// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require get_template_directory() . '/inc/entex-template-filters.php'; 		// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require get_template_directory() . '/inc/entex-template-post-data.php'; 	// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require get_template_directory() . '/inc/entex-template-actions.php'; 		// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require get_template_directory() . '/inc/entex-template-output.php'; 		// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require get_template_directory() . '/inc/entex-template-locations.php'; 	// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require get_template_directory() . '/inc/entex-template-selector.php'; 		// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require get_template_directory() . '/inc/entex-template-sourcecode.php'; 	// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require get_template_directory() . '/inc/entex-template-comments.php'; 		// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require get_template_directory() . '/inc/entex-template-custom-fields.php'; // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound



/* -------------------- */
// DEFAULT SUPPORT OF PLUGINS

// SHARING | Scriptless social sharing plugin
if(in_array('scriptless-social-sharing/scriptless-social-sharing.php', apply_filters('active_plugins', get_option('active_plugins')))){ 
	require get_template_directory() . '/inc/plugins/entex-plugin-scriptless-social-sharing.php'; // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
}

// Postie
if(in_array('postie/postie.php', apply_filters('active_plugins', get_option('active_plugins')))){ 
	require get_template_directory() . '/inc/plugins/entex-plugin-postie.php'; // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
}


// -- END FILE -- //