<?php 

// Updated 2021 10 22
// ENTEX BREADCRUMB ENGINE - YOAST synced
// Dependencies: ENTEX CONTEXTUAL ENGINE

/* -------------------- */
// EARLY ACTION: Prepare json schema

add_action('wp_head', 'entex_breadcrumbs_schema', 30);


// FUNCTIONS

/*
 * function 1: Collects current page hiarchy
 * function 2: Intercept endpoints
 * function 3: Filter labels
 * function 4: Building Link object
 * function 5: Output link || html function
 *
 * REMARK: 'current' (Last breadcrumb) text - will be replaced by filter
 */
 
function entex_breadcrumbs_populate_crumbs(){
	
		$crumbs = array();
		$Home = esc_html(apply_filters('entex_breadcrumbs_label_home', _x('Home', 'Breadcrumbs', 'entex')));

		$show_on_front  = get_option('show_on_front');
		$page_for_posts = get_option('page_for_posts');
		
		if( ($show_on_front === 'page' && is_front_page()) || ($show_on_front === 'posts' && is_home()) ){
			// Do nothing.
			// @codingStandardsIgnoreEnd
			$sniffer = '';
		}
		
		$blog_parent = false;
		if($page_for_posts){
			$page = get_post($page_for_posts);
			if(isset($page->post_parent) && $page->post_parent){
				$blog_parent = array(
					'text' => get_the_title($page->post_parent),
					'url' => get_permalink($page->post_parent)
				);
			}
		}
		
		
		$homeclass = '';
		/* other hidden statuses decided by action */
		if(defined('ENTEX_BREADCRUMBS_HIDE_HOME_WITHIN')) $homeclass = 'screen-reader-text';
		
		if(is_front_page()){
			
			$crumbs[] = array(
				'text' => $Home,
				'url' => home_url('/')
			);

		} else if(is_singular() || is_home()){
			
			$crumbs[] = array(
				'text' => $Home,
				'url' => home_url('/'),
				'class' => $homeclass 
			);
			
			$obj = get_post(get_queried_object_id());
			if(!$obj) return '';
			
			/* filter */
			$add = apply_filters('entex_breadcrumbs_start', false, $obj, $crumbs, 'singular');
			if($add && is_array($add) && !empty($add)) $crumbs = $add;
			
			if(isset($obj->post_type) && isset($obj->post_parent) && 0 == $obj->post_parent){
				if(get_post_type_archive_link($obj->post_type)){
					if($obj->post_type == 'post' && !empty($blog_parent)){
						$crumbs[] = $blog_parent;
					}
					$crumbs[] = array(
						'ptarchive' => $obj->post_type
					);
				}
			}
			
			if(isset($obj->post_parent) && 0 == $obj->post_parent){
				$taxonomies = get_the_taxonomies($obj);
			
				if(!empty($taxonomies)){
					
					$taxonomy = '';
					/* filter */
					$taxonomy = apply_filters('entex_breadcrumbs_singular_main_taxonomy', 'category', $obj, $taxonomies);
					if($taxonomy && array_key_exists($taxonomy, $taxonomies)){
						$taxonomy = $taxonomy;
					} else if(array_key_exists('category', $taxonomies)){
						$taxonomy = 'category';
					} else {
						foreach($taxonomies as $taxonomy => $whatever){
							if(is_taxonomy_hierarchical($taxonomy)) break;
								else $taxonomy = '';
						}
					}
					if($taxonomy){
						$terms = get_the_terms($obj, $taxonomy);
						if(is_array($terms) && $terms !== array()){
							
							if(!isset($terms[1])){
								$deepest_term = $terms[0];
							} else {
								foreach($terms as $term){ 
									$tids[] = $term->term_id;
								}
								$closest = get_terms(
									array(
										'taxonomy' => $taxonomy,
										'order' => 'DESC',
										'orderby' => 'term_id',
										'include' => implode(',',$tids),
										'childless' => true
									)
								);
								if(!empty($closest)) $terms = $closest;
								$deepest_term = $terms[0];
							}
							
							if(is_taxonomy_hierarchical($taxonomy) && $deepest_term->parent != 0){
								$c = 0;
								$term = $deepest_term;
								while($term->parent != 0){
									$term = get_term($term->parent, $deepest_term->taxonomy);
									$parents[] = $term; $c++;
									if($c > 10) break;
								}
								foreach(array_reverse($parents) as $parent){
									$crumbs[] = array(
										'term' => $parent
									);
								}
							}

							$crumbs[] = array(
								'term' => $deepest_term
							);
							
						}
					}
				}

			} else {
				// ToDo build the parents to media parent
				$ancestors = array();
				if(isset($obj->ancestors)){
					if(is_array($obj->ancestors)){
						$ancestors = array_values($obj->ancestors);
					} else {
						$ancestors = array($obj->ancestors );
					}
				} else if(isset($obj->post_parent)){
					$ancestors = array($obj->post_parent);
				}
				/* filter */ 
				$ancestors = apply_filters('entex_breadcrumbs_ancestors', $ancestors);
				
				if(!is_array($ancestors)) $ancestors = (array) $ancestors;
				$ancestors = array_reverse( $ancestors );
				if(is_array($ancestors) && $ancestors !== array()){
					foreach($ancestors as $ancestor){
						$crumbs[] = array(
							'id' => $ancestor
						);
					}
				}
			}
			
			/* Building last on singular */

			$crumbs[] = array(
				'id' => $obj->ID
			);

		} else {
			
			// ARCHIVE
			
			$crumbs[] = array(
				'text' => $Home,
				'url' => home_url('/'),
				'class' => $homeclass 
			);
			
			
			
			global $wp_query;
			
			if(is_post_type_archive()){
				
				// This is like Shop page
				$post_type = $wp_query->get('post_type');
				if($post_type && is_string($post_type)){

					/* current */
					$crumbs[] = array(
						'ptarchive' => $post_type
					);
				}
				
			} else if(is_tax() || is_tag() || is_category()){
				
				$deepest_term = $wp_query->get_queried_object();
				if(is_taxonomy_hierarchical($deepest_term->taxonomy)) $hierarchical = true;
					else $hierarchical = false;
					
					
				$taxonomy = $deepest_term->taxonomy;
				$taxonomy_object = get_taxonomy($taxonomy);
				$post_types = $taxonomy_object->object_type;
				if(isset($post_types[0])){
					$post_type = $post_types[0];
					if(get_post_type_archive_link($post_type)){
						if($post_type == 'post' && !empty($blog_parent)){
							$crumbs[] = $blog_parent;
						}
						$crumbs[] = array(
							'ptarchive' => $post_type
						);
					}
				}
				
				if($hierarchical && $deepest_term->parent != 0){ 
					$c = 0;
					$term = $deepest_term;
					while($term->parent != 0){
						$term = get_term($term->parent, $deepest_term->taxonomy);
						$parents[] = $term; $c++;
						if($c > 10) break;
					}
					foreach(array_reverse($parents) as $parent){
						$crumbs[] = array(
							'term' => $parent
						);
					}
				}
				
				/* current */
				$crumbs[] = array(
					'term' => $deepest_term
				);
				
			} else {
				
				if(!empty($blog_parent)){
					$crumbs[] = $blog_parent;
				}
				
				$crumbs[] = array(
					'ptarchive' => 'post'
				);
				
				if(is_day()){
					
					global $wp_locale;
					$crumbs[] = array(
						'text' => $wp_locale->get_month(get_query_var('monthnum')) .' '. get_query_var('year'),
						'url' => get_month_link(get_query_var('year'), get_query_var('monthnum'))
					);
				}

				/* current */
				$crumbs[] = array(
					'text' => 'Filtered in later',
					'url' => null
				);
			}
		}
		$crumbs = apply_filters('entex_crumbs', $crumbs);
		return $crumbs;
}





function entex_filter_breadcrumb_placeholder_title($text, $post_id, $crumb = null, $i = null, $current = null){
	
	/* circuit if defined leave Yoast as original */
	if(defined('ENTEX_BREADCRUMBS_YOAST') && !defined('ENTEX_BREADCRUMBS_YOAST_FILTER') && function_exists('yoast_breadcrumb')) return $text;
	
	/* We borrow from archive trails to keep consistance */
	/* Otherwise the 'saved page title' will be in use on anchestors trails */
	if($post_id == get_option('page_for_posts')) $text = entex_filter_breadcrumb_blog($text, 'page');

	return $text;
}
add_filter('entex_within_breadcrumb_label_is_page', 'entex_filter_breadcrumb_placeholder_title', 10, 5);
add_filter('wp_seo_get_bc_title', 'entex_filter_breadcrumb_placeholder_title', 10, 2);



/* NOT Yoast compatible - no filter exists for 'ptarchive', use Admin option settings */
function entex_filter_breadcrumb_blog($text, $post_type, $crumb = null, $i = null, $current = null){

	$text = __('Blog', 'entex');
	//$text = get_the_title(get_option('page_for_posts'));
	return $text;
}
add_filter('entex_within_breadcrumb_label_is_post_type_archive_post', 'entex_filter_breadcrumb_blog', 10, 5);



// Entex filter
/**
 * Endpoint handler
 * Adding filters to current pageload
 * Runs only once
**/

function entex_breadcrumbs_filter_ancestors($ancestors){
	
	if(defined('ENTEX_BREADCRUMBS_YOAST') && !defined('ENTEX_BREADCRUMBS_YOAST_FILTER') && function_exists('yoast_breadcrumb')) return $ancestors;
	
	static $cache = false;
	if($cache) return $ancestors;
	$cache = true;
	
	if(function_exists('is_endpoint')){
		if(entex_is_endpoint()){
			
			//array_unshift($ancestors, get_queried_object_id());
			
			add_filter('entex_crumbs', function($crumbs){
				$crumbs[] = array(
					'url'  => null,
					'text' => entex_fn_titlecase(entex_get_endpoint())
				);
				return $crumbs;
			}, 5, 1);
			add_filter('wpseo_breadcrumb_links', function($crumbs){
				$crumbs[] = array(
					'url'  => null,
					'text' => entex_fn_titlecase(entex_get_endpoint())
				);
				return $crumbs;
			}, 5, 1);
		}
	}

	return $ancestors;
}
//add_filter('wp_seo_get_bc_ancestors', 'entex_breadcrumbs_filter_ancestors', 10, 1); // dep
add_filter('entex_breadcrumbs_ancestors', 'entex_breadcrumbs_filter_ancestors', 10, 1);



/**
 * Rebuild with custom text on last crumb
 * Add visual startpage crumb 
**/

function entex_filter_crumbs($original){
	
	/* filter */
	$Home = apply_filters('entex_breadcrumbs_label_home', _x('Home', 'Breadcrumbs', 'entex'));
	
	// On home, we dont need calculations, lets circuit
	
	// A little nice trick on domain landing
	/* translators: */
	$Welcome = sprintf(_x('Welcome to %s', 'Breadcrumbs', 'entex'), entex_theme_fn_get_blogname());
	
	/* filter */
	/* return false to disable */
	$Welcome = apply_filters('entex_breadcrumbs_label_welcome', $Welcome);
	
	// We have no crumb on startpage
	// Maybe we will, othervise bail
	if(!is_array($original) || $original === array() || count($original) == 1){ 
		if($Welcome === null) return array();
		if($Welcome){
			$crumbs[] = array(
				'text' => $Welcome,
				'schema' => $Home,
				'url' => $original[0]['url']
			);
			return $crumbs;
		}
		return $original;
	}
	
	// From here, we are never at startpage
	$current = entex_theme_fn_get_is();
	
	$count = 1;
	$end = count($original);
	$crumbs = array();
	
	foreach($original as $i => $crumb) {

		// Keep in sync
		$crumbs[$i] = $crumb;
		
		// Lets isolate the startpage crumb
		if(!$i) $crumbs[$i]['text'] = $Home;

		// Lets isolate the last crumb
		if($count == $end){

			if(isset($crumb['id'])) unset($crumbs[$i]['id']);
			if(isset($crumb['term'])) unset($crumbs[$i]['term']);
			if(isset($crumb['ptarchive'])) unset($crumbs[$i]['ptarchive']);


			$crumbs[$i]['text'] = $current['breadcrumb'];
			$crumbs[$i]['schema'] = $current['breadcrumb-schema'];
			$crumbs[$i]['url'] = null;
			$crumbs[$i]['allow_html'] = true;
			$crumbs[$i]['class'] = ($current['breadcrumb-visible'] == 'No') ? 'screen-reader-text' : '';
			
		} else {
			$sniffer = '';
			// Within trail breadcrumbs
			//if($count == ($end - 1)) $crumbs[$i]['class'] = 'screen-reader-text';
		}
		
		$count++;
	}
	return $crumbs;
}
add_filter('entex_crumbs', 'entex_filter_crumbs', 10, 1);



function entex_breadcrumbs_populate_data($crumbs, $data = false) {
	
		if(!is_array($crumbs) || $crumbs === array()) return;
		
		$links = array();
		$parents = array();
		
		$use_nav_label = false;
		if(defined('ENTEX_BREADCRUMBS_PRIMARY_MENU')) $use_nav_label = true;
		if($use_nav_label){
			$menu_name = apply_filters('entex_breadcrumbs_primary_menu', 'primary');
			if(($locations = get_nav_menu_locations()) && isset($locations[$menu_name])){
				$menu = wp_get_nav_menu_object($locations[$menu_name]);
				$menu_items = wp_get_nav_menu_items($menu->term_id);
				foreach ( (array) $menu_items as $key => $menu_item ) {
					$NavLabel[$menu_item->object_id] = $menu_item->title;
				}
			}
		}
		
		$end = count($crumbs);
		$count = 1;
		
		foreach($crumbs as $i => $crumb) {
			
			$current = false;
			if($count == $end) $current = true;
			$link = array();
			$link['title'] = '';
			
			/* Might been filtered in, like endpoints */
			if(isset($crumb['schema'])) $link['schema'] = $crumb['schema'];

			/* Never current: */
			if(isset( $crumb['id'] )){
				
				$link['url']  = get_permalink($crumb['id']);
				$link['text'] = strip_tags(get_the_title($crumb['id']));
				
				/* Nav */
				if($use_nav_label && isset($NavLabel[$crumb['id']])){
					/* filter */ // -Return false to disable single replacement
					$text = apply_filters('breadcrumb_text_navigation_label', $NavLabel[$crumb['id']], $crumb, $i, $current);
					if($text){
						$link['title'] = $link['text'];
						$link['text'] = $text;
					}
				}
				
				$post_type = get_post_type($crumb['id']);

				/* filter */ // Each post-type label within the trail
				$link['text'] = apply_filters('entex_within_breadcrumb_label_is_'.$post_type, $link['text'], $crumb['id'], $crumb, $i, $current);
				
				/* filter */ // All custom post and pages label within the trail
				$link['text'] = apply_filters('entex_within_breadcrumb_label_is_singular', $link['text'], $crumb['id'], $crumb, $i, $current);
			}
			
			/* Never current: */
			if(isset( $crumb['term'] )){
				
				$link['url']  = get_term_link($crumb['term']);
				$link['text'] = $crumb['term']->name;
				
				/* Nav */
				if($use_nav_label && isset($NavLabel[$crumb['term']->term_id])){
					/* filter */ // -Return false to disable single replacement
					$text = apply_filters('breadcrumb_text_navigation_label', $NavLabel[$crumb['term']->term_id], $crumb, $i, $current);
					if($text){
						$link['title'] = $link['text'];
						$link['text'] = $text;
					}
				}
			}
			
			/* Never current: */
			if(isset( $crumb['ptarchive'] )){
				
				if(defined('ENTEX_BREADCRUMBS_HIDE_ARCHIVE_WITHIN')) continue;
				
				$archive_title = '';
				$post_type_obj = get_post_type_object( $crumb['ptarchive'] );
				if(is_object($post_type_obj)){
					if(isset($post_type_obj->label) && $post_type_obj->label !== ''){
						$archive_title = $post_type_obj->label;
					} else if(isset($post_type_obj->labels->menu_name) && $post_type_obj->labels->menu_name !== ''){
						$archive_title = $post_type_obj->labels->menu_name;
					} else {
						$archive_title = $post_type_obj->name;
					}
				}
				$link['url']  = get_post_type_archive_link( $crumb['ptarchive'] );
				$link['text'] = $archive_title;
				
				/* filter */ // Each post-type label within the trail
				$link['text'] = apply_filters('entex_within_breadcrumb_label_is_post_type_archive_'.$crumb['ptarchive'], $link['text'], $crumb['ptarchive'], $crumb, $i, $current);
				
				/* filter */ // All post-type label within the trail
				$link['text'] = apply_filters('entex_within_breadcrumb_label_is_post_type_archive', $link['text'], $crumb['ptarchive'], $crumb, $i, $current);
			}

			if(isset( $crumb['text'] )){
				
				if(!$crumb['url']){
					$link['text'] = $crumb['text'];
				} else {
					/* Currently only home crumbs */
					$link['url'] = $crumb['url'];
					$link['text'] = $crumb['text'];
				}
				if($current) $link['url'] = null;
			}
			
			if(isset($crumb['class'])) $link['class'] = $crumb['class'];
			
			if($data){
				$parent = apply_filters('entex_single_breadcrumb_parent', $link, $crumb, $i, $current);
				$parents[] = $parent;
			} else {
				/* filter */
				$link = apply_filters('entex_single_breadcrumb_data', $link, $crumb, $i, $current);
				$links[] = entex_breadcrumbs_populate_html($link, $crumb, $i, $current);
			}
			$count++;
		}
		if($data) return $parents;
			else return $links;
}


// SANTIZE HERE 
function entex_breadcrumbs_populate_html($link, $crumb, $i, $current) {
		$output = '';
		if(isset($link['text']) && (is_string($link['text']) && $link['text'] !== '')){
			$text = $link['text'];
			if(isset($link['url']) && (is_string($link['url']) && $link['url'] !== '')){
				$attr = '';
				$attr .= (isset($link['title']) && $link['title']) ? ' title="'. esc_attr($link['title']) .'"' : '';
				$attr .= (isset($link['class']) && $link['class']) ? ' class="'. esc_attr($link['class']) .'"' : '';
				$output = '<a href="'. esc_url($link['url']) .'"'. $attr .'>'. esc_html($text) .'</a>';
			} else {
				$attr = (isset($link['class']) && $link['class']) ? ' class="'. esc_attr($link['class']) .'"' : '';
				$output = '<span'. $attr  .'>'. esc_html($text).'</span>';
			}
		}
		$output = apply_filters('entex_single_breadcrumb_html', $output, $link, $crumb, $i, $current);
		return $output;
}






// SCHEMAS

// ENTEX only:
// add_action('wp', 'entex_template_prepare_wp_head_schema');
// add_action('wp_head', 'entex_breadcrumbs_schema', 30, 1);

function entex_breadcrumbs_schema(){
	
	if(defined('ENTEX_SCHEMA_DISABLE')) return;
	if(is_singular() && function_exists('entex_noindex')){
		if(entex_noindex()) return;
	}
	
	$is = entex_theme_fn_get_is();
	$current_url = $is['url'];
	
	$crumbs = entex_breadcrumbs_populate_crumbs();
	if(!$crumbs) return '';
	
	$crumbs = entex_breadcrumbs_populate_data($crumbs, true);
	if(!is_array($crumbs) || $crumbs === array()){
		return;
	}
	
	$end = count($crumbs);
	$listItems = [];
	$count = 1;

	foreach($crumbs as $i => $crumb){

		$item = [];
		$current = false;
		if($count == $end) $current = true;
		if(isset($crumb['schema'])) $text = $crumb['schema'];
			else $text = $crumb['text'];
		if($current){
			$item = [
				'@id' => $current_url,
				'name' => $text
			];
		} else {
			$item = [
				'@id' => $crumb['url'],
				'name' => $text
			];
		}
		
		if(!empty($item)){
			$listItem = [
				'@type' => 'ListItem',
				'position' => $count,
				'item' => $item
			];

			$listItems[] = $listItem;
			$count++;
		}
    }

	$schema = [
		'@context' => 'http://schema.org',
		'@type' => 'BreadcrumbList',
		'itemListElement' => $listItems
	];
	
	/* filter */ // - NOTE: This is global template filter
	$schema = apply_filters('entex_template_schema', $schema);
    $html = '<script type="application/ld+json">'."\r\n". stripslashes(json_encode($schema, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)) ."\r\n".'</script>'."\r\n";
	$html = "\r\n". stripslashes(json_encode($schema, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)) ."\r\n";
	
	/* filter */
	$html = apply_filters('entex_template_output_schema_html', $html, $schema);
	
	add_filter('script_loader_tag', function($tag, $handle, $src){
		if($handle == 'entex-schema') $tag = str_replace('text/javascript', 'application/ld+json', $tag);
		return $tag;
	}, 10, 3);
	
	// Seems we cant run a filter without a 'true' loaded javascript file
	wp_add_inline_script('entex-schema', $html);

}


// -- END FILE -- //